/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSnapshotSchedulesResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeSnapshotSchedulesResponse.Builder, DescribeSnapshotSchedulesResponse> {
    private static final SdkField<List<SnapshotSchedule>> SNAPSHOT_SCHEDULES_FIELD = SdkField
            .<List<SnapshotSchedule>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSnapshotSchedulesResponse::snapshotSchedules))
            .setter(setter(Builder::snapshotSchedules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotSchedules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SnapshotSchedule")
                            .memberFieldInfo(
                                    SdkField.<SnapshotSchedule> builder(MarshallingType.SDK_POJO)
                                            .constructor(SnapshotSchedule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SnapshotSchedule").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSnapshotSchedulesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_SCHEDULES_FIELD,
            MARKER_FIELD));

    private final List<SnapshotSchedule> snapshotSchedules;

    private final String marker;

    private DescribeSnapshotSchedulesResponse(BuilderImpl builder) {
        super(builder);
        this.snapshotSchedules = builder.snapshotSchedules;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * A list of SnapshotSchedules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of SnapshotSchedules.
     */
    public List<SnapshotSchedule> snapshotSchedules() {
        return snapshotSchedules;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned marker value
     * in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all
     * response records have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         marker value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code>
     *         field is empty, all response records have been retrieved for the request.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snapshotSchedules());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotSchedulesResponse)) {
            return false;
        }
        DescribeSnapshotSchedulesResponse other = (DescribeSnapshotSchedulesResponse) obj;
        return Objects.equals(snapshotSchedules(), other.snapshotSchedules()) && Objects.equals(marker(), other.marker());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeSnapshotSchedulesResponse").add("SnapshotSchedules", snapshotSchedules())
                .add("Marker", marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotSchedules":
            return Optional.ofNullable(clazz.cast(snapshotSchedules()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSnapshotSchedulesResponse, T> g) {
        return obj -> g.apply((DescribeSnapshotSchedulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSnapshotSchedulesResponse> {
        /**
         * <p>
         * A list of SnapshotSchedules.
         * </p>
         * 
         * @param snapshotSchedules
         *        A list of SnapshotSchedules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotSchedules(Collection<SnapshotSchedule> snapshotSchedules);

        /**
         * <p>
         * A list of SnapshotSchedules.
         * </p>
         * 
         * @param snapshotSchedules
         *        A list of SnapshotSchedules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotSchedules(SnapshotSchedule... snapshotSchedules);

        /**
         * <p>
         * A list of SnapshotSchedules.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SnapshotSchedule>.Builder} avoiding the
         * need to create one manually via {@link List<SnapshotSchedule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SnapshotSchedule>.Builder#build()} is called immediately and
         * its result is passed to {@link #snapshotSchedules(List<SnapshotSchedule>)}.
         * 
         * @param snapshotSchedules
         *        a consumer that will call methods on {@link List<SnapshotSchedule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshotSchedules(List<SnapshotSchedule>)
         */
        Builder snapshotSchedules(Consumer<SnapshotSchedule.Builder>... snapshotSchedules);

        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a
         * value is returned in a response, you can retrieve the next set of records by providing this returned marker
         * value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is
         * empty, all response records have been retrieved for the request.
         * </p>
         * 
         * @param marker
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request. If a value is returned in a response, you can retrieve the next set of records by providing
         *        this returned marker value in the <code>marker</code> parameter and retrying the command. If the
         *        <code>marker</code> field is empty, all response records have been retrieved for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private List<SnapshotSchedule> snapshotSchedules = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotSchedulesResponse model) {
            super(model);
            snapshotSchedules(model.snapshotSchedules);
            marker(model.marker);
        }

        public final Collection<SnapshotSchedule.Builder> getSnapshotSchedules() {
            return snapshotSchedules != null ? snapshotSchedules.stream().map(SnapshotSchedule::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder snapshotSchedules(Collection<SnapshotSchedule> snapshotSchedules) {
            this.snapshotSchedules = SnapshotScheduleListCopier.copy(snapshotSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotSchedules(SnapshotSchedule... snapshotSchedules) {
            snapshotSchedules(Arrays.asList(snapshotSchedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotSchedules(Consumer<SnapshotSchedule.Builder>... snapshotSchedules) {
            snapshotSchedules(Stream.of(snapshotSchedules).map(c -> SnapshotSchedule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSnapshotSchedules(Collection<SnapshotSchedule.BuilderImpl> snapshotSchedules) {
            this.snapshotSchedules = SnapshotScheduleListCopier.copyFromBuilder(snapshotSchedules);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeSnapshotSchedulesResponse build() {
            return new DescribeSnapshotSchedulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
