/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReservedNodesRequest extends RedshiftRequest implements
        ToCopyableBuilder<DescribeReservedNodesRequest.Builder, DescribeReservedNodesRequest> {
    private static final SdkField<String> RESERVED_NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeReservedNodesRequest::reservedNodeId)).setter(setter(Builder::reservedNodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodeId").build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeReservedNodesRequest::maxRecords)).setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeReservedNodesRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_NODE_ID_FIELD,
            MAX_RECORDS_FIELD, MARKER_FIELD));

    private final String reservedNodeId;

    private final Integer maxRecords;

    private final String marker;

    private DescribeReservedNodesRequest(BuilderImpl builder) {
        super(builder);
        this.reservedNodeId = builder.reservedNodeId;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * Identifier for the node reservation.
     * </p>
     * 
     * @return Identifier for the node reservation.
     */
    public String reservedNodeId() {
        return reservedNodeId;
    }

    /**
     * <p>
     * The maximum number of response records to return in each call. If the number of remaining response records
     * exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the
     * response. You can retrieve the next set of records by retrying the command with the returned marker value.
     * </p>
     * <p>
     * Default: <code>100</code>
     * </p>
     * <p>
     * Constraints: minimum 20, maximum 100.
     * </p>
     * 
     * @return The maximum number of response records to return in each call. If the number of remaining response
     *         records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code>
     *         field of the response. You can retrieve the next set of records by retrying the command with the returned
     *         marker value. </p>
     *         <p>
     *         Default: <code>100</code>
     *         </p>
     *         <p>
     *         Constraints: minimum 20, maximum 100.
     */
    public Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * An optional parameter that specifies the starting point to return a set of response records. When the results of
     * a <a>DescribeReservedNodes</a> request exceed the value specified in <code>MaxRecords</code>, AWS returns a value
     * in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing
     * the returned marker value in the <code>Marker</code> parameter and retrying the request.
     * </p>
     * 
     * @return An optional parameter that specifies the starting point to return a set of response records. When the
     *         results of a <a>DescribeReservedNodes</a> request exceed the value specified in <code>MaxRecords</code>,
     *         AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of
     *         response records by providing the returned marker value in the <code>Marker</code> parameter and retrying
     *         the request.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservedNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedNodesRequest)) {
            return false;
        }
        DescribeReservedNodesRequest other = (DescribeReservedNodesRequest) obj;
        return Objects.equals(reservedNodeId(), other.reservedNodeId()) && Objects.equals(maxRecords(), other.maxRecords())
                && Objects.equals(marker(), other.marker());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeReservedNodesRequest").add("ReservedNodeId", reservedNodeId())
                .add("MaxRecords", maxRecords()).add("Marker", marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedNodeId":
            return Optional.ofNullable(clazz.cast(reservedNodeId()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedNodesRequest, T> g) {
        return obj -> g.apply((DescribeReservedNodesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeReservedNodesRequest> {
        /**
         * <p>
         * Identifier for the node reservation.
         * </p>
         * 
         * @param reservedNodeId
         *        Identifier for the node reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedNodeId(String reservedNodeId);

        /**
         * <p>
         * The maximum number of response records to return in each call. If the number of remaining response records
         * exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of
         * the response. You can retrieve the next set of records by retrying the command with the returned marker
         * value.
         * </p>
         * <p>
         * Default: <code>100</code>
         * </p>
         * <p>
         * Constraints: minimum 20, maximum 100.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of response records to return in each call. If the number of remaining response
         *        records exceeds the specified <code>MaxRecords</code> value, a value is returned in a
         *        <code>marker</code> field of the response. You can retrieve the next set of records by retrying the
         *        command with the returned marker value. </p>
         *        <p>
         *        Default: <code>100</code>
         *        </p>
         *        <p>
         *        Constraints: minimum 20, maximum 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * An optional parameter that specifies the starting point to return a set of response records. When the results
         * of a <a>DescribeReservedNodes</a> request exceed the value specified in <code>MaxRecords</code>, AWS returns
         * a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records
         * by providing the returned marker value in the <code>Marker</code> parameter and retrying the request.
         * </p>
         * 
         * @param marker
         *        An optional parameter that specifies the starting point to return a set of response records. When the
         *        results of a <a>DescribeReservedNodes</a> request exceed the value specified in
         *        <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can
         *        retrieve the next set of response records by providing the returned marker value in the
         *        <code>Marker</code> parameter and retrying the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String reservedNodeId;

        private Integer maxRecords;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedNodesRequest model) {
            super(model);
            reservedNodeId(model.reservedNodeId);
            maxRecords(model.maxRecords);
            marker(model.marker);
        }

        public final String getReservedNodeId() {
            return reservedNodeId;
        }

        @Override
        public final Builder reservedNodeId(String reservedNodeId) {
            this.reservedNodeId = reservedNodeId;
            return this;
        }

        public final void setReservedNodeId(String reservedNodeId) {
            this.reservedNodeId = reservedNodeId;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeReservedNodesRequest build() {
            return new DescribeReservedNodesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
