/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output from the <a>DescribeOrderableClusterOptions</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOrderableClusterOptionsResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeOrderableClusterOptionsResponse.Builder, DescribeOrderableClusterOptionsResponse> {
    private static final SdkField<List<OrderableClusterOption>> ORDERABLE_CLUSTER_OPTIONS_FIELD = SdkField
            .<List<OrderableClusterOption>> builder(MarshallingType.LIST)
            .getter(getter(DescribeOrderableClusterOptionsResponse::orderableClusterOptions))
            .setter(setter(Builder::orderableClusterOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderableClusterOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("OrderableClusterOption")
                            .memberFieldInfo(
                                    SdkField.<OrderableClusterOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrderableClusterOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("OrderableClusterOption").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeOrderableClusterOptionsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORDERABLE_CLUSTER_OPTIONS_FIELD, MARKER_FIELD));

    private final List<OrderableClusterOption> orderableClusterOptions;

    private final String marker;

    private DescribeOrderableClusterOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.orderableClusterOptions = builder.orderableClusterOptions;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * An <code>OrderableClusterOption</code> structure containing information about orderable options for the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An <code>OrderableClusterOption</code> structure containing information about orderable options for the
     *         cluster.
     */
    public List<OrderableClusterOption> orderableClusterOptions() {
        return orderableClusterOptions;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned marker value
     * in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all
     * response records have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code>
     *         field is empty, all response records have been retrieved for the request.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(orderableClusterOptions());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrderableClusterOptionsResponse)) {
            return false;
        }
        DescribeOrderableClusterOptionsResponse other = (DescribeOrderableClusterOptionsResponse) obj;
        return Objects.equals(orderableClusterOptions(), other.orderableClusterOptions())
                && Objects.equals(marker(), other.marker());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeOrderableClusterOptionsResponse")
                .add("OrderableClusterOptions", orderableClusterOptions()).add("Marker", marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrderableClusterOptions":
            return Optional.ofNullable(clazz.cast(orderableClusterOptions()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrderableClusterOptionsResponse, T> g) {
        return obj -> g.apply((DescribeOrderableClusterOptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOrderableClusterOptionsResponse> {
        /**
         * <p>
         * An <code>OrderableClusterOption</code> structure containing information about orderable options for the
         * cluster.
         * </p>
         * 
         * @param orderableClusterOptions
         *        An <code>OrderableClusterOption</code> structure containing information about orderable options for
         *        the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderableClusterOptions(Collection<OrderableClusterOption> orderableClusterOptions);

        /**
         * <p>
         * An <code>OrderableClusterOption</code> structure containing information about orderable options for the
         * cluster.
         * </p>
         * 
         * @param orderableClusterOptions
         *        An <code>OrderableClusterOption</code> structure containing information about orderable options for
         *        the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderableClusterOptions(OrderableClusterOption... orderableClusterOptions);

        /**
         * <p>
         * An <code>OrderableClusterOption</code> structure containing information about orderable options for the
         * cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OrderableClusterOption>.Builder} avoiding
         * the need to create one manually via {@link List<OrderableClusterOption>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OrderableClusterOption>.Builder#build()} is called
         * immediately and its result is passed to {@link #orderableClusterOptions(List<OrderableClusterOption>)}.
         * 
         * @param orderableClusterOptions
         *        a consumer that will call methods on {@link List<OrderableClusterOption>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orderableClusterOptions(List<OrderableClusterOption>)
         */
        Builder orderableClusterOptions(Consumer<OrderableClusterOption.Builder>... orderableClusterOptions);

        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a
         * value is returned in a response, you can retrieve the next set of records by providing this returned marker
         * value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is
         * empty, all response records have been retrieved for the request.
         * </p>
         * 
         * @param marker
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request. If a value is returned in a response, you can retrieve the next set of records by providing
         *        this returned marker value in the <code>Marker</code> parameter and retrying the command. If the
         *        <code>Marker</code> field is empty, all response records have been retrieved for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private List<OrderableClusterOption> orderableClusterOptions = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrderableClusterOptionsResponse model) {
            super(model);
            orderableClusterOptions(model.orderableClusterOptions);
            marker(model.marker);
        }

        public final Collection<OrderableClusterOption.Builder> getOrderableClusterOptions() {
            return orderableClusterOptions != null ? orderableClusterOptions.stream().map(OrderableClusterOption::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder orderableClusterOptions(Collection<OrderableClusterOption> orderableClusterOptions) {
            this.orderableClusterOptions = OrderableClusterOptionsListCopier.copy(orderableClusterOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderableClusterOptions(OrderableClusterOption... orderableClusterOptions) {
            orderableClusterOptions(Arrays.asList(orderableClusterOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderableClusterOptions(Consumer<OrderableClusterOption.Builder>... orderableClusterOptions) {
            orderableClusterOptions(Stream.of(orderableClusterOptions)
                    .map(c -> OrderableClusterOption.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOrderableClusterOptions(Collection<OrderableClusterOption.BuilderImpl> orderableClusterOptions) {
            this.orderableClusterOptions = OrderableClusterOptionsListCopier.copyFromBuilder(orderableClusterOptions);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeOrderableClusterOptionsResponse build() {
            return new DescribeOrderableClusterOptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
