/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeHsmClientCertificatesResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeHsmClientCertificatesResponse.Builder, DescribeHsmClientCertificatesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeHsmClientCertificatesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<HsmClientCertificate>> HSM_CLIENT_CERTIFICATES_FIELD = SdkField
            .<List<HsmClientCertificate>> builder(MarshallingType.LIST)
            .getter(getter(DescribeHsmClientCertificatesResponse::hsmClientCertificates))
            .setter(setter(Builder::hsmClientCertificates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmClientCertificates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("HsmClientCertificate")
                            .memberFieldInfo(
                                    SdkField.<HsmClientCertificate> builder(MarshallingType.SDK_POJO)
                                            .constructor(HsmClientCertificate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("HsmClientCertificate").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            HSM_CLIENT_CERTIFICATES_FIELD));

    private final String marker;

    private final List<HsmClientCertificate> hsmClientCertificates;

    private DescribeHsmClientCertificatesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.hsmClientCertificates = builder.hsmClientCertificates;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned marker value
     * in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all
     * response records have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code>
     *         field is empty, all response records have been retrieved for the request.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * A list of the identifiers for one or more HSM client certificates used by Amazon Redshift clusters to store and
     * retrieve database encryption keys in an HSM.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the identifiers for one or more HSM client certificates used by Amazon Redshift clusters to
     *         store and retrieve database encryption keys in an HSM.
     */
    public List<HsmClientCertificate> hsmClientCertificates() {
        return hsmClientCertificates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hsmClientCertificates());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHsmClientCertificatesResponse)) {
            return false;
        }
        DescribeHsmClientCertificatesResponse other = (DescribeHsmClientCertificatesResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(hsmClientCertificates(), other.hsmClientCertificates());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeHsmClientCertificatesResponse").add("Marker", marker())
                .add("HsmClientCertificates", hsmClientCertificates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "HsmClientCertificates":
            return Optional.ofNullable(clazz.cast(hsmClientCertificates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHsmClientCertificatesResponse, T> g) {
        return obj -> g.apply((DescribeHsmClientCertificatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeHsmClientCertificatesResponse> {
        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a
         * value is returned in a response, you can retrieve the next set of records by providing this returned marker
         * value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is
         * empty, all response records have been retrieved for the request.
         * </p>
         * 
         * @param marker
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request. If a value is returned in a response, you can retrieve the next set of records by providing
         *        this returned marker value in the <code>Marker</code> parameter and retrying the command. If the
         *        <code>Marker</code> field is empty, all response records have been retrieved for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of the identifiers for one or more HSM client certificates used by Amazon Redshift clusters to store
         * and retrieve database encryption keys in an HSM.
         * </p>
         * 
         * @param hsmClientCertificates
         *        A list of the identifiers for one or more HSM client certificates used by Amazon Redshift clusters to
         *        store and retrieve database encryption keys in an HSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmClientCertificates(Collection<HsmClientCertificate> hsmClientCertificates);

        /**
         * <p>
         * A list of the identifiers for one or more HSM client certificates used by Amazon Redshift clusters to store
         * and retrieve database encryption keys in an HSM.
         * </p>
         * 
         * @param hsmClientCertificates
         *        A list of the identifiers for one or more HSM client certificates used by Amazon Redshift clusters to
         *        store and retrieve database encryption keys in an HSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmClientCertificates(HsmClientCertificate... hsmClientCertificates);

        /**
         * <p>
         * A list of the identifiers for one or more HSM client certificates used by Amazon Redshift clusters to store
         * and retrieve database encryption keys in an HSM.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HsmClientCertificate>.Builder} avoiding the
         * need to create one manually via {@link List<HsmClientCertificate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HsmClientCertificate>.Builder#build()} is called immediately
         * and its result is passed to {@link #hsmClientCertificates(List<HsmClientCertificate>)}.
         * 
         * @param hsmClientCertificates
         *        a consumer that will call methods on {@link List<HsmClientCertificate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hsmClientCertificates(List<HsmClientCertificate>)
         */
        Builder hsmClientCertificates(Consumer<HsmClientCertificate.Builder>... hsmClientCertificates);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private String marker;

        private List<HsmClientCertificate> hsmClientCertificates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHsmClientCertificatesResponse model) {
            super(model);
            marker(model.marker);
            hsmClientCertificates(model.hsmClientCertificates);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<HsmClientCertificate.Builder> getHsmClientCertificates() {
            return hsmClientCertificates != null ? hsmClientCertificates.stream().map(HsmClientCertificate::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hsmClientCertificates(Collection<HsmClientCertificate> hsmClientCertificates) {
            this.hsmClientCertificates = HsmClientCertificateListCopier.copy(hsmClientCertificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsmClientCertificates(HsmClientCertificate... hsmClientCertificates) {
            hsmClientCertificates(Arrays.asList(hsmClientCertificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsmClientCertificates(Consumer<HsmClientCertificate.Builder>... hsmClientCertificates) {
            hsmClientCertificates(Stream.of(hsmClientCertificates)
                    .map(c -> HsmClientCertificate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHsmClientCertificates(Collection<HsmClientCertificate.BuilderImpl> hsmClientCertificates) {
            this.hsmClientCertificates = HsmClientCertificateListCopier.copyFromBuilder(hsmClientCertificates);
        }

        @Override
        public DescribeHsmClientCertificatesResponse build() {
            return new DescribeHsmClientCertificatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
