/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClusterTracksResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeClusterTracksResponse.Builder, DescribeClusterTracksResponse> {
    private static final SdkField<List<MaintenanceTrack>> MAINTENANCE_TRACKS_FIELD = SdkField
            .<List<MaintenanceTrack>> builder(MarshallingType.LIST)
            .getter(getter(DescribeClusterTracksResponse::maintenanceTracks))
            .setter(setter(Builder::maintenanceTracks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceTracks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("MaintenanceTrack")
                            .memberFieldInfo(
                                    SdkField.<MaintenanceTrack> builder(MarshallingType.SDK_POJO)
                                            .constructor(MaintenanceTrack::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("MaintenanceTrack").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeClusterTracksResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAINTENANCE_TRACKS_FIELD,
            MARKER_FIELD));

    private final List<MaintenanceTrack> maintenanceTracks;

    private final String marker;

    private DescribeClusterTracksResponse(BuilderImpl builder) {
        super(builder);
        this.maintenanceTracks = builder.maintenanceTracks;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * A list of maintenance tracks output by the <code>DescribeClusterTracks</code> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of maintenance tracks output by the <code>DescribeClusterTracks</code> operation.
     */
    public List<MaintenanceTrack> maintenanceTracks() {
        return maintenanceTracks;
    }

    /**
     * <p>
     * The starting point to return a set of response tracklist records. You can retrieve the next set of response
     * records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request.
     * </p>
     * 
     * @return The starting point to return a set of response tracklist records. You can retrieve the next set of
     *         response records by providing the returned marker value in the <code>Marker</code> parameter and retrying
     *         the request.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceTracks());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterTracksResponse)) {
            return false;
        }
        DescribeClusterTracksResponse other = (DescribeClusterTracksResponse) obj;
        return Objects.equals(maintenanceTracks(), other.maintenanceTracks()) && Objects.equals(marker(), other.marker());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeClusterTracksResponse").add("MaintenanceTracks", maintenanceTracks())
                .add("Marker", marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaintenanceTracks":
            return Optional.ofNullable(clazz.cast(maintenanceTracks()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterTracksResponse, T> g) {
        return obj -> g.apply((DescribeClusterTracksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeClusterTracksResponse> {
        /**
         * <p>
         * A list of maintenance tracks output by the <code>DescribeClusterTracks</code> operation.
         * </p>
         * 
         * @param maintenanceTracks
         *        A list of maintenance tracks output by the <code>DescribeClusterTracks</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceTracks(Collection<MaintenanceTrack> maintenanceTracks);

        /**
         * <p>
         * A list of maintenance tracks output by the <code>DescribeClusterTracks</code> operation.
         * </p>
         * 
         * @param maintenanceTracks
         *        A list of maintenance tracks output by the <code>DescribeClusterTracks</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceTracks(MaintenanceTrack... maintenanceTracks);

        /**
         * <p>
         * A list of maintenance tracks output by the <code>DescribeClusterTracks</code> operation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MaintenanceTrack>.Builder} avoiding the
         * need to create one manually via {@link List<MaintenanceTrack>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MaintenanceTrack>.Builder#build()} is called immediately and
         * its result is passed to {@link #maintenanceTracks(List<MaintenanceTrack>)}.
         * 
         * @param maintenanceTracks
         *        a consumer that will call methods on {@link List<MaintenanceTrack>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceTracks(List<MaintenanceTrack>)
         */
        Builder maintenanceTracks(Consumer<MaintenanceTrack.Builder>... maintenanceTracks);

        /**
         * <p>
         * The starting point to return a set of response tracklist records. You can retrieve the next set of response
         * records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request.
         * </p>
         * 
         * @param marker
         *        The starting point to return a set of response tracklist records. You can retrieve the next set of
         *        response records by providing the returned marker value in the <code>Marker</code> parameter and
         *        retrying the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private List<MaintenanceTrack> maintenanceTracks = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterTracksResponse model) {
            super(model);
            maintenanceTracks(model.maintenanceTracks);
            marker(model.marker);
        }

        public final Collection<MaintenanceTrack.Builder> getMaintenanceTracks() {
            return maintenanceTracks != null ? maintenanceTracks.stream().map(MaintenanceTrack::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder maintenanceTracks(Collection<MaintenanceTrack> maintenanceTracks) {
            this.maintenanceTracks = TrackListCopier.copy(maintenanceTracks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder maintenanceTracks(MaintenanceTrack... maintenanceTracks) {
            maintenanceTracks(Arrays.asList(maintenanceTracks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder maintenanceTracks(Consumer<MaintenanceTrack.Builder>... maintenanceTracks) {
            maintenanceTracks(Stream.of(maintenanceTracks).map(c -> MaintenanceTrack.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMaintenanceTracks(Collection<MaintenanceTrack.BuilderImpl> maintenanceTracks) {
            this.maintenanceTracks = TrackListCopier.copyFromBuilder(maintenanceTracks);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeClusterTracksResponse build() {
            return new DescribeClusterTracksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
