/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output from the <a>DescribeClusterParameterGroups</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClusterParameterGroupsResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeClusterParameterGroupsResponse.Builder, DescribeClusterParameterGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeClusterParameterGroupsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<ClusterParameterGroup>> PARAMETER_GROUPS_FIELD = SdkField
            .<List<ClusterParameterGroup>> builder(MarshallingType.LIST)
            .getter(getter(DescribeClusterParameterGroupsResponse::parameterGroups))
            .setter(setter(Builder::parameterGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ClusterParameterGroup")
                            .memberFieldInfo(
                                    SdkField.<ClusterParameterGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterParameterGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ClusterParameterGroup").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            PARAMETER_GROUPS_FIELD));

    private final String marker;

    private final List<ClusterParameterGroup> parameterGroups;

    private DescribeClusterParameterGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.parameterGroups = builder.parameterGroups;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned marker value
     * in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all
     * response records have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code>
     *         field is empty, all response records have been retrieved for the request.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * A list of <a>ClusterParameterGroup</a> instances. Each instance describes one cluster parameter group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <a>ClusterParameterGroup</a> instances. Each instance describes one cluster parameter group.
     */
    public List<ClusterParameterGroup> parameterGroups() {
        return parameterGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(parameterGroups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterParameterGroupsResponse)) {
            return false;
        }
        DescribeClusterParameterGroupsResponse other = (DescribeClusterParameterGroupsResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(parameterGroups(), other.parameterGroups());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeClusterParameterGroupsResponse").add("Marker", marker())
                .add("ParameterGroups", parameterGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ParameterGroups":
            return Optional.ofNullable(clazz.cast(parameterGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterParameterGroupsResponse, T> g) {
        return obj -> g.apply((DescribeClusterParameterGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeClusterParameterGroupsResponse> {
        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a
         * value is returned in a response, you can retrieve the next set of records by providing this returned marker
         * value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is
         * empty, all response records have been retrieved for the request.
         * </p>
         * 
         * @param marker
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request. If a value is returned in a response, you can retrieve the next set of records by providing
         *        this returned marker value in the <code>Marker</code> parameter and retrying the command. If the
         *        <code>Marker</code> field is empty, all response records have been retrieved for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of <a>ClusterParameterGroup</a> instances. Each instance describes one cluster parameter group.
         * </p>
         * 
         * @param parameterGroups
         *        A list of <a>ClusterParameterGroup</a> instances. Each instance describes one cluster parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroups(Collection<ClusterParameterGroup> parameterGroups);

        /**
         * <p>
         * A list of <a>ClusterParameterGroup</a> instances. Each instance describes one cluster parameter group.
         * </p>
         * 
         * @param parameterGroups
         *        A list of <a>ClusterParameterGroup</a> instances. Each instance describes one cluster parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroups(ClusterParameterGroup... parameterGroups);

        /**
         * <p>
         * A list of <a>ClusterParameterGroup</a> instances. Each instance describes one cluster parameter group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ClusterParameterGroup>.Builder} avoiding
         * the need to create one manually via {@link List<ClusterParameterGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ClusterParameterGroup>.Builder#build()} is called
         * immediately and its result is passed to {@link #parameterGroups(List<ClusterParameterGroup>)}.
         * 
         * @param parameterGroups
         *        a consumer that will call methods on {@link List<ClusterParameterGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterGroups(List<ClusterParameterGroup>)
         */
        Builder parameterGroups(Consumer<ClusterParameterGroup.Builder>... parameterGroups);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private String marker;

        private List<ClusterParameterGroup> parameterGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterParameterGroupsResponse model) {
            super(model);
            marker(model.marker);
            parameterGroups(model.parameterGroups);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ClusterParameterGroup.Builder> getParameterGroups() {
            return parameterGroups != null ? parameterGroups.stream().map(ClusterParameterGroup::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterGroups(Collection<ClusterParameterGroup> parameterGroups) {
            this.parameterGroups = ParameterGroupListCopier.copy(parameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterGroups(ClusterParameterGroup... parameterGroups) {
            parameterGroups(Arrays.asList(parameterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterGroups(Consumer<ClusterParameterGroup.Builder>... parameterGroups) {
            parameterGroups(Stream.of(parameterGroups).map(c -> ClusterParameterGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setParameterGroups(Collection<ClusterParameterGroup.BuilderImpl> parameterGroups) {
            this.parameterGroups = ParameterGroupListCopier.copyFromBuilder(parameterGroups);
        }

        @Override
        public DescribeClusterParameterGroupsResponse build() {
            return new DescribeClusterParameterGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
