/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClusterDbRevisionsResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeClusterDbRevisionsResponse.Builder, DescribeClusterDbRevisionsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeClusterDbRevisionsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<ClusterDbRevision>> CLUSTER_DB_REVISIONS_FIELD = SdkField
            .<List<ClusterDbRevision>> builder(MarshallingType.LIST)
            .getter(getter(DescribeClusterDbRevisionsResponse::clusterDbRevisions))
            .setter(setter(Builder::clusterDbRevisions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterDbRevisions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ClusterDbRevision")
                            .memberFieldInfo(
                                    SdkField.<ClusterDbRevision> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterDbRevision::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ClusterDbRevision").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            CLUSTER_DB_REVISIONS_FIELD));

    private final String marker;

    private final List<ClusterDbRevision> clusterDbRevisions;

    private DescribeClusterDbRevisionsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.clusterDbRevisions = builder.clusterDbRevisions;
    }

    /**
     * <p>
     * A string representing the starting point for the next set of revisions. If a value is returned in a response, you
     * can retrieve the next set of revisions by providing the value in the <code>marker</code> parameter and retrying
     * the command. If the <code>marker</code> field is empty, all revisions have already been returned.
     * </p>
     * 
     * @return A string representing the starting point for the next set of revisions. If a value is returned in a
     *         response, you can retrieve the next set of revisions by providing the value in the <code>marker</code>
     *         parameter and retrying the command. If the <code>marker</code> field is empty, all revisions have already
     *         been returned.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * A list of revisions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of revisions.
     */
    public List<ClusterDbRevision> clusterDbRevisions() {
        return clusterDbRevisions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(clusterDbRevisions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterDbRevisionsResponse)) {
            return false;
        }
        DescribeClusterDbRevisionsResponse other = (DescribeClusterDbRevisionsResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(clusterDbRevisions(), other.clusterDbRevisions());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeClusterDbRevisionsResponse").add("Marker", marker())
                .add("ClusterDbRevisions", clusterDbRevisions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ClusterDbRevisions":
            return Optional.ofNullable(clazz.cast(clusterDbRevisions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterDbRevisionsResponse, T> g) {
        return obj -> g.apply((DescribeClusterDbRevisionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeClusterDbRevisionsResponse> {
        /**
         * <p>
         * A string representing the starting point for the next set of revisions. If a value is returned in a response,
         * you can retrieve the next set of revisions by providing the value in the <code>marker</code> parameter and
         * retrying the command. If the <code>marker</code> field is empty, all revisions have already been returned.
         * </p>
         * 
         * @param marker
         *        A string representing the starting point for the next set of revisions. If a value is returned in a
         *        response, you can retrieve the next set of revisions by providing the value in the <code>marker</code>
         *        parameter and retrying the command. If the <code>marker</code> field is empty, all revisions have
         *        already been returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of revisions.
         * </p>
         * 
         * @param clusterDbRevisions
         *        A list of revisions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterDbRevisions(Collection<ClusterDbRevision> clusterDbRevisions);

        /**
         * <p>
         * A list of revisions.
         * </p>
         * 
         * @param clusterDbRevisions
         *        A list of revisions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterDbRevisions(ClusterDbRevision... clusterDbRevisions);

        /**
         * <p>
         * A list of revisions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ClusterDbRevision>.Builder} avoiding the
         * need to create one manually via {@link List<ClusterDbRevision>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ClusterDbRevision>.Builder#build()} is called immediately
         * and its result is passed to {@link #clusterDbRevisions(List<ClusterDbRevision>)}.
         * 
         * @param clusterDbRevisions
         *        a consumer that will call methods on {@link List<ClusterDbRevision>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterDbRevisions(List<ClusterDbRevision>)
         */
        Builder clusterDbRevisions(Consumer<ClusterDbRevision.Builder>... clusterDbRevisions);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private String marker;

        private List<ClusterDbRevision> clusterDbRevisions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterDbRevisionsResponse model) {
            super(model);
            marker(model.marker);
            clusterDbRevisions(model.clusterDbRevisions);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ClusterDbRevision.Builder> getClusterDbRevisions() {
            return clusterDbRevisions != null ? clusterDbRevisions.stream().map(ClusterDbRevision::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusterDbRevisions(Collection<ClusterDbRevision> clusterDbRevisions) {
            this.clusterDbRevisions = ClusterDbRevisionsListCopier.copy(clusterDbRevisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterDbRevisions(ClusterDbRevision... clusterDbRevisions) {
            clusterDbRevisions(Arrays.asList(clusterDbRevisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterDbRevisions(Consumer<ClusterDbRevision.Builder>... clusterDbRevisions) {
            clusterDbRevisions(Stream.of(clusterDbRevisions).map(c -> ClusterDbRevision.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setClusterDbRevisions(Collection<ClusterDbRevision.BuilderImpl> clusterDbRevisions) {
            this.clusterDbRevisions = ClusterDbRevisionsListCopier.copyFromBuilder(clusterDbRevisions);
        }

        @Override
        public DescribeClusterDbRevisionsResponse build() {
            return new DescribeClusterDbRevisionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
