/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccountAttributesResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeAccountAttributesResponse.Builder, DescribeAccountAttributesResponse> {
    private static final SdkField<List<AccountAttribute>> ACCOUNT_ATTRIBUTES_FIELD = SdkField
            .<List<AccountAttribute>> builder(MarshallingType.LIST)
            .getter(getter(DescribeAccountAttributesResponse::accountAttributes))
            .setter(setter(Builder::accountAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AccountAttribute")
                            .memberFieldInfo(
                                    SdkField.<AccountAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AccountAttribute").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ATTRIBUTES_FIELD));

    private final List<AccountAttribute> accountAttributes;

    private DescribeAccountAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.accountAttributes = builder.accountAttributes;
    }

    /**
     * <p>
     * A list of attributes assigned to an account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of attributes assigned to an account.
     */
    public List<AccountAttribute> accountAttributes() {
        return accountAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountAttributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountAttributesResponse)) {
            return false;
        }
        DescribeAccountAttributesResponse other = (DescribeAccountAttributesResponse) obj;
        return Objects.equals(accountAttributes(), other.accountAttributes());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeAccountAttributesResponse").add("AccountAttributes", accountAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountAttributes":
            return Optional.ofNullable(clazz.cast(accountAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountAttributesResponse, T> g) {
        return obj -> g.apply((DescribeAccountAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAccountAttributesResponse> {
        /**
         * <p>
         * A list of attributes assigned to an account.
         * </p>
         * 
         * @param accountAttributes
         *        A list of attributes assigned to an account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAttributes(Collection<AccountAttribute> accountAttributes);

        /**
         * <p>
         * A list of attributes assigned to an account.
         * </p>
         * 
         * @param accountAttributes
         *        A list of attributes assigned to an account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAttributes(AccountAttribute... accountAttributes);

        /**
         * <p>
         * A list of attributes assigned to an account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AccountAttribute>.Builder} avoiding the
         * need to create one manually via {@link List<AccountAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AccountAttribute>.Builder#build()} is called immediately and
         * its result is passed to {@link #accountAttributes(List<AccountAttribute>)}.
         * 
         * @param accountAttributes
         *        a consumer that will call methods on {@link List<AccountAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountAttributes(List<AccountAttribute>)
         */
        Builder accountAttributes(Consumer<AccountAttribute.Builder>... accountAttributes);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private List<AccountAttribute> accountAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountAttributesResponse model) {
            super(model);
            accountAttributes(model.accountAttributes);
        }

        public final Collection<AccountAttribute.Builder> getAccountAttributes() {
            return accountAttributes != null ? accountAttributes.stream().map(AccountAttribute::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accountAttributes(Collection<AccountAttribute> accountAttributes) {
            this.accountAttributes = AttributeListCopier.copy(accountAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAttributes(AccountAttribute... accountAttributes) {
            accountAttributes(Arrays.asList(accountAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAttributes(Consumer<AccountAttribute.Builder>... accountAttributes) {
            accountAttributes(Stream.of(accountAttributes).map(c -> AccountAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAccountAttributes(Collection<AccountAttribute.BuilderImpl> accountAttributes) {
            this.accountAttributes = AttributeListCopier.copyFromBuilder(accountAttributes);
        }

        @Override
        public DescribeAccountAttributesResponse build() {
            return new DescribeAccountAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
