/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteClusterSnapshotResponse extends RedshiftResponse implements
        ToCopyableBuilder<DeleteClusterSnapshotResponse.Builder, DeleteClusterSnapshotResponse> {
    private static final SdkField<Snapshot> SNAPSHOT_FIELD = SdkField.<Snapshot> builder(MarshallingType.SDK_POJO)
            .getter(getter(DeleteClusterSnapshotResponse::snapshot)).setter(setter(Builder::snapshot))
            .constructor(Snapshot::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Snapshot").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_FIELD));

    private final Snapshot snapshot;

    private DeleteClusterSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.snapshot = builder.snapshot;
    }

    /**
     * Returns the value of the Snapshot property for this object.
     * 
     * @return The value of the Snapshot property for this object.
     */
    public Snapshot snapshot() {
        return snapshot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snapshot());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteClusterSnapshotResponse)) {
            return false;
        }
        DeleteClusterSnapshotResponse other = (DeleteClusterSnapshotResponse) obj;
        return Objects.equals(snapshot(), other.snapshot());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteClusterSnapshotResponse").add("Snapshot", snapshot()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Snapshot":
            return Optional.ofNullable(clazz.cast(snapshot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteClusterSnapshotResponse, T> g) {
        return obj -> g.apply((DeleteClusterSnapshotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteClusterSnapshotResponse> {
        /**
         * Sets the value of the Snapshot property for this object.
         *
         * @param snapshot
         *        The new value for the Snapshot property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshot(Snapshot snapshot);

        /**
         * Sets the value of the Snapshot property for this object.
         *
         * This is a convenience that creates an instance of the {@link Snapshot.Builder} avoiding the need to create
         * one manually via {@link Snapshot#builder()}.
         *
         * When the {@link Consumer} completes, {@link Snapshot.Builder#build()} is called immediately and its result is
         * passed to {@link #snapshot(Snapshot)}.
         * 
         * @param snapshot
         *        a consumer that will call methods on {@link Snapshot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshot(Snapshot)
         */
        default Builder snapshot(Consumer<Snapshot.Builder> snapshot) {
            return snapshot(Snapshot.builder().applyMutation(snapshot).build());
        }
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private Snapshot snapshot;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteClusterSnapshotResponse model) {
            super(model);
            snapshot(model.snapshot);
        }

        public final Snapshot.Builder getSnapshot() {
            return snapshot != null ? snapshot.toBuilder() : null;
        }

        @Override
        public final Builder snapshot(Snapshot snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public final void setSnapshot(Snapshot.BuilderImpl snapshot) {
            this.snapshot = snapshot != null ? snapshot.build() : null;
        }

        @Override
        public DeleteClusterSnapshotResponse build() {
            return new DeleteClusterSnapshotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
