/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a deferred maintenance window
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeferredMaintenanceWindow implements SdkPojo, Serializable,
        ToCopyableBuilder<DeferredMaintenanceWindow.Builder, DeferredMaintenanceWindow> {
    private static final SdkField<String> DEFER_MAINTENANCE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DeferredMaintenanceWindow::deferMaintenanceIdentifier))
            .setter(setter(Builder::deferMaintenanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeferMaintenanceIdentifier").build())
            .build();

    private static final SdkField<Instant> DEFER_MAINTENANCE_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).getter(getter(DeferredMaintenanceWindow::deferMaintenanceStartTime))
            .setter(setter(Builder::deferMaintenanceStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeferMaintenanceStartTime").build())
            .build();

    private static final SdkField<Instant> DEFER_MAINTENANCE_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DeferredMaintenanceWindow::deferMaintenanceEndTime)).setter(setter(Builder::deferMaintenanceEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeferMaintenanceEndTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DEFER_MAINTENANCE_IDENTIFIER_FIELD, DEFER_MAINTENANCE_START_TIME_FIELD, DEFER_MAINTENANCE_END_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deferMaintenanceIdentifier;

    private final Instant deferMaintenanceStartTime;

    private final Instant deferMaintenanceEndTime;

    private DeferredMaintenanceWindow(BuilderImpl builder) {
        this.deferMaintenanceIdentifier = builder.deferMaintenanceIdentifier;
        this.deferMaintenanceStartTime = builder.deferMaintenanceStartTime;
        this.deferMaintenanceEndTime = builder.deferMaintenanceEndTime;
    }

    /**
     * <p>
     * A unique identifier for the maintenance window.
     * </p>
     * 
     * @return A unique identifier for the maintenance window.
     */
    public String deferMaintenanceIdentifier() {
        return deferMaintenanceIdentifier;
    }

    /**
     * <p>
     * A timestamp for the beginning of the time period when we defer maintenance.
     * </p>
     * 
     * @return A timestamp for the beginning of the time period when we defer maintenance.
     */
    public Instant deferMaintenanceStartTime() {
        return deferMaintenanceStartTime;
    }

    /**
     * <p>
     * A timestamp for the end of the time period when we defer maintenance.
     * </p>
     * 
     * @return A timestamp for the end of the time period when we defer maintenance.
     */
    public Instant deferMaintenanceEndTime() {
        return deferMaintenanceEndTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deferMaintenanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(deferMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(deferMaintenanceEndTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeferredMaintenanceWindow)) {
            return false;
        }
        DeferredMaintenanceWindow other = (DeferredMaintenanceWindow) obj;
        return Objects.equals(deferMaintenanceIdentifier(), other.deferMaintenanceIdentifier())
                && Objects.equals(deferMaintenanceStartTime(), other.deferMaintenanceStartTime())
                && Objects.equals(deferMaintenanceEndTime(), other.deferMaintenanceEndTime());
    }

    @Override
    public String toString() {
        return ToString.builder("DeferredMaintenanceWindow").add("DeferMaintenanceIdentifier", deferMaintenanceIdentifier())
                .add("DeferMaintenanceStartTime", deferMaintenanceStartTime())
                .add("DeferMaintenanceEndTime", deferMaintenanceEndTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeferMaintenanceIdentifier":
            return Optional.ofNullable(clazz.cast(deferMaintenanceIdentifier()));
        case "DeferMaintenanceStartTime":
            return Optional.ofNullable(clazz.cast(deferMaintenanceStartTime()));
        case "DeferMaintenanceEndTime":
            return Optional.ofNullable(clazz.cast(deferMaintenanceEndTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeferredMaintenanceWindow, T> g) {
        return obj -> g.apply((DeferredMaintenanceWindow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeferredMaintenanceWindow> {
        /**
         * <p>
         * A unique identifier for the maintenance window.
         * </p>
         * 
         * @param deferMaintenanceIdentifier
         *        A unique identifier for the maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deferMaintenanceIdentifier(String deferMaintenanceIdentifier);

        /**
         * <p>
         * A timestamp for the beginning of the time period when we defer maintenance.
         * </p>
         * 
         * @param deferMaintenanceStartTime
         *        A timestamp for the beginning of the time period when we defer maintenance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deferMaintenanceStartTime(Instant deferMaintenanceStartTime);

        /**
         * <p>
         * A timestamp for the end of the time period when we defer maintenance.
         * </p>
         * 
         * @param deferMaintenanceEndTime
         *        A timestamp for the end of the time period when we defer maintenance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deferMaintenanceEndTime(Instant deferMaintenanceEndTime);
    }

    static final class BuilderImpl implements Builder {
        private String deferMaintenanceIdentifier;

        private Instant deferMaintenanceStartTime;

        private Instant deferMaintenanceEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DeferredMaintenanceWindow model) {
            deferMaintenanceIdentifier(model.deferMaintenanceIdentifier);
            deferMaintenanceStartTime(model.deferMaintenanceStartTime);
            deferMaintenanceEndTime(model.deferMaintenanceEndTime);
        }

        public final String getDeferMaintenanceIdentifier() {
            return deferMaintenanceIdentifier;
        }

        @Override
        public final Builder deferMaintenanceIdentifier(String deferMaintenanceIdentifier) {
            this.deferMaintenanceIdentifier = deferMaintenanceIdentifier;
            return this;
        }

        public final void setDeferMaintenanceIdentifier(String deferMaintenanceIdentifier) {
            this.deferMaintenanceIdentifier = deferMaintenanceIdentifier;
        }

        public final Instant getDeferMaintenanceStartTime() {
            return deferMaintenanceStartTime;
        }

        @Override
        public final Builder deferMaintenanceStartTime(Instant deferMaintenanceStartTime) {
            this.deferMaintenanceStartTime = deferMaintenanceStartTime;
            return this;
        }

        public final void setDeferMaintenanceStartTime(Instant deferMaintenanceStartTime) {
            this.deferMaintenanceStartTime = deferMaintenanceStartTime;
        }

        public final Instant getDeferMaintenanceEndTime() {
            return deferMaintenanceEndTime;
        }

        @Override
        public final Builder deferMaintenanceEndTime(Instant deferMaintenanceEndTime) {
            this.deferMaintenanceEndTime = deferMaintenanceEndTime;
            return this;
        }

        public final void setDeferMaintenanceEndTime(Instant deferMaintenanceEndTime) {
            this.deferMaintenanceEndTime = deferMaintenanceEndTime;
        }

        @Override
        public DeferredMaintenanceWindow build() {
            return new DeferredMaintenanceWindow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
