/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSnapshotScheduleRequest extends RedshiftRequest implements
        ToCopyableBuilder<CreateSnapshotScheduleRequest.Builder, CreateSnapshotScheduleRequest> {
    private static final SdkField<List<String>> SCHEDULE_DEFINITIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateSnapshotScheduleRequest::scheduleDefinitions))
            .setter(setter(Builder::scheduleDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ScheduleDefinition")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ScheduleDefinition").build()).build()).build()).build();

    private static final SdkField<String> SCHEDULE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSnapshotScheduleRequest::scheduleIdentifier)).setter(setter(Builder::scheduleIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleIdentifier").build())
            .build();

    private static final SdkField<String> SCHEDULE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSnapshotScheduleRequest::scheduleDescription)).setter(setter(Builder::scheduleDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleDescription").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateSnapshotScheduleRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateSnapshotScheduleRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()).build();

    private static final SdkField<Integer> NEXT_INVOCATIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateSnapshotScheduleRequest::nextInvocations)).setter(setter(Builder::nextInvocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextInvocations").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_DEFINITIONS_FIELD,
            SCHEDULE_IDENTIFIER_FIELD, SCHEDULE_DESCRIPTION_FIELD, TAGS_FIELD, DRY_RUN_FIELD, NEXT_INVOCATIONS_FIELD));

    private final List<String> scheduleDefinitions;

    private final String scheduleIdentifier;

    private final String scheduleDescription;

    private final List<Tag> tags;

    private final Boolean dryRun;

    private final Integer nextInvocations;

    private CreateSnapshotScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.scheduleDefinitions = builder.scheduleDefinitions;
        this.scheduleIdentifier = builder.scheduleIdentifier;
        this.scheduleDescription = builder.scheduleDescription;
        this.tags = builder.tags;
        this.dryRun = builder.dryRun;
        this.nextInvocations = builder.nextInvocations;
    }

    /**
     * <p>
     * The definition of the snapshot schedule. The definition is made up of schedule expressions, for example
     * "cron(30 12 *)" or "rate(12 hours)".
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The definition of the snapshot schedule. The definition is made up of schedule expressions, for example
     *         "cron(30 12 *)" or "rate(12 hours)".
     */
    public List<String> scheduleDefinitions() {
        return scheduleDefinitions;
    }

    /**
     * <p>
     * A unique identifier for a snapshot schedule. Only alphanumeric characters are allowed for the identifier.
     * </p>
     * 
     * @return A unique identifier for a snapshot schedule. Only alphanumeric characters are allowed for the identifier.
     */
    public String scheduleIdentifier() {
        return scheduleIdentifier;
    }

    /**
     * <p>
     * The description of the snapshot schedule.
     * </p>
     * 
     * @return The description of the snapshot schedule.
     */
    public String scheduleDescription() {
        return scheduleDescription;
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * Returns the value of the DryRun property for this object.
     * 
     * @return The value of the DryRun property for this object.
     */
    public Boolean dryRun() {
        return dryRun;
    }

    /**
     * Returns the value of the NextInvocations property for this object.
     * 
     * @return The value of the NextInvocations property for this object.
     */
    public Integer nextInvocations() {
        return nextInvocations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduleDefinitions());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleDescription());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(nextInvocations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotScheduleRequest)) {
            return false;
        }
        CreateSnapshotScheduleRequest other = (CreateSnapshotScheduleRequest) obj;
        return Objects.equals(scheduleDefinitions(), other.scheduleDefinitions())
                && Objects.equals(scheduleIdentifier(), other.scheduleIdentifier())
                && Objects.equals(scheduleDescription(), other.scheduleDescription()) && Objects.equals(tags(), other.tags())
                && Objects.equals(dryRun(), other.dryRun()) && Objects.equals(nextInvocations(), other.nextInvocations());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateSnapshotScheduleRequest").add("ScheduleDefinitions", scheduleDefinitions())
                .add("ScheduleIdentifier", scheduleIdentifier()).add("ScheduleDescription", scheduleDescription())
                .add("Tags", tags()).add("DryRun", dryRun()).add("NextInvocations", nextInvocations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduleDefinitions":
            return Optional.ofNullable(clazz.cast(scheduleDefinitions()));
        case "ScheduleIdentifier":
            return Optional.ofNullable(clazz.cast(scheduleIdentifier()));
        case "ScheduleDescription":
            return Optional.ofNullable(clazz.cast(scheduleDescription()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "NextInvocations":
            return Optional.ofNullable(clazz.cast(nextInvocations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSnapshotScheduleRequest, T> g) {
        return obj -> g.apply((CreateSnapshotScheduleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSnapshotScheduleRequest> {
        /**
         * <p>
         * The definition of the snapshot schedule. The definition is made up of schedule expressions, for example
         * "cron(30 12 *)" or "rate(12 hours)".
         * </p>
         * 
         * @param scheduleDefinitions
         *        The definition of the snapshot schedule. The definition is made up of schedule expressions, for
         *        example "cron(30 12 *)" or "rate(12 hours)".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleDefinitions(Collection<String> scheduleDefinitions);

        /**
         * <p>
         * The definition of the snapshot schedule. The definition is made up of schedule expressions, for example
         * "cron(30 12 *)" or "rate(12 hours)".
         * </p>
         * 
         * @param scheduleDefinitions
         *        The definition of the snapshot schedule. The definition is made up of schedule expressions, for
         *        example "cron(30 12 *)" or "rate(12 hours)".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleDefinitions(String... scheduleDefinitions);

        /**
         * <p>
         * A unique identifier for a snapshot schedule. Only alphanumeric characters are allowed for the identifier.
         * </p>
         * 
         * @param scheduleIdentifier
         *        A unique identifier for a snapshot schedule. Only alphanumeric characters are allowed for the
         *        identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleIdentifier(String scheduleIdentifier);

        /**
         * <p>
         * The description of the snapshot schedule.
         * </p>
         * 
         * @param scheduleDescription
         *        The description of the snapshot schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleDescription(String scheduleDescription);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * Sets the value of the DryRun property for this object.
         *
         * @param dryRun
         *        The new value for the DryRun property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * Sets the value of the NextInvocations property for this object.
         *
         * @param nextInvocations
         *        The new value for the NextInvocations property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextInvocations(Integer nextInvocations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private List<String> scheduleDefinitions = DefaultSdkAutoConstructList.getInstance();

        private String scheduleIdentifier;

        private String scheduleDescription;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Boolean dryRun;

        private Integer nextInvocations;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnapshotScheduleRequest model) {
            super(model);
            scheduleDefinitions(model.scheduleDefinitions);
            scheduleIdentifier(model.scheduleIdentifier);
            scheduleDescription(model.scheduleDescription);
            tags(model.tags);
            dryRun(model.dryRun);
            nextInvocations(model.nextInvocations);
        }

        public final Collection<String> getScheduleDefinitions() {
            return scheduleDefinitions;
        }

        @Override
        public final Builder scheduleDefinitions(Collection<String> scheduleDefinitions) {
            this.scheduleDefinitions = ScheduleDefinitionListCopier.copy(scheduleDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduleDefinitions(String... scheduleDefinitions) {
            scheduleDefinitions(Arrays.asList(scheduleDefinitions));
            return this;
        }

        public final void setScheduleDefinitions(Collection<String> scheduleDefinitions) {
            this.scheduleDefinitions = ScheduleDefinitionListCopier.copy(scheduleDefinitions);
        }

        public final String getScheduleIdentifier() {
            return scheduleIdentifier;
        }

        @Override
        public final Builder scheduleIdentifier(String scheduleIdentifier) {
            this.scheduleIdentifier = scheduleIdentifier;
            return this;
        }

        public final void setScheduleIdentifier(String scheduleIdentifier) {
            this.scheduleIdentifier = scheduleIdentifier;
        }

        public final String getScheduleDescription() {
            return scheduleDescription;
        }

        @Override
        public final Builder scheduleDescription(String scheduleDescription) {
            this.scheduleDescription = scheduleDescription;
            return this;
        }

        public final void setScheduleDescription(String scheduleDescription) {
            this.scheduleDescription = scheduleDescription;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        public final Integer getNextInvocations() {
            return nextInvocations;
        }

        @Override
        public final Builder nextInvocations(Integer nextInvocations) {
            this.nextInvocations = nextInvocations;
            return this;
        }

        public final void setNextInvocations(Integer nextInvocations) {
            this.nextInvocations = nextInvocations;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSnapshotScheduleRequest build() {
            return new CreateSnapshotScheduleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
