/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHsmConfigurationResponse extends RedshiftResponse implements
        ToCopyableBuilder<CreateHsmConfigurationResponse.Builder, CreateHsmConfigurationResponse> {
    private static final SdkField<HsmConfiguration> HSM_CONFIGURATION_FIELD = SdkField
            .<HsmConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateHsmConfigurationResponse::hsmConfiguration)).setter(setter(Builder::hsmConfiguration))
            .constructor(HsmConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HSM_CONFIGURATION_FIELD));

    private final HsmConfiguration hsmConfiguration;

    private CreateHsmConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.hsmConfiguration = builder.hsmConfiguration;
    }

    /**
     * Returns the value of the HsmConfiguration property for this object.
     * 
     * @return The value of the HsmConfiguration property for this object.
     */
    public HsmConfiguration hsmConfiguration() {
        return hsmConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hsmConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHsmConfigurationResponse)) {
            return false;
        }
        CreateHsmConfigurationResponse other = (CreateHsmConfigurationResponse) obj;
        return Objects.equals(hsmConfiguration(), other.hsmConfiguration());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateHsmConfigurationResponse").add("HsmConfiguration", hsmConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HsmConfiguration":
            return Optional.ofNullable(clazz.cast(hsmConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHsmConfigurationResponse, T> g) {
        return obj -> g.apply((CreateHsmConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateHsmConfigurationResponse> {
        /**
         * Sets the value of the HsmConfiguration property for this object.
         *
         * @param hsmConfiguration
         *        The new value for the HsmConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmConfiguration(HsmConfiguration hsmConfiguration);

        /**
         * Sets the value of the HsmConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link HsmConfiguration.Builder} avoiding the need to
         * create one manually via {@link HsmConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link HsmConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #hsmConfiguration(HsmConfiguration)}.
         * 
         * @param hsmConfiguration
         *        a consumer that will call methods on {@link HsmConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hsmConfiguration(HsmConfiguration)
         */
        default Builder hsmConfiguration(Consumer<HsmConfiguration.Builder> hsmConfiguration) {
            return hsmConfiguration(HsmConfiguration.builder().applyMutation(hsmConfiguration).build());
        }
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private HsmConfiguration hsmConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHsmConfigurationResponse model) {
            super(model);
            hsmConfiguration(model.hsmConfiguration);
        }

        public final HsmConfiguration.Builder getHsmConfiguration() {
            return hsmConfiguration != null ? hsmConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder hsmConfiguration(HsmConfiguration hsmConfiguration) {
            this.hsmConfiguration = hsmConfiguration;
            return this;
        }

        public final void setHsmConfiguration(HsmConfiguration.BuilderImpl hsmConfiguration) {
            this.hsmConfiguration = hsmConfiguration != null ? hsmConfiguration.build() : null;
        }

        @Override
        public CreateHsmConfigurationResponse build() {
            return new CreateHsmConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
