/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the destination region and retention period that are configured for cross-region snapshot copy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterSnapshotCopyStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterSnapshotCopyStatus.Builder, ClusterSnapshotCopyStatus> {
    private static final SdkField<String> DESTINATION_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterSnapshotCopyStatus::destinationRegion)).setter(setter(Builder::destinationRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationRegion").build()).build();

    private static final SdkField<Long> RETENTION_PERIOD_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(ClusterSnapshotCopyStatus::retentionPeriod)).setter(setter(Builder::retentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriod").build()).build();

    private static final SdkField<Integer> MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ClusterSnapshotCopyStatus::manualSnapshotRetentionPeriod))
            .setter(setter(Builder::manualSnapshotRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManualSnapshotRetentionPeriod")
                    .build()).build();

    private static final SdkField<String> SNAPSHOT_COPY_GRANT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterSnapshotCopyStatus::snapshotCopyGrantName)).setter(setter(Builder::snapshotCopyGrantName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotCopyGrantName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_REGION_FIELD,
            RETENTION_PERIOD_FIELD, MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD, SNAPSHOT_COPY_GRANT_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String destinationRegion;

    private final Long retentionPeriod;

    private final Integer manualSnapshotRetentionPeriod;

    private final String snapshotCopyGrantName;

    private ClusterSnapshotCopyStatus(BuilderImpl builder) {
        this.destinationRegion = builder.destinationRegion;
        this.retentionPeriod = builder.retentionPeriod;
        this.manualSnapshotRetentionPeriod = builder.manualSnapshotRetentionPeriod;
        this.snapshotCopyGrantName = builder.snapshotCopyGrantName;
    }

    /**
     * <p>
     * The destination region that snapshots are automatically copied to when cross-region snapshot copy is enabled.
     * </p>
     * 
     * @return The destination region that snapshots are automatically copied to when cross-region snapshot copy is
     *         enabled.
     */
    public String destinationRegion() {
        return destinationRegion;
    }

    /**
     * <p>
     * The number of days that automated snapshots are retained in the destination region after they are copied from a
     * source region.
     * </p>
     * 
     * @return The number of days that automated snapshots are retained in the destination region after they are copied
     *         from a source region.
     */
    public Long retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * <p>
     * The number of days that automated snapshots are retained in the destination region after they are copied from a
     * source region. If the value is -1, the manual snapshot is retained indefinitely.
     * </p>
     * <p>
     * The value must be either -1 or an integer between 1 and 3,653.
     * </p>
     * 
     * @return The number of days that automated snapshots are retained in the destination region after they are copied
     *         from a source region. If the value is -1, the manual snapshot is retained indefinitely. </p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     */
    public Integer manualSnapshotRetentionPeriod() {
        return manualSnapshotRetentionPeriod;
    }

    /**
     * <p>
     * The name of the snapshot copy grant.
     * </p>
     * 
     * @return The name of the snapshot copy grant.
     */
    public String snapshotCopyGrantName() {
        return snapshotCopyGrantName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(manualSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotCopyGrantName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSnapshotCopyStatus)) {
            return false;
        }
        ClusterSnapshotCopyStatus other = (ClusterSnapshotCopyStatus) obj;
        return Objects.equals(destinationRegion(), other.destinationRegion())
                && Objects.equals(retentionPeriod(), other.retentionPeriod())
                && Objects.equals(manualSnapshotRetentionPeriod(), other.manualSnapshotRetentionPeriod())
                && Objects.equals(snapshotCopyGrantName(), other.snapshotCopyGrantName());
    }

    @Override
    public String toString() {
        return ToString.builder("ClusterSnapshotCopyStatus").add("DestinationRegion", destinationRegion())
                .add("RetentionPeriod", retentionPeriod()).add("ManualSnapshotRetentionPeriod", manualSnapshotRetentionPeriod())
                .add("SnapshotCopyGrantName", snapshotCopyGrantName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationRegion":
            return Optional.ofNullable(clazz.cast(destinationRegion()));
        case "RetentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "ManualSnapshotRetentionPeriod":
            return Optional.ofNullable(clazz.cast(manualSnapshotRetentionPeriod()));
        case "SnapshotCopyGrantName":
            return Optional.ofNullable(clazz.cast(snapshotCopyGrantName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterSnapshotCopyStatus, T> g) {
        return obj -> g.apply((ClusterSnapshotCopyStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterSnapshotCopyStatus> {
        /**
         * <p>
         * The destination region that snapshots are automatically copied to when cross-region snapshot copy is enabled.
         * </p>
         * 
         * @param destinationRegion
         *        The destination region that snapshots are automatically copied to when cross-region snapshot copy is
         *        enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationRegion(String destinationRegion);

        /**
         * <p>
         * The number of days that automated snapshots are retained in the destination region after they are copied from
         * a source region.
         * </p>
         * 
         * @param retentionPeriod
         *        The number of days that automated snapshots are retained in the destination region after they are
         *        copied from a source region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(Long retentionPeriod);

        /**
         * <p>
         * The number of days that automated snapshots are retained in the destination region after they are copied from
         * a source region. If the value is -1, the manual snapshot is retained indefinitely.
         * </p>
         * <p>
         * The value must be either -1 or an integer between 1 and 3,653.
         * </p>
         * 
         * @param manualSnapshotRetentionPeriod
         *        The number of days that automated snapshots are retained in the destination region after they are
         *        copied from a source region. If the value is -1, the manual snapshot is retained indefinitely. </p>
         *        <p>
         *        The value must be either -1 or an integer between 1 and 3,653.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod);

        /**
         * <p>
         * The name of the snapshot copy grant.
         * </p>
         * 
         * @param snapshotCopyGrantName
         *        The name of the snapshot copy grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotCopyGrantName(String snapshotCopyGrantName);
    }

    static final class BuilderImpl implements Builder {
        private String destinationRegion;

        private Long retentionPeriod;

        private Integer manualSnapshotRetentionPeriod;

        private String snapshotCopyGrantName;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterSnapshotCopyStatus model) {
            destinationRegion(model.destinationRegion);
            retentionPeriod(model.retentionPeriod);
            manualSnapshotRetentionPeriod(model.manualSnapshotRetentionPeriod);
            snapshotCopyGrantName(model.snapshotCopyGrantName);
        }

        public final String getDestinationRegion() {
            return destinationRegion;
        }

        @Override
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        public final Long getRetentionPeriod() {
            return retentionPeriod;
        }

        @Override
        public final Builder retentionPeriod(Long retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final void setRetentionPeriod(Long retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        public final Integer getManualSnapshotRetentionPeriod() {
            return manualSnapshotRetentionPeriod;
        }

        @Override
        public final Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
            return this;
        }

        public final void setManualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
        }

        public final String getSnapshotCopyGrantName() {
            return snapshotCopyGrantName;
        }

        @Override
        public final Builder snapshotCopyGrantName(String snapshotCopyGrantName) {
            this.snapshotCopyGrantName = snapshotCopyGrantName;
            return this;
        }

        public final void setSnapshotCopyGrantName(String snapshotCopyGrantName) {
            this.snapshotCopyGrantName = snapshotCopyGrantName;
        }

        @Override
        public ClusterSnapshotCopyStatus build() {
            return new ClusterSnapshotCopyStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
