/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the status of a parameter group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterParameterStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterParameterStatus.Builder, ClusterParameterStatus> {
    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterParameterStatus::parameterName)).setter(setter(Builder::parameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterName").build()).build();

    private static final SdkField<String> PARAMETER_APPLY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterParameterStatus::parameterApplyStatus)).setter(setter(Builder::parameterApplyStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterApplyStatus").build())
            .build();

    private static final SdkField<String> PARAMETER_APPLY_ERROR_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterParameterStatus::parameterApplyErrorDescription))
            .setter(setter(Builder::parameterApplyErrorDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterApplyErrorDescription")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_NAME_FIELD,
            PARAMETER_APPLY_STATUS_FIELD, PARAMETER_APPLY_ERROR_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String parameterName;

    private final String parameterApplyStatus;

    private final String parameterApplyErrorDescription;

    private ClusterParameterStatus(BuilderImpl builder) {
        this.parameterName = builder.parameterName;
        this.parameterApplyStatus = builder.parameterApplyStatus;
        this.parameterApplyErrorDescription = builder.parameterApplyErrorDescription;
    }

    /**
     * <p>
     * The name of the parameter.
     * </p>
     * 
     * @return The name of the parameter.
     */
    public String parameterName() {
        return parameterName;
    }

    /**
     * <p>
     * The status of the parameter that indicates whether the parameter is in sync with the database, waiting for a
     * cluster reboot, or encountered an error when being applied.
     * </p>
     * <p>
     * The following are possible statuses and descriptions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>in-sync</code>: The parameter value is in sync with the database.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending-reboot</code>: The parameter value will be applied after the cluster reboots.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>applying</code>: The parameter value is being applied to the database.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>invalid-parameter</code>: Cannot apply the parameter value because it has an invalid value or syntax.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>apply-deferred</code>: The parameter contains static property changes. The changes are deferred until the
     * cluster reboots.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>apply-error</code>: Cannot connect to the cluster. The parameter change will be applied after the cluster
     * reboots.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unknown-error</code>: Cannot apply the parameter change right now. The change will be applied after the
     * cluster reboots.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the parameter that indicates whether the parameter is in sync with the database, waiting
     *         for a cluster reboot, or encountered an error when being applied.</p>
     *         <p>
     *         The following are possible statuses and descriptions.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>in-sync</code>: The parameter value is in sync with the database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending-reboot</code>: The parameter value will be applied after the cluster reboots.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>applying</code>: The parameter value is being applied to the database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>invalid-parameter</code>: Cannot apply the parameter value because it has an invalid value or
     *         syntax.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>apply-deferred</code>: The parameter contains static property changes. The changes are deferred
     *         until the cluster reboots.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>apply-error</code>: Cannot connect to the cluster. The parameter change will be applied after the
     *         cluster reboots.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unknown-error</code>: Cannot apply the parameter change right now. The change will be applied after
     *         the cluster reboots.
     *         </p>
     *         </li>
     */
    public String parameterApplyStatus() {
        return parameterApplyStatus;
    }

    /**
     * <p>
     * The error that prevented the parameter from being applied to the database.
     * </p>
     * 
     * @return The error that prevented the parameter from being applied to the database.
     */
    public String parameterApplyErrorDescription() {
        return parameterApplyErrorDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(parameterApplyStatus());
        hashCode = 31 * hashCode + Objects.hashCode(parameterApplyErrorDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterParameterStatus)) {
            return false;
        }
        ClusterParameterStatus other = (ClusterParameterStatus) obj;
        return Objects.equals(parameterName(), other.parameterName())
                && Objects.equals(parameterApplyStatus(), other.parameterApplyStatus())
                && Objects.equals(parameterApplyErrorDescription(), other.parameterApplyErrorDescription());
    }

    @Override
    public String toString() {
        return ToString.builder("ClusterParameterStatus").add("ParameterName", parameterName())
                .add("ParameterApplyStatus", parameterApplyStatus())
                .add("ParameterApplyErrorDescription", parameterApplyErrorDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterName":
            return Optional.ofNullable(clazz.cast(parameterName()));
        case "ParameterApplyStatus":
            return Optional.ofNullable(clazz.cast(parameterApplyStatus()));
        case "ParameterApplyErrorDescription":
            return Optional.ofNullable(clazz.cast(parameterApplyErrorDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterParameterStatus, T> g) {
        return obj -> g.apply((ClusterParameterStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterParameterStatus> {
        /**
         * <p>
         * The name of the parameter.
         * </p>
         * 
         * @param parameterName
         *        The name of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterName(String parameterName);

        /**
         * <p>
         * The status of the parameter that indicates whether the parameter is in sync with the database, waiting for a
         * cluster reboot, or encountered an error when being applied.
         * </p>
         * <p>
         * The following are possible statuses and descriptions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>in-sync</code>: The parameter value is in sync with the database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending-reboot</code>: The parameter value will be applied after the cluster reboots.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>applying</code>: The parameter value is being applied to the database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>invalid-parameter</code>: Cannot apply the parameter value because it has an invalid value or syntax.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>apply-deferred</code>: The parameter contains static property changes. The changes are deferred until
         * the cluster reboots.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>apply-error</code>: Cannot connect to the cluster. The parameter change will be applied after the
         * cluster reboots.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unknown-error</code>: Cannot apply the parameter change right now. The change will be applied after the
         * cluster reboots.
         * </p>
         * </li>
         * </ul>
         * 
         * @param parameterApplyStatus
         *        The status of the parameter that indicates whether the parameter is in sync with the database, waiting
         *        for a cluster reboot, or encountered an error when being applied.</p>
         *        <p>
         *        The following are possible statuses and descriptions.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>in-sync</code>: The parameter value is in sync with the database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending-reboot</code>: The parameter value will be applied after the cluster reboots.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>applying</code>: The parameter value is being applied to the database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>invalid-parameter</code>: Cannot apply the parameter value because it has an invalid value or
         *        syntax.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>apply-deferred</code>: The parameter contains static property changes. The changes are deferred
         *        until the cluster reboots.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>apply-error</code>: Cannot connect to the cluster. The parameter change will be applied after
         *        the cluster reboots.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unknown-error</code>: Cannot apply the parameter change right now. The change will be applied
         *        after the cluster reboots.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterApplyStatus(String parameterApplyStatus);

        /**
         * <p>
         * The error that prevented the parameter from being applied to the database.
         * </p>
         * 
         * @param parameterApplyErrorDescription
         *        The error that prevented the parameter from being applied to the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterApplyErrorDescription(String parameterApplyErrorDescription);
    }

    static final class BuilderImpl implements Builder {
        private String parameterName;

        private String parameterApplyStatus;

        private String parameterApplyErrorDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterParameterStatus model) {
            parameterName(model.parameterName);
            parameterApplyStatus(model.parameterApplyStatus);
            parameterApplyErrorDescription(model.parameterApplyErrorDescription);
        }

        public final String getParameterName() {
            return parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        public final String getParameterApplyStatus() {
            return parameterApplyStatus;
        }

        @Override
        public final Builder parameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
            return this;
        }

        public final void setParameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
        }

        public final String getParameterApplyErrorDescription() {
            return parameterApplyErrorDescription;
        }

        @Override
        public final Builder parameterApplyErrorDescription(String parameterApplyErrorDescription) {
            this.parameterApplyErrorDescription = parameterApplyErrorDescription;
            return this;
        }

        public final void setParameterApplyErrorDescription(String parameterApplyErrorDescription) {
            this.parameterApplyErrorDescription = parameterApplyErrorDescription;
        }

        @Override
        public ClusterParameterStatus build() {
            return new ClusterParameterStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
