/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Cluster implements SdkPojo, Serializable, ToCopyableBuilder<Cluster.Builder, Cluster> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::clusterIdentifier)).setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::nodeType)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<String> CLUSTER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::clusterStatus)).setter(setter(Builder::clusterStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterStatus").build()).build();

    private static final SdkField<String> MODIFY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::modifyStatus)).setter(setter(Builder::modifyStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifyStatus").build()).build();

    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::masterUsername)).setter(setter(Builder::masterUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()).build();

    private static final SdkField<String> DB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::dbName)).setter(setter(Builder::dbName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBName").build()).build();

    private static final SdkField<Endpoint> ENDPOINT_FIELD = SdkField.<Endpoint> builder(MarshallingType.SDK_POJO)
            .getter(getter(Cluster::endpoint)).setter(setter(Builder::endpoint)).constructor(Endpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<Instant> CLUSTER_CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Cluster::clusterCreateTime)).setter(setter(Builder::clusterCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterCreateTime").build()).build();

    private static final SdkField<Integer> AUTOMATED_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Cluster::automatedSnapshotRetentionPeriod))
            .setter(setter(Builder::automatedSnapshotRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomatedSnapshotRetentionPeriod")
                    .build()).build();

    private static final SdkField<Integer> MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Cluster::manualSnapshotRetentionPeriod))
            .setter(setter(Builder::manualSnapshotRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManualSnapshotRetentionPeriod")
                    .build()).build();

    private static final SdkField<List<ClusterSecurityGroupMembership>> CLUSTER_SECURITY_GROUPS_FIELD = SdkField
            .<List<ClusterSecurityGroupMembership>> builder(MarshallingType.LIST)
            .getter(getter(Cluster::clusterSecurityGroups))
            .setter(setter(Builder::clusterSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ClusterSecurityGroup")
                            .memberFieldInfo(
                                    SdkField.<ClusterSecurityGroupMembership> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterSecurityGroupMembership::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ClusterSecurityGroup").build()).build()).build()).build();

    private static final SdkField<List<VpcSecurityGroupMembership>> VPC_SECURITY_GROUPS_FIELD = SdkField
            .<List<VpcSecurityGroupMembership>> builder(MarshallingType.LIST)
            .getter(getter(Cluster::vpcSecurityGroups))
            .setter(setter(Builder::vpcSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroup")
                            .memberFieldInfo(
                                    SdkField.<VpcSecurityGroupMembership> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcSecurityGroupMembership::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroup").build()).build()).build()).build();

    private static final SdkField<List<ClusterParameterGroupStatus>> CLUSTER_PARAMETER_GROUPS_FIELD = SdkField
            .<List<ClusterParameterGroupStatus>> builder(MarshallingType.LIST)
            .getter(getter(Cluster::clusterParameterGroups))
            .setter(setter(Builder::clusterParameterGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterParameterGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ClusterParameterGroup")
                            .memberFieldInfo(
                                    SdkField.<ClusterParameterGroupStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterParameterGroupStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ClusterParameterGroup").build()).build()).build()).build();

    private static final SdkField<String> CLUSTER_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::clusterSubnetGroupName)).setter(setter(Builder::clusterSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSubnetGroupName").build())
            .build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<PendingModifiedValues> PENDING_MODIFIED_VALUES_FIELD = SdkField
            .<PendingModifiedValues> builder(MarshallingType.SDK_POJO).getter(getter(Cluster::pendingModifiedValues))
            .setter(setter(Builder::pendingModifiedValues)).constructor(PendingModifiedValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingModifiedValues").build())
            .build();

    private static final SdkField<String> CLUSTER_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::clusterVersion)).setter(setter(Builder::clusterVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterVersion").build()).build();

    private static final SdkField<Boolean> ALLOW_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Cluster::allowVersionUpgrade)).setter(setter(Builder::allowVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowVersionUpgrade").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Cluster::numberOfNodes)).setter(setter(Builder::numberOfNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNodes").build()).build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Cluster::publiclyAccessible)).setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build())
            .build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Cluster::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final SdkField<RestoreStatus> RESTORE_STATUS_FIELD = SdkField
            .<RestoreStatus> builder(MarshallingType.SDK_POJO).getter(getter(Cluster::restoreStatus))
            .setter(setter(Builder::restoreStatus)).constructor(RestoreStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreStatus").build()).build();

    private static final SdkField<DataTransferProgress> DATA_TRANSFER_PROGRESS_FIELD = SdkField
            .<DataTransferProgress> builder(MarshallingType.SDK_POJO).getter(getter(Cluster::dataTransferProgress))
            .setter(setter(Builder::dataTransferProgress)).constructor(DataTransferProgress::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTransferProgress").build())
            .build();

    private static final SdkField<HsmStatus> HSM_STATUS_FIELD = SdkField.<HsmStatus> builder(MarshallingType.SDK_POJO)
            .getter(getter(Cluster::hsmStatus)).setter(setter(Builder::hsmStatus)).constructor(HsmStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmStatus").build()).build();

    private static final SdkField<ClusterSnapshotCopyStatus> CLUSTER_SNAPSHOT_COPY_STATUS_FIELD = SdkField
            .<ClusterSnapshotCopyStatus> builder(MarshallingType.SDK_POJO).getter(getter(Cluster::clusterSnapshotCopyStatus))
            .setter(setter(Builder::clusterSnapshotCopyStatus)).constructor(ClusterSnapshotCopyStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSnapshotCopyStatus").build())
            .build();

    private static final SdkField<String> CLUSTER_PUBLIC_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::clusterPublicKey)).setter(setter(Builder::clusterPublicKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterPublicKey").build()).build();

    private static final SdkField<List<ClusterNode>> CLUSTER_NODES_FIELD = SdkField
            .<List<ClusterNode>> builder(MarshallingType.LIST)
            .getter(getter(Cluster::clusterNodes))
            .setter(setter(Builder::clusterNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterNodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClusterNode> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterNode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ElasticIpStatus> ELASTIC_IP_STATUS_FIELD = SdkField
            .<ElasticIpStatus> builder(MarshallingType.SDK_POJO).getter(getter(Cluster::elasticIpStatus))
            .setter(setter(Builder::elasticIpStatus)).constructor(ElasticIpStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticIpStatus").build()).build();

    private static final SdkField<String> CLUSTER_REVISION_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::clusterRevisionNumber)).setter(setter(Builder::clusterRevisionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterRevisionNumber").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(Cluster::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Boolean> ENHANCED_VPC_ROUTING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Cluster::enhancedVpcRouting)).setter(setter(Builder::enhancedVpcRouting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnhancedVpcRouting").build())
            .build();

    private static final SdkField<List<ClusterIamRole>> IAM_ROLES_FIELD = SdkField
            .<List<ClusterIamRole>> builder(MarshallingType.LIST)
            .getter(getter(Cluster::iamRoles))
            .setter(setter(Builder::iamRoles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ClusterIamRole")
                            .memberFieldInfo(
                                    SdkField.<ClusterIamRole> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterIamRole::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ClusterIamRole").build()).build()).build()).build();

    private static final SdkField<List<String>> PENDING_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Cluster::pendingActions))
            .setter(setter(Builder::pendingActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MAINTENANCE_TRACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::maintenanceTrackName)).setter(setter(Builder::maintenanceTrackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceTrackName").build())
            .build();

    private static final SdkField<String> ELASTIC_RESIZE_NUMBER_OF_NODE_OPTIONS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::elasticResizeNumberOfNodeOptions))
            .setter(setter(Builder::elasticResizeNumberOfNodeOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticResizeNumberOfNodeOptions")
                    .build()).build();

    private static final SdkField<List<DeferredMaintenanceWindow>> DEFERRED_MAINTENANCE_WINDOWS_FIELD = SdkField
            .<List<DeferredMaintenanceWindow>> builder(MarshallingType.LIST)
            .getter(getter(Cluster::deferredMaintenanceWindows))
            .setter(setter(Builder::deferredMaintenanceWindows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeferredMaintenanceWindows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DeferredMaintenanceWindow")
                            .memberFieldInfo(
                                    SdkField.<DeferredMaintenanceWindow> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeferredMaintenanceWindow::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DeferredMaintenanceWindow").build()).build()).build()).build();

    private static final SdkField<String> SNAPSHOT_SCHEDULE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::snapshotScheduleIdentifier))
            .setter(setter(Builder::snapshotScheduleIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotScheduleIdentifier").build())
            .build();

    private static final SdkField<String> SNAPSHOT_SCHEDULE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::snapshotScheduleStateAsString)).setter(setter(Builder::snapshotScheduleState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotScheduleState").build())
            .build();

    private static final SdkField<ResizeInfo> RESIZE_INFO_FIELD = SdkField.<ResizeInfo> builder(MarshallingType.SDK_POJO)
            .getter(getter(Cluster::resizeInfo)).setter(setter(Builder::resizeInfo)).constructor(ResizeInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResizeInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            NODE_TYPE_FIELD, CLUSTER_STATUS_FIELD, MODIFY_STATUS_FIELD, MASTER_USERNAME_FIELD, DB_NAME_FIELD, ENDPOINT_FIELD,
            CLUSTER_CREATE_TIME_FIELD, AUTOMATED_SNAPSHOT_RETENTION_PERIOD_FIELD, MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD,
            CLUSTER_SECURITY_GROUPS_FIELD, VPC_SECURITY_GROUPS_FIELD, CLUSTER_PARAMETER_GROUPS_FIELD,
            CLUSTER_SUBNET_GROUP_NAME_FIELD, VPC_ID_FIELD, AVAILABILITY_ZONE_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD,
            PENDING_MODIFIED_VALUES_FIELD, CLUSTER_VERSION_FIELD, ALLOW_VERSION_UPGRADE_FIELD, NUMBER_OF_NODES_FIELD,
            PUBLICLY_ACCESSIBLE_FIELD, ENCRYPTED_FIELD, RESTORE_STATUS_FIELD, DATA_TRANSFER_PROGRESS_FIELD, HSM_STATUS_FIELD,
            CLUSTER_SNAPSHOT_COPY_STATUS_FIELD, CLUSTER_PUBLIC_KEY_FIELD, CLUSTER_NODES_FIELD, ELASTIC_IP_STATUS_FIELD,
            CLUSTER_REVISION_NUMBER_FIELD, TAGS_FIELD, KMS_KEY_ID_FIELD, ENHANCED_VPC_ROUTING_FIELD, IAM_ROLES_FIELD,
            PENDING_ACTIONS_FIELD, MAINTENANCE_TRACK_NAME_FIELD, ELASTIC_RESIZE_NUMBER_OF_NODE_OPTIONS_FIELD,
            DEFERRED_MAINTENANCE_WINDOWS_FIELD, SNAPSHOT_SCHEDULE_IDENTIFIER_FIELD, SNAPSHOT_SCHEDULE_STATE_FIELD,
            RESIZE_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clusterIdentifier;

    private final String nodeType;

    private final String clusterStatus;

    private final String modifyStatus;

    private final String masterUsername;

    private final String dbName;

    private final Endpoint endpoint;

    private final Instant clusterCreateTime;

    private final Integer automatedSnapshotRetentionPeriod;

    private final Integer manualSnapshotRetentionPeriod;

    private final List<ClusterSecurityGroupMembership> clusterSecurityGroups;

    private final List<VpcSecurityGroupMembership> vpcSecurityGroups;

    private final List<ClusterParameterGroupStatus> clusterParameterGroups;

    private final String clusterSubnetGroupName;

    private final String vpcId;

    private final String availabilityZone;

    private final String preferredMaintenanceWindow;

    private final PendingModifiedValues pendingModifiedValues;

    private final String clusterVersion;

    private final Boolean allowVersionUpgrade;

    private final Integer numberOfNodes;

    private final Boolean publiclyAccessible;

    private final Boolean encrypted;

    private final RestoreStatus restoreStatus;

    private final DataTransferProgress dataTransferProgress;

    private final HsmStatus hsmStatus;

    private final ClusterSnapshotCopyStatus clusterSnapshotCopyStatus;

    private final String clusterPublicKey;

    private final List<ClusterNode> clusterNodes;

    private final ElasticIpStatus elasticIpStatus;

    private final String clusterRevisionNumber;

    private final List<Tag> tags;

    private final String kmsKeyId;

    private final Boolean enhancedVpcRouting;

    private final List<ClusterIamRole> iamRoles;

    private final List<String> pendingActions;

    private final String maintenanceTrackName;

    private final String elasticResizeNumberOfNodeOptions;

    private final List<DeferredMaintenanceWindow> deferredMaintenanceWindows;

    private final String snapshotScheduleIdentifier;

    private final String snapshotScheduleState;

    private final ResizeInfo resizeInfo;

    private Cluster(BuilderImpl builder) {
        this.clusterIdentifier = builder.clusterIdentifier;
        this.nodeType = builder.nodeType;
        this.clusterStatus = builder.clusterStatus;
        this.modifyStatus = builder.modifyStatus;
        this.masterUsername = builder.masterUsername;
        this.dbName = builder.dbName;
        this.endpoint = builder.endpoint;
        this.clusterCreateTime = builder.clusterCreateTime;
        this.automatedSnapshotRetentionPeriod = builder.automatedSnapshotRetentionPeriod;
        this.manualSnapshotRetentionPeriod = builder.manualSnapshotRetentionPeriod;
        this.clusterSecurityGroups = builder.clusterSecurityGroups;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
        this.clusterParameterGroups = builder.clusterParameterGroups;
        this.clusterSubnetGroupName = builder.clusterSubnetGroupName;
        this.vpcId = builder.vpcId;
        this.availabilityZone = builder.availabilityZone;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.clusterVersion = builder.clusterVersion;
        this.allowVersionUpgrade = builder.allowVersionUpgrade;
        this.numberOfNodes = builder.numberOfNodes;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.encrypted = builder.encrypted;
        this.restoreStatus = builder.restoreStatus;
        this.dataTransferProgress = builder.dataTransferProgress;
        this.hsmStatus = builder.hsmStatus;
        this.clusterSnapshotCopyStatus = builder.clusterSnapshotCopyStatus;
        this.clusterPublicKey = builder.clusterPublicKey;
        this.clusterNodes = builder.clusterNodes;
        this.elasticIpStatus = builder.elasticIpStatus;
        this.clusterRevisionNumber = builder.clusterRevisionNumber;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
        this.enhancedVpcRouting = builder.enhancedVpcRouting;
        this.iamRoles = builder.iamRoles;
        this.pendingActions = builder.pendingActions;
        this.maintenanceTrackName = builder.maintenanceTrackName;
        this.elasticResizeNumberOfNodeOptions = builder.elasticResizeNumberOfNodeOptions;
        this.deferredMaintenanceWindows = builder.deferredMaintenanceWindows;
        this.snapshotScheduleIdentifier = builder.snapshotScheduleIdentifier;
        this.snapshotScheduleState = builder.snapshotScheduleState;
        this.resizeInfo = builder.resizeInfo;
    }

    /**
     * <p>
     * The unique identifier of the cluster.
     * </p>
     * 
     * @return The unique identifier of the cluster.
     */
    public String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The node type for the nodes in the cluster.
     * </p>
     * 
     * @return The node type for the nodes in the cluster.
     */
    public String nodeType() {
        return nodeType;
    }

    /**
     * <p>
     * The current state of the cluster. Possible values are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>available</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>available, prep-for-resize</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>available, resize-cleanup</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cancelling-resize</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>creating</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleting</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>final-snapshot</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>hardware-failure</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>incompatible-hsm</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>incompatible-network</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>incompatible-parameters</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>incompatible-restore</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>modifying</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rebooting</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>renaming</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resizing</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rotating-keys</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>storage-full</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>updating-hsm</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The current state of the cluster. Possible values are the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>available</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>available, prep-for-resize</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>available, resize-cleanup</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cancelling-resize</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>creating</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleting</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>final-snapshot</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>hardware-failure</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>incompatible-hsm</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>incompatible-network</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>incompatible-parameters</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>incompatible-restore</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>modifying</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rebooting</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>renaming</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resizing</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rotating-keys</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>storage-full</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>updating-hsm</code>
     *         </p>
     *         </li>
     */
    public String clusterStatus() {
        return clusterStatus;
    }

    /**
     * <p>
     * The status of a modify operation, if any, initiated for the cluster.
     * </p>
     * 
     * @return The status of a modify operation, if any, initiated for the cluster.
     */
    public String modifyStatus() {
        return modifyStatus;
    }

    /**
     * <p>
     * The master user name for the cluster. This name is used to connect to the database that is specified in the
     * <b>DBName</b> parameter.
     * </p>
     * 
     * @return The master user name for the cluster. This name is used to connect to the database that is specified in
     *         the <b>DBName</b> parameter.
     */
    public String masterUsername() {
        return masterUsername;
    }

    /**
     * <p>
     * The name of the initial database that was created when the cluster was created. This same name is returned for
     * the life of the cluster. If an initial database was not specified, a database named <code>dev</code>dev was
     * created by default.
     * </p>
     * 
     * @return The name of the initial database that was created when the cluster was created. This same name is
     *         returned for the life of the cluster. If an initial database was not specified, a database named
     *         <code>dev</code>dev was created by default.
     */
    public String dbName() {
        return dbName;
    }

    /**
     * <p>
     * The connection endpoint.
     * </p>
     * 
     * @return The connection endpoint.
     */
    public Endpoint endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The date and time that the cluster was created.
     * </p>
     * 
     * @return The date and time that the cluster was created.
     */
    public Instant clusterCreateTime() {
        return clusterCreateTime;
    }

    /**
     * <p>
     * The number of days that automatic cluster snapshots are retained.
     * </p>
     * 
     * @return The number of days that automatic cluster snapshots are retained.
     */
    public Integer automatedSnapshotRetentionPeriod() {
        return automatedSnapshotRetentionPeriod;
    }

    /**
     * <p>
     * The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained
     * indefinitely. This setting doesn't change the retention period of existing snapshots.
     * </p>
     * <p>
     * The value must be either -1 or an integer between 1 and 3,653.
     * </p>
     * 
     * @return The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained
     *         indefinitely. This setting doesn't change the retention period of existing snapshots.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     */
    public Integer manualSnapshotRetentionPeriod() {
        return manualSnapshotRetentionPeriod;
    }

    /**
     * <p>
     * A list of cluster security group that are associated with the cluster. Each security group is represented by an
     * element that contains <code>ClusterSecurityGroup.Name</code> and <code>ClusterSecurityGroup.Status</code>
     * subelements.
     * </p>
     * <p>
     * Cluster security groups are used when the cluster is not created in an Amazon Virtual Private Cloud (VPC).
     * Clusters that are created in a VPC use VPC security groups, which are listed by the <b>VpcSecurityGroups</b>
     * parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of cluster security group that are associated with the cluster. Each security group is represented
     *         by an element that contains <code>ClusterSecurityGroup.Name</code> and
     *         <code>ClusterSecurityGroup.Status</code> subelements. </p>
     *         <p>
     *         Cluster security groups are used when the cluster is not created in an Amazon Virtual Private Cloud
     *         (VPC). Clusters that are created in a VPC use VPC security groups, which are listed by the
     *         <b>VpcSecurityGroups</b> parameter.
     */
    public List<ClusterSecurityGroupMembership> clusterSecurityGroups() {
        return clusterSecurityGroups;
    }

    /**
     * <p>
     * A list of Amazon Virtual Private Cloud (Amazon VPC) security groups that are associated with the cluster. This
     * parameter is returned only if the cluster is in a VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of Amazon Virtual Private Cloud (Amazon VPC) security groups that are associated with the cluster.
     *         This parameter is returned only if the cluster is in a VPC.
     */
    public List<VpcSecurityGroupMembership> vpcSecurityGroups() {
        return vpcSecurityGroups;
    }

    /**
     * <p>
     * The list of cluster parameter groups that are associated with this cluster. Each parameter group in the list is
     * returned with its status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of cluster parameter groups that are associated with this cluster. Each parameter group in the
     *         list is returned with its status.
     */
    public List<ClusterParameterGroupStatus> clusterParameterGroups() {
        return clusterParameterGroups;
    }

    /**
     * <p>
     * The name of the subnet group that is associated with the cluster. This parameter is valid only when the cluster
     * is in a VPC.
     * </p>
     * 
     * @return The name of the subnet group that is associated with the cluster. This parameter is valid only when the
     *         cluster is in a VPC.
     */
    public String clusterSubnetGroupName() {
        return clusterSubnetGroupName;
    }

    /**
     * <p>
     * The identifier of the VPC the cluster is in, if the cluster is in a VPC.
     * </p>
     * 
     * @return The identifier of the VPC the cluster is in, if the cluster is in a VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The name of the Availability Zone in which the cluster is located.
     * </p>
     * 
     * @return The name of the Availability Zone in which the cluster is located.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The weekly time range, in Universal Coordinated Time (UTC), during which system maintenance can occur.
     * </p>
     * 
     * @return The weekly time range, in Universal Coordinated Time (UTC), during which system maintenance can occur.
     */
    public String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * A value that, if present, indicates that changes to the cluster are pending. Specific pending changes are
     * identified by subelements.
     * </p>
     * 
     * @return A value that, if present, indicates that changes to the cluster are pending. Specific pending changes are
     *         identified by subelements.
     */
    public PendingModifiedValues pendingModifiedValues() {
        return pendingModifiedValues;
    }

    /**
     * <p>
     * The version ID of the Amazon Redshift engine that is running on the cluster.
     * </p>
     * 
     * @return The version ID of the Amazon Redshift engine that is running on the cluster.
     */
    public String clusterVersion() {
        return clusterVersion;
    }

    /**
     * <p>
     * A boolean value that, if <code>true</code>, indicates that major version upgrades will be applied automatically
     * to the cluster during the maintenance window.
     * </p>
     * 
     * @return A boolean value that, if <code>true</code>, indicates that major version upgrades will be applied
     *         automatically to the cluster during the maintenance window.
     */
    public Boolean allowVersionUpgrade() {
        return allowVersionUpgrade;
    }

    /**
     * <p>
     * The number of compute nodes in the cluster.
     * </p>
     * 
     * @return The number of compute nodes in the cluster.
     */
    public Integer numberOfNodes() {
        return numberOfNodes;
    }

    /**
     * <p>
     * A boolean value that, if <code>true</code>, indicates that the cluster can be accessed from a public network.
     * </p>
     * 
     * @return A boolean value that, if <code>true</code>, indicates that the cluster can be accessed from a public
     *         network.
     */
    public Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * <p>
     * A boolean value that, if <code>true</code>, indicates that data in the cluster is encrypted at rest.
     * </p>
     * 
     * @return A boolean value that, if <code>true</code>, indicates that data in the cluster is encrypted at rest.
     */
    public Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * A value that describes the status of a cluster restore action. This parameter returns null if the cluster was not
     * created by restoring a snapshot.
     * </p>
     * 
     * @return A value that describes the status of a cluster restore action. This parameter returns null if the cluster
     *         was not created by restoring a snapshot.
     */
    public RestoreStatus restoreStatus() {
        return restoreStatus;
    }

    /**
     * Returns the value of the DataTransferProgress property for this object.
     * 
     * @return The value of the DataTransferProgress property for this object.
     */
    public DataTransferProgress dataTransferProgress() {
        return dataTransferProgress;
    }

    /**
     * <p>
     * A value that reports whether the Amazon Redshift cluster has finished applying any hardware security module (HSM)
     * settings changes specified in a modify cluster command.
     * </p>
     * <p>
     * Values: active, applying
     * </p>
     * 
     * @return A value that reports whether the Amazon Redshift cluster has finished applying any hardware security
     *         module (HSM) settings changes specified in a modify cluster command.</p>
     *         <p>
     *         Values: active, applying
     */
    public HsmStatus hsmStatus() {
        return hsmStatus;
    }

    /**
     * <p>
     * A value that returns the destination region and retention period that are configured for cross-region snapshot
     * copy.
     * </p>
     * 
     * @return A value that returns the destination region and retention period that are configured for cross-region
     *         snapshot copy.
     */
    public ClusterSnapshotCopyStatus clusterSnapshotCopyStatus() {
        return clusterSnapshotCopyStatus;
    }

    /**
     * <p>
     * The public key for the cluster.
     * </p>
     * 
     * @return The public key for the cluster.
     */
    public String clusterPublicKey() {
        return clusterPublicKey;
    }

    /**
     * <p>
     * The nodes in the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The nodes in the cluster.
     */
    public List<ClusterNode> clusterNodes() {
        return clusterNodes;
    }

    /**
     * <p>
     * The status of the elastic IP (EIP) address.
     * </p>
     * 
     * @return The status of the elastic IP (EIP) address.
     */
    public ElasticIpStatus elasticIpStatus() {
        return elasticIpStatus;
    }

    /**
     * <p>
     * The specific revision number of the database in the cluster.
     * </p>
     * 
     * @return The specific revision number of the database in the cluster.
     */
    public String clusterRevisionNumber() {
        return clusterRevisionNumber;
    }

    /**
     * <p>
     * The list of tags for the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of tags for the cluster.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The AWS Key Management Service (AWS KMS) key ID of the encryption key used to encrypt data in the cluster.
     * </p>
     * 
     * @return The AWS Key Management Service (AWS KMS) key ID of the encryption key used to encrypt data in the
     *         cluster.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster
     * that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the
     * Amazon Redshift Cluster Management Guide.
     * </p>
     * <p>
     * If this option is <code>true</code>, enhanced VPC routing is enabled.
     * </p>
     * <p>
     * Default: false
     * </p>
     * 
     * @return An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a
     *         cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a>
     *         in the Amazon Redshift Cluster Management Guide.</p>
     *         <p>
     *         If this option is <code>true</code>, enhanced VPC routing is enabled.
     *         </p>
     *         <p>
     *         Default: false
     */
    public Boolean enhancedVpcRouting() {
        return enhancedVpcRouting;
    }

    /**
     * <p>
     * A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access other AWS
     * services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access other
     *         AWS services.
     */
    public List<ClusterIamRole> iamRoles() {
        return iamRoles;
    }

    /**
     * <p>
     * Cluster operations that are waiting to be started.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Cluster operations that are waiting to be started.
     */
    public List<String> pendingActions() {
        return pendingActions;
    }

    /**
     * <p>
     * The name of the maintenance track for the cluster.
     * </p>
     * 
     * @return The name of the maintenance track for the cluster.
     */
    public String maintenanceTrackName() {
        return maintenanceTrackName;
    }

    /**
     * <p>
     * The number of nodes that you can resize the cluster to with the elastic resize method.
     * </p>
     * 
     * @return The number of nodes that you can resize the cluster to with the elastic resize method.
     */
    public String elasticResizeNumberOfNodeOptions() {
        return elasticResizeNumberOfNodeOptions;
    }

    /**
     * <p>
     * Describes a group of <code>DeferredMaintenanceWindow</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Describes a group of <code>DeferredMaintenanceWindow</code> objects.
     */
    public List<DeferredMaintenanceWindow> deferredMaintenanceWindows() {
        return deferredMaintenanceWindows;
    }

    /**
     * <p>
     * A unique identifier for the cluster snapshot schedule.
     * </p>
     * 
     * @return A unique identifier for the cluster snapshot schedule.
     */
    public String snapshotScheduleIdentifier() {
        return snapshotScheduleIdentifier;
    }

    /**
     * <p>
     * The current state of the cluster snapshot schedule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #snapshotScheduleState} will return {@link ScheduleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #snapshotScheduleStateAsString}.
     * </p>
     * 
     * @return The current state of the cluster snapshot schedule.
     * @see ScheduleState
     */
    public ScheduleState snapshotScheduleState() {
        return ScheduleState.fromValue(snapshotScheduleState);
    }

    /**
     * <p>
     * The current state of the cluster snapshot schedule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #snapshotScheduleState} will return {@link ScheduleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #snapshotScheduleStateAsString}.
     * </p>
     * 
     * @return The current state of the cluster snapshot schedule.
     * @see ScheduleState
     */
    public String snapshotScheduleStateAsString() {
        return snapshotScheduleState;
    }

    /**
     * <p>
     * Returns the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AllowCancelResize: a boolean value indicating if the resize operation can be cancelled.
     * </p>
     * </li>
     * <li>
     * <p>
     * ResizeType: Returns ClassicResize
     * </p>
     * </li>
     * </ul>
     * 
     * @return Returns the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         AllowCancelResize: a boolean value indicating if the resize operation can be cancelled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ResizeType: Returns ClassicResize
     *         </p>
     *         </li>
     */
    public ResizeInfo resizeInfo() {
        return resizeInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(clusterStatus());
        hashCode = 31 * hashCode + Objects.hashCode(modifyStatus());
        hashCode = 31 * hashCode + Objects.hashCode(masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(dbName());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(clusterCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(automatedSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(manualSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(clusterSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(vpcSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(clusterParameterGroups());
        hashCode = 31 * hashCode + Objects.hashCode(clusterSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(pendingModifiedValues());
        hashCode = 31 * hashCode + Objects.hashCode(clusterVersion());
        hashCode = 31 * hashCode + Objects.hashCode(allowVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(restoreStatus());
        hashCode = 31 * hashCode + Objects.hashCode(dataTransferProgress());
        hashCode = 31 * hashCode + Objects.hashCode(hsmStatus());
        hashCode = 31 * hashCode + Objects.hashCode(clusterSnapshotCopyStatus());
        hashCode = 31 * hashCode + Objects.hashCode(clusterPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(clusterNodes());
        hashCode = 31 * hashCode + Objects.hashCode(elasticIpStatus());
        hashCode = 31 * hashCode + Objects.hashCode(clusterRevisionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(enhancedVpcRouting());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoles());
        hashCode = 31 * hashCode + Objects.hashCode(pendingActions());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceTrackName());
        hashCode = 31 * hashCode + Objects.hashCode(elasticResizeNumberOfNodeOptions());
        hashCode = 31 * hashCode + Objects.hashCode(deferredMaintenanceWindows());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotScheduleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotScheduleStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resizeInfo());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(nodeType(), other.nodeType())
                && Objects.equals(clusterStatus(), other.clusterStatus()) && Objects.equals(modifyStatus(), other.modifyStatus())
                && Objects.equals(masterUsername(), other.masterUsername()) && Objects.equals(dbName(), other.dbName())
                && Objects.equals(endpoint(), other.endpoint()) && Objects.equals(clusterCreateTime(), other.clusterCreateTime())
                && Objects.equals(automatedSnapshotRetentionPeriod(), other.automatedSnapshotRetentionPeriod())
                && Objects.equals(manualSnapshotRetentionPeriod(), other.manualSnapshotRetentionPeriod())
                && Objects.equals(clusterSecurityGroups(), other.clusterSecurityGroups())
                && Objects.equals(vpcSecurityGroups(), other.vpcSecurityGroups())
                && Objects.equals(clusterParameterGroups(), other.clusterParameterGroups())
                && Objects.equals(clusterSubnetGroupName(), other.clusterSubnetGroupName())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(pendingModifiedValues(), other.pendingModifiedValues())
                && Objects.equals(clusterVersion(), other.clusterVersion())
                && Objects.equals(allowVersionUpgrade(), other.allowVersionUpgrade())
                && Objects.equals(numberOfNodes(), other.numberOfNodes())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && Objects.equals(encrypted(), other.encrypted()) && Objects.equals(restoreStatus(), other.restoreStatus())
                && Objects.equals(dataTransferProgress(), other.dataTransferProgress())
                && Objects.equals(hsmStatus(), other.hsmStatus())
                && Objects.equals(clusterSnapshotCopyStatus(), other.clusterSnapshotCopyStatus())
                && Objects.equals(clusterPublicKey(), other.clusterPublicKey())
                && Objects.equals(clusterNodes(), other.clusterNodes())
                && Objects.equals(elasticIpStatus(), other.elasticIpStatus())
                && Objects.equals(clusterRevisionNumber(), other.clusterRevisionNumber()) && Objects.equals(tags(), other.tags())
                && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(enhancedVpcRouting(), other.enhancedVpcRouting())
                && Objects.equals(iamRoles(), other.iamRoles()) && Objects.equals(pendingActions(), other.pendingActions())
                && Objects.equals(maintenanceTrackName(), other.maintenanceTrackName())
                && Objects.equals(elasticResizeNumberOfNodeOptions(), other.elasticResizeNumberOfNodeOptions())
                && Objects.equals(deferredMaintenanceWindows(), other.deferredMaintenanceWindows())
                && Objects.equals(snapshotScheduleIdentifier(), other.snapshotScheduleIdentifier())
                && Objects.equals(snapshotScheduleStateAsString(), other.snapshotScheduleStateAsString())
                && Objects.equals(resizeInfo(), other.resizeInfo());
    }

    @Override
    public String toString() {
        return ToString.builder("Cluster").add("ClusterIdentifier", clusterIdentifier()).add("NodeType", nodeType())
                .add("ClusterStatus", clusterStatus()).add("ModifyStatus", modifyStatus())
                .add("MasterUsername", masterUsername()).add("DBName", dbName()).add("Endpoint", endpoint())
                .add("ClusterCreateTime", clusterCreateTime())
                .add("AutomatedSnapshotRetentionPeriod", automatedSnapshotRetentionPeriod())
                .add("ManualSnapshotRetentionPeriod", manualSnapshotRetentionPeriod())
                .add("ClusterSecurityGroups", clusterSecurityGroups()).add("VpcSecurityGroups", vpcSecurityGroups())
                .add("ClusterParameterGroups", clusterParameterGroups()).add("ClusterSubnetGroupName", clusterSubnetGroupName())
                .add("VpcId", vpcId()).add("AvailabilityZone", availabilityZone())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("PendingModifiedValues", pendingModifiedValues()).add("ClusterVersion", clusterVersion())
                .add("AllowVersionUpgrade", allowVersionUpgrade()).add("NumberOfNodes", numberOfNodes())
                .add("PubliclyAccessible", publiclyAccessible()).add("Encrypted", encrypted())
                .add("RestoreStatus", restoreStatus()).add("DataTransferProgress", dataTransferProgress())
                .add("HsmStatus", hsmStatus()).add("ClusterSnapshotCopyStatus", clusterSnapshotCopyStatus())
                .add("ClusterPublicKey", clusterPublicKey()).add("ClusterNodes", clusterNodes())
                .add("ElasticIpStatus", elasticIpStatus()).add("ClusterRevisionNumber", clusterRevisionNumber())
                .add("Tags", tags()).add("KmsKeyId", kmsKeyId()).add("EnhancedVpcRouting", enhancedVpcRouting())
                .add("IamRoles", iamRoles()).add("PendingActions", pendingActions())
                .add("MaintenanceTrackName", maintenanceTrackName())
                .add("ElasticResizeNumberOfNodeOptions", elasticResizeNumberOfNodeOptions())
                .add("DeferredMaintenanceWindows", deferredMaintenanceWindows())
                .add("SnapshotScheduleIdentifier", snapshotScheduleIdentifier())
                .add("SnapshotScheduleState", snapshotScheduleStateAsString()).add("ResizeInfo", resizeInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        case "ClusterStatus":
            return Optional.ofNullable(clazz.cast(clusterStatus()));
        case "ModifyStatus":
            return Optional.ofNullable(clazz.cast(modifyStatus()));
        case "MasterUsername":
            return Optional.ofNullable(clazz.cast(masterUsername()));
        case "DBName":
            return Optional.ofNullable(clazz.cast(dbName()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "ClusterCreateTime":
            return Optional.ofNullable(clazz.cast(clusterCreateTime()));
        case "AutomatedSnapshotRetentionPeriod":
            return Optional.ofNullable(clazz.cast(automatedSnapshotRetentionPeriod()));
        case "ManualSnapshotRetentionPeriod":
            return Optional.ofNullable(clazz.cast(manualSnapshotRetentionPeriod()));
        case "ClusterSecurityGroups":
            return Optional.ofNullable(clazz.cast(clusterSecurityGroups()));
        case "VpcSecurityGroups":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroups()));
        case "ClusterParameterGroups":
            return Optional.ofNullable(clazz.cast(clusterParameterGroups()));
        case "ClusterSubnetGroupName":
            return Optional.ofNullable(clazz.cast(clusterSubnetGroupName()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "PendingModifiedValues":
            return Optional.ofNullable(clazz.cast(pendingModifiedValues()));
        case "ClusterVersion":
            return Optional.ofNullable(clazz.cast(clusterVersion()));
        case "AllowVersionUpgrade":
            return Optional.ofNullable(clazz.cast(allowVersionUpgrade()));
        case "NumberOfNodes":
            return Optional.ofNullable(clazz.cast(numberOfNodes()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "RestoreStatus":
            return Optional.ofNullable(clazz.cast(restoreStatus()));
        case "DataTransferProgress":
            return Optional.ofNullable(clazz.cast(dataTransferProgress()));
        case "HsmStatus":
            return Optional.ofNullable(clazz.cast(hsmStatus()));
        case "ClusterSnapshotCopyStatus":
            return Optional.ofNullable(clazz.cast(clusterSnapshotCopyStatus()));
        case "ClusterPublicKey":
            return Optional.ofNullable(clazz.cast(clusterPublicKey()));
        case "ClusterNodes":
            return Optional.ofNullable(clazz.cast(clusterNodes()));
        case "ElasticIpStatus":
            return Optional.ofNullable(clazz.cast(elasticIpStatus()));
        case "ClusterRevisionNumber":
            return Optional.ofNullable(clazz.cast(clusterRevisionNumber()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "EnhancedVpcRouting":
            return Optional.ofNullable(clazz.cast(enhancedVpcRouting()));
        case "IamRoles":
            return Optional.ofNullable(clazz.cast(iamRoles()));
        case "PendingActions":
            return Optional.ofNullable(clazz.cast(pendingActions()));
        case "MaintenanceTrackName":
            return Optional.ofNullable(clazz.cast(maintenanceTrackName()));
        case "ElasticResizeNumberOfNodeOptions":
            return Optional.ofNullable(clazz.cast(elasticResizeNumberOfNodeOptions()));
        case "DeferredMaintenanceWindows":
            return Optional.ofNullable(clazz.cast(deferredMaintenanceWindows()));
        case "SnapshotScheduleIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotScheduleIdentifier()));
        case "SnapshotScheduleState":
            return Optional.ofNullable(clazz.cast(snapshotScheduleStateAsString()));
        case "ResizeInfo":
            return Optional.ofNullable(clazz.cast(resizeInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cluster, T> g) {
        return obj -> g.apply((Cluster) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Cluster> {
        /**
         * <p>
         * The unique identifier of the cluster.
         * </p>
         * 
         * @param clusterIdentifier
         *        The unique identifier of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The node type for the nodes in the cluster.
         * </p>
         * 
         * @param nodeType
         *        The node type for the nodes in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * The current state of the cluster. Possible values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>available</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available, prep-for-resize</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available, resize-cleanup</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cancelling-resize</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>creating</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleting</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>final-snapshot</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hardware-failure</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>incompatible-hsm</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>incompatible-network</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>incompatible-parameters</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>incompatible-restore</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>modifying</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rebooting</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>renaming</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resizing</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rotating-keys</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>storage-full</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>updating-hsm</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param clusterStatus
         *        The current state of the cluster. Possible values are the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>available</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available, prep-for-resize</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available, resize-cleanup</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cancelling-resize</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>creating</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleting</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>final-snapshot</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>hardware-failure</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>incompatible-hsm</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>incompatible-network</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>incompatible-parameters</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>incompatible-restore</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>modifying</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rebooting</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>renaming</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resizing</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rotating-keys</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>storage-full</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>updating-hsm</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterStatus(String clusterStatus);

        /**
         * <p>
         * The status of a modify operation, if any, initiated for the cluster.
         * </p>
         * 
         * @param modifyStatus
         *        The status of a modify operation, if any, initiated for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifyStatus(String modifyStatus);

        /**
         * <p>
         * The master user name for the cluster. This name is used to connect to the database that is specified in the
         * <b>DBName</b> parameter.
         * </p>
         * 
         * @param masterUsername
         *        The master user name for the cluster. This name is used to connect to the database that is specified
         *        in the <b>DBName</b> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUsername(String masterUsername);

        /**
         * <p>
         * The name of the initial database that was created when the cluster was created. This same name is returned
         * for the life of the cluster. If an initial database was not specified, a database named <code>dev</code>dev
         * was created by default.
         * </p>
         * 
         * @param dbName
         *        The name of the initial database that was created when the cluster was created. This same name is
         *        returned for the life of the cluster. If an initial database was not specified, a database named
         *        <code>dev</code>dev was created by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbName(String dbName);

        /**
         * <p>
         * The connection endpoint.
         * </p>
         * 
         * @param endpoint
         *        The connection endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(Endpoint endpoint);

        /**
         * <p>
         * The connection endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link Endpoint.Builder} avoiding the need to create
         * one manually via {@link Endpoint#builder()}.
         *
         * When the {@link Consumer} completes, {@link Endpoint.Builder#build()} is called immediately and its result is
         * passed to {@link #endpoint(Endpoint)}.
         * 
         * @param endpoint
         *        a consumer that will call methods on {@link Endpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoint(Endpoint)
         */
        default Builder endpoint(Consumer<Endpoint.Builder> endpoint) {
            return endpoint(Endpoint.builder().applyMutation(endpoint).build());
        }

        /**
         * <p>
         * The date and time that the cluster was created.
         * </p>
         * 
         * @param clusterCreateTime
         *        The date and time that the cluster was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterCreateTime(Instant clusterCreateTime);

        /**
         * <p>
         * The number of days that automatic cluster snapshots are retained.
         * </p>
         * 
         * @param automatedSnapshotRetentionPeriod
         *        The number of days that automatic cluster snapshots are retained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod);

        /**
         * <p>
         * The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained
         * indefinitely. This setting doesn't change the retention period of existing snapshots.
         * </p>
         * <p>
         * The value must be either -1 or an integer between 1 and 3,653.
         * </p>
         * 
         * @param manualSnapshotRetentionPeriod
         *        The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained
         *        indefinitely. This setting doesn't change the retention period of existing snapshots.</p>
         *        <p>
         *        The value must be either -1 or an integer between 1 and 3,653.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod);

        /**
         * <p>
         * A list of cluster security group that are associated with the cluster. Each security group is represented by
         * an element that contains <code>ClusterSecurityGroup.Name</code> and <code>ClusterSecurityGroup.Status</code>
         * subelements.
         * </p>
         * <p>
         * Cluster security groups are used when the cluster is not created in an Amazon Virtual Private Cloud (VPC).
         * Clusters that are created in a VPC use VPC security groups, which are listed by the <b>VpcSecurityGroups</b>
         * parameter.
         * </p>
         * 
         * @param clusterSecurityGroups
         *        A list of cluster security group that are associated with the cluster. Each security group is
         *        represented by an element that contains <code>ClusterSecurityGroup.Name</code> and
         *        <code>ClusterSecurityGroup.Status</code> subelements. </p>
         *        <p>
         *        Cluster security groups are used when the cluster is not created in an Amazon Virtual Private Cloud
         *        (VPC). Clusters that are created in a VPC use VPC security groups, which are listed by the
         *        <b>VpcSecurityGroups</b> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSecurityGroups(Collection<ClusterSecurityGroupMembership> clusterSecurityGroups);

        /**
         * <p>
         * A list of cluster security group that are associated with the cluster. Each security group is represented by
         * an element that contains <code>ClusterSecurityGroup.Name</code> and <code>ClusterSecurityGroup.Status</code>
         * subelements.
         * </p>
         * <p>
         * Cluster security groups are used when the cluster is not created in an Amazon Virtual Private Cloud (VPC).
         * Clusters that are created in a VPC use VPC security groups, which are listed by the <b>VpcSecurityGroups</b>
         * parameter.
         * </p>
         * 
         * @param clusterSecurityGroups
         *        A list of cluster security group that are associated with the cluster. Each security group is
         *        represented by an element that contains <code>ClusterSecurityGroup.Name</code> and
         *        <code>ClusterSecurityGroup.Status</code> subelements. </p>
         *        <p>
         *        Cluster security groups are used when the cluster is not created in an Amazon Virtual Private Cloud
         *        (VPC). Clusters that are created in a VPC use VPC security groups, which are listed by the
         *        <b>VpcSecurityGroups</b> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSecurityGroups(ClusterSecurityGroupMembership... clusterSecurityGroups);

        /**
         * <p>
         * A list of cluster security group that are associated with the cluster. Each security group is represented by
         * an element that contains <code>ClusterSecurityGroup.Name</code> and <code>ClusterSecurityGroup.Status</code>
         * subelements.
         * </p>
         * <p>
         * Cluster security groups are used when the cluster is not created in an Amazon Virtual Private Cloud (VPC).
         * Clusters that are created in a VPC use VPC security groups, which are listed by the <b>VpcSecurityGroups</b>
         * parameter.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ClusterSecurityGroupMembership>.Builder}
         * avoiding the need to create one manually via {@link List<ClusterSecurityGroupMembership>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ClusterSecurityGroupMembership>.Builder#build()} is called
         * immediately and its result is passed to {@link #clusterSecurityGroups(List<ClusterSecurityGroupMembership>)}.
         * 
         * @param clusterSecurityGroups
         *        a consumer that will call methods on {@link List<ClusterSecurityGroupMembership>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterSecurityGroups(List<ClusterSecurityGroupMembership>)
         */
        Builder clusterSecurityGroups(Consumer<ClusterSecurityGroupMembership.Builder>... clusterSecurityGroups);

        /**
         * <p>
         * A list of Amazon Virtual Private Cloud (Amazon VPC) security groups that are associated with the cluster.
         * This parameter is returned only if the cluster is in a VPC.
         * </p>
         * 
         * @param vpcSecurityGroups
         *        A list of Amazon Virtual Private Cloud (Amazon VPC) security groups that are associated with the
         *        cluster. This parameter is returned only if the cluster is in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups);

        /**
         * <p>
         * A list of Amazon Virtual Private Cloud (Amazon VPC) security groups that are associated with the cluster.
         * This parameter is returned only if the cluster is in a VPC.
         * </p>
         * 
         * @param vpcSecurityGroups
         *        A list of Amazon Virtual Private Cloud (Amazon VPC) security groups that are associated with the
         *        cluster. This parameter is returned only if the cluster is in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroups(VpcSecurityGroupMembership... vpcSecurityGroups);

        /**
         * <p>
         * A list of Amazon Virtual Private Cloud (Amazon VPC) security groups that are associated with the cluster.
         * This parameter is returned only if the cluster is in a VPC.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VpcSecurityGroupMembership>.Builder}
         * avoiding the need to create one manually via {@link List<VpcSecurityGroupMembership>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VpcSecurityGroupMembership>.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcSecurityGroups(List<VpcSecurityGroupMembership>)}.
         * 
         * @param vpcSecurityGroups
         *        a consumer that will call methods on {@link List<VpcSecurityGroupMembership>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcSecurityGroups(List<VpcSecurityGroupMembership>)
         */
        Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder>... vpcSecurityGroups);

        /**
         * <p>
         * The list of cluster parameter groups that are associated with this cluster. Each parameter group in the list
         * is returned with its status.
         * </p>
         * 
         * @param clusterParameterGroups
         *        The list of cluster parameter groups that are associated with this cluster. Each parameter group in
         *        the list is returned with its status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterParameterGroups(Collection<ClusterParameterGroupStatus> clusterParameterGroups);

        /**
         * <p>
         * The list of cluster parameter groups that are associated with this cluster. Each parameter group in the list
         * is returned with its status.
         * </p>
         * 
         * @param clusterParameterGroups
         *        The list of cluster parameter groups that are associated with this cluster. Each parameter group in
         *        the list is returned with its status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterParameterGroups(ClusterParameterGroupStatus... clusterParameterGroups);

        /**
         * <p>
         * The list of cluster parameter groups that are associated with this cluster. Each parameter group in the list
         * is returned with its status.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ClusterParameterGroupStatus>.Builder}
         * avoiding the need to create one manually via {@link List<ClusterParameterGroupStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ClusterParameterGroupStatus>.Builder#build()} is called
         * immediately and its result is passed to {@link #clusterParameterGroups(List<ClusterParameterGroupStatus>)}.
         * 
         * @param clusterParameterGroups
         *        a consumer that will call methods on {@link List<ClusterParameterGroupStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterParameterGroups(List<ClusterParameterGroupStatus>)
         */
        Builder clusterParameterGroups(Consumer<ClusterParameterGroupStatus.Builder>... clusterParameterGroups);

        /**
         * <p>
         * The name of the subnet group that is associated with the cluster. This parameter is valid only when the
         * cluster is in a VPC.
         * </p>
         * 
         * @param clusterSubnetGroupName
         *        The name of the subnet group that is associated with the cluster. This parameter is valid only when
         *        the cluster is in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSubnetGroupName(String clusterSubnetGroupName);

        /**
         * <p>
         * The identifier of the VPC the cluster is in, if the cluster is in a VPC.
         * </p>
         * 
         * @param vpcId
         *        The identifier of the VPC the cluster is in, if the cluster is in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The name of the Availability Zone in which the cluster is located.
         * </p>
         * 
         * @param availabilityZone
         *        The name of the Availability Zone in which the cluster is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The weekly time range, in Universal Coordinated Time (UTC), during which system maintenance can occur.
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        The weekly time range, in Universal Coordinated Time (UTC), during which system maintenance can occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * A value that, if present, indicates that changes to the cluster are pending. Specific pending changes are
         * identified by subelements.
         * </p>
         * 
         * @param pendingModifiedValues
         *        A value that, if present, indicates that changes to the cluster are pending. Specific pending changes
         *        are identified by subelements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingModifiedValues(PendingModifiedValues pendingModifiedValues);

        /**
         * <p>
         * A value that, if present, indicates that changes to the cluster are pending. Specific pending changes are
         * identified by subelements.
         * </p>
         * This is a convenience that creates an instance of the {@link PendingModifiedValues.Builder} avoiding the need
         * to create one manually via {@link PendingModifiedValues#builder()}.
         *
         * When the {@link Consumer} completes, {@link PendingModifiedValues.Builder#build()} is called immediately and
         * its result is passed to {@link #pendingModifiedValues(PendingModifiedValues)}.
         * 
         * @param pendingModifiedValues
         *        a consumer that will call methods on {@link PendingModifiedValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingModifiedValues(PendingModifiedValues)
         */
        default Builder pendingModifiedValues(Consumer<PendingModifiedValues.Builder> pendingModifiedValues) {
            return pendingModifiedValues(PendingModifiedValues.builder().applyMutation(pendingModifiedValues).build());
        }

        /**
         * <p>
         * The version ID of the Amazon Redshift engine that is running on the cluster.
         * </p>
         * 
         * @param clusterVersion
         *        The version ID of the Amazon Redshift engine that is running on the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterVersion(String clusterVersion);

        /**
         * <p>
         * A boolean value that, if <code>true</code>, indicates that major version upgrades will be applied
         * automatically to the cluster during the maintenance window.
         * </p>
         * 
         * @param allowVersionUpgrade
         *        A boolean value that, if <code>true</code>, indicates that major version upgrades will be applied
         *        automatically to the cluster during the maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowVersionUpgrade(Boolean allowVersionUpgrade);

        /**
         * <p>
         * The number of compute nodes in the cluster.
         * </p>
         * 
         * @param numberOfNodes
         *        The number of compute nodes in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfNodes(Integer numberOfNodes);

        /**
         * <p>
         * A boolean value that, if <code>true</code>, indicates that the cluster can be accessed from a public network.
         * </p>
         * 
         * @param publiclyAccessible
         *        A boolean value that, if <code>true</code>, indicates that the cluster can be accessed from a public
         *        network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * A boolean value that, if <code>true</code>, indicates that data in the cluster is encrypted at rest.
         * </p>
         * 
         * @param encrypted
         *        A boolean value that, if <code>true</code>, indicates that data in the cluster is encrypted at rest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * A value that describes the status of a cluster restore action. This parameter returns null if the cluster was
         * not created by restoring a snapshot.
         * </p>
         * 
         * @param restoreStatus
         *        A value that describes the status of a cluster restore action. This parameter returns null if the
         *        cluster was not created by restoring a snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreStatus(RestoreStatus restoreStatus);

        /**
         * <p>
         * A value that describes the status of a cluster restore action. This parameter returns null if the cluster was
         * not created by restoring a snapshot.
         * </p>
         * This is a convenience that creates an instance of the {@link RestoreStatus.Builder} avoiding the need to
         * create one manually via {@link RestoreStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link RestoreStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #restoreStatus(RestoreStatus)}.
         * 
         * @param restoreStatus
         *        a consumer that will call methods on {@link RestoreStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restoreStatus(RestoreStatus)
         */
        default Builder restoreStatus(Consumer<RestoreStatus.Builder> restoreStatus) {
            return restoreStatus(RestoreStatus.builder().applyMutation(restoreStatus).build());
        }

        /**
         * Sets the value of the DataTransferProgress property for this object.
         *
         * @param dataTransferProgress
         *        The new value for the DataTransferProgress property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTransferProgress(DataTransferProgress dataTransferProgress);

        /**
         * Sets the value of the DataTransferProgress property for this object.
         *
         * This is a convenience that creates an instance of the {@link DataTransferProgress.Builder} avoiding the need
         * to create one manually via {@link DataTransferProgress#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataTransferProgress.Builder#build()} is called immediately and
         * its result is passed to {@link #dataTransferProgress(DataTransferProgress)}.
         * 
         * @param dataTransferProgress
         *        a consumer that will call methods on {@link DataTransferProgress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataTransferProgress(DataTransferProgress)
         */
        default Builder dataTransferProgress(Consumer<DataTransferProgress.Builder> dataTransferProgress) {
            return dataTransferProgress(DataTransferProgress.builder().applyMutation(dataTransferProgress).build());
        }

        /**
         * <p>
         * A value that reports whether the Amazon Redshift cluster has finished applying any hardware security module
         * (HSM) settings changes specified in a modify cluster command.
         * </p>
         * <p>
         * Values: active, applying
         * </p>
         * 
         * @param hsmStatus
         *        A value that reports whether the Amazon Redshift cluster has finished applying any hardware security
         *        module (HSM) settings changes specified in a modify cluster command.</p>
         *        <p>
         *        Values: active, applying
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmStatus(HsmStatus hsmStatus);

        /**
         * <p>
         * A value that reports whether the Amazon Redshift cluster has finished applying any hardware security module
         * (HSM) settings changes specified in a modify cluster command.
         * </p>
         * <p>
         * Values: active, applying
         * </p>
         * This is a convenience that creates an instance of the {@link HsmStatus.Builder} avoiding the need to create
         * one manually via {@link HsmStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link HsmStatus.Builder#build()} is called immediately and its result
         * is passed to {@link #hsmStatus(HsmStatus)}.
         * 
         * @param hsmStatus
         *        a consumer that will call methods on {@link HsmStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hsmStatus(HsmStatus)
         */
        default Builder hsmStatus(Consumer<HsmStatus.Builder> hsmStatus) {
            return hsmStatus(HsmStatus.builder().applyMutation(hsmStatus).build());
        }

        /**
         * <p>
         * A value that returns the destination region and retention period that are configured for cross-region
         * snapshot copy.
         * </p>
         * 
         * @param clusterSnapshotCopyStatus
         *        A value that returns the destination region and retention period that are configured for cross-region
         *        snapshot copy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSnapshotCopyStatus(ClusterSnapshotCopyStatus clusterSnapshotCopyStatus);

        /**
         * <p>
         * A value that returns the destination region and retention period that are configured for cross-region
         * snapshot copy.
         * </p>
         * This is a convenience that creates an instance of the {@link ClusterSnapshotCopyStatus.Builder} avoiding the
         * need to create one manually via {@link ClusterSnapshotCopyStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClusterSnapshotCopyStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #clusterSnapshotCopyStatus(ClusterSnapshotCopyStatus)}.
         * 
         * @param clusterSnapshotCopyStatus
         *        a consumer that will call methods on {@link ClusterSnapshotCopyStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterSnapshotCopyStatus(ClusterSnapshotCopyStatus)
         */
        default Builder clusterSnapshotCopyStatus(Consumer<ClusterSnapshotCopyStatus.Builder> clusterSnapshotCopyStatus) {
            return clusterSnapshotCopyStatus(ClusterSnapshotCopyStatus.builder().applyMutation(clusterSnapshotCopyStatus).build());
        }

        /**
         * <p>
         * The public key for the cluster.
         * </p>
         * 
         * @param clusterPublicKey
         *        The public key for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterPublicKey(String clusterPublicKey);

        /**
         * <p>
         * The nodes in the cluster.
         * </p>
         * 
         * @param clusterNodes
         *        The nodes in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterNodes(Collection<ClusterNode> clusterNodes);

        /**
         * <p>
         * The nodes in the cluster.
         * </p>
         * 
         * @param clusterNodes
         *        The nodes in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterNodes(ClusterNode... clusterNodes);

        /**
         * <p>
         * The nodes in the cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ClusterNode>.Builder} avoiding the need to
         * create one manually via {@link List<ClusterNode>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ClusterNode>.Builder#build()} is called immediately and its
         * result is passed to {@link #clusterNodes(List<ClusterNode>)}.
         * 
         * @param clusterNodes
         *        a consumer that will call methods on {@link List<ClusterNode>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterNodes(List<ClusterNode>)
         */
        Builder clusterNodes(Consumer<ClusterNode.Builder>... clusterNodes);

        /**
         * <p>
         * The status of the elastic IP (EIP) address.
         * </p>
         * 
         * @param elasticIpStatus
         *        The status of the elastic IP (EIP) address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticIpStatus(ElasticIpStatus elasticIpStatus);

        /**
         * <p>
         * The status of the elastic IP (EIP) address.
         * </p>
         * This is a convenience that creates an instance of the {@link ElasticIpStatus.Builder} avoiding the need to
         * create one manually via {@link ElasticIpStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link ElasticIpStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #elasticIpStatus(ElasticIpStatus)}.
         * 
         * @param elasticIpStatus
         *        a consumer that will call methods on {@link ElasticIpStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticIpStatus(ElasticIpStatus)
         */
        default Builder elasticIpStatus(Consumer<ElasticIpStatus.Builder> elasticIpStatus) {
            return elasticIpStatus(ElasticIpStatus.builder().applyMutation(elasticIpStatus).build());
        }

        /**
         * <p>
         * The specific revision number of the database in the cluster.
         * </p>
         * 
         * @param clusterRevisionNumber
         *        The specific revision number of the database in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterRevisionNumber(String clusterRevisionNumber);

        /**
         * <p>
         * The list of tags for the cluster.
         * </p>
         * 
         * @param tags
         *        The list of tags for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The list of tags for the cluster.
         * </p>
         * 
         * @param tags
         *        The list of tags for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The list of tags for the cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The AWS Key Management Service (AWS KMS) key ID of the encryption key used to encrypt data in the cluster.
         * </p>
         * 
         * @param kmsKeyId
         *        The AWS Key Management Service (AWS KMS) key ID of the encryption key used to encrypt data in the
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster
         * that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
         * href="http://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in
         * the Amazon Redshift Cluster Management Guide.
         * </p>
         * <p>
         * If this option is <code>true</code>, enhanced VPC routing is enabled.
         * </p>
         * <p>
         * Default: false
         * </p>
         * 
         * @param enhancedVpcRouting
         *        An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a
         *        cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a
         *        href="http://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC
         *        Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
         *        <p>
         *        If this option is <code>true</code>, enhanced VPC routing is enabled.
         *        </p>
         *        <p>
         *        Default: false
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enhancedVpcRouting(Boolean enhancedVpcRouting);

        /**
         * <p>
         * A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access other AWS
         * services.
         * </p>
         * 
         * @param iamRoles
         *        A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access
         *        other AWS services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoles(Collection<ClusterIamRole> iamRoles);

        /**
         * <p>
         * A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access other AWS
         * services.
         * </p>
         * 
         * @param iamRoles
         *        A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access
         *        other AWS services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoles(ClusterIamRole... iamRoles);

        /**
         * <p>
         * A list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access other AWS
         * services.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ClusterIamRole>.Builder} avoiding the need
         * to create one manually via {@link List<ClusterIamRole>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ClusterIamRole>.Builder#build()} is called immediately and
         * its result is passed to {@link #iamRoles(List<ClusterIamRole>)}.
         * 
         * @param iamRoles
         *        a consumer that will call methods on {@link List<ClusterIamRole>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamRoles(List<ClusterIamRole>)
         */
        Builder iamRoles(Consumer<ClusterIamRole.Builder>... iamRoles);

        /**
         * <p>
         * Cluster operations that are waiting to be started.
         * </p>
         * 
         * @param pendingActions
         *        Cluster operations that are waiting to be started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingActions(Collection<String> pendingActions);

        /**
         * <p>
         * Cluster operations that are waiting to be started.
         * </p>
         * 
         * @param pendingActions
         *        Cluster operations that are waiting to be started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingActions(String... pendingActions);

        /**
         * <p>
         * The name of the maintenance track for the cluster.
         * </p>
         * 
         * @param maintenanceTrackName
         *        The name of the maintenance track for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceTrackName(String maintenanceTrackName);

        /**
         * <p>
         * The number of nodes that you can resize the cluster to with the elastic resize method.
         * </p>
         * 
         * @param elasticResizeNumberOfNodeOptions
         *        The number of nodes that you can resize the cluster to with the elastic resize method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticResizeNumberOfNodeOptions(String elasticResizeNumberOfNodeOptions);

        /**
         * <p>
         * Describes a group of <code>DeferredMaintenanceWindow</code> objects.
         * </p>
         * 
         * @param deferredMaintenanceWindows
         *        Describes a group of <code>DeferredMaintenanceWindow</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deferredMaintenanceWindows(Collection<DeferredMaintenanceWindow> deferredMaintenanceWindows);

        /**
         * <p>
         * Describes a group of <code>DeferredMaintenanceWindow</code> objects.
         * </p>
         * 
         * @param deferredMaintenanceWindows
         *        Describes a group of <code>DeferredMaintenanceWindow</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deferredMaintenanceWindows(DeferredMaintenanceWindow... deferredMaintenanceWindows);

        /**
         * <p>
         * Describes a group of <code>DeferredMaintenanceWindow</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DeferredMaintenanceWindow>.Builder}
         * avoiding the need to create one manually via {@link List<DeferredMaintenanceWindow>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeferredMaintenanceWindow>.Builder#build()} is called
         * immediately and its result is passed to {@link #deferredMaintenanceWindows(List<DeferredMaintenanceWindow>)}.
         * 
         * @param deferredMaintenanceWindows
         *        a consumer that will call methods on {@link List<DeferredMaintenanceWindow>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deferredMaintenanceWindows(List<DeferredMaintenanceWindow>)
         */
        Builder deferredMaintenanceWindows(Consumer<DeferredMaintenanceWindow.Builder>... deferredMaintenanceWindows);

        /**
         * <p>
         * A unique identifier for the cluster snapshot schedule.
         * </p>
         * 
         * @param snapshotScheduleIdentifier
         *        A unique identifier for the cluster snapshot schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotScheduleIdentifier(String snapshotScheduleIdentifier);

        /**
         * <p>
         * The current state of the cluster snapshot schedule.
         * </p>
         * 
         * @param snapshotScheduleState
         *        The current state of the cluster snapshot schedule.
         * @see ScheduleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleState
         */
        Builder snapshotScheduleState(String snapshotScheduleState);

        /**
         * <p>
         * The current state of the cluster snapshot schedule.
         * </p>
         * 
         * @param snapshotScheduleState
         *        The current state of the cluster snapshot schedule.
         * @see ScheduleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleState
         */
        Builder snapshotScheduleState(ScheduleState snapshotScheduleState);

        /**
         * <p>
         * Returns the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AllowCancelResize: a boolean value indicating if the resize operation can be cancelled.
         * </p>
         * </li>
         * <li>
         * <p>
         * ResizeType: Returns ClassicResize
         * </p>
         * </li>
         * </ul>
         * 
         * @param resizeInfo
         *        Returns the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        AllowCancelResize: a boolean value indicating if the resize operation can be cancelled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ResizeType: Returns ClassicResize
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resizeInfo(ResizeInfo resizeInfo);

        /**
         * <p>
         * Returns the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AllowCancelResize: a boolean value indicating if the resize operation can be cancelled.
         * </p>
         * </li>
         * <li>
         * <p>
         * ResizeType: Returns ClassicResize
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link ResizeInfo.Builder} avoiding the need to create
         * one manually via {@link ResizeInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResizeInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #resizeInfo(ResizeInfo)}.
         * 
         * @param resizeInfo
         *        a consumer that will call methods on {@link ResizeInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resizeInfo(ResizeInfo)
         */
        default Builder resizeInfo(Consumer<ResizeInfo.Builder> resizeInfo) {
            return resizeInfo(ResizeInfo.builder().applyMutation(resizeInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String nodeType;

        private String clusterStatus;

        private String modifyStatus;

        private String masterUsername;

        private String dbName;

        private Endpoint endpoint;

        private Instant clusterCreateTime;

        private Integer automatedSnapshotRetentionPeriod;

        private Integer manualSnapshotRetentionPeriod;

        private List<ClusterSecurityGroupMembership> clusterSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private List<VpcSecurityGroupMembership> vpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private List<ClusterParameterGroupStatus> clusterParameterGroups = DefaultSdkAutoConstructList.getInstance();

        private String clusterSubnetGroupName;

        private String vpcId;

        private String availabilityZone;

        private String preferredMaintenanceWindow;

        private PendingModifiedValues pendingModifiedValues;

        private String clusterVersion;

        private Boolean allowVersionUpgrade;

        private Integer numberOfNodes;

        private Boolean publiclyAccessible;

        private Boolean encrypted;

        private RestoreStatus restoreStatus;

        private DataTransferProgress dataTransferProgress;

        private HsmStatus hsmStatus;

        private ClusterSnapshotCopyStatus clusterSnapshotCopyStatus;

        private String clusterPublicKey;

        private List<ClusterNode> clusterNodes = DefaultSdkAutoConstructList.getInstance();

        private ElasticIpStatus elasticIpStatus;

        private String clusterRevisionNumber;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String kmsKeyId;

        private Boolean enhancedVpcRouting;

        private List<ClusterIamRole> iamRoles = DefaultSdkAutoConstructList.getInstance();

        private List<String> pendingActions = DefaultSdkAutoConstructList.getInstance();

        private String maintenanceTrackName;

        private String elasticResizeNumberOfNodeOptions;

        private List<DeferredMaintenanceWindow> deferredMaintenanceWindows = DefaultSdkAutoConstructList.getInstance();

        private String snapshotScheduleIdentifier;

        private String snapshotScheduleState;

        private ResizeInfo resizeInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            clusterIdentifier(model.clusterIdentifier);
            nodeType(model.nodeType);
            clusterStatus(model.clusterStatus);
            modifyStatus(model.modifyStatus);
            masterUsername(model.masterUsername);
            dbName(model.dbName);
            endpoint(model.endpoint);
            clusterCreateTime(model.clusterCreateTime);
            automatedSnapshotRetentionPeriod(model.automatedSnapshotRetentionPeriod);
            manualSnapshotRetentionPeriod(model.manualSnapshotRetentionPeriod);
            clusterSecurityGroups(model.clusterSecurityGroups);
            vpcSecurityGroups(model.vpcSecurityGroups);
            clusterParameterGroups(model.clusterParameterGroups);
            clusterSubnetGroupName(model.clusterSubnetGroupName);
            vpcId(model.vpcId);
            availabilityZone(model.availabilityZone);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            pendingModifiedValues(model.pendingModifiedValues);
            clusterVersion(model.clusterVersion);
            allowVersionUpgrade(model.allowVersionUpgrade);
            numberOfNodes(model.numberOfNodes);
            publiclyAccessible(model.publiclyAccessible);
            encrypted(model.encrypted);
            restoreStatus(model.restoreStatus);
            dataTransferProgress(model.dataTransferProgress);
            hsmStatus(model.hsmStatus);
            clusterSnapshotCopyStatus(model.clusterSnapshotCopyStatus);
            clusterPublicKey(model.clusterPublicKey);
            clusterNodes(model.clusterNodes);
            elasticIpStatus(model.elasticIpStatus);
            clusterRevisionNumber(model.clusterRevisionNumber);
            tags(model.tags);
            kmsKeyId(model.kmsKeyId);
            enhancedVpcRouting(model.enhancedVpcRouting);
            iamRoles(model.iamRoles);
            pendingActions(model.pendingActions);
            maintenanceTrackName(model.maintenanceTrackName);
            elasticResizeNumberOfNodeOptions(model.elasticResizeNumberOfNodeOptions);
            deferredMaintenanceWindows(model.deferredMaintenanceWindows);
            snapshotScheduleIdentifier(model.snapshotScheduleIdentifier);
            snapshotScheduleState(model.snapshotScheduleState);
            resizeInfo(model.resizeInfo);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getNodeType() {
            return nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final String getClusterStatus() {
            return clusterStatus;
        }

        @Override
        public final Builder clusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
            return this;
        }

        public final void setClusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
        }

        public final String getModifyStatus() {
            return modifyStatus;
        }

        @Override
        public final Builder modifyStatus(String modifyStatus) {
            this.modifyStatus = modifyStatus;
            return this;
        }

        public final void setModifyStatus(String modifyStatus) {
            this.modifyStatus = modifyStatus;
        }

        public final String getMasterUsername() {
            return masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        public final String getDBName() {
            return dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final void setDBName(String dbName) {
            this.dbName = dbName;
        }

        public final Endpoint.Builder getEndpoint() {
            return endpoint != null ? endpoint.toBuilder() : null;
        }

        @Override
        public final Builder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(Endpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        public final Instant getClusterCreateTime() {
            return clusterCreateTime;
        }

        @Override
        public final Builder clusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
            return this;
        }

        public final void setClusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
        }

        public final Integer getAutomatedSnapshotRetentionPeriod() {
            return automatedSnapshotRetentionPeriod;
        }

        @Override
        public final Builder automatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
            return this;
        }

        public final void setAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
        }

        public final Integer getManualSnapshotRetentionPeriod() {
            return manualSnapshotRetentionPeriod;
        }

        @Override
        public final Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
            return this;
        }

        public final void setManualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
        }

        public final Collection<ClusterSecurityGroupMembership.Builder> getClusterSecurityGroups() {
            return clusterSecurityGroups != null ? clusterSecurityGroups.stream().map(ClusterSecurityGroupMembership::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusterSecurityGroups(Collection<ClusterSecurityGroupMembership> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupMembershipListCopier.copy(clusterSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSecurityGroups(ClusterSecurityGroupMembership... clusterSecurityGroups) {
            clusterSecurityGroups(Arrays.asList(clusterSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSecurityGroups(Consumer<ClusterSecurityGroupMembership.Builder>... clusterSecurityGroups) {
            clusterSecurityGroups(Stream.of(clusterSecurityGroups)
                    .map(c -> ClusterSecurityGroupMembership.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setClusterSecurityGroups(Collection<ClusterSecurityGroupMembership.BuilderImpl> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupMembershipListCopier.copyFromBuilder(clusterSecurityGroups);
        }

        public final Collection<VpcSecurityGroupMembership.Builder> getVpcSecurityGroups() {
            return vpcSecurityGroups != null ? vpcSecurityGroups.stream().map(VpcSecurityGroupMembership::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(VpcSecurityGroupMembership... vpcSecurityGroups) {
            vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder>... vpcSecurityGroups) {
            vpcSecurityGroups(Stream.of(vpcSecurityGroups)
                    .map(c -> VpcSecurityGroupMembership.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership.BuilderImpl> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copyFromBuilder(vpcSecurityGroups);
        }

        public final Collection<ClusterParameterGroupStatus.Builder> getClusterParameterGroups() {
            return clusterParameterGroups != null ? clusterParameterGroups.stream().map(ClusterParameterGroupStatus::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusterParameterGroups(Collection<ClusterParameterGroupStatus> clusterParameterGroups) {
            this.clusterParameterGroups = ClusterParameterGroupStatusListCopier.copy(clusterParameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterParameterGroups(ClusterParameterGroupStatus... clusterParameterGroups) {
            clusterParameterGroups(Arrays.asList(clusterParameterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterParameterGroups(Consumer<ClusterParameterGroupStatus.Builder>... clusterParameterGroups) {
            clusterParameterGroups(Stream.of(clusterParameterGroups)
                    .map(c -> ClusterParameterGroupStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setClusterParameterGroups(Collection<ClusterParameterGroupStatus.BuilderImpl> clusterParameterGroups) {
            this.clusterParameterGroups = ClusterParameterGroupStatusListCopier.copyFromBuilder(clusterParameterGroups);
        }

        public final String getClusterSubnetGroupName() {
            return clusterSubnetGroupName;
        }

        @Override
        public final Builder clusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
            return this;
        }

        public final void setClusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final PendingModifiedValues.Builder getPendingModifiedValues() {
            return pendingModifiedValues != null ? pendingModifiedValues.toBuilder() : null;
        }

        @Override
        public final Builder pendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final void setPendingModifiedValues(PendingModifiedValues.BuilderImpl pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues != null ? pendingModifiedValues.build() : null;
        }

        public final String getClusterVersion() {
            return clusterVersion;
        }

        @Override
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        public final Boolean getAllowVersionUpgrade() {
            return allowVersionUpgrade;
        }

        @Override
        public final Builder allowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
            return this;
        }

        public final void setAllowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
        }

        public final Integer getNumberOfNodes() {
            return numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final RestoreStatus.Builder getRestoreStatus() {
            return restoreStatus != null ? restoreStatus.toBuilder() : null;
        }

        @Override
        public final Builder restoreStatus(RestoreStatus restoreStatus) {
            this.restoreStatus = restoreStatus;
            return this;
        }

        public final void setRestoreStatus(RestoreStatus.BuilderImpl restoreStatus) {
            this.restoreStatus = restoreStatus != null ? restoreStatus.build() : null;
        }

        public final DataTransferProgress.Builder getDataTransferProgress() {
            return dataTransferProgress != null ? dataTransferProgress.toBuilder() : null;
        }

        @Override
        public final Builder dataTransferProgress(DataTransferProgress dataTransferProgress) {
            this.dataTransferProgress = dataTransferProgress;
            return this;
        }

        public final void setDataTransferProgress(DataTransferProgress.BuilderImpl dataTransferProgress) {
            this.dataTransferProgress = dataTransferProgress != null ? dataTransferProgress.build() : null;
        }

        public final HsmStatus.Builder getHsmStatus() {
            return hsmStatus != null ? hsmStatus.toBuilder() : null;
        }

        @Override
        public final Builder hsmStatus(HsmStatus hsmStatus) {
            this.hsmStatus = hsmStatus;
            return this;
        }

        public final void setHsmStatus(HsmStatus.BuilderImpl hsmStatus) {
            this.hsmStatus = hsmStatus != null ? hsmStatus.build() : null;
        }

        public final ClusterSnapshotCopyStatus.Builder getClusterSnapshotCopyStatus() {
            return clusterSnapshotCopyStatus != null ? clusterSnapshotCopyStatus.toBuilder() : null;
        }

        @Override
        public final Builder clusterSnapshotCopyStatus(ClusterSnapshotCopyStatus clusterSnapshotCopyStatus) {
            this.clusterSnapshotCopyStatus = clusterSnapshotCopyStatus;
            return this;
        }

        public final void setClusterSnapshotCopyStatus(ClusterSnapshotCopyStatus.BuilderImpl clusterSnapshotCopyStatus) {
            this.clusterSnapshotCopyStatus = clusterSnapshotCopyStatus != null ? clusterSnapshotCopyStatus.build() : null;
        }

        public final String getClusterPublicKey() {
            return clusterPublicKey;
        }

        @Override
        public final Builder clusterPublicKey(String clusterPublicKey) {
            this.clusterPublicKey = clusterPublicKey;
            return this;
        }

        public final void setClusterPublicKey(String clusterPublicKey) {
            this.clusterPublicKey = clusterPublicKey;
        }

        public final Collection<ClusterNode.Builder> getClusterNodes() {
            return clusterNodes != null ? clusterNodes.stream().map(ClusterNode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusterNodes(Collection<ClusterNode> clusterNodes) {
            this.clusterNodes = ClusterNodesListCopier.copy(clusterNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterNodes(ClusterNode... clusterNodes) {
            clusterNodes(Arrays.asList(clusterNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterNodes(Consumer<ClusterNode.Builder>... clusterNodes) {
            clusterNodes(Stream.of(clusterNodes).map(c -> ClusterNode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setClusterNodes(Collection<ClusterNode.BuilderImpl> clusterNodes) {
            this.clusterNodes = ClusterNodesListCopier.copyFromBuilder(clusterNodes);
        }

        public final ElasticIpStatus.Builder getElasticIpStatus() {
            return elasticIpStatus != null ? elasticIpStatus.toBuilder() : null;
        }

        @Override
        public final Builder elasticIpStatus(ElasticIpStatus elasticIpStatus) {
            this.elasticIpStatus = elasticIpStatus;
            return this;
        }

        public final void setElasticIpStatus(ElasticIpStatus.BuilderImpl elasticIpStatus) {
            this.elasticIpStatus = elasticIpStatus != null ? elasticIpStatus.build() : null;
        }

        public final String getClusterRevisionNumber() {
            return clusterRevisionNumber;
        }

        @Override
        public final Builder clusterRevisionNumber(String clusterRevisionNumber) {
            this.clusterRevisionNumber = clusterRevisionNumber;
            return this;
        }

        public final void setClusterRevisionNumber(String clusterRevisionNumber) {
            this.clusterRevisionNumber = clusterRevisionNumber;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getEnhancedVpcRouting() {
            return enhancedVpcRouting;
        }

        @Override
        public final Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        public final void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
        }

        public final Collection<ClusterIamRole.Builder> getIamRoles() {
            return iamRoles != null ? iamRoles.stream().map(ClusterIamRole::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder iamRoles(Collection<ClusterIamRole> iamRoles) {
            this.iamRoles = ClusterIamRoleListCopier.copy(iamRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamRoles(ClusterIamRole... iamRoles) {
            iamRoles(Arrays.asList(iamRoles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamRoles(Consumer<ClusterIamRole.Builder>... iamRoles) {
            iamRoles(Stream.of(iamRoles).map(c -> ClusterIamRole.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIamRoles(Collection<ClusterIamRole.BuilderImpl> iamRoles) {
            this.iamRoles = ClusterIamRoleListCopier.copyFromBuilder(iamRoles);
        }

        public final Collection<String> getPendingActions() {
            return pendingActions;
        }

        @Override
        public final Builder pendingActions(Collection<String> pendingActions) {
            this.pendingActions = PendingActionsListCopier.copy(pendingActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingActions(String... pendingActions) {
            pendingActions(Arrays.asList(pendingActions));
            return this;
        }

        public final void setPendingActions(Collection<String> pendingActions) {
            this.pendingActions = PendingActionsListCopier.copy(pendingActions);
        }

        public final String getMaintenanceTrackName() {
            return maintenanceTrackName;
        }

        @Override
        public final Builder maintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
            return this;
        }

        public final void setMaintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
        }

        public final String getElasticResizeNumberOfNodeOptions() {
            return elasticResizeNumberOfNodeOptions;
        }

        @Override
        public final Builder elasticResizeNumberOfNodeOptions(String elasticResizeNumberOfNodeOptions) {
            this.elasticResizeNumberOfNodeOptions = elasticResizeNumberOfNodeOptions;
            return this;
        }

        public final void setElasticResizeNumberOfNodeOptions(String elasticResizeNumberOfNodeOptions) {
            this.elasticResizeNumberOfNodeOptions = elasticResizeNumberOfNodeOptions;
        }

        public final Collection<DeferredMaintenanceWindow.Builder> getDeferredMaintenanceWindows() {
            return deferredMaintenanceWindows != null ? deferredMaintenanceWindows.stream()
                    .map(DeferredMaintenanceWindow::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deferredMaintenanceWindows(Collection<DeferredMaintenanceWindow> deferredMaintenanceWindows) {
            this.deferredMaintenanceWindows = DeferredMaintenanceWindowsListCopier.copy(deferredMaintenanceWindows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deferredMaintenanceWindows(DeferredMaintenanceWindow... deferredMaintenanceWindows) {
            deferredMaintenanceWindows(Arrays.asList(deferredMaintenanceWindows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deferredMaintenanceWindows(Consumer<DeferredMaintenanceWindow.Builder>... deferredMaintenanceWindows) {
            deferredMaintenanceWindows(Stream.of(deferredMaintenanceWindows)
                    .map(c -> DeferredMaintenanceWindow.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDeferredMaintenanceWindows(
                Collection<DeferredMaintenanceWindow.BuilderImpl> deferredMaintenanceWindows) {
            this.deferredMaintenanceWindows = DeferredMaintenanceWindowsListCopier.copyFromBuilder(deferredMaintenanceWindows);
        }

        public final String getSnapshotScheduleIdentifier() {
            return snapshotScheduleIdentifier;
        }

        @Override
        public final Builder snapshotScheduleIdentifier(String snapshotScheduleIdentifier) {
            this.snapshotScheduleIdentifier = snapshotScheduleIdentifier;
            return this;
        }

        public final void setSnapshotScheduleIdentifier(String snapshotScheduleIdentifier) {
            this.snapshotScheduleIdentifier = snapshotScheduleIdentifier;
        }

        public final String getSnapshotScheduleState() {
            return snapshotScheduleState;
        }

        @Override
        public final Builder snapshotScheduleState(String snapshotScheduleState) {
            this.snapshotScheduleState = snapshotScheduleState;
            return this;
        }

        @Override
        public final Builder snapshotScheduleState(ScheduleState snapshotScheduleState) {
            this.snapshotScheduleState(snapshotScheduleState.toString());
            return this;
        }

        public final void setSnapshotScheduleState(String snapshotScheduleState) {
            this.snapshotScheduleState = snapshotScheduleState;
        }

        public final ResizeInfo.Builder getResizeInfo() {
            return resizeInfo != null ? resizeInfo.toBuilder() : null;
        }

        @Override
        public final Builder resizeInfo(ResizeInfo resizeInfo) {
            this.resizeInfo = resizeInfo;
            return this;
        }

        public final void setResizeInfo(ResizeInfo.BuilderImpl resizeInfo) {
            this.resizeInfo = resizeInfo != null ? resizeInfo.build() : null;
        }

        @Override
        public Cluster build() {
            return new Cluster(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
