/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an availability zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AvailabilityZone implements SdkPojo, Serializable,
        ToCopyableBuilder<AvailabilityZone.Builder, AvailabilityZone> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AvailabilityZone::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<SupportedPlatform>> SUPPORTED_PLATFORMS_FIELD = SdkField
            .<List<SupportedPlatform>> builder(MarshallingType.LIST)
            .getter(getter(AvailabilityZone::supportedPlatforms))
            .setter(setter(Builder::supportedPlatforms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedPlatforms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SupportedPlatform")
                            .memberFieldInfo(
                                    SdkField.<SupportedPlatform> builder(MarshallingType.SDK_POJO)
                                            .constructor(SupportedPlatform::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SupportedPlatform").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SUPPORTED_PLATFORMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<SupportedPlatform> supportedPlatforms;

    private AvailabilityZone(BuilderImpl builder) {
        this.name = builder.name;
        this.supportedPlatforms = builder.supportedPlatforms;
    }

    /**
     * <p>
     * The name of the availability zone.
     * </p>
     * 
     * @return The name of the availability zone.
     */
    public String name() {
        return name;
    }

    /**
     * Returns the value of the SupportedPlatforms property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the SupportedPlatforms property for this object.
     */
    public List<SupportedPlatform> supportedPlatforms() {
        return supportedPlatforms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(supportedPlatforms());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZone)) {
            return false;
        }
        AvailabilityZone other = (AvailabilityZone) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(supportedPlatforms(), other.supportedPlatforms());
    }

    @Override
    public String toString() {
        return ToString.builder("AvailabilityZone").add("Name", name()).add("SupportedPlatforms", supportedPlatforms()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SupportedPlatforms":
            return Optional.ofNullable(clazz.cast(supportedPlatforms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AvailabilityZone, T> g) {
        return obj -> g.apply((AvailabilityZone) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AvailabilityZone> {
        /**
         * <p>
         * The name of the availability zone.
         * </p>
         * 
         * @param name
         *        The name of the availability zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the SupportedPlatforms property for this object.
         *
         * @param supportedPlatforms
         *        The new value for the SupportedPlatforms property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedPlatforms(Collection<SupportedPlatform> supportedPlatforms);

        /**
         * Sets the value of the SupportedPlatforms property for this object.
         *
         * @param supportedPlatforms
         *        The new value for the SupportedPlatforms property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedPlatforms(SupportedPlatform... supportedPlatforms);

        /**
         * Sets the value of the SupportedPlatforms property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<SupportedPlatform>.Builder} avoiding the
         * need to create one manually via {@link List<SupportedPlatform>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SupportedPlatform>.Builder#build()} is called immediately
         * and its result is passed to {@link #supportedPlatforms(List<SupportedPlatform>)}.
         * 
         * @param supportedPlatforms
         *        a consumer that will call methods on {@link List<SupportedPlatform>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supportedPlatforms(List<SupportedPlatform>)
         */
        Builder supportedPlatforms(Consumer<SupportedPlatform.Builder>... supportedPlatforms);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<SupportedPlatform> supportedPlatforms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityZone model) {
            name(model.name);
            supportedPlatforms(model.supportedPlatforms);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<SupportedPlatform.Builder> getSupportedPlatforms() {
            return supportedPlatforms != null ? supportedPlatforms.stream().map(SupportedPlatform::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder supportedPlatforms(Collection<SupportedPlatform> supportedPlatforms) {
            this.supportedPlatforms = SupportedPlatformsListCopier.copy(supportedPlatforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedPlatforms(SupportedPlatform... supportedPlatforms) {
            supportedPlatforms(Arrays.asList(supportedPlatforms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedPlatforms(Consumer<SupportedPlatform.Builder>... supportedPlatforms) {
            supportedPlatforms(Stream.of(supportedPlatforms).map(c -> SupportedPlatform.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSupportedPlatforms(Collection<SupportedPlatform.BuilderImpl> supportedPlatforms) {
            this.supportedPlatforms = SupportedPlatformsListCopier.copyFromBuilder(supportedPlatforms);
        }

        @Override
        public AvailabilityZone build() {
            return new AvailabilityZone(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
