/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptReservedNodeExchangeResponse extends RedshiftResponse implements
        ToCopyableBuilder<AcceptReservedNodeExchangeResponse.Builder, AcceptReservedNodeExchangeResponse> {
    private static final SdkField<ReservedNode> EXCHANGED_RESERVED_NODE_FIELD = SdkField
            .<ReservedNode> builder(MarshallingType.SDK_POJO)
            .getter(getter(AcceptReservedNodeExchangeResponse::exchangedReservedNode))
            .setter(setter(Builder::exchangedReservedNode)).constructor(ReservedNode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExchangedReservedNode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(EXCHANGED_RESERVED_NODE_FIELD));

    private final ReservedNode exchangedReservedNode;

    private AcceptReservedNodeExchangeResponse(BuilderImpl builder) {
        super(builder);
        this.exchangedReservedNode = builder.exchangedReservedNode;
    }

    /**
     * Returns the value of the ExchangedReservedNode property for this object.
     * 
     * @return The value of the ExchangedReservedNode property for this object.
     */
    public ReservedNode exchangedReservedNode() {
        return exchangedReservedNode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exchangedReservedNode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptReservedNodeExchangeResponse)) {
            return false;
        }
        AcceptReservedNodeExchangeResponse other = (AcceptReservedNodeExchangeResponse) obj;
        return Objects.equals(exchangedReservedNode(), other.exchangedReservedNode());
    }

    @Override
    public String toString() {
        return ToString.builder("AcceptReservedNodeExchangeResponse").add("ExchangedReservedNode", exchangedReservedNode())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExchangedReservedNode":
            return Optional.ofNullable(clazz.cast(exchangedReservedNode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceptReservedNodeExchangeResponse, T> g) {
        return obj -> g.apply((AcceptReservedNodeExchangeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AcceptReservedNodeExchangeResponse> {
        /**
         * Sets the value of the ExchangedReservedNode property for this object.
         *
         * @param exchangedReservedNode
         *        The new value for the ExchangedReservedNode property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exchangedReservedNode(ReservedNode exchangedReservedNode);

        /**
         * Sets the value of the ExchangedReservedNode property for this object.
         *
         * This is a convenience that creates an instance of the {@link ReservedNode.Builder} avoiding the need to
         * create one manually via {@link ReservedNode#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReservedNode.Builder#build()} is called immediately and its
         * result is passed to {@link #exchangedReservedNode(ReservedNode)}.
         * 
         * @param exchangedReservedNode
         *        a consumer that will call methods on {@link ReservedNode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exchangedReservedNode(ReservedNode)
         */
        default Builder exchangedReservedNode(Consumer<ReservedNode.Builder> exchangedReservedNode) {
            return exchangedReservedNode(ReservedNode.builder().applyMutation(exchangedReservedNode).build());
        }
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private ReservedNode exchangedReservedNode;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptReservedNodeExchangeResponse model) {
            super(model);
            exchangedReservedNode(model.exchangedReservedNode);
        }

        public final ReservedNode.Builder getExchangedReservedNode() {
            return exchangedReservedNode != null ? exchangedReservedNode.toBuilder() : null;
        }

        @Override
        public final Builder exchangedReservedNode(ReservedNode exchangedReservedNode) {
            this.exchangedReservedNode = exchangedReservedNode;
            return this;
        }

        public final void setExchangedReservedNode(ReservedNode.BuilderImpl exchangedReservedNode) {
            this.exchangedReservedNode = exchangedReservedNode != null ? exchangedReservedNode.build() : null;
        }

        @Override
        public AcceptReservedNodeExchangeResponse build() {
            return new AcceptReservedNodeExchangeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
