/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.redshift.model.AcceptReservedNodeExchangeRequest;
import software.amazon.awssdk.services.redshift.model.AcceptReservedNodeExchangeResponse;
import software.amazon.awssdk.services.redshift.model.AccessToSnapshotDeniedException;
import software.amazon.awssdk.services.redshift.model.AuthorizationAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.AuthorizationNotFoundException;
import software.amazon.awssdk.services.redshift.model.AuthorizationQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest;
import software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressResponse;
import software.amazon.awssdk.services.redshift.model.AuthorizeSnapshotAccessRequest;
import software.amazon.awssdk.services.redshift.model.AuthorizeSnapshotAccessResponse;
import software.amazon.awssdk.services.redshift.model.BatchDeleteClusterSnapshotsRequest;
import software.amazon.awssdk.services.redshift.model.BatchDeleteClusterSnapshotsResponse;
import software.amazon.awssdk.services.redshift.model.BatchDeleteRequestSizeExceededException;
import software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsLimitExceededException;
import software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsRequest;
import software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsResponse;
import software.amazon.awssdk.services.redshift.model.BucketNotFoundException;
import software.amazon.awssdk.services.redshift.model.CancelResizeRequest;
import software.amazon.awssdk.services.redshift.model.CancelResizeResponse;
import software.amazon.awssdk.services.redshift.model.ClusterAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ClusterNotFoundException;
import software.amazon.awssdk.services.redshift.model.ClusterOnLatestRevisionException;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroupNotFoundException;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ClusterQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupNotFoundException;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ClusterSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ClusterSnapshotNotFoundException;
import software.amazon.awssdk.services.redshift.model.ClusterSnapshotQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroupNotFoundException;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.CopyClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.CopyClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.CopyToRegionDisabledException;
import software.amazon.awssdk.services.redshift.model.CreateClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterParameterGroupResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterSubnetGroupRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterSubnetGroupResponse;
import software.amazon.awssdk.services.redshift.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.redshift.model.CreateEventSubscriptionResponse;
import software.amazon.awssdk.services.redshift.model.CreateHsmClientCertificateRequest;
import software.amazon.awssdk.services.redshift.model.CreateHsmClientCertificateResponse;
import software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationRequest;
import software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationResponse;
import software.amazon.awssdk.services.redshift.model.CreateSnapshotCopyGrantRequest;
import software.amazon.awssdk.services.redshift.model.CreateSnapshotCopyGrantResponse;
import software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleRequest;
import software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleResponse;
import software.amazon.awssdk.services.redshift.model.CreateTagsRequest;
import software.amazon.awssdk.services.redshift.model.CreateTagsResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterParameterGroupResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSecurityGroupRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSecurityGroupResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSubnetGroupRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSubnetGroupResponse;
import software.amazon.awssdk.services.redshift.model.DeleteEventSubscriptionRequest;
import software.amazon.awssdk.services.redshift.model.DeleteEventSubscriptionResponse;
import software.amazon.awssdk.services.redshift.model.DeleteHsmClientCertificateRequest;
import software.amazon.awssdk.services.redshift.model.DeleteHsmClientCertificateResponse;
import software.amazon.awssdk.services.redshift.model.DeleteHsmConfigurationRequest;
import software.amazon.awssdk.services.redshift.model.DeleteHsmConfigurationResponse;
import software.amazon.awssdk.services.redshift.model.DeleteSnapshotCopyGrantRequest;
import software.amazon.awssdk.services.redshift.model.DeleteSnapshotCopyGrantResponse;
import software.amazon.awssdk.services.redshift.model.DeleteSnapshotScheduleRequest;
import software.amazon.awssdk.services.redshift.model.DeleteSnapshotScheduleResponse;
import software.amazon.awssdk.services.redshift.model.DeleteTagsRequest;
import software.amazon.awssdk.services.redshift.model.DeleteTagsResponse;
import software.amazon.awssdk.services.redshift.model.DependentServiceRequestThrottlingException;
import software.amazon.awssdk.services.redshift.model.DependentServiceUnavailableException;
import software.amazon.awssdk.services.redshift.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParametersResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterTracksRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterTracksResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClustersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClustersResponse;
import software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersResponse;
import software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeEventsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEventsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeLoggingStatusRequest;
import software.amazon.awssdk.services.redshift.model.DescribeLoggingStatusResponse;
import software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeResizeRequest;
import software.amazon.awssdk.services.redshift.model.DescribeResizeResponse;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeStorageRequest;
import software.amazon.awssdk.services.redshift.model.DescribeStorageResponse;
import software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusRequest;
import software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusResponse;
import software.amazon.awssdk.services.redshift.model.DescribeTagsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeTagsResponse;
import software.amazon.awssdk.services.redshift.model.DisableLoggingRequest;
import software.amazon.awssdk.services.redshift.model.DisableLoggingResponse;
import software.amazon.awssdk.services.redshift.model.DisableSnapshotCopyRequest;
import software.amazon.awssdk.services.redshift.model.DisableSnapshotCopyResponse;
import software.amazon.awssdk.services.redshift.model.EnableLoggingRequest;
import software.amazon.awssdk.services.redshift.model.EnableLoggingResponse;
import software.amazon.awssdk.services.redshift.model.EnableSnapshotCopyRequest;
import software.amazon.awssdk.services.redshift.model.EnableSnapshotCopyResponse;
import software.amazon.awssdk.services.redshift.model.EventSubscriptionQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.GetClusterCredentialsRequest;
import software.amazon.awssdk.services.redshift.model.GetClusterCredentialsResponse;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsRequest;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsResponse;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificateAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificateNotFoundException;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificateQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.HsmConfigurationAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.HsmConfigurationNotFoundException;
import software.amazon.awssdk.services.redshift.model.HsmConfigurationQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.InProgressTableRestoreQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.IncompatibleOrderableOptionsException;
import software.amazon.awssdk.services.redshift.model.InsufficientClusterCapacityException;
import software.amazon.awssdk.services.redshift.model.InsufficientS3BucketPolicyException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterParameterGroupStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterSecurityGroupStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterSnapshotScheduleStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterSnapshotStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterSubnetGroupStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterSubnetStateException;
import software.amazon.awssdk.services.redshift.model.InvalidClusterTrackException;
import software.amazon.awssdk.services.redshift.model.InvalidElasticIpException;
import software.amazon.awssdk.services.redshift.model.InvalidHsmClientCertificateStateException;
import software.amazon.awssdk.services.redshift.model.InvalidHsmConfigurationStateException;
import software.amazon.awssdk.services.redshift.model.InvalidReservedNodeStateException;
import software.amazon.awssdk.services.redshift.model.InvalidRestoreException;
import software.amazon.awssdk.services.redshift.model.InvalidRetentionPeriodException;
import software.amazon.awssdk.services.redshift.model.InvalidS3BucketNameException;
import software.amazon.awssdk.services.redshift.model.InvalidS3KeyPrefixException;
import software.amazon.awssdk.services.redshift.model.InvalidScheduleException;
import software.amazon.awssdk.services.redshift.model.InvalidSnapshotCopyGrantStateException;
import software.amazon.awssdk.services.redshift.model.InvalidSubnetException;
import software.amazon.awssdk.services.redshift.model.InvalidSubscriptionStateException;
import software.amazon.awssdk.services.redshift.model.InvalidTableRestoreArgumentException;
import software.amazon.awssdk.services.redshift.model.InvalidTagException;
import software.amazon.awssdk.services.redshift.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.redshift.model.LimitExceededException;
import software.amazon.awssdk.services.redshift.model.ModifyClusterDbRevisionRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterDbRevisionResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterIamRolesRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterIamRolesResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterParameterGroupResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotScheduleRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotScheduleResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSubnetGroupRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSubnetGroupResponse;
import software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionRequest;
import software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionResponse;
import software.amazon.awssdk.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest;
import software.amazon.awssdk.services.redshift.model.ModifySnapshotCopyRetentionPeriodResponse;
import software.amazon.awssdk.services.redshift.model.ModifySnapshotScheduleRequest;
import software.amazon.awssdk.services.redshift.model.ModifySnapshotScheduleResponse;
import software.amazon.awssdk.services.redshift.model.NumberOfNodesPerClusterLimitExceededException;
import software.amazon.awssdk.services.redshift.model.NumberOfNodesQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingRequest;
import software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingResponse;
import software.amazon.awssdk.services.redshift.model.RebootClusterRequest;
import software.amazon.awssdk.services.redshift.model.RebootClusterResponse;
import software.amazon.awssdk.services.redshift.model.RedshiftException;
import software.amazon.awssdk.services.redshift.model.ReservedNodeAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.ReservedNodeAlreadyMigratedException;
import software.amazon.awssdk.services.redshift.model.ReservedNodeNotFoundException;
import software.amazon.awssdk.services.redshift.model.ReservedNodeOfferingNotFoundException;
import software.amazon.awssdk.services.redshift.model.ReservedNodeQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupResponse;
import software.amazon.awssdk.services.redshift.model.ResizeClusterRequest;
import software.amazon.awssdk.services.redshift.model.ResizeClusterResponse;
import software.amazon.awssdk.services.redshift.model.ResizeNotFoundException;
import software.amazon.awssdk.services.redshift.model.ResourceNotFoundException;
import software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.RestoreTableFromClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.RestoreTableFromClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.RevokeClusterSecurityGroupIngressRequest;
import software.amazon.awssdk.services.redshift.model.RevokeClusterSecurityGroupIngressResponse;
import software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessRequest;
import software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessResponse;
import software.amazon.awssdk.services.redshift.model.RotateEncryptionKeyRequest;
import software.amazon.awssdk.services.redshift.model.RotateEncryptionKeyResponse;
import software.amazon.awssdk.services.redshift.model.ScheduleDefinitionTypeUnsupportedException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyAlreadyDisabledException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyAlreadyEnabledException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyDisabledException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyGrantAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyGrantNotFoundException;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyGrantQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.SnapshotScheduleAlreadyExistsException;
import software.amazon.awssdk.services.redshift.model.SnapshotScheduleNotFoundException;
import software.amazon.awssdk.services.redshift.model.SnapshotScheduleQuotaExceededException;
import software.amazon.awssdk.services.redshift.model.SnapshotScheduleUpdateInProgressException;
import software.amazon.awssdk.services.redshift.model.SnsInvalidTopicException;
import software.amazon.awssdk.services.redshift.model.SnsNoAuthorizationException;
import software.amazon.awssdk.services.redshift.model.SnsTopicArnNotFoundException;
import software.amazon.awssdk.services.redshift.model.SourceNotFoundException;
import software.amazon.awssdk.services.redshift.model.SubnetAlreadyInUseException;
import software.amazon.awssdk.services.redshift.model.SubscriptionAlreadyExistException;
import software.amazon.awssdk.services.redshift.model.SubscriptionCategoryNotFoundException;
import software.amazon.awssdk.services.redshift.model.SubscriptionEventIdNotFoundException;
import software.amazon.awssdk.services.redshift.model.SubscriptionNotFoundException;
import software.amazon.awssdk.services.redshift.model.SubscriptionSeverityNotFoundException;
import software.amazon.awssdk.services.redshift.model.TableLimitExceededException;
import software.amazon.awssdk.services.redshift.model.TableRestoreNotFoundException;
import software.amazon.awssdk.services.redshift.model.TagLimitExceededException;
import software.amazon.awssdk.services.redshift.model.UnauthorizedOperationException;
import software.amazon.awssdk.services.redshift.model.UnknownSnapshotCopyRegionException;
import software.amazon.awssdk.services.redshift.model.UnsupportedOperationException;
import software.amazon.awssdk.services.redshift.model.UnsupportedOptionException;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterParameterGroupsIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterParametersIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterSecurityGroupsIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterSnapshotsIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterSubnetGroupsIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterVersionsIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeClustersIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeDefaultClusterParametersIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeEventSubscriptionsIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeEventsIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeHsmClientCertificatesIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeHsmConfigurationsIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeOrderableClusterOptionsIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodeOfferingsIterable;
import software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodesIterable;

/**
 * Service client for accessing Amazon Redshift. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon Redshift</fullname>
 * <p>
 * <b>Overview</b>
 * </p>
 * <p>
 * This is an interface reference for Amazon Redshift. It contains documentation for one of the programming or command
 * line interfaces you can use to manage Amazon Redshift clusters. Note that Amazon Redshift is asynchronous, which
 * means that some interfaces may require techniques, such as polling or asynchronous callback handlers, to determine
 * when a command has been applied. In this reference, the parameter descriptions indicate whether a change is applied
 * immediately, on the next instance reboot, or during the next maintenance window. For a summary of the Amazon Redshift
 * cluster management interfaces, go to <a
 * href="http://docs.aws.amazon.com/redshift/latest/mgmt/using-aws-sdk.html">Using the Amazon Redshift Management
 * Interfaces</a>.
 * </p>
 * <p>
 * Amazon Redshift manages all the work of setting up, operating, and scaling a data warehouse: provisioning capacity,
 * monitoring and backing up the cluster, and applying patches and upgrades to the Amazon Redshift engine. You can focus
 * on using your data to acquire new insights for your business and customers.
 * </p>
 * <p>
 * If you are a first-time user of Amazon Redshift, we recommend that you begin by reading the <a
 * href="http://docs.aws.amazon.com/redshift/latest/gsg/getting-started.html">Amazon Redshift Getting Started Guide</a>.
 * </p>
 * <p>
 * If you are a database developer, the <a href="http://docs.aws.amazon.com/redshift/latest/dg/welcome.html">Amazon
 * Redshift Database Developer Guide</a> explains how to design, build, query, and maintain the databases that make up
 * your data warehouse.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface RedshiftClient extends SdkClient {
    String SERVICE_NAME = "redshift";

    /**
     * Create a {@link RedshiftClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static RedshiftClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link RedshiftClient}.
     */
    static RedshiftClientBuilder builder() {
        return new DefaultRedshiftClientBuilder();
    }

    /**
     * <p>
     * Exchanges a DC1 Reserved Node for a DC2 Reserved Node with no changes to the configuration (term, payment type,
     * or number of nodes) and no additional costs.
     * </p>
     *
     * @param acceptReservedNodeExchangeRequest
     * @return Result of the AcceptReservedNodeExchange operation returned by the service.
     * @throws ReservedNodeNotFoundException
     *         The specified reserved compute node not found.
     * @throws InvalidReservedNodeStateException
     *         Indicates that the Reserved Node being exchanged is not in an active state.
     * @throws ReservedNodeAlreadyMigratedException
     *         Indicates that the reserved node has already been exchanged.
     * @throws ReservedNodeOfferingNotFoundException
     *         Specified offering does not exist.
     * @throws UnsupportedOperationException
     *         The requested operation isn't supported.
     * @throws DependentServiceUnavailableException
     *         Your request cannot be completed because a dependent internal service is temporarily unavailable. Wait 30
     *         to 60 seconds and try again.
     * @throws ReservedNodeAlreadyExistsException
     *         User already has a reservation with the given identifier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.AcceptReservedNodeExchange
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AcceptReservedNodeExchange"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptReservedNodeExchangeResponse acceptReservedNodeExchange(
            AcceptReservedNodeExchangeRequest acceptReservedNodeExchangeRequest) throws ReservedNodeNotFoundException,
            InvalidReservedNodeStateException, ReservedNodeAlreadyMigratedException, ReservedNodeOfferingNotFoundException,
            UnsupportedOperationException, DependentServiceUnavailableException, ReservedNodeAlreadyExistsException,
            AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Exchanges a DC1 Reserved Node for a DC2 Reserved Node with no changes to the configuration (term, payment type,
     * or number of nodes) and no additional costs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptReservedNodeExchangeRequest.Builder} avoiding
     * the need to create one manually via {@link AcceptReservedNodeExchangeRequest#builder()}
     * </p>
     *
     * @param acceptReservedNodeExchangeRequest
     *        A {@link Consumer} that will call methods on {@link AcceptReservedNodeExchangeInputMessage.Builder} to
     *        create a request.
     * @return Result of the AcceptReservedNodeExchange operation returned by the service.
     * @throws ReservedNodeNotFoundException
     *         The specified reserved compute node not found.
     * @throws InvalidReservedNodeStateException
     *         Indicates that the Reserved Node being exchanged is not in an active state.
     * @throws ReservedNodeAlreadyMigratedException
     *         Indicates that the reserved node has already been exchanged.
     * @throws ReservedNodeOfferingNotFoundException
     *         Specified offering does not exist.
     * @throws UnsupportedOperationException
     *         The requested operation isn't supported.
     * @throws DependentServiceUnavailableException
     *         Your request cannot be completed because a dependent internal service is temporarily unavailable. Wait 30
     *         to 60 seconds and try again.
     * @throws ReservedNodeAlreadyExistsException
     *         User already has a reservation with the given identifier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.AcceptReservedNodeExchange
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AcceptReservedNodeExchange"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptReservedNodeExchangeResponse acceptReservedNodeExchange(
            Consumer<AcceptReservedNodeExchangeRequest.Builder> acceptReservedNodeExchangeRequest)
            throws ReservedNodeNotFoundException, InvalidReservedNodeStateException, ReservedNodeAlreadyMigratedException,
            ReservedNodeOfferingNotFoundException, UnsupportedOperationException, DependentServiceUnavailableException,
            ReservedNodeAlreadyExistsException, AwsServiceException, SdkClientException, RedshiftException {
        return acceptReservedNodeExchange(AcceptReservedNodeExchangeRequest.builder()
                .applyMutation(acceptReservedNodeExchangeRequest).build());
    }

    /**
     * <p>
     * Adds an inbound (ingress) rule to an Amazon Redshift security group. Depending on whether the application
     * accessing your cluster is running on the Internet or an Amazon EC2 instance, you can authorize inbound access to
     * either a Classless Interdomain Routing (CIDR)/Internet Protocol (IP) range or to an Amazon EC2 security group.
     * You can add as many as 20 ingress rules to an Amazon Redshift security group.
     * </p>
     * <p>
     * If you authorize access to an Amazon EC2 security group, specify <i>EC2SecurityGroupName</i> and
     * <i>EC2SecurityGroupOwnerId</i>. The Amazon EC2 security group and Amazon Redshift cluster must be in the same AWS
     * Region.
     * </p>
     * <p>
     * If you authorize access to a CIDR/IP address range, specify <i>CIDRIP</i>. For an overview of CIDR blocks, see
     * the Wikipedia article on <a href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless
     * Inter-Domain Routing</a>.
     * </p>
     * <p>
     * You must also associate the security group with a cluster so that clients running on these IP addresses or the
     * EC2 instance are authorized to connect to the cluster. For information about managing security groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Working with Security
     * Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param authorizeClusterSecurityGroupIngressRequest
     * @return Result of the AuthorizeClusterSecurityGroupIngress operation returned by the service.
     * @throws ClusterSecurityGroupNotFoundException
     *         The cluster security group name does not refer to an existing cluster security group.
     * @throws InvalidClusterSecurityGroupStateException
     *         The state of the cluster security group is not <code>available</code>.
     * @throws AuthorizationAlreadyExistsException
     *         The specified CIDR block or EC2 security group is already authorized for the specified cluster security
     *         group.
     * @throws AuthorizationQuotaExceededException
     *         The authorization quota for the cluster security group has been reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.AuthorizeClusterSecurityGroupIngress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeClusterSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    default AuthorizeClusterSecurityGroupIngressResponse authorizeClusterSecurityGroupIngress(
            AuthorizeClusterSecurityGroupIngressRequest authorizeClusterSecurityGroupIngressRequest)
            throws ClusterSecurityGroupNotFoundException, InvalidClusterSecurityGroupStateException,
            AuthorizationAlreadyExistsException, AuthorizationQuotaExceededException, AwsServiceException, SdkClientException,
            RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an inbound (ingress) rule to an Amazon Redshift security group. Depending on whether the application
     * accessing your cluster is running on the Internet or an Amazon EC2 instance, you can authorize inbound access to
     * either a Classless Interdomain Routing (CIDR)/Internet Protocol (IP) range or to an Amazon EC2 security group.
     * You can add as many as 20 ingress rules to an Amazon Redshift security group.
     * </p>
     * <p>
     * If you authorize access to an Amazon EC2 security group, specify <i>EC2SecurityGroupName</i> and
     * <i>EC2SecurityGroupOwnerId</i>. The Amazon EC2 security group and Amazon Redshift cluster must be in the same AWS
     * Region.
     * </p>
     * <p>
     * If you authorize access to a CIDR/IP address range, specify <i>CIDRIP</i>. For an overview of CIDR blocks, see
     * the Wikipedia article on <a href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless
     * Inter-Domain Routing</a>.
     * </p>
     * <p>
     * You must also associate the security group with a cluster so that clients running on these IP addresses or the
     * EC2 instance are authorized to connect to the cluster. For information about managing security groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Working with Security
     * Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AuthorizeClusterSecurityGroupIngressRequest.Builder} avoiding the need to create one manually via
     * {@link AuthorizeClusterSecurityGroupIngressRequest#builder()}
     * </p>
     *
     * @param authorizeClusterSecurityGroupIngressRequest
     *        A {@link Consumer} that will call methods on {@link AuthorizeClusterSecurityGroupIngressMessage.Builder}
     *        to create a request.
     * @return Result of the AuthorizeClusterSecurityGroupIngress operation returned by the service.
     * @throws ClusterSecurityGroupNotFoundException
     *         The cluster security group name does not refer to an existing cluster security group.
     * @throws InvalidClusterSecurityGroupStateException
     *         The state of the cluster security group is not <code>available</code>.
     * @throws AuthorizationAlreadyExistsException
     *         The specified CIDR block or EC2 security group is already authorized for the specified cluster security
     *         group.
     * @throws AuthorizationQuotaExceededException
     *         The authorization quota for the cluster security group has been reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.AuthorizeClusterSecurityGroupIngress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeClusterSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    default AuthorizeClusterSecurityGroupIngressResponse authorizeClusterSecurityGroupIngress(
            Consumer<AuthorizeClusterSecurityGroupIngressRequest.Builder> authorizeClusterSecurityGroupIngressRequest)
            throws ClusterSecurityGroupNotFoundException, InvalidClusterSecurityGroupStateException,
            AuthorizationAlreadyExistsException, AuthorizationQuotaExceededException, AwsServiceException, SdkClientException,
            RedshiftException {
        return authorizeClusterSecurityGroupIngress(AuthorizeClusterSecurityGroupIngressRequest.builder()
                .applyMutation(authorizeClusterSecurityGroupIngressRequest).build());
    }

    /**
     * <p>
     * Authorizes the specified AWS customer account to restore the specified snapshot.
     * </p>
     * <p>
     * For more information about working with snapshots, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param authorizeSnapshotAccessRequest
     * @return Result of the AuthorizeSnapshotAccess operation returned by the service.
     * @throws ClusterSnapshotNotFoundException
     *         The snapshot identifier does not refer to an existing cluster snapshot.
     * @throws AuthorizationAlreadyExistsException
     *         The specified CIDR block or EC2 security group is already authorized for the specified cluster security
     *         group.
     * @throws AuthorizationQuotaExceededException
     *         The authorization quota for the cluster security group has been reached.
     * @throws DependentServiceRequestThrottlingException
     *         The request cannot be completed because a dependent service is throttling requests made by Amazon
     *         Redshift on your behalf. Wait and retry the request.
     * @throws InvalidClusterSnapshotStateException
     *         The specified cluster snapshot is not in the <code>available</code> state, or other accounts are
     *         authorized to access the snapshot.
     * @throws LimitExceededException
     *         The encryption key has exceeded its grant limit in AWS KMS.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.AuthorizeSnapshotAccess
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeSnapshotAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default AuthorizeSnapshotAccessResponse authorizeSnapshotAccess(AuthorizeSnapshotAccessRequest authorizeSnapshotAccessRequest)
            throws ClusterSnapshotNotFoundException, AuthorizationAlreadyExistsException, AuthorizationQuotaExceededException,
            DependentServiceRequestThrottlingException, InvalidClusterSnapshotStateException, LimitExceededException,
            AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Authorizes the specified AWS customer account to restore the specified snapshot.
     * </p>
     * <p>
     * For more information about working with snapshots, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AuthorizeSnapshotAccessRequest.Builder} avoiding
     * the need to create one manually via {@link AuthorizeSnapshotAccessRequest#builder()}
     * </p>
     *
     * @param authorizeSnapshotAccessRequest
     *        A {@link Consumer} that will call methods on {@link AuthorizeSnapshotAccessMessage.Builder} to create a
     *        request.
     * @return Result of the AuthorizeSnapshotAccess operation returned by the service.
     * @throws ClusterSnapshotNotFoundException
     *         The snapshot identifier does not refer to an existing cluster snapshot.
     * @throws AuthorizationAlreadyExistsException
     *         The specified CIDR block or EC2 security group is already authorized for the specified cluster security
     *         group.
     * @throws AuthorizationQuotaExceededException
     *         The authorization quota for the cluster security group has been reached.
     * @throws DependentServiceRequestThrottlingException
     *         The request cannot be completed because a dependent service is throttling requests made by Amazon
     *         Redshift on your behalf. Wait and retry the request.
     * @throws InvalidClusterSnapshotStateException
     *         The specified cluster snapshot is not in the <code>available</code> state, or other accounts are
     *         authorized to access the snapshot.
     * @throws LimitExceededException
     *         The encryption key has exceeded its grant limit in AWS KMS.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.AuthorizeSnapshotAccess
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeSnapshotAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default AuthorizeSnapshotAccessResponse authorizeSnapshotAccess(
            Consumer<AuthorizeSnapshotAccessRequest.Builder> authorizeSnapshotAccessRequest)
            throws ClusterSnapshotNotFoundException, AuthorizationAlreadyExistsException, AuthorizationQuotaExceededException,
            DependentServiceRequestThrottlingException, InvalidClusterSnapshotStateException, LimitExceededException,
            AwsServiceException, SdkClientException, RedshiftException {
        return authorizeSnapshotAccess(AuthorizeSnapshotAccessRequest.builder().applyMutation(authorizeSnapshotAccessRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a set of cluster snapshots.
     * </p>
     *
     * @param batchDeleteClusterSnapshotsRequest
     * @return Result of the BatchDeleteClusterSnapshots operation returned by the service.
     * @throws BatchDeleteRequestSizeExceededException
     *         The maximum number for a batch delete of snapshots has been reached. The limit is 100.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.BatchDeleteClusterSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/BatchDeleteClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteClusterSnapshotsResponse batchDeleteClusterSnapshots(
            BatchDeleteClusterSnapshotsRequest batchDeleteClusterSnapshotsRequest)
            throws BatchDeleteRequestSizeExceededException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a set of cluster snapshots.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteClusterSnapshotsRequest.Builder}
     * avoiding the need to create one manually via {@link BatchDeleteClusterSnapshotsRequest#builder()}
     * </p>
     *
     * @param batchDeleteClusterSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeleteClusterSnapshotsRequest.Builder} to create
     *        a request.
     * @return Result of the BatchDeleteClusterSnapshots operation returned by the service.
     * @throws BatchDeleteRequestSizeExceededException
     *         The maximum number for a batch delete of snapshots has been reached. The limit is 100.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.BatchDeleteClusterSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/BatchDeleteClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteClusterSnapshotsResponse batchDeleteClusterSnapshots(
            Consumer<BatchDeleteClusterSnapshotsRequest.Builder> batchDeleteClusterSnapshotsRequest)
            throws BatchDeleteRequestSizeExceededException, AwsServiceException, SdkClientException, RedshiftException {
        return batchDeleteClusterSnapshots(BatchDeleteClusterSnapshotsRequest.builder()
                .applyMutation(batchDeleteClusterSnapshotsRequest).build());
    }

    /**
     * <p>
     * Modifies the settings for a list of snapshots.
     * </p>
     *
     * @param batchModifyClusterSnapshotsRequest
     * @return Result of the BatchModifyClusterSnapshots operation returned by the service.
     * @throws InvalidRetentionPeriodException
     *         The retention period specified is either in the past or is not a valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     * @throws BatchModifyClusterSnapshotsLimitExceededException
     *         The maximum number for snapshot identifiers has been reached. The limit is 100.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.BatchModifyClusterSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/BatchModifyClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchModifyClusterSnapshotsResponse batchModifyClusterSnapshots(
            BatchModifyClusterSnapshotsRequest batchModifyClusterSnapshotsRequest) throws InvalidRetentionPeriodException,
            BatchModifyClusterSnapshotsLimitExceededException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the settings for a list of snapshots.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchModifyClusterSnapshotsRequest.Builder}
     * avoiding the need to create one manually via {@link BatchModifyClusterSnapshotsRequest#builder()}
     * </p>
     *
     * @param batchModifyClusterSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link BatchModifyClusterSnapshotsMessage.Builder} to create
     *        a request.
     * @return Result of the BatchModifyClusterSnapshots operation returned by the service.
     * @throws InvalidRetentionPeriodException
     *         The retention period specified is either in the past or is not a valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     * @throws BatchModifyClusterSnapshotsLimitExceededException
     *         The maximum number for snapshot identifiers has been reached. The limit is 100.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.BatchModifyClusterSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/BatchModifyClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchModifyClusterSnapshotsResponse batchModifyClusterSnapshots(
            Consumer<BatchModifyClusterSnapshotsRequest.Builder> batchModifyClusterSnapshotsRequest)
            throws InvalidRetentionPeriodException, BatchModifyClusterSnapshotsLimitExceededException, AwsServiceException,
            SdkClientException, RedshiftException {
        return batchModifyClusterSnapshots(BatchModifyClusterSnapshotsRequest.builder()
                .applyMutation(batchModifyClusterSnapshotsRequest).build());
    }

    /**
     * <p>
     * Cancels a resize operation.
     * </p>
     *
     * @param cancelResizeRequest
     * @return Result of the CancelResize operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws ResizeNotFoundException
     *         A resize operation for the specified cluster is not found.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws UnsupportedOperationException
     *         The requested operation isn't supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CancelResize
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CancelResize" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelResizeResponse cancelResize(CancelResizeRequest cancelResizeRequest) throws ClusterNotFoundException,
            ResizeNotFoundException, InvalidClusterStateException, UnsupportedOperationException, AwsServiceException,
            SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a resize operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelResizeRequest.Builder} avoiding the need to
     * create one manually via {@link CancelResizeRequest#builder()}
     * </p>
     *
     * @param cancelResizeRequest
     *        A {@link Consumer} that will call methods on {@link CancelResizeMessage.Builder} to create a request.
     * @return Result of the CancelResize operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws ResizeNotFoundException
     *         A resize operation for the specified cluster is not found.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws UnsupportedOperationException
     *         The requested operation isn't supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CancelResize
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CancelResize" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelResizeResponse cancelResize(Consumer<CancelResizeRequest.Builder> cancelResizeRequest)
            throws ClusterNotFoundException, ResizeNotFoundException, InvalidClusterStateException,
            UnsupportedOperationException, AwsServiceException, SdkClientException, RedshiftException {
        return cancelResize(CancelResizeRequest.builder().applyMutation(cancelResizeRequest).build());
    }

    /**
     * <p>
     * Copies the specified automated cluster snapshot to a new manual cluster snapshot. The source must be an automated
     * snapshot and it must be in the available state.
     * </p>
     * <p>
     * When you delete a cluster, Amazon Redshift deletes any automated snapshots of the cluster. Also, when the
     * retention period of the snapshot expires, Amazon Redshift automatically deletes it. If you want to keep an
     * automated snapshot for a longer period, you can make a manual copy of the snapshot. Manual snapshots are retained
     * until you delete them.
     * </p>
     * <p>
     * For more information about working with snapshots, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param copyClusterSnapshotRequest
     * @return Result of the CopyClusterSnapshot operation returned by the service.
     * @throws ClusterSnapshotAlreadyExistsException
     *         The value specified as a snapshot identifier is already used by an existing snapshot.
     * @throws ClusterSnapshotNotFoundException
     *         The snapshot identifier does not refer to an existing cluster snapshot.
     * @throws InvalidClusterSnapshotStateException
     *         The specified cluster snapshot is not in the <code>available</code> state, or other accounts are
     *         authorized to access the snapshot.
     * @throws ClusterSnapshotQuotaExceededException
     *         The request would result in the user exceeding the allowed number of cluster snapshots.
     * @throws InvalidRetentionPeriodException
     *         The retention period specified is either in the past or is not a valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CopyClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CopyClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CopyClusterSnapshotResponse copyClusterSnapshot(CopyClusterSnapshotRequest copyClusterSnapshotRequest)
            throws ClusterSnapshotAlreadyExistsException, ClusterSnapshotNotFoundException, InvalidClusterSnapshotStateException,
            ClusterSnapshotQuotaExceededException, InvalidRetentionPeriodException, AwsServiceException, SdkClientException,
            RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies the specified automated cluster snapshot to a new manual cluster snapshot. The source must be an automated
     * snapshot and it must be in the available state.
     * </p>
     * <p>
     * When you delete a cluster, Amazon Redshift deletes any automated snapshots of the cluster. Also, when the
     * retention period of the snapshot expires, Amazon Redshift automatically deletes it. If you want to keep an
     * automated snapshot for a longer period, you can make a manual copy of the snapshot. Manual snapshots are retained
     * until you delete them.
     * </p>
     * <p>
     * For more information about working with snapshots, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyClusterSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link CopyClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param copyClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CopyClusterSnapshotMessage.Builder} to create a
     *        request.
     * @return Result of the CopyClusterSnapshot operation returned by the service.
     * @throws ClusterSnapshotAlreadyExistsException
     *         The value specified as a snapshot identifier is already used by an existing snapshot.
     * @throws ClusterSnapshotNotFoundException
     *         The snapshot identifier does not refer to an existing cluster snapshot.
     * @throws InvalidClusterSnapshotStateException
     *         The specified cluster snapshot is not in the <code>available</code> state, or other accounts are
     *         authorized to access the snapshot.
     * @throws ClusterSnapshotQuotaExceededException
     *         The request would result in the user exceeding the allowed number of cluster snapshots.
     * @throws InvalidRetentionPeriodException
     *         The retention period specified is either in the past or is not a valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CopyClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CopyClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CopyClusterSnapshotResponse copyClusterSnapshot(
            Consumer<CopyClusterSnapshotRequest.Builder> copyClusterSnapshotRequest)
            throws ClusterSnapshotAlreadyExistsException, ClusterSnapshotNotFoundException, InvalidClusterSnapshotStateException,
            ClusterSnapshotQuotaExceededException, InvalidRetentionPeriodException, AwsServiceException, SdkClientException,
            RedshiftException {
        return copyClusterSnapshot(CopyClusterSnapshotRequest.builder().applyMutation(copyClusterSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates a new cluster.
     * </p>
     * <p>
     * To create a cluster in Virtual Private Cloud (VPC), you must provide a cluster subnet group name. The cluster
     * subnet group identifies the subnets of your VPC that Amazon Redshift uses when creating the cluster. For more
     * information about managing clusters, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in
     * the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param createClusterRequest
     * @return Result of the CreateCluster operation returned by the service.
     * @throws ClusterAlreadyExistsException
     *         The account already has a cluster with the given identifier.
     * @throws InsufficientClusterCapacityException
     *         The number of nodes specified exceeds the allotted capacity of the cluster.
     * @throws ClusterParameterGroupNotFoundException
     *         The parameter group name does not refer to an existing parameter group.
     * @throws ClusterSecurityGroupNotFoundException
     *         The cluster security group name does not refer to an existing cluster security group.
     * @throws ClusterQuotaExceededException
     *         The request would exceed the allowed number of cluster instances for this account. For information about
     *         increasing your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws NumberOfNodesQuotaExceededException
     *         The operation would exceed the number of nodes allotted to the account. For information about increasing
     *         your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws NumberOfNodesPerClusterLimitExceededException
     *         The operation would exceed the number of nodes allowed for a cluster.
     * @throws ClusterSubnetGroupNotFoundException
     *         The cluster subnet group name does not refer to an existing cluster subnet group.
     * @throws InvalidVpcNetworkStateException
     *         The cluster subnet group does not cover all Availability Zones.
     * @throws InvalidClusterSubnetGroupStateException
     *         The cluster subnet group cannot be deleted because it is in use.
     * @throws InvalidSubnetException
     *         The requested subnet is not valid, or not all of the subnets are in the same VPC.
     * @throws UnauthorizedOperationException
     *         Your account is not authorized to perform the requested operation.
     * @throws HsmClientCertificateNotFoundException
     *         There is no Amazon Redshift HSM client certificate with the specified identifier.
     * @throws HsmConfigurationNotFoundException
     *         There is no Amazon Redshift HSM configuration with the specified identifier.
     * @throws InvalidElasticIpException
     *         The Elastic IP (EIP) is invalid or cannot be found.
     * @throws TagLimitExceededException
     *         You have exceeded the number of tags allowed.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws LimitExceededException
     *         The encryption key has exceeded its grant limit in AWS KMS.
     * @throws DependentServiceRequestThrottlingException
     *         The request cannot be completed because a dependent service is throttling requests made by Amazon
     *         Redshift on your behalf. Wait and retry the request.
     * @throws InvalidClusterTrackException
     *         The provided cluster track name is not valid.
     * @throws SnapshotScheduleNotFoundException
     *         We could not find the specified snapshot schedule.
     * @throws InvalidRetentionPeriodException
     *         The retention period specified is either in the past or is not a valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CreateCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws ClusterAlreadyExistsException,
            InsufficientClusterCapacityException, ClusterParameterGroupNotFoundException, ClusterSecurityGroupNotFoundException,
            ClusterQuotaExceededException, NumberOfNodesQuotaExceededException, NumberOfNodesPerClusterLimitExceededException,
            ClusterSubnetGroupNotFoundException, InvalidVpcNetworkStateException, InvalidClusterSubnetGroupStateException,
            InvalidSubnetException, UnauthorizedOperationException, HsmClientCertificateNotFoundException,
            HsmConfigurationNotFoundException, InvalidElasticIpException, TagLimitExceededException, InvalidTagException,
            LimitExceededException, DependentServiceRequestThrottlingException, InvalidClusterTrackException,
            SnapshotScheduleNotFoundException, InvalidRetentionPeriodException, AwsServiceException, SdkClientException,
            RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new cluster.
     * </p>
     * <p>
     * To create a cluster in Virtual Private Cloud (VPC), you must provide a cluster subnet group name. The cluster
     * subnet group identifies the subnets of your VPC that Amazon Redshift uses when creating the cluster. For more
     * information about managing clusters, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in
     * the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterRequest.Builder} avoiding the need to
     * create one manually via {@link CreateClusterRequest#builder()}
     * </p>
     *
     * @param createClusterRequest
     *        A {@link Consumer} that will call methods on {@link CreateClusterMessage.Builder} to create a request.
     * @return Result of the CreateCluster operation returned by the service.
     * @throws ClusterAlreadyExistsException
     *         The account already has a cluster with the given identifier.
     * @throws InsufficientClusterCapacityException
     *         The number of nodes specified exceeds the allotted capacity of the cluster.
     * @throws ClusterParameterGroupNotFoundException
     *         The parameter group name does not refer to an existing parameter group.
     * @throws ClusterSecurityGroupNotFoundException
     *         The cluster security group name does not refer to an existing cluster security group.
     * @throws ClusterQuotaExceededException
     *         The request would exceed the allowed number of cluster instances for this account. For information about
     *         increasing your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws NumberOfNodesQuotaExceededException
     *         The operation would exceed the number of nodes allotted to the account. For information about increasing
     *         your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws NumberOfNodesPerClusterLimitExceededException
     *         The operation would exceed the number of nodes allowed for a cluster.
     * @throws ClusterSubnetGroupNotFoundException
     *         The cluster subnet group name does not refer to an existing cluster subnet group.
     * @throws InvalidVpcNetworkStateException
     *         The cluster subnet group does not cover all Availability Zones.
     * @throws InvalidClusterSubnetGroupStateException
     *         The cluster subnet group cannot be deleted because it is in use.
     * @throws InvalidSubnetException
     *         The requested subnet is not valid, or not all of the subnets are in the same VPC.
     * @throws UnauthorizedOperationException
     *         Your account is not authorized to perform the requested operation.
     * @throws HsmClientCertificateNotFoundException
     *         There is no Amazon Redshift HSM client certificate with the specified identifier.
     * @throws HsmConfigurationNotFoundException
     *         There is no Amazon Redshift HSM configuration with the specified identifier.
     * @throws InvalidElasticIpException
     *         The Elastic IP (EIP) is invalid or cannot be found.
     * @throws TagLimitExceededException
     *         You have exceeded the number of tags allowed.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws LimitExceededException
     *         The encryption key has exceeded its grant limit in AWS KMS.
     * @throws DependentServiceRequestThrottlingException
     *         The request cannot be completed because a dependent service is throttling requests made by Amazon
     *         Redshift on your behalf. Wait and retry the request.
     * @throws InvalidClusterTrackException
     *         The provided cluster track name is not valid.
     * @throws SnapshotScheduleNotFoundException
     *         We could not find the specified snapshot schedule.
     * @throws InvalidRetentionPeriodException
     *         The retention period specified is either in the past or is not a valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CreateCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateClusterResponse createCluster(Consumer<CreateClusterRequest.Builder> createClusterRequest)
            throws ClusterAlreadyExistsException, InsufficientClusterCapacityException, ClusterParameterGroupNotFoundException,
            ClusterSecurityGroupNotFoundException, ClusterQuotaExceededException, NumberOfNodesQuotaExceededException,
            NumberOfNodesPerClusterLimitExceededException, ClusterSubnetGroupNotFoundException, InvalidVpcNetworkStateException,
            InvalidClusterSubnetGroupStateException, InvalidSubnetException, UnauthorizedOperationException,
            HsmClientCertificateNotFoundException, HsmConfigurationNotFoundException, InvalidElasticIpException,
            TagLimitExceededException, InvalidTagException, LimitExceededException, DependentServiceRequestThrottlingException,
            InvalidClusterTrackException, SnapshotScheduleNotFoundException, InvalidRetentionPeriodException,
            AwsServiceException, SdkClientException, RedshiftException {
        return createCluster(CreateClusterRequest.builder().applyMutation(createClusterRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Redshift parameter group.
     * </p>
     * <p>
     * Creating parameter groups is independent of creating clusters. You can associate a cluster with a parameter group
     * when you create the cluster. You can also associate an existing cluster with a parameter group after the cluster
     * is created by using <a>ModifyCluster</a>.
     * </p>
     * <p>
     * Parameters in the parameter group define specific behavior that applies to the databases you create on the
     * cluster. For more information about parameters and parameter groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param createClusterParameterGroupRequest
     * @return Result of the CreateClusterParameterGroup operation returned by the service.
     * @throws ClusterParameterGroupQuotaExceededException
     *         The request would result in the user exceeding the allowed number of cluster parameter groups. For
     *         information about increasing your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws ClusterParameterGroupAlreadyExistsException
     *         A cluster parameter group with the same name already exists.
     * @throws TagLimitExceededException
     *         You have exceeded the number of tags allowed.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CreateClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateClusterParameterGroupResponse createClusterParameterGroup(
            CreateClusterParameterGroupRequest createClusterParameterGroupRequest)
            throws ClusterParameterGroupQuotaExceededException, ClusterParameterGroupAlreadyExistsException,
            TagLimitExceededException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Redshift parameter group.
     * </p>
     * <p>
     * Creating parameter groups is independent of creating clusters. You can associate a cluster with a parameter group
     * when you create the cluster. You can also associate an existing cluster with a parameter group after the cluster
     * is created by using <a>ModifyCluster</a>.
     * </p>
     * <p>
     * Parameters in the parameter group define specific behavior that applies to the databases you create on the
     * cluster. For more information about parameters and parameter groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CreateClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param createClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateClusterParameterGroupMessage.Builder} to create
     *        a request.
     * @return Result of the CreateClusterParameterGroup operation returned by the service.
     * @throws ClusterParameterGroupQuotaExceededException
     *         The request would result in the user exceeding the allowed number of cluster parameter groups. For
     *         information about increasing your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws ClusterParameterGroupAlreadyExistsException
     *         A cluster parameter group with the same name already exists.
     * @throws TagLimitExceededException
     *         You have exceeded the number of tags allowed.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CreateClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateClusterParameterGroupResponse createClusterParameterGroup(
            Consumer<CreateClusterParameterGroupRequest.Builder> createClusterParameterGroupRequest)
            throws ClusterParameterGroupQuotaExceededException, ClusterParameterGroupAlreadyExistsException,
            TagLimitExceededException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return createClusterParameterGroup(CreateClusterParameterGroupRequest.builder()
                .applyMutation(createClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon Redshift security group. You use security groups to control access to non-VPC clusters.
     * </p>
     * <p>
     * For information about managing security groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster
     * Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param createClusterSecurityGroupRequest
     * @return Result of the CreateClusterSecurityGroup operation returned by the service.
     * @throws ClusterSecurityGroupAlreadyExistsException
     *         A cluster security group with the same name already exists.
     * @throws ClusterSecurityGroupQuotaExceededException
     *         The request would result in the user exceeding the allowed number of cluster security groups. For
     *         information about increasing your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws TagLimitExceededException
     *         You have exceeded the number of tags allowed.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CreateClusterSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateClusterSecurityGroupResponse createClusterSecurityGroup(
            CreateClusterSecurityGroupRequest createClusterSecurityGroupRequest)
            throws ClusterSecurityGroupAlreadyExistsException, ClusterSecurityGroupQuotaExceededException,
            TagLimitExceededException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon Redshift security group. You use security groups to control access to non-VPC clusters.
     * </p>
     * <p>
     * For information about managing security groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster
     * Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterSecurityGroupRequest.Builder} avoiding
     * the need to create one manually via {@link CreateClusterSecurityGroupRequest#builder()}
     * </p>
     *
     * @param createClusterSecurityGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateClusterSecurityGroupMessage.Builder} to create a
     *        request.
     * @return Result of the CreateClusterSecurityGroup operation returned by the service.
     * @throws ClusterSecurityGroupAlreadyExistsException
     *         A cluster security group with the same name already exists.
     * @throws ClusterSecurityGroupQuotaExceededException
     *         The request would result in the user exceeding the allowed number of cluster security groups. For
     *         information about increasing your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws TagLimitExceededException
     *         You have exceeded the number of tags allowed.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CreateClusterSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateClusterSecurityGroupResponse createClusterSecurityGroup(
            Consumer<CreateClusterSecurityGroupRequest.Builder> createClusterSecurityGroupRequest)
            throws ClusterSecurityGroupAlreadyExistsException, ClusterSecurityGroupQuotaExceededException,
            TagLimitExceededException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return createClusterSecurityGroup(CreateClusterSecurityGroupRequest.builder()
                .applyMutation(createClusterSecurityGroupRequest).build());
    }

    /**
     * <p>
     * Creates a manual snapshot of the specified cluster. The cluster must be in the <code>available</code> state.
     * </p>
     * <p>
     * For more information about working with snapshots, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param createClusterSnapshotRequest
     * @return Result of the CreateClusterSnapshot operation returned by the service.
     * @throws ClusterSnapshotAlreadyExistsException
     *         The value specified as a snapshot identifier is already used by an existing snapshot.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws ClusterSnapshotQuotaExceededException
     *         The request would result in the user exceeding the allowed number of cluster snapshots.
     * @throws TagLimitExceededException
     *         You have exceeded the number of tags allowed.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws InvalidRetentionPeriodException
     *         The retention period specified is either in the past or is not a valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CreateClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateClusterSnapshotResponse createClusterSnapshot(CreateClusterSnapshotRequest createClusterSnapshotRequest)
            throws ClusterSnapshotAlreadyExistsException, InvalidClusterStateException, ClusterNotFoundException,
            ClusterSnapshotQuotaExceededException, TagLimitExceededException, InvalidTagException,
            InvalidRetentionPeriodException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a manual snapshot of the specified cluster. The cluster must be in the <code>available</code> state.
     * </p>
     * <p>
     * For more information about working with snapshots, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link CreateClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param createClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CreateClusterSnapshotMessage.Builder} to create a
     *        request.
     * @return Result of the CreateClusterSnapshot operation returned by the service.
     * @throws ClusterSnapshotAlreadyExistsException
     *         The value specified as a snapshot identifier is already used by an existing snapshot.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws ClusterSnapshotQuotaExceededException
     *         The request would result in the user exceeding the allowed number of cluster snapshots.
     * @throws TagLimitExceededException
     *         You have exceeded the number of tags allowed.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws InvalidRetentionPeriodException
     *         The retention period specified is either in the past or is not a valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CreateClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateClusterSnapshotResponse createClusterSnapshot(
            Consumer<CreateClusterSnapshotRequest.Builder> createClusterSnapshotRequest)
            throws ClusterSnapshotAlreadyExistsException, InvalidClusterStateException, ClusterNotFoundException,
            ClusterSnapshotQuotaExceededException, TagLimitExceededException, InvalidTagException,
            InvalidRetentionPeriodException, AwsServiceException, SdkClientException, RedshiftException {
        return createClusterSnapshot(CreateClusterSnapshotRequest.builder().applyMutation(createClusterSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon Redshift subnet group. You must provide a list of one or more subnets in your existing
     * Amazon Virtual Private Cloud (Amazon VPC) when creating Amazon Redshift subnet group.
     * </p>
     * <p>
     * For information about subnet groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-cluster-subnet-groups.html">Amazon Redshift
     * Cluster Subnet Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param createClusterSubnetGroupRequest
     * @return Result of the CreateClusterSubnetGroup operation returned by the service.
     * @throws ClusterSubnetGroupAlreadyExistsException
     *         A <i>ClusterSubnetGroupName</i> is already used by an existing cluster subnet group.
     * @throws ClusterSubnetGroupQuotaExceededException
     *         The request would result in user exceeding the allowed number of cluster subnet groups. For information
     *         about increasing your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws ClusterSubnetQuotaExceededException
     *         The request would result in user exceeding the allowed number of subnets in a cluster subnet groups. For
     *         information about increasing your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws InvalidSubnetException
     *         The requested subnet is not valid, or not all of the subnets are in the same VPC.
     * @throws UnauthorizedOperationException
     *         Your account is not authorized to perform the requested operation.
     * @throws TagLimitExceededException
     *         You have exceeded the number of tags allowed.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws DependentServiceRequestThrottlingException
     *         The request cannot be completed because a dependent service is throttling requests made by Amazon
     *         Redshift on your behalf. Wait and retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CreateClusterSubnetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateClusterSubnetGroupResponse createClusterSubnetGroup(
            CreateClusterSubnetGroupRequest createClusterSubnetGroupRequest) throws ClusterSubnetGroupAlreadyExistsException,
            ClusterSubnetGroupQuotaExceededException, ClusterSubnetQuotaExceededException, InvalidSubnetException,
            UnauthorizedOperationException, TagLimitExceededException, InvalidTagException,
            DependentServiceRequestThrottlingException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon Redshift subnet group. You must provide a list of one or more subnets in your existing
     * Amazon Virtual Private Cloud (Amazon VPC) when creating Amazon Redshift subnet group.
     * </p>
     * <p>
     * For information about subnet groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-cluster-subnet-groups.html">Amazon Redshift
     * Cluster Subnet Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterSubnetGroupRequest.Builder} avoiding
     * the need to create one manually via {@link CreateClusterSubnetGroupRequest#builder()}
     * </p>
     *
     * @param createClusterSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateClusterSubnetGroupMessage.Builder} to create a
     *        request.
     * @return Result of the CreateClusterSubnetGroup operation returned by the service.
     * @throws ClusterSubnetGroupAlreadyExistsException
     *         A <i>ClusterSubnetGroupName</i> is already used by an existing cluster subnet group.
     * @throws ClusterSubnetGroupQuotaExceededException
     *         The request would result in user exceeding the allowed number of cluster subnet groups. For information
     *         about increasing your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws ClusterSubnetQuotaExceededException
     *         The request would result in user exceeding the allowed number of subnets in a cluster subnet groups. For
     *         information about increasing your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws InvalidSubnetException
     *         The requested subnet is not valid, or not all of the subnets are in the same VPC.
     * @throws UnauthorizedOperationException
     *         Your account is not authorized to perform the requested operation.
     * @throws TagLimitExceededException
     *         You have exceeded the number of tags allowed.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws DependentServiceRequestThrottlingException
     *         The request cannot be completed because a dependent service is throttling requests made by Amazon
     *         Redshift on your behalf. Wait and retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CreateClusterSubnetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateClusterSubnetGroupResponse createClusterSubnetGroup(
            Consumer<CreateClusterSubnetGroupRequest.Builder> createClusterSubnetGroupRequest)
            throws ClusterSubnetGroupAlreadyExistsException, ClusterSubnetGroupQuotaExceededException,
            ClusterSubnetQuotaExceededException, InvalidSubnetException, UnauthorizedOperationException,
            TagLimitExceededException, InvalidTagException, DependentServiceRequestThrottlingException, AwsServiceException,
            SdkClientException, RedshiftException {
        return createClusterSubnetGroup(CreateClusterSubnetGroupRequest.builder().applyMutation(createClusterSubnetGroupRequest)
                .build());
    }

    /**
     * <p>
     * Creates an Amazon Redshift event notification subscription. This action requires an ARN (Amazon Resource Name) of
     * an Amazon SNS topic created by either the Amazon Redshift console, the Amazon SNS console, or the Amazon SNS API.
     * To obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is
     * displayed in the SNS console.
     * </p>
     * <p>
     * You can specify the source type, and lists of Amazon Redshift source IDs, event categories, and event severities.
     * Notifications will be sent for all events you want that match those criteria. For example, you can specify source
     * type = cluster, source ID = my-cluster-1 and mycluster2, event categories = Availability, Backup, and severity =
     * ERROR. The subscription will only send notifications for those ERROR events in the Availability and Backup
     * categories for the specified clusters.
     * </p>
     * <p>
     * If you specify both the source type and source IDs, such as source type = cluster and source identifier =
     * my-cluster-1, notifications will be sent for all the cluster events for my-cluster-1. If you specify a source
     * type but do not specify a source identifier, you will receive notice of the events for the objects of that type
     * in your AWS account. If you do not specify either the SourceType nor the SourceIdentifier, you will be notified
     * of events generated from all Amazon Redshift sources belonging to your AWS account. You must specify a source
     * type if you specify a source ID.
     * </p>
     *
     * @param createEventSubscriptionRequest
     * @return Result of the CreateEventSubscription operation returned by the service.
     * @throws EventSubscriptionQuotaExceededException
     *         The request would exceed the allowed number of event subscriptions for this account. For information
     *         about increasing your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws SubscriptionAlreadyExistException
     *         There is already an existing event notification subscription with the specified name.
     * @throws SnsInvalidTopicException
     *         Amazon SNS has responded that there is a problem with the specified Amazon SNS topic.
     * @throws SnsNoAuthorizationException
     *         You do not have permission to publish to the specified Amazon SNS topic.
     * @throws SnsTopicArnNotFoundException
     *         An Amazon SNS topic with the specified Amazon Resource Name (ARN) does not exist.
     * @throws SubscriptionEventIdNotFoundException
     *         An Amazon Redshift event with the specified event ID does not exist.
     * @throws SubscriptionCategoryNotFoundException
     *         The value specified for the event category was not one of the allowed values, or it specified a category
     *         that does not apply to the specified source type. The allowed values are Configuration, Management,
     *         Monitoring, and Security.
     * @throws SubscriptionSeverityNotFoundException
     *         The value specified for the event severity was not one of the allowed values, or it specified a severity
     *         that does not apply to the specified source type. The allowed values are ERROR and INFO.
     * @throws SourceNotFoundException
     *         The specified Amazon Redshift event source could not be found.
     * @throws TagLimitExceededException
     *         You have exceeded the number of tags allowed.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CreateEventSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEventSubscriptionResponse createEventSubscription(CreateEventSubscriptionRequest createEventSubscriptionRequest)
            throws EventSubscriptionQuotaExceededException, SubscriptionAlreadyExistException, SnsInvalidTopicException,
            SnsNoAuthorizationException, SnsTopicArnNotFoundException, SubscriptionEventIdNotFoundException,
            SubscriptionCategoryNotFoundException, SubscriptionSeverityNotFoundException, SourceNotFoundException,
            TagLimitExceededException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Redshift event notification subscription. This action requires an ARN (Amazon Resource Name) of
     * an Amazon SNS topic created by either the Amazon Redshift console, the Amazon SNS console, or the Amazon SNS API.
     * To obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is
     * displayed in the SNS console.
     * </p>
     * <p>
     * You can specify the source type, and lists of Amazon Redshift source IDs, event categories, and event severities.
     * Notifications will be sent for all events you want that match those criteria. For example, you can specify source
     * type = cluster, source ID = my-cluster-1 and mycluster2, event categories = Availability, Backup, and severity =
     * ERROR. The subscription will only send notifications for those ERROR events in the Availability and Backup
     * categories for the specified clusters.
     * </p>
     * <p>
     * If you specify both the source type and source IDs, such as source type = cluster and source identifier =
     * my-cluster-1, notifications will be sent for all the cluster events for my-cluster-1. If you specify a source
     * type but do not specify a source identifier, you will receive notice of the events for the objects of that type
     * in your AWS account. If you do not specify either the SourceType nor the SourceIdentifier, you will be notified
     * of events generated from all Amazon Redshift sources belonging to your AWS account. You must specify a source
     * type if you specify a source ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEventSubscriptionRequest#builder()}
     * </p>
     *
     * @param createEventSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link CreateEventSubscriptionMessage.Builder} to create a
     *        request.
     * @return Result of the CreateEventSubscription operation returned by the service.
     * @throws EventSubscriptionQuotaExceededException
     *         The request would exceed the allowed number of event subscriptions for this account. For information
     *         about increasing your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws SubscriptionAlreadyExistException
     *         There is already an existing event notification subscription with the specified name.
     * @throws SnsInvalidTopicException
     *         Amazon SNS has responded that there is a problem with the specified Amazon SNS topic.
     * @throws SnsNoAuthorizationException
     *         You do not have permission to publish to the specified Amazon SNS topic.
     * @throws SnsTopicArnNotFoundException
     *         An Amazon SNS topic with the specified Amazon Resource Name (ARN) does not exist.
     * @throws SubscriptionEventIdNotFoundException
     *         An Amazon Redshift event with the specified event ID does not exist.
     * @throws SubscriptionCategoryNotFoundException
     *         The value specified for the event category was not one of the allowed values, or it specified a category
     *         that does not apply to the specified source type. The allowed values are Configuration, Management,
     *         Monitoring, and Security.
     * @throws SubscriptionSeverityNotFoundException
     *         The value specified for the event severity was not one of the allowed values, or it specified a severity
     *         that does not apply to the specified source type. The allowed values are ERROR and INFO.
     * @throws SourceNotFoundException
     *         The specified Amazon Redshift event source could not be found.
     * @throws TagLimitExceededException
     *         You have exceeded the number of tags allowed.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CreateEventSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEventSubscriptionResponse createEventSubscription(
            Consumer<CreateEventSubscriptionRequest.Builder> createEventSubscriptionRequest)
            throws EventSubscriptionQuotaExceededException, SubscriptionAlreadyExistException, SnsInvalidTopicException,
            SnsNoAuthorizationException, SnsTopicArnNotFoundException, SubscriptionEventIdNotFoundException,
            SubscriptionCategoryNotFoundException, SubscriptionSeverityNotFoundException, SourceNotFoundException,
            TagLimitExceededException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return createEventSubscription(CreateEventSubscriptionRequest.builder().applyMutation(createEventSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Creates an HSM client certificate that an Amazon Redshift cluster will use to connect to the client's HSM in
     * order to store and retrieve the keys used to encrypt the cluster databases.
     * </p>
     * <p>
     * The command returns a public key, which you must store in the HSM. In addition to creating the HSM certificate,
     * you must create an Amazon Redshift HSM configuration that provides a cluster the information needed to store and
     * use encryption keys in the HSM. For more information, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-HSM.html">Hardware Security Modules</a> in the
     * Amazon Redshift Cluster Management Guide.
     * </p>
     *
     * @param createHsmClientCertificateRequest
     * @return Result of the CreateHsmClientCertificate operation returned by the service.
     * @throws HsmClientCertificateAlreadyExistsException
     *         There is already an existing Amazon Redshift HSM client certificate with the specified identifier.
     * @throws HsmClientCertificateQuotaExceededException
     *         The quota for HSM client certificates has been reached. For information about increasing your quota, go
     *         to <a href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws TagLimitExceededException
     *         You have exceeded the number of tags allowed.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CreateHsmClientCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateHsmClientCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateHsmClientCertificateResponse createHsmClientCertificate(
            CreateHsmClientCertificateRequest createHsmClientCertificateRequest)
            throws HsmClientCertificateAlreadyExistsException, HsmClientCertificateQuotaExceededException,
            TagLimitExceededException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an HSM client certificate that an Amazon Redshift cluster will use to connect to the client's HSM in
     * order to store and retrieve the keys used to encrypt the cluster databases.
     * </p>
     * <p>
     * The command returns a public key, which you must store in the HSM. In addition to creating the HSM certificate,
     * you must create an Amazon Redshift HSM configuration that provides a cluster the information needed to store and
     * use encryption keys in the HSM. For more information, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-HSM.html">Hardware Security Modules</a> in the
     * Amazon Redshift Cluster Management Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHsmClientCertificateRequest.Builder} avoiding
     * the need to create one manually via {@link CreateHsmClientCertificateRequest#builder()}
     * </p>
     *
     * @param createHsmClientCertificateRequest
     *        A {@link Consumer} that will call methods on {@link CreateHsmClientCertificateMessage.Builder} to create a
     *        request.
     * @return Result of the CreateHsmClientCertificate operation returned by the service.
     * @throws HsmClientCertificateAlreadyExistsException
     *         There is already an existing Amazon Redshift HSM client certificate with the specified identifier.
     * @throws HsmClientCertificateQuotaExceededException
     *         The quota for HSM client certificates has been reached. For information about increasing your quota, go
     *         to <a href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws TagLimitExceededException
     *         You have exceeded the number of tags allowed.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CreateHsmClientCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateHsmClientCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateHsmClientCertificateResponse createHsmClientCertificate(
            Consumer<CreateHsmClientCertificateRequest.Builder> createHsmClientCertificateRequest)
            throws HsmClientCertificateAlreadyExistsException, HsmClientCertificateQuotaExceededException,
            TagLimitExceededException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return createHsmClientCertificate(CreateHsmClientCertificateRequest.builder()
                .applyMutation(createHsmClientCertificateRequest).build());
    }

    /**
     * <p>
     * Creates an HSM configuration that contains the information required by an Amazon Redshift cluster to store and
     * use database encryption keys in a Hardware Security Module (HSM). After creating the HSM configuration, you can
     * specify it as a parameter when creating a cluster. The cluster will then store its encryption keys in the HSM.
     * </p>
     * <p>
     * In addition to creating an HSM configuration, you must also create an HSM client certificate. For more
     * information, go to <a href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-HSM.html">Hardware
     * Security Modules</a> in the Amazon Redshift Cluster Management Guide.
     * </p>
     *
     * @param createHsmConfigurationRequest
     * @return Result of the CreateHsmConfiguration operation returned by the service.
     * @throws HsmConfigurationAlreadyExistsException
     *         There is already an existing Amazon Redshift HSM configuration with the specified identifier.
     * @throws HsmConfigurationQuotaExceededException
     *         The quota for HSM configurations has been reached. For information about increasing your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws TagLimitExceededException
     *         You have exceeded the number of tags allowed.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CreateHsmConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateHsmConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateHsmConfigurationResponse createHsmConfiguration(CreateHsmConfigurationRequest createHsmConfigurationRequest)
            throws HsmConfigurationAlreadyExistsException, HsmConfigurationQuotaExceededException, TagLimitExceededException,
            InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an HSM configuration that contains the information required by an Amazon Redshift cluster to store and
     * use database encryption keys in a Hardware Security Module (HSM). After creating the HSM configuration, you can
     * specify it as a parameter when creating a cluster. The cluster will then store its encryption keys in the HSM.
     * </p>
     * <p>
     * In addition to creating an HSM configuration, you must also create an HSM client certificate. For more
     * information, go to <a href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-HSM.html">Hardware
     * Security Modules</a> in the Amazon Redshift Cluster Management Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHsmConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateHsmConfigurationRequest#builder()}
     * </p>
     *
     * @param createHsmConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateHsmConfigurationMessage.Builder} to create a
     *        request.
     * @return Result of the CreateHsmConfiguration operation returned by the service.
     * @throws HsmConfigurationAlreadyExistsException
     *         There is already an existing Amazon Redshift HSM configuration with the specified identifier.
     * @throws HsmConfigurationQuotaExceededException
     *         The quota for HSM configurations has been reached. For information about increasing your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws TagLimitExceededException
     *         You have exceeded the number of tags allowed.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CreateHsmConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateHsmConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateHsmConfigurationResponse createHsmConfiguration(
            Consumer<CreateHsmConfigurationRequest.Builder> createHsmConfigurationRequest)
            throws HsmConfigurationAlreadyExistsException, HsmConfigurationQuotaExceededException, TagLimitExceededException,
            InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return createHsmConfiguration(CreateHsmConfigurationRequest.builder().applyMutation(createHsmConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Creates a snapshot copy grant that permits Amazon Redshift to use a customer master key (CMK) from AWS Key
     * Management Service (AWS KMS) to encrypt copied snapshots in a destination region.
     * </p>
     * <p>
     * For more information about managing snapshot copy grants, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database
     * Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param createSnapshotCopyGrantRequest
     *        The result of the <code>CreateSnapshotCopyGrant</code> action.
     * @return Result of the CreateSnapshotCopyGrant operation returned by the service.
     * @throws SnapshotCopyGrantAlreadyExistsException
     *         The snapshot copy grant can't be created because a grant with the same name already exists.
     * @throws SnapshotCopyGrantQuotaExceededException
     *         The AWS account has exceeded the maximum number of snapshot copy grants in this region.
     * @throws LimitExceededException
     *         The encryption key has exceeded its grant limit in AWS KMS.
     * @throws TagLimitExceededException
     *         You have exceeded the number of tags allowed.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws DependentServiceRequestThrottlingException
     *         The request cannot be completed because a dependent service is throttling requests made by Amazon
     *         Redshift on your behalf. Wait and retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CreateSnapshotCopyGrant
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateSnapshotCopyGrant"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSnapshotCopyGrantResponse createSnapshotCopyGrant(CreateSnapshotCopyGrantRequest createSnapshotCopyGrantRequest)
            throws SnapshotCopyGrantAlreadyExistsException, SnapshotCopyGrantQuotaExceededException, LimitExceededException,
            TagLimitExceededException, InvalidTagException, DependentServiceRequestThrottlingException, AwsServiceException,
            SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot copy grant that permits Amazon Redshift to use a customer master key (CMK) from AWS Key
     * Management Service (AWS KMS) to encrypt copied snapshots in a destination region.
     * </p>
     * <p>
     * For more information about managing snapshot copy grants, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database
     * Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSnapshotCopyGrantRequest.Builder} avoiding
     * the need to create one manually via {@link CreateSnapshotCopyGrantRequest#builder()}
     * </p>
     *
     * @param createSnapshotCopyGrantRequest
     *        A {@link Consumer} that will call methods on {@link CreateSnapshotCopyGrantMessage.Builder} to create a
     *        request. The result of the <code>CreateSnapshotCopyGrant</code> action.
     * @return Result of the CreateSnapshotCopyGrant operation returned by the service.
     * @throws SnapshotCopyGrantAlreadyExistsException
     *         The snapshot copy grant can't be created because a grant with the same name already exists.
     * @throws SnapshotCopyGrantQuotaExceededException
     *         The AWS account has exceeded the maximum number of snapshot copy grants in this region.
     * @throws LimitExceededException
     *         The encryption key has exceeded its grant limit in AWS KMS.
     * @throws TagLimitExceededException
     *         You have exceeded the number of tags allowed.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws DependentServiceRequestThrottlingException
     *         The request cannot be completed because a dependent service is throttling requests made by Amazon
     *         Redshift on your behalf. Wait and retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CreateSnapshotCopyGrant
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateSnapshotCopyGrant"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSnapshotCopyGrantResponse createSnapshotCopyGrant(
            Consumer<CreateSnapshotCopyGrantRequest.Builder> createSnapshotCopyGrantRequest)
            throws SnapshotCopyGrantAlreadyExistsException, SnapshotCopyGrantQuotaExceededException, LimitExceededException,
            TagLimitExceededException, InvalidTagException, DependentServiceRequestThrottlingException, AwsServiceException,
            SdkClientException, RedshiftException {
        return createSnapshotCopyGrant(CreateSnapshotCopyGrantRequest.builder().applyMutation(createSnapshotCopyGrantRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new snapshot schedule.
     * </p>
     *
     * @param createSnapshotScheduleRequest
     * @return Result of the CreateSnapshotSchedule operation returned by the service.
     * @throws SnapshotScheduleAlreadyExistsException
     *         The specified snapshot schedule already exists.
     * @throws InvalidScheduleException
     *         The schedule you submitted isn't valid.
     * @throws SnapshotScheduleQuotaExceededException
     *         You have exceeded the quota of snapshot schedules.
     * @throws TagLimitExceededException
     *         You have exceeded the number of tags allowed.
     * @throws ScheduleDefinitionTypeUnsupportedException
     *         The definition you submitted is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CreateSnapshotSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateSnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSnapshotScheduleResponse createSnapshotSchedule(CreateSnapshotScheduleRequest createSnapshotScheduleRequest)
            throws SnapshotScheduleAlreadyExistsException, InvalidScheduleException, SnapshotScheduleQuotaExceededException,
            TagLimitExceededException, ScheduleDefinitionTypeUnsupportedException, AwsServiceException, SdkClientException,
            RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new snapshot schedule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSnapshotScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSnapshotScheduleRequest#builder()}
     * </p>
     *
     * @param createSnapshotScheduleRequest
     *        A {@link Consumer} that will call methods on {@link CreateSnapshotScheduleMessage.Builder} to create a
     *        request.
     * @return Result of the CreateSnapshotSchedule operation returned by the service.
     * @throws SnapshotScheduleAlreadyExistsException
     *         The specified snapshot schedule already exists.
     * @throws InvalidScheduleException
     *         The schedule you submitted isn't valid.
     * @throws SnapshotScheduleQuotaExceededException
     *         You have exceeded the quota of snapshot schedules.
     * @throws TagLimitExceededException
     *         You have exceeded the number of tags allowed.
     * @throws ScheduleDefinitionTypeUnsupportedException
     *         The definition you submitted is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CreateSnapshotSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateSnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSnapshotScheduleResponse createSnapshotSchedule(
            Consumer<CreateSnapshotScheduleRequest.Builder> createSnapshotScheduleRequest)
            throws SnapshotScheduleAlreadyExistsException, InvalidScheduleException, SnapshotScheduleQuotaExceededException,
            TagLimitExceededException, ScheduleDefinitionTypeUnsupportedException, AwsServiceException, SdkClientException,
            RedshiftException {
        return createSnapshotSchedule(CreateSnapshotScheduleRequest.builder().applyMutation(createSnapshotScheduleRequest)
                .build());
    }

    /**
     * <p>
     * Adds one or more tags to a specified resource.
     * </p>
     * <p>
     * A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, you will receive an
     * error and the attempt will fail.
     * </p>
     * <p>
     * If you specify a key that already exists for the resource, the value for that key will be updated with the new
     * value.
     * </p>
     *
     * @param createTagsRequest
     *        Contains the output from the <code>CreateTags</code> action.
     * @return Result of the CreateTags operation returned by the service.
     * @throws TagLimitExceededException
     *         You have exceeded the number of tags allowed.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CreateTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTagsResponse createTags(CreateTagsRequest createTagsRequest) throws TagLimitExceededException,
            ResourceNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags to a specified resource.
     * </p>
     * <p>
     * A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, you will receive an
     * error and the attempt will fail.
     * </p>
     * <p>
     * If you specify a key that already exists for the resource, the value for that key will be updated with the new
     * value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTagsRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTagsRequest#builder()}
     * </p>
     *
     * @param createTagsRequest
     *        A {@link Consumer} that will call methods on {@link CreateTagsMessage.Builder} to create a request.
     *        Contains the output from the <code>CreateTags</code> action.
     * @return Result of the CreateTags operation returned by the service.
     * @throws TagLimitExceededException
     *         You have exceeded the number of tags allowed.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.CreateTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTagsResponse createTags(Consumer<CreateTagsRequest.Builder> createTagsRequest)
            throws TagLimitExceededException, ResourceNotFoundException, InvalidTagException, AwsServiceException,
            SdkClientException, RedshiftException {
        return createTags(CreateTagsRequest.builder().applyMutation(createTagsRequest).build());
    }

    /**
     * <p>
     * Deletes a previously provisioned cluster. A successful response from the web service indicates that the request
     * was received correctly. Use <a>DescribeClusters</a> to monitor the status of the deletion. The delete operation
     * cannot be canceled or reverted once submitted. For more information about managing clusters, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in
     * the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you want to shut down the cluster and retain it for future use, set <i>SkipFinalClusterSnapshot</i> to
     * <code>false</code> and specify a name for <i>FinalClusterSnapshotIdentifier</i>. You can later restore this
     * snapshot to resume using the cluster. If a final cluster snapshot is requested, the status of the cluster will be
     * "final-snapshot" while the snapshot is being taken, then it's "deleting" once Amazon Redshift begins deleting the
     * cluster.
     * </p>
     * <p>
     * For more information about managing clusters, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in
     * the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param deleteClusterRequest
     * @return Result of the DeleteCluster operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws ClusterSnapshotAlreadyExistsException
     *         The value specified as a snapshot identifier is already used by an existing snapshot.
     * @throws ClusterSnapshotQuotaExceededException
     *         The request would result in the user exceeding the allowed number of cluster snapshots.
     * @throws InvalidRetentionPeriodException
     *         The retention period specified is either in the past or is not a valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DeleteCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteClusterResponse deleteCluster(DeleteClusterRequest deleteClusterRequest) throws ClusterNotFoundException,
            InvalidClusterStateException, ClusterSnapshotAlreadyExistsException, ClusterSnapshotQuotaExceededException,
            InvalidRetentionPeriodException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a previously provisioned cluster. A successful response from the web service indicates that the request
     * was received correctly. Use <a>DescribeClusters</a> to monitor the status of the deletion. The delete operation
     * cannot be canceled or reverted once submitted. For more information about managing clusters, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in
     * the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you want to shut down the cluster and retain it for future use, set <i>SkipFinalClusterSnapshot</i> to
     * <code>false</code> and specify a name for <i>FinalClusterSnapshotIdentifier</i>. You can later restore this
     * snapshot to resume using the cluster. If a final cluster snapshot is requested, the status of the cluster will be
     * "final-snapshot" while the snapshot is being taken, then it's "deleting" once Amazon Redshift begins deleting the
     * cluster.
     * </p>
     * <p>
     * For more information about managing clusters, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in
     * the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteClusterRequest#builder()}
     * </p>
     *
     * @param deleteClusterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteClusterMessage.Builder} to create a request.
     * @return Result of the DeleteCluster operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws ClusterSnapshotAlreadyExistsException
     *         The value specified as a snapshot identifier is already used by an existing snapshot.
     * @throws ClusterSnapshotQuotaExceededException
     *         The request would result in the user exceeding the allowed number of cluster snapshots.
     * @throws InvalidRetentionPeriodException
     *         The retention period specified is either in the past or is not a valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DeleteCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteClusterResponse deleteCluster(Consumer<DeleteClusterRequest.Builder> deleteClusterRequest)
            throws ClusterNotFoundException, InvalidClusterStateException, ClusterSnapshotAlreadyExistsException,
            ClusterSnapshotQuotaExceededException, InvalidRetentionPeriodException, AwsServiceException, SdkClientException,
            RedshiftException {
        return deleteCluster(DeleteClusterRequest.builder().applyMutation(deleteClusterRequest).build());
    }

    /**
     * <p>
     * Deletes a specified Amazon Redshift parameter group.
     * </p>
     * <note>
     * <p>
     * You cannot delete a parameter group if it is associated with a cluster.
     * </p>
     * </note>
     *
     * @param deleteClusterParameterGroupRequest
     * @return Result of the DeleteClusterParameterGroup operation returned by the service.
     * @throws InvalidClusterParameterGroupStateException
     *         The cluster parameter group action can not be completed because another task is in progress that involves
     *         the parameter group. Wait a few moments and try the operation again.
     * @throws ClusterParameterGroupNotFoundException
     *         The parameter group name does not refer to an existing parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DeleteClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteClusterParameterGroupResponse deleteClusterParameterGroup(
            DeleteClusterParameterGroupRequest deleteClusterParameterGroupRequest)
            throws InvalidClusterParameterGroupStateException, ClusterParameterGroupNotFoundException, AwsServiceException,
            SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified Amazon Redshift parameter group.
     * </p>
     * <note>
     * <p>
     * You cannot delete a parameter group if it is associated with a cluster.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param deleteClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteClusterParameterGroupMessage.Builder} to create
     *        a request.
     * @return Result of the DeleteClusterParameterGroup operation returned by the service.
     * @throws InvalidClusterParameterGroupStateException
     *         The cluster parameter group action can not be completed because another task is in progress that involves
     *         the parameter group. Wait a few moments and try the operation again.
     * @throws ClusterParameterGroupNotFoundException
     *         The parameter group name does not refer to an existing parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DeleteClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteClusterParameterGroupResponse deleteClusterParameterGroup(
            Consumer<DeleteClusterParameterGroupRequest.Builder> deleteClusterParameterGroupRequest)
            throws InvalidClusterParameterGroupStateException, ClusterParameterGroupNotFoundException, AwsServiceException,
            SdkClientException, RedshiftException {
        return deleteClusterParameterGroup(DeleteClusterParameterGroupRequest.builder()
                .applyMutation(deleteClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Redshift security group.
     * </p>
     * <note>
     * <p>
     * You cannot delete a security group that is associated with any clusters. You cannot delete the default security
     * group.
     * </p>
     * </note>
     * <p>
     * For information about managing security groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster
     * Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param deleteClusterSecurityGroupRequest
     * @return Result of the DeleteClusterSecurityGroup operation returned by the service.
     * @throws InvalidClusterSecurityGroupStateException
     *         The state of the cluster security group is not <code>available</code>.
     * @throws ClusterSecurityGroupNotFoundException
     *         The cluster security group name does not refer to an existing cluster security group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DeleteClusterSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteClusterSecurityGroupResponse deleteClusterSecurityGroup(
            DeleteClusterSecurityGroupRequest deleteClusterSecurityGroupRequest)
            throws InvalidClusterSecurityGroupStateException, ClusterSecurityGroupNotFoundException, AwsServiceException,
            SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Redshift security group.
     * </p>
     * <note>
     * <p>
     * You cannot delete a security group that is associated with any clusters. You cannot delete the default security
     * group.
     * </p>
     * </note>
     * <p>
     * For information about managing security groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster
     * Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterSecurityGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteClusterSecurityGroupRequest#builder()}
     * </p>
     *
     * @param deleteClusterSecurityGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteClusterSecurityGroupMessage.Builder} to create a
     *        request.
     * @return Result of the DeleteClusterSecurityGroup operation returned by the service.
     * @throws InvalidClusterSecurityGroupStateException
     *         The state of the cluster security group is not <code>available</code>.
     * @throws ClusterSecurityGroupNotFoundException
     *         The cluster security group name does not refer to an existing cluster security group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DeleteClusterSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteClusterSecurityGroupResponse deleteClusterSecurityGroup(
            Consumer<DeleteClusterSecurityGroupRequest.Builder> deleteClusterSecurityGroupRequest)
            throws InvalidClusterSecurityGroupStateException, ClusterSecurityGroupNotFoundException, AwsServiceException,
            SdkClientException, RedshiftException {
        return deleteClusterSecurityGroup(DeleteClusterSecurityGroupRequest.builder()
                .applyMutation(deleteClusterSecurityGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified manual snapshot. The snapshot must be in the <code>available</code> state, with no other
     * users authorized to access the snapshot.
     * </p>
     * <p>
     * Unlike automated snapshots, manual snapshots are retained even after you delete your cluster. Amazon Redshift
     * does not delete your manual snapshots. You must delete manual snapshot explicitly to avoid getting charged. If
     * other accounts are authorized to access the snapshot, you must revoke all of the authorizations before you can
     * delete the snapshot.
     * </p>
     *
     * @param deleteClusterSnapshotRequest
     * @return Result of the DeleteClusterSnapshot operation returned by the service.
     * @throws InvalidClusterSnapshotStateException
     *         The specified cluster snapshot is not in the <code>available</code> state, or other accounts are
     *         authorized to access the snapshot.
     * @throws ClusterSnapshotNotFoundException
     *         The snapshot identifier does not refer to an existing cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DeleteClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteClusterSnapshotResponse deleteClusterSnapshot(DeleteClusterSnapshotRequest deleteClusterSnapshotRequest)
            throws InvalidClusterSnapshotStateException, ClusterSnapshotNotFoundException, AwsServiceException,
            SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified manual snapshot. The snapshot must be in the <code>available</code> state, with no other
     * users authorized to access the snapshot.
     * </p>
     * <p>
     * Unlike automated snapshots, manual snapshots are retained even after you delete your cluster. Amazon Redshift
     * does not delete your manual snapshots. You must delete manual snapshot explicitly to avoid getting charged. If
     * other accounts are authorized to access the snapshot, you must revoke all of the authorizations before you can
     * delete the snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteClusterSnapshotMessage.Builder} to create a
     *        request.
     * @return Result of the DeleteClusterSnapshot operation returned by the service.
     * @throws InvalidClusterSnapshotStateException
     *         The specified cluster snapshot is not in the <code>available</code> state, or other accounts are
     *         authorized to access the snapshot.
     * @throws ClusterSnapshotNotFoundException
     *         The snapshot identifier does not refer to an existing cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DeleteClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteClusterSnapshotResponse deleteClusterSnapshot(
            Consumer<DeleteClusterSnapshotRequest.Builder> deleteClusterSnapshotRequest)
            throws InvalidClusterSnapshotStateException, ClusterSnapshotNotFoundException, AwsServiceException,
            SdkClientException, RedshiftException {
        return deleteClusterSnapshot(DeleteClusterSnapshotRequest.builder().applyMutation(deleteClusterSnapshotRequest).build());
    }

    /**
     * <p>
     * Deletes the specified cluster subnet group.
     * </p>
     *
     * @param deleteClusterSubnetGroupRequest
     * @return Result of the DeleteClusterSubnetGroup operation returned by the service.
     * @throws InvalidClusterSubnetGroupStateException
     *         The cluster subnet group cannot be deleted because it is in use.
     * @throws InvalidClusterSubnetStateException
     *         The state of the subnet is invalid.
     * @throws ClusterSubnetGroupNotFoundException
     *         The cluster subnet group name does not refer to an existing cluster subnet group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DeleteClusterSubnetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteClusterSubnetGroupResponse deleteClusterSubnetGroup(
            DeleteClusterSubnetGroupRequest deleteClusterSubnetGroupRequest) throws InvalidClusterSubnetGroupStateException,
            InvalidClusterSubnetStateException, ClusterSubnetGroupNotFoundException, AwsServiceException, SdkClientException,
            RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified cluster subnet group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterSubnetGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteClusterSubnetGroupRequest#builder()}
     * </p>
     *
     * @param deleteClusterSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteClusterSubnetGroupMessage.Builder} to create a
     *        request.
     * @return Result of the DeleteClusterSubnetGroup operation returned by the service.
     * @throws InvalidClusterSubnetGroupStateException
     *         The cluster subnet group cannot be deleted because it is in use.
     * @throws InvalidClusterSubnetStateException
     *         The state of the subnet is invalid.
     * @throws ClusterSubnetGroupNotFoundException
     *         The cluster subnet group name does not refer to an existing cluster subnet group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DeleteClusterSubnetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteClusterSubnetGroupResponse deleteClusterSubnetGroup(
            Consumer<DeleteClusterSubnetGroupRequest.Builder> deleteClusterSubnetGroupRequest)
            throws InvalidClusterSubnetGroupStateException, InvalidClusterSubnetStateException,
            ClusterSubnetGroupNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        return deleteClusterSubnetGroup(DeleteClusterSubnetGroupRequest.builder().applyMutation(deleteClusterSubnetGroupRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an Amazon Redshift event notification subscription.
     * </p>
     *
     * @param deleteEventSubscriptionRequest
     * @return Result of the DeleteEventSubscription operation returned by the service.
     * @throws SubscriptionNotFoundException
     *         An Amazon Redshift event notification subscription with the specified name does not exist.
     * @throws InvalidSubscriptionStateException
     *         The subscription request is invalid because it is a duplicate request. This subscription request is
     *         already in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DeleteEventSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEventSubscriptionResponse deleteEventSubscription(DeleteEventSubscriptionRequest deleteEventSubscriptionRequest)
            throws SubscriptionNotFoundException, InvalidSubscriptionStateException, AwsServiceException, SdkClientException,
            RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Redshift event notification subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEventSubscriptionRequest#builder()}
     * </p>
     *
     * @param deleteEventSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEventSubscriptionMessage.Builder} to create a
     *        request.
     * @return Result of the DeleteEventSubscription operation returned by the service.
     * @throws SubscriptionNotFoundException
     *         An Amazon Redshift event notification subscription with the specified name does not exist.
     * @throws InvalidSubscriptionStateException
     *         The subscription request is invalid because it is a duplicate request. This subscription request is
     *         already in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DeleteEventSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEventSubscriptionResponse deleteEventSubscription(
            Consumer<DeleteEventSubscriptionRequest.Builder> deleteEventSubscriptionRequest)
            throws SubscriptionNotFoundException, InvalidSubscriptionStateException, AwsServiceException, SdkClientException,
            RedshiftException {
        return deleteEventSubscription(DeleteEventSubscriptionRequest.builder().applyMutation(deleteEventSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified HSM client certificate.
     * </p>
     *
     * @param deleteHsmClientCertificateRequest
     * @return Result of the DeleteHsmClientCertificate operation returned by the service.
     * @throws InvalidHsmClientCertificateStateException
     *         The specified HSM client certificate is not in the <code>available</code> state, or it is still in use by
     *         one or more Amazon Redshift clusters.
     * @throws HsmClientCertificateNotFoundException
     *         There is no Amazon Redshift HSM client certificate with the specified identifier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DeleteHsmClientCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteHsmClientCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteHsmClientCertificateResponse deleteHsmClientCertificate(
            DeleteHsmClientCertificateRequest deleteHsmClientCertificateRequest)
            throws InvalidHsmClientCertificateStateException, HsmClientCertificateNotFoundException, AwsServiceException,
            SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified HSM client certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHsmClientCertificateRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteHsmClientCertificateRequest#builder()}
     * </p>
     *
     * @param deleteHsmClientCertificateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteHsmClientCertificateMessage.Builder} to create a
     *        request.
     * @return Result of the DeleteHsmClientCertificate operation returned by the service.
     * @throws InvalidHsmClientCertificateStateException
     *         The specified HSM client certificate is not in the <code>available</code> state, or it is still in use by
     *         one or more Amazon Redshift clusters.
     * @throws HsmClientCertificateNotFoundException
     *         There is no Amazon Redshift HSM client certificate with the specified identifier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DeleteHsmClientCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteHsmClientCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteHsmClientCertificateResponse deleteHsmClientCertificate(
            Consumer<DeleteHsmClientCertificateRequest.Builder> deleteHsmClientCertificateRequest)
            throws InvalidHsmClientCertificateStateException, HsmClientCertificateNotFoundException, AwsServiceException,
            SdkClientException, RedshiftException {
        return deleteHsmClientCertificate(DeleteHsmClientCertificateRequest.builder()
                .applyMutation(deleteHsmClientCertificateRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Amazon Redshift HSM configuration.
     * </p>
     *
     * @param deleteHsmConfigurationRequest
     * @return Result of the DeleteHsmConfiguration operation returned by the service.
     * @throws InvalidHsmConfigurationStateException
     *         The specified HSM configuration is not in the <code>available</code> state, or it is still in use by one
     *         or more Amazon Redshift clusters.
     * @throws HsmConfigurationNotFoundException
     *         There is no Amazon Redshift HSM configuration with the specified identifier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DeleteHsmConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteHsmConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteHsmConfigurationResponse deleteHsmConfiguration(DeleteHsmConfigurationRequest deleteHsmConfigurationRequest)
            throws InvalidHsmConfigurationStateException, HsmConfigurationNotFoundException, AwsServiceException,
            SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Amazon Redshift HSM configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHsmConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteHsmConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteHsmConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteHsmConfigurationMessage.Builder} to create a
     *        request.
     * @return Result of the DeleteHsmConfiguration operation returned by the service.
     * @throws InvalidHsmConfigurationStateException
     *         The specified HSM configuration is not in the <code>available</code> state, or it is still in use by one
     *         or more Amazon Redshift clusters.
     * @throws HsmConfigurationNotFoundException
     *         There is no Amazon Redshift HSM configuration with the specified identifier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DeleteHsmConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteHsmConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteHsmConfigurationResponse deleteHsmConfiguration(
            Consumer<DeleteHsmConfigurationRequest.Builder> deleteHsmConfigurationRequest)
            throws InvalidHsmConfigurationStateException, HsmConfigurationNotFoundException, AwsServiceException,
            SdkClientException, RedshiftException {
        return deleteHsmConfiguration(DeleteHsmConfigurationRequest.builder().applyMutation(deleteHsmConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified snapshot copy grant.
     * </p>
     *
     * @param deleteSnapshotCopyGrantRequest
     *        The result of the <code>DeleteSnapshotCopyGrant</code> action.
     * @return Result of the DeleteSnapshotCopyGrant operation returned by the service.
     * @throws InvalidSnapshotCopyGrantStateException
     *         The snapshot copy grant can't be deleted because it is used by one or more clusters.
     * @throws SnapshotCopyGrantNotFoundException
     *         The specified snapshot copy grant can't be found. Make sure that the name is typed correctly and that the
     *         grant exists in the destination region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DeleteSnapshotCopyGrant
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteSnapshotCopyGrant"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSnapshotCopyGrantResponse deleteSnapshotCopyGrant(DeleteSnapshotCopyGrantRequest deleteSnapshotCopyGrantRequest)
            throws InvalidSnapshotCopyGrantStateException, SnapshotCopyGrantNotFoundException, AwsServiceException,
            SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified snapshot copy grant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSnapshotCopyGrantRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSnapshotCopyGrantRequest#builder()}
     * </p>
     *
     * @param deleteSnapshotCopyGrantRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSnapshotCopyGrantMessage.Builder} to create a
     *        request. The result of the <code>DeleteSnapshotCopyGrant</code> action.
     * @return Result of the DeleteSnapshotCopyGrant operation returned by the service.
     * @throws InvalidSnapshotCopyGrantStateException
     *         The snapshot copy grant can't be deleted because it is used by one or more clusters.
     * @throws SnapshotCopyGrantNotFoundException
     *         The specified snapshot copy grant can't be found. Make sure that the name is typed correctly and that the
     *         grant exists in the destination region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DeleteSnapshotCopyGrant
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteSnapshotCopyGrant"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSnapshotCopyGrantResponse deleteSnapshotCopyGrant(
            Consumer<DeleteSnapshotCopyGrantRequest.Builder> deleteSnapshotCopyGrantRequest)
            throws InvalidSnapshotCopyGrantStateException, SnapshotCopyGrantNotFoundException, AwsServiceException,
            SdkClientException, RedshiftException {
        return deleteSnapshotCopyGrant(DeleteSnapshotCopyGrantRequest.builder().applyMutation(deleteSnapshotCopyGrantRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a snapshot schedule.
     * </p>
     *
     * @param deleteSnapshotScheduleRequest
     * @return Result of the DeleteSnapshotSchedule operation returned by the service.
     * @throws InvalidClusterSnapshotScheduleStateException
     *         The cluster snapshot schedule state is not valid.
     * @throws SnapshotScheduleNotFoundException
     *         We could not find the specified snapshot schedule.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DeleteSnapshotSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteSnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSnapshotScheduleResponse deleteSnapshotSchedule(DeleteSnapshotScheduleRequest deleteSnapshotScheduleRequest)
            throws InvalidClusterSnapshotScheduleStateException, SnapshotScheduleNotFoundException, AwsServiceException,
            SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a snapshot schedule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSnapshotScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSnapshotScheduleRequest#builder()}
     * </p>
     *
     * @param deleteSnapshotScheduleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSnapshotScheduleMessage.Builder} to create a
     *        request.
     * @return Result of the DeleteSnapshotSchedule operation returned by the service.
     * @throws InvalidClusterSnapshotScheduleStateException
     *         The cluster snapshot schedule state is not valid.
     * @throws SnapshotScheduleNotFoundException
     *         We could not find the specified snapshot schedule.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DeleteSnapshotSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteSnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSnapshotScheduleResponse deleteSnapshotSchedule(
            Consumer<DeleteSnapshotScheduleRequest.Builder> deleteSnapshotScheduleRequest)
            throws InvalidClusterSnapshotScheduleStateException, SnapshotScheduleNotFoundException, AwsServiceException,
            SdkClientException, RedshiftException {
        return deleteSnapshotSchedule(DeleteSnapshotScheduleRequest.builder().applyMutation(deleteSnapshotScheduleRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a tag or tags from a resource. You must provide the ARN of the resource from which you want to delete the
     * tag or tags.
     * </p>
     *
     * @param deleteTagsRequest
     *        Contains the output from the <code>DeleteTags</code> action.
     * @return Result of the DeleteTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DeleteTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws ResourceNotFoundException,
            InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a tag or tags from a resource. You must provide the ARN of the resource from which you want to delete the
     * tag or tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTagsRequest#builder()}
     * </p>
     *
     * @param deleteTagsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTagsMessage.Builder} to create a request.
     *        Contains the output from the <code>DeleteTags</code> action.
     * @return Result of the DeleteTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DeleteTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTagsResponse deleteTags(Consumer<DeleteTagsRequest.Builder> deleteTagsRequest)
            throws ResourceNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return deleteTags(DeleteTagsRequest.builder().applyMutation(deleteTagsRequest).build());
    }

    /**
     * <p>
     * Returns a list of attributes attached to an account
     * </p>
     *
     * @return Result of the DescribeAccountAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeAccountAttributes
     * @see #describeAccountAttributes(DescribeAccountAttributesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountAttributesResponse describeAccountAttributes() throws AwsServiceException, SdkClientException,
            RedshiftException {
        return describeAccountAttributes(DescribeAccountAttributesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of attributes attached to an account
     * </p>
     *
     * @param describeAccountAttributesRequest
     * @return Result of the DescribeAccountAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeAccountAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountAttributesResponse describeAccountAttributes(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) throws AwsServiceException, SdkClientException,
            RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of attributes attached to an account
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAccountAttributesRequest#builder()}
     * </p>
     *
     * @param describeAccountAttributesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAccountAttributesMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeAccountAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeAccountAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountAttributesResponse describeAccountAttributes(
            Consumer<DescribeAccountAttributesRequest.Builder> describeAccountAttributesRequest) throws AwsServiceException,
            SdkClientException, RedshiftException {
        return describeAccountAttributes(DescribeAccountAttributesRequest.builder()
                .applyMutation(describeAccountAttributesRequest).build());
    }

    /**
     * <p>
     * Returns an array of <code>ClusterDbRevision</code> objects.
     * </p>
     *
     * @return Result of the DescribeClusterDbRevisions operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterDbRevisions
     * @see #describeClusterDbRevisions(DescribeClusterDbRevisionsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterDbRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterDbRevisionsResponse describeClusterDbRevisions() throws ClusterNotFoundException,
            InvalidClusterStateException, AwsServiceException, SdkClientException, RedshiftException {
        return describeClusterDbRevisions(DescribeClusterDbRevisionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns an array of <code>ClusterDbRevision</code> objects.
     * </p>
     *
     * @param describeClusterDbRevisionsRequest
     * @return Result of the DescribeClusterDbRevisions operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterDbRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterDbRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterDbRevisionsResponse describeClusterDbRevisions(
            DescribeClusterDbRevisionsRequest describeClusterDbRevisionsRequest) throws ClusterNotFoundException,
            InvalidClusterStateException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of <code>ClusterDbRevision</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterDbRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeClusterDbRevisionsRequest#builder()}
     * </p>
     *
     * @param describeClusterDbRevisionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterDbRevisionsMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeClusterDbRevisions operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterDbRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterDbRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterDbRevisionsResponse describeClusterDbRevisions(
            Consumer<DescribeClusterDbRevisionsRequest.Builder> describeClusterDbRevisionsRequest)
            throws ClusterNotFoundException, InvalidClusterStateException, AwsServiceException, SdkClientException,
            RedshiftException {
        return describeClusterDbRevisions(DescribeClusterDbRevisionsRequest.builder()
                .applyMutation(describeClusterDbRevisionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Amazon Redshift parameter groups, including parameter groups you created and the default
     * parameter group. For each parameter group, the response includes the parameter group name, description, and
     * parameter group family name. You can optionally specify a name to retrieve the description of a specific
     * parameter group.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all parameter groups
     * that match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all parameter
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, parameter groups are returned regardless of whether
     * they have tag keys or values associated with them.
     * </p>
     *
     * @return Result of the DescribeClusterParameterGroups operation returned by the service.
     * @throws ClusterParameterGroupNotFoundException
     *         The parameter group name does not refer to an existing parameter group.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterParameterGroups
     * @see #describeClusterParameterGroups(DescribeClusterParameterGroupsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterParameterGroupsResponse describeClusterParameterGroups()
            throws ClusterParameterGroupNotFoundException, InvalidTagException, AwsServiceException, SdkClientException,
            RedshiftException {
        return describeClusterParameterGroups(DescribeClusterParameterGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of Amazon Redshift parameter groups, including parameter groups you created and the default
     * parameter group. For each parameter group, the response includes the parameter group name, description, and
     * parameter group family name. You can optionally specify a name to retrieve the description of a specific
     * parameter group.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all parameter groups
     * that match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all parameter
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, parameter groups are returned regardless of whether
     * they have tag keys or values associated with them.
     * </p>
     *
     * @param describeClusterParameterGroupsRequest
     * @return Result of the DescribeClusterParameterGroups operation returned by the service.
     * @throws ClusterParameterGroupNotFoundException
     *         The parameter group name does not refer to an existing parameter group.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterParameterGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterParameterGroupsResponse describeClusterParameterGroups(
            DescribeClusterParameterGroupsRequest describeClusterParameterGroupsRequest)
            throws ClusterParameterGroupNotFoundException, InvalidTagException, AwsServiceException, SdkClientException,
            RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Amazon Redshift parameter groups, including parameter groups you created and the default
     * parameter group. For each parameter group, the response includes the parameter group name, description, and
     * parameter group family name. You can optionally specify a name to retrieve the description of a specific
     * parameter group.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all parameter groups
     * that match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all parameter
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, parameter groups are returned regardless of whether
     * they have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterParameterGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeClusterParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeClusterParameterGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterParameterGroupsMessage.Builder} to
     *        create a request.
     * @return Result of the DescribeClusterParameterGroups operation returned by the service.
     * @throws ClusterParameterGroupNotFoundException
     *         The parameter group name does not refer to an existing parameter group.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterParameterGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterParameterGroupsResponse describeClusterParameterGroups(
            Consumer<DescribeClusterParameterGroupsRequest.Builder> describeClusterParameterGroupsRequest)
            throws ClusterParameterGroupNotFoundException, InvalidTagException, AwsServiceException, SdkClientException,
            RedshiftException {
        return describeClusterParameterGroups(DescribeClusterParameterGroupsRequest.builder()
                .applyMutation(describeClusterParameterGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Amazon Redshift parameter groups, including parameter groups you created and the default
     * parameter group. For each parameter group, the response includes the parameter group name, description, and
     * parameter group family name. You can optionally specify a name to retrieve the description of a specific
     * parameter group.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all parameter groups
     * that match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all parameter
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, parameter groups are returned regardless of whether
     * they have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterParameterGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterParameterGroupsIterable responses = client.describeClusterParameterGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeClusterParameterGroupsIterable responses = client
     *             .describeClusterParameterGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterParameterGroupsIterable responses = client.describeClusterParameterGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterParameterGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ClusterParameterGroupNotFoundException
     *         The parameter group name does not refer to an existing parameter group.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterParameterGroups
     * @see #describeClusterParameterGroupsPaginator(DescribeClusterParameterGroupsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterParameterGroupsIterable describeClusterParameterGroupsPaginator()
            throws ClusterParameterGroupNotFoundException, InvalidTagException, AwsServiceException, SdkClientException,
            RedshiftException {
        return describeClusterParameterGroupsPaginator(DescribeClusterParameterGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of Amazon Redshift parameter groups, including parameter groups you created and the default
     * parameter group. For each parameter group, the response includes the parameter group name, description, and
     * parameter group family name. You can optionally specify a name to retrieve the description of a specific
     * parameter group.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all parameter groups
     * that match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all parameter
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, parameter groups are returned regardless of whether
     * they have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterParameterGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterParameterGroupsIterable responses = client.describeClusterParameterGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeClusterParameterGroupsIterable responses = client
     *             .describeClusterParameterGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterParameterGroupsIterable responses = client.describeClusterParameterGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterParameterGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeClusterParameterGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ClusterParameterGroupNotFoundException
     *         The parameter group name does not refer to an existing parameter group.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterParameterGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterParameterGroupsIterable describeClusterParameterGroupsPaginator(
            DescribeClusterParameterGroupsRequest describeClusterParameterGroupsRequest)
            throws ClusterParameterGroupNotFoundException, InvalidTagException, AwsServiceException, SdkClientException,
            RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Amazon Redshift parameter groups, including parameter groups you created and the default
     * parameter group. For each parameter group, the response includes the parameter group name, description, and
     * parameter group family name. You can optionally specify a name to retrieve the description of a specific
     * parameter group.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all parameter groups
     * that match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all parameter
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, parameter groups are returned regardless of whether
     * they have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterParameterGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterParameterGroupsIterable responses = client.describeClusterParameterGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeClusterParameterGroupsIterable responses = client
     *             .describeClusterParameterGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterParameterGroupsIterable responses = client.describeClusterParameterGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterParameterGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterParameterGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeClusterParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeClusterParameterGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterParameterGroupsMessage.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ClusterParameterGroupNotFoundException
     *         The parameter group name does not refer to an existing parameter group.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterParameterGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterParameterGroupsIterable describeClusterParameterGroupsPaginator(
            Consumer<DescribeClusterParameterGroupsRequest.Builder> describeClusterParameterGroupsRequest)
            throws ClusterParameterGroupNotFoundException, InvalidTagException, AwsServiceException, SdkClientException,
            RedshiftException {
        return describeClusterParameterGroupsPaginator(DescribeClusterParameterGroupsRequest.builder()
                .applyMutation(describeClusterParameterGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a detailed list of parameters contained within the specified Amazon Redshift parameter group. For each
     * parameter the response includes information such as parameter name, description, data type, value, whether the
     * parameter value is modifiable, and so on.
     * </p>
     * <p>
     * You can specify <i>source</i> filter to retrieve parameters of only specific type. For example, to retrieve
     * parameters that were modified by a user action such as from <a>ModifyClusterParameterGroup</a>, you can specify
     * <i>source</i> equal to <i>user</i>.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param describeClusterParametersRequest
     * @return Result of the DescribeClusterParameters operation returned by the service.
     * @throws ClusterParameterGroupNotFoundException
     *         The parameter group name does not refer to an existing parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterParametersResponse describeClusterParameters(
            DescribeClusterParametersRequest describeClusterParametersRequest) throws ClusterParameterGroupNotFoundException,
            AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a detailed list of parameters contained within the specified Amazon Redshift parameter group. For each
     * parameter the response includes information such as parameter name, description, data type, value, whether the
     * parameter value is modifiable, and so on.
     * </p>
     * <p>
     * You can specify <i>source</i> filter to retrieve parameters of only specific type. For example, to retrieve
     * parameters that were modified by a user action such as from <a>ModifyClusterParameterGroup</a>, you can specify
     * <i>source</i> equal to <i>user</i>.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterParametersRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeClusterParametersRequest#builder()}
     * </p>
     *
     * @param describeClusterParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterParametersMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeClusterParameters operation returned by the service.
     * @throws ClusterParameterGroupNotFoundException
     *         The parameter group name does not refer to an existing parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterParametersResponse describeClusterParameters(
            Consumer<DescribeClusterParametersRequest.Builder> describeClusterParametersRequest)
            throws ClusterParameterGroupNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        return describeClusterParameters(DescribeClusterParametersRequest.builder()
                .applyMutation(describeClusterParametersRequest).build());
    }

    /**
     * <p>
     * Returns a detailed list of parameters contained within the specified Amazon Redshift parameter group. For each
     * parameter the response includes information such as parameter name, description, data type, value, whether the
     * parameter value is modifiable, and so on.
     * </p>
     * <p>
     * You can specify <i>source</i> filter to retrieve parameters of only specific type. For example, to retrieve
     * parameters that were modified by a user action such as from <a>ModifyClusterParameterGroup</a>, you can specify
     * <i>source</i> equal to <i>user</i>.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterParameters(software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterParametersIterable responses = client.describeClusterParametersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeClusterParametersIterable responses = client
     *             .describeClusterParametersPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeClusterParametersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterParametersIterable responses = client.describeClusterParametersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterParameters(software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeClusterParametersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ClusterParameterGroupNotFoundException
     *         The parameter group name does not refer to an existing parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterParametersIterable describeClusterParametersPaginator(
            DescribeClusterParametersRequest describeClusterParametersRequest) throws ClusterParameterGroupNotFoundException,
            AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a detailed list of parameters contained within the specified Amazon Redshift parameter group. For each
     * parameter the response includes information such as parameter name, description, data type, value, whether the
     * parameter value is modifiable, and so on.
     * </p>
     * <p>
     * You can specify <i>source</i> filter to retrieve parameters of only specific type. For example, to retrieve
     * parameters that were modified by a user action such as from <a>ModifyClusterParameterGroup</a>, you can specify
     * <i>source</i> equal to <i>user</i>.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterParameters(software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterParametersIterable responses = client.describeClusterParametersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeClusterParametersIterable responses = client
     *             .describeClusterParametersPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeClusterParametersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterParametersIterable responses = client.describeClusterParametersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterParameters(software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterParametersRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeClusterParametersRequest#builder()}
     * </p>
     *
     * @param describeClusterParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterParametersMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ClusterParameterGroupNotFoundException
     *         The parameter group name does not refer to an existing parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterParametersIterable describeClusterParametersPaginator(
            Consumer<DescribeClusterParametersRequest.Builder> describeClusterParametersRequest)
            throws ClusterParameterGroupNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        return describeClusterParametersPaginator(DescribeClusterParametersRequest.builder()
                .applyMutation(describeClusterParametersRequest).build());
    }

    /**
     * <p>
     * Returns information about Amazon Redshift security groups. If the name of a security group is specified, the
     * response will contain only information about only that security group.
     * </p>
     * <p>
     * For information about managing security groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster
     * Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all security groups that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all security
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, security groups are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     *
     * @param describeClusterSecurityGroupsRequest
     * @return Result of the DescribeClusterSecurityGroups operation returned by the service.
     * @throws ClusterSecurityGroupNotFoundException
     *         The cluster security group name does not refer to an existing cluster security group.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterSecurityGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSecurityGroupsResponse describeClusterSecurityGroups(
            DescribeClusterSecurityGroupsRequest describeClusterSecurityGroupsRequest)
            throws ClusterSecurityGroupNotFoundException, InvalidTagException, AwsServiceException, SdkClientException,
            RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about Amazon Redshift security groups. If the name of a security group is specified, the
     * response will contain only information about only that security group.
     * </p>
     * <p>
     * For information about managing security groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster
     * Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all security groups that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all security
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, security groups are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterSecurityGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeClusterSecurityGroupsRequest#builder()}
     * </p>
     *
     * @param describeClusterSecurityGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterSecurityGroupsMessage.Builder} to
     *        create a request.
     * @return Result of the DescribeClusterSecurityGroups operation returned by the service.
     * @throws ClusterSecurityGroupNotFoundException
     *         The cluster security group name does not refer to an existing cluster security group.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterSecurityGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSecurityGroupsResponse describeClusterSecurityGroups(
            Consumer<DescribeClusterSecurityGroupsRequest.Builder> describeClusterSecurityGroupsRequest)
            throws ClusterSecurityGroupNotFoundException, InvalidTagException, AwsServiceException, SdkClientException,
            RedshiftException {
        return describeClusterSecurityGroups(DescribeClusterSecurityGroupsRequest.builder()
                .applyMutation(describeClusterSecurityGroupsRequest).build());
    }

    /**
     * <p>
     * Returns information about Amazon Redshift security groups. If the name of a security group is specified, the
     * response will contain only information about only that security group.
     * </p>
     * <p>
     * For information about managing security groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster
     * Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all security groups that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all security
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, security groups are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterSecurityGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSecurityGroupsIterable responses = client.describeClusterSecurityGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeClusterSecurityGroupsIterable responses = client
     *             .describeClusterSecurityGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSecurityGroupsIterable responses = client.describeClusterSecurityGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterSecurityGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeClusterSecurityGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ClusterSecurityGroupNotFoundException
     *         The cluster security group name does not refer to an existing cluster security group.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterSecurityGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSecurityGroupsIterable describeClusterSecurityGroupsPaginator(
            DescribeClusterSecurityGroupsRequest describeClusterSecurityGroupsRequest)
            throws ClusterSecurityGroupNotFoundException, InvalidTagException, AwsServiceException, SdkClientException,
            RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about Amazon Redshift security groups. If the name of a security group is specified, the
     * response will contain only information about only that security group.
     * </p>
     * <p>
     * For information about managing security groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster
     * Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all security groups that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all security
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, security groups are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterSecurityGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSecurityGroupsIterable responses = client.describeClusterSecurityGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeClusterSecurityGroupsIterable responses = client
     *             .describeClusterSecurityGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSecurityGroupsIterable responses = client.describeClusterSecurityGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterSecurityGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterSecurityGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeClusterSecurityGroupsRequest#builder()}
     * </p>
     *
     * @param describeClusterSecurityGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterSecurityGroupsMessage.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ClusterSecurityGroupNotFoundException
     *         The cluster security group name does not refer to an existing cluster security group.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterSecurityGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSecurityGroupsIterable describeClusterSecurityGroupsPaginator(
            Consumer<DescribeClusterSecurityGroupsRequest.Builder> describeClusterSecurityGroupsRequest)
            throws ClusterSecurityGroupNotFoundException, InvalidTagException, AwsServiceException, SdkClientException,
            RedshiftException {
        return describeClusterSecurityGroupsPaginator(DescribeClusterSecurityGroupsRequest.builder()
                .applyMutation(describeClusterSecurityGroupsRequest).build());
    }

    /**
     * <p>
     * Returns one or more snapshot objects, which contain metadata about your cluster snapshots. By default, this
     * operation returns information about all snapshots of all clusters that are owned by you AWS customer account. No
     * information is returned for snapshots owned by inactive AWS customer accounts.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all snapshots that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all snapshots
     * that have any combination of those values are returned. Only snapshots that you own are returned in the response;
     * shared snapshots are not returned with the tag key and tag value request parameters.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, snapshots are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     *
     * @return Result of the DescribeClusterSnapshots operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws ClusterSnapshotNotFoundException
     *         The snapshot identifier does not refer to an existing cluster snapshot.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterSnapshots
     * @see #describeClusterSnapshots(DescribeClusterSnapshotsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSnapshotsResponse describeClusterSnapshots() throws ClusterNotFoundException,
            ClusterSnapshotNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return describeClusterSnapshots(DescribeClusterSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns one or more snapshot objects, which contain metadata about your cluster snapshots. By default, this
     * operation returns information about all snapshots of all clusters that are owned by you AWS customer account. No
     * information is returned for snapshots owned by inactive AWS customer accounts.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all snapshots that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all snapshots
     * that have any combination of those values are returned. Only snapshots that you own are returned in the response;
     * shared snapshots are not returned with the tag key and tag value request parameters.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, snapshots are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     *
     * @param describeClusterSnapshotsRequest
     * @return Result of the DescribeClusterSnapshots operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws ClusterSnapshotNotFoundException
     *         The snapshot identifier does not refer to an existing cluster snapshot.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSnapshotsResponse describeClusterSnapshots(
            DescribeClusterSnapshotsRequest describeClusterSnapshotsRequest) throws ClusterNotFoundException,
            ClusterSnapshotNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns one or more snapshot objects, which contain metadata about your cluster snapshots. By default, this
     * operation returns information about all snapshots of all clusters that are owned by you AWS customer account. No
     * information is returned for snapshots owned by inactive AWS customer accounts.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all snapshots that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all snapshots
     * that have any combination of those values are returned. Only snapshots that you own are returned in the response;
     * shared snapshots are not returned with the tag key and tag value request parameters.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, snapshots are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterSnapshotsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeClusterSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeClusterSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterSnapshotsMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeClusterSnapshots operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws ClusterSnapshotNotFoundException
     *         The snapshot identifier does not refer to an existing cluster snapshot.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSnapshotsResponse describeClusterSnapshots(
            Consumer<DescribeClusterSnapshotsRequest.Builder> describeClusterSnapshotsRequest) throws ClusterNotFoundException,
            ClusterSnapshotNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return describeClusterSnapshots(DescribeClusterSnapshotsRequest.builder().applyMutation(describeClusterSnapshotsRequest)
                .build());
    }

    /**
     * <p>
     * Returns one or more snapshot objects, which contain metadata about your cluster snapshots. By default, this
     * operation returns information about all snapshots of all clusters that are owned by you AWS customer account. No
     * information is returned for snapshots owned by inactive AWS customer accounts.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all snapshots that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all snapshots
     * that have any combination of those values are returned. Only snapshots that you own are returned in the response;
     * shared snapshots are not returned with the tag key and tag value request parameters.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, snapshots are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterSnapshots(software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSnapshotsIterable responses = client.describeClusterSnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeClusterSnapshotsIterable responses = client
     *             .describeClusterSnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSnapshotsIterable responses = client.describeClusterSnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterSnapshots(software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws ClusterSnapshotNotFoundException
     *         The snapshot identifier does not refer to an existing cluster snapshot.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterSnapshots
     * @see #describeClusterSnapshotsPaginator(DescribeClusterSnapshotsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSnapshotsIterable describeClusterSnapshotsPaginator() throws ClusterNotFoundException,
            ClusterSnapshotNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return describeClusterSnapshotsPaginator(DescribeClusterSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns one or more snapshot objects, which contain metadata about your cluster snapshots. By default, this
     * operation returns information about all snapshots of all clusters that are owned by you AWS customer account. No
     * information is returned for snapshots owned by inactive AWS customer accounts.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all snapshots that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all snapshots
     * that have any combination of those values are returned. Only snapshots that you own are returned in the response;
     * shared snapshots are not returned with the tag key and tag value request parameters.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, snapshots are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterSnapshots(software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSnapshotsIterable responses = client.describeClusterSnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeClusterSnapshotsIterable responses = client
     *             .describeClusterSnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSnapshotsIterable responses = client.describeClusterSnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterSnapshots(software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeClusterSnapshotsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws ClusterSnapshotNotFoundException
     *         The snapshot identifier does not refer to an existing cluster snapshot.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSnapshotsIterable describeClusterSnapshotsPaginator(
            DescribeClusterSnapshotsRequest describeClusterSnapshotsRequest) throws ClusterNotFoundException,
            ClusterSnapshotNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns one or more snapshot objects, which contain metadata about your cluster snapshots. By default, this
     * operation returns information about all snapshots of all clusters that are owned by you AWS customer account. No
     * information is returned for snapshots owned by inactive AWS customer accounts.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all snapshots that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all snapshots
     * that have any combination of those values are returned. Only snapshots that you own are returned in the response;
     * shared snapshots are not returned with the tag key and tag value request parameters.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, snapshots are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterSnapshots(software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSnapshotsIterable responses = client.describeClusterSnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeClusterSnapshotsIterable responses = client
     *             .describeClusterSnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSnapshotsIterable responses = client.describeClusterSnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterSnapshots(software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterSnapshotsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeClusterSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeClusterSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterSnapshotsMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws ClusterSnapshotNotFoundException
     *         The snapshot identifier does not refer to an existing cluster snapshot.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSnapshotsIterable describeClusterSnapshotsPaginator(
            Consumer<DescribeClusterSnapshotsRequest.Builder> describeClusterSnapshotsRequest) throws ClusterNotFoundException,
            ClusterSnapshotNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return describeClusterSnapshotsPaginator(DescribeClusterSnapshotsRequest.builder()
                .applyMutation(describeClusterSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns one or more cluster subnet group objects, which contain metadata about your cluster subnet groups. By
     * default, this operation returns information about all cluster subnet groups that are defined in you AWS account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all subnet groups that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all subnet
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subnet groups are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     *
     * @return Result of the DescribeClusterSubnetGroups operation returned by the service.
     * @throws ClusterSubnetGroupNotFoundException
     *         The cluster subnet group name does not refer to an existing cluster subnet group.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterSubnetGroups
     * @see #describeClusterSubnetGroups(DescribeClusterSubnetGroupsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSubnetGroupsResponse describeClusterSubnetGroups() throws ClusterSubnetGroupNotFoundException,
            InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return describeClusterSubnetGroups(DescribeClusterSubnetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns one or more cluster subnet group objects, which contain metadata about your cluster subnet groups. By
     * default, this operation returns information about all cluster subnet groups that are defined in you AWS account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all subnet groups that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all subnet
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subnet groups are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     *
     * @param describeClusterSubnetGroupsRequest
     * @return Result of the DescribeClusterSubnetGroups operation returned by the service.
     * @throws ClusterSubnetGroupNotFoundException
     *         The cluster subnet group name does not refer to an existing cluster subnet group.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterSubnetGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSubnetGroupsResponse describeClusterSubnetGroups(
            DescribeClusterSubnetGroupsRequest describeClusterSubnetGroupsRequest) throws ClusterSubnetGroupNotFoundException,
            InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns one or more cluster subnet group objects, which contain metadata about your cluster subnet groups. By
     * default, this operation returns information about all cluster subnet groups that are defined in you AWS account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all subnet groups that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all subnet
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subnet groups are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterSubnetGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeClusterSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeClusterSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterSubnetGroupsMessage.Builder} to create
     *        a request.
     * @return Result of the DescribeClusterSubnetGroups operation returned by the service.
     * @throws ClusterSubnetGroupNotFoundException
     *         The cluster subnet group name does not refer to an existing cluster subnet group.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterSubnetGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSubnetGroupsResponse describeClusterSubnetGroups(
            Consumer<DescribeClusterSubnetGroupsRequest.Builder> describeClusterSubnetGroupsRequest)
            throws ClusterSubnetGroupNotFoundException, InvalidTagException, AwsServiceException, SdkClientException,
            RedshiftException {
        return describeClusterSubnetGroups(DescribeClusterSubnetGroupsRequest.builder()
                .applyMutation(describeClusterSubnetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns one or more cluster subnet group objects, which contain metadata about your cluster subnet groups. By
     * default, this operation returns information about all cluster subnet groups that are defined in you AWS account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all subnet groups that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all subnet
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subnet groups are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterSubnetGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSubnetGroupsIterable responses = client.describeClusterSubnetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeClusterSubnetGroupsIterable responses = client
     *             .describeClusterSubnetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSubnetGroupsIterable responses = client.describeClusterSubnetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterSubnetGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ClusterSubnetGroupNotFoundException
     *         The cluster subnet group name does not refer to an existing cluster subnet group.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterSubnetGroups
     * @see #describeClusterSubnetGroupsPaginator(DescribeClusterSubnetGroupsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSubnetGroupsIterable describeClusterSubnetGroupsPaginator()
            throws ClusterSubnetGroupNotFoundException, InvalidTagException, AwsServiceException, SdkClientException,
            RedshiftException {
        return describeClusterSubnetGroupsPaginator(DescribeClusterSubnetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns one or more cluster subnet group objects, which contain metadata about your cluster subnet groups. By
     * default, this operation returns information about all cluster subnet groups that are defined in you AWS account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all subnet groups that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all subnet
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subnet groups are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterSubnetGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSubnetGroupsIterable responses = client.describeClusterSubnetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeClusterSubnetGroupsIterable responses = client
     *             .describeClusterSubnetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSubnetGroupsIterable responses = client.describeClusterSubnetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterSubnetGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeClusterSubnetGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ClusterSubnetGroupNotFoundException
     *         The cluster subnet group name does not refer to an existing cluster subnet group.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterSubnetGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSubnetGroupsIterable describeClusterSubnetGroupsPaginator(
            DescribeClusterSubnetGroupsRequest describeClusterSubnetGroupsRequest) throws ClusterSubnetGroupNotFoundException,
            InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns one or more cluster subnet group objects, which contain metadata about your cluster subnet groups. By
     * default, this operation returns information about all cluster subnet groups that are defined in you AWS account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all subnet groups that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all subnet
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subnet groups are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterSubnetGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSubnetGroupsIterable responses = client.describeClusterSubnetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeClusterSubnetGroupsIterable responses = client
     *             .describeClusterSubnetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSubnetGroupsIterable responses = client.describeClusterSubnetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterSubnetGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterSubnetGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeClusterSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeClusterSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterSubnetGroupsMessage.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ClusterSubnetGroupNotFoundException
     *         The cluster subnet group name does not refer to an existing cluster subnet group.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterSubnetGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSubnetGroupsIterable describeClusterSubnetGroupsPaginator(
            Consumer<DescribeClusterSubnetGroupsRequest.Builder> describeClusterSubnetGroupsRequest)
            throws ClusterSubnetGroupNotFoundException, InvalidTagException, AwsServiceException, SdkClientException,
            RedshiftException {
        return describeClusterSubnetGroupsPaginator(DescribeClusterSubnetGroupsRequest.builder()
                .applyMutation(describeClusterSubnetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the available maintenance tracks.
     * </p>
     *
     * @return Result of the DescribeClusterTracks operation returned by the service.
     * @throws InvalidClusterTrackException
     *         The provided cluster track name is not valid.
     * @throws UnauthorizedOperationException
     *         Your account is not authorized to perform the requested operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterTracks
     * @see #describeClusterTracks(DescribeClusterTracksRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterTracks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeClusterTracksResponse describeClusterTracks() throws InvalidClusterTrackException,
            UnauthorizedOperationException, AwsServiceException, SdkClientException, RedshiftException {
        return describeClusterTracks(DescribeClusterTracksRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of all the available maintenance tracks.
     * </p>
     *
     * @param describeClusterTracksRequest
     * @return Result of the DescribeClusterTracks operation returned by the service.
     * @throws InvalidClusterTrackException
     *         The provided cluster track name is not valid.
     * @throws UnauthorizedOperationException
     *         Your account is not authorized to perform the requested operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterTracks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterTracks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeClusterTracksResponse describeClusterTracks(DescribeClusterTracksRequest describeClusterTracksRequest)
            throws InvalidClusterTrackException, UnauthorizedOperationException, AwsServiceException, SdkClientException,
            RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all the available maintenance tracks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterTracksRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeClusterTracksRequest#builder()}
     * </p>
     *
     * @param describeClusterTracksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterTracksMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeClusterTracks operation returned by the service.
     * @throws InvalidClusterTrackException
     *         The provided cluster track name is not valid.
     * @throws UnauthorizedOperationException
     *         Your account is not authorized to perform the requested operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterTracks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterTracks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeClusterTracksResponse describeClusterTracks(
            Consumer<DescribeClusterTracksRequest.Builder> describeClusterTracksRequest) throws InvalidClusterTrackException,
            UnauthorizedOperationException, AwsServiceException, SdkClientException, RedshiftException {
        return describeClusterTracks(DescribeClusterTracksRequest.builder().applyMutation(describeClusterTracksRequest).build());
    }

    /**
     * <p>
     * Returns descriptions of the available Amazon Redshift cluster versions. You can call this operation even before
     * creating any clusters to learn more about the Amazon Redshift versions. For more information about managing
     * clusters, go to <a href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon
     * Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @return Result of the DescribeClusterVersions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterVersions
     * @see #describeClusterVersions(DescribeClusterVersionsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterVersionsResponse describeClusterVersions() throws AwsServiceException, SdkClientException,
            RedshiftException {
        return describeClusterVersions(DescribeClusterVersionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns descriptions of the available Amazon Redshift cluster versions. You can call this operation even before
     * creating any clusters to learn more about the Amazon Redshift versions. For more information about managing
     * clusters, go to <a href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon
     * Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param describeClusterVersionsRequest
     * @return Result of the DescribeClusterVersions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterVersionsResponse describeClusterVersions(DescribeClusterVersionsRequest describeClusterVersionsRequest)
            throws AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns descriptions of the available Amazon Redshift cluster versions. You can call this operation even before
     * creating any clusters to learn more about the Amazon Redshift versions. For more information about managing
     * clusters, go to <a href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon
     * Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeClusterVersionsRequest#builder()}
     * </p>
     *
     * @param describeClusterVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterVersionsMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeClusterVersions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterVersionsResponse describeClusterVersions(
            Consumer<DescribeClusterVersionsRequest.Builder> describeClusterVersionsRequest) throws AwsServiceException,
            SdkClientException, RedshiftException {
        return describeClusterVersions(DescribeClusterVersionsRequest.builder().applyMutation(describeClusterVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns descriptions of the available Amazon Redshift cluster versions. You can call this operation even before
     * creating any clusters to learn more about the Amazon Redshift versions. For more information about managing
     * clusters, go to <a href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon
     * Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterVersions(software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterVersionsIterable responses = client.describeClusterVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeClusterVersionsIterable responses = client
     *             .describeClusterVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterVersionsIterable responses = client.describeClusterVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterVersions(software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterVersions
     * @see #describeClusterVersionsPaginator(DescribeClusterVersionsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterVersionsIterable describeClusterVersionsPaginator() throws AwsServiceException, SdkClientException,
            RedshiftException {
        return describeClusterVersionsPaginator(DescribeClusterVersionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns descriptions of the available Amazon Redshift cluster versions. You can call this operation even before
     * creating any clusters to learn more about the Amazon Redshift versions. For more information about managing
     * clusters, go to <a href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon
     * Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterVersions(software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterVersionsIterable responses = client.describeClusterVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeClusterVersionsIterable responses = client
     *             .describeClusterVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterVersionsIterable responses = client.describeClusterVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterVersions(software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeClusterVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterVersionsIterable describeClusterVersionsPaginator(
            DescribeClusterVersionsRequest describeClusterVersionsRequest) throws AwsServiceException, SdkClientException,
            RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns descriptions of the available Amazon Redshift cluster versions. You can call this operation even before
     * creating any clusters to learn more about the Amazon Redshift versions. For more information about managing
     * clusters, go to <a href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon
     * Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterVersions(software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterVersionsIterable responses = client.describeClusterVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeClusterVersionsIterable responses = client
     *             .describeClusterVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterVersionsIterable responses = client.describeClusterVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterVersions(software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeClusterVersionsRequest#builder()}
     * </p>
     *
     * @param describeClusterVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterVersionsMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusterVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterVersionsIterable describeClusterVersionsPaginator(
            Consumer<DescribeClusterVersionsRequest.Builder> describeClusterVersionsRequest) throws AwsServiceException,
            SdkClientException, RedshiftException {
        return describeClusterVersionsPaginator(DescribeClusterVersionsRequest.builder()
                .applyMutation(describeClusterVersionsRequest).build());
    }

    /**
     * <p>
     * Returns properties of provisioned clusters including general cluster properties, cluster database properties,
     * maintenance and backup properties, and security and access properties. This operation supports pagination. For
     * more information about managing clusters, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in
     * the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all clusters that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all clusters
     * that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, clusters are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     *
     * @return Result of the DescribeClusters operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusters
     * @see #describeClusters(DescribeClustersRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeClustersResponse describeClusters() throws ClusterNotFoundException, InvalidTagException,
            AwsServiceException, SdkClientException, RedshiftException {
        return describeClusters(DescribeClustersRequest.builder().build());
    }

    /**
     * <p>
     * Returns properties of provisioned clusters including general cluster properties, cluster database properties,
     * maintenance and backup properties, and security and access properties. This operation supports pagination. For
     * more information about managing clusters, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in
     * the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all clusters that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all clusters
     * that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, clusters are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     *
     * @param describeClustersRequest
     * @return Result of the DescribeClusters operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeClustersResponse describeClusters(DescribeClustersRequest describeClustersRequest)
            throws ClusterNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns properties of provisioned clusters including general cluster properties, cluster database properties,
     * maintenance and backup properties, and security and access properties. This operation supports pagination. For
     * more information about managing clusters, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in
     * the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all clusters that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all clusters
     * that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, clusters are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClustersRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeClustersRequest#builder()}
     * </p>
     *
     * @param describeClustersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClustersMessage.Builder} to create a request.
     * @return Result of the DescribeClusters operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeClustersResponse describeClusters(Consumer<DescribeClustersRequest.Builder> describeClustersRequest)
            throws ClusterNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return describeClusters(DescribeClustersRequest.builder().applyMutation(describeClustersRequest).build());
    }

    /**
     * <p>
     * Returns properties of provisioned clusters including general cluster properties, cluster database properties,
     * maintenance and backup properties, and security and access properties. This operation supports pagination. For
     * more information about managing clusters, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in
     * the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all clusters that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all clusters
     * that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, clusters are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusters(software.amazon.awssdk.services.redshift.model.DescribeClustersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClustersIterable responses = client.describeClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeClustersIterable responses = client
     *             .describeClustersPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClustersIterable responses = client.describeClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusters(software.amazon.awssdk.services.redshift.model.DescribeClustersRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusters
     * @see #describeClustersPaginator(DescribeClustersRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeClustersIterable describeClustersPaginator() throws ClusterNotFoundException, InvalidTagException,
            AwsServiceException, SdkClientException, RedshiftException {
        return describeClustersPaginator(DescribeClustersRequest.builder().build());
    }

    /**
     * <p>
     * Returns properties of provisioned clusters including general cluster properties, cluster database properties,
     * maintenance and backup properties, and security and access properties. This operation supports pagination. For
     * more information about managing clusters, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in
     * the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all clusters that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all clusters
     * that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, clusters are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusters(software.amazon.awssdk.services.redshift.model.DescribeClustersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClustersIterable responses = client.describeClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeClustersIterable responses = client
     *             .describeClustersPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClustersIterable responses = client.describeClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusters(software.amazon.awssdk.services.redshift.model.DescribeClustersRequest)} operation.</b>
     * </p>
     *
     * @param describeClustersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeClustersIterable describeClustersPaginator(DescribeClustersRequest describeClustersRequest)
            throws ClusterNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns properties of provisioned clusters including general cluster properties, cluster database properties,
     * maintenance and backup properties, and security and access properties. This operation supports pagination. For
     * more information about managing clusters, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in
     * the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all clusters that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all clusters
     * that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, clusters are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusters(software.amazon.awssdk.services.redshift.model.DescribeClustersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClustersIterable responses = client.describeClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeClustersIterable responses = client
     *             .describeClustersPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClustersIterable responses = client.describeClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusters(software.amazon.awssdk.services.redshift.model.DescribeClustersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClustersRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeClustersRequest#builder()}
     * </p>
     *
     * @param describeClustersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClustersMessage.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeClusters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeClustersIterable describeClustersPaginator(Consumer<DescribeClustersRequest.Builder> describeClustersRequest)
            throws ClusterNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return describeClustersPaginator(DescribeClustersRequest.builder().applyMutation(describeClustersRequest).build());
    }

    /**
     * <p>
     * Returns a list of parameter settings for the specified parameter group family.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param describeDefaultClusterParametersRequest
     * @return Result of the DescribeDefaultClusterParameters operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeDefaultClusterParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDefaultClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDefaultClusterParametersResponse describeDefaultClusterParameters(
            DescribeDefaultClusterParametersRequest describeDefaultClusterParametersRequest) throws AwsServiceException,
            SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of parameter settings for the specified parameter group family.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDefaultClusterParametersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDefaultClusterParametersRequest#builder()}
     * </p>
     *
     * @param describeDefaultClusterParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDefaultClusterParametersMessage.Builder} to
     *        create a request.
     * @return Result of the DescribeDefaultClusterParameters operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeDefaultClusterParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDefaultClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDefaultClusterParametersResponse describeDefaultClusterParameters(
            Consumer<DescribeDefaultClusterParametersRequest.Builder> describeDefaultClusterParametersRequest)
            throws AwsServiceException, SdkClientException, RedshiftException {
        return describeDefaultClusterParameters(DescribeDefaultClusterParametersRequest.builder()
                .applyMutation(describeDefaultClusterParametersRequest).build());
    }

    /**
     * <p>
     * Returns a list of parameter settings for the specified parameter group family.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDefaultClusterParameters(software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeDefaultClusterParametersIterable responses = client.describeDefaultClusterParametersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeDefaultClusterParametersIterable responses = client
     *             .describeDefaultClusterParametersPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeDefaultClusterParametersIterable responses = client.describeDefaultClusterParametersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDefaultClusterParameters(software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDefaultClusterParametersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeDefaultClusterParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDefaultClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDefaultClusterParametersIterable describeDefaultClusterParametersPaginator(
            DescribeDefaultClusterParametersRequest describeDefaultClusterParametersRequest) throws AwsServiceException,
            SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of parameter settings for the specified parameter group family.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDefaultClusterParameters(software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeDefaultClusterParametersIterable responses = client.describeDefaultClusterParametersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeDefaultClusterParametersIterable responses = client
     *             .describeDefaultClusterParametersPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeDefaultClusterParametersIterable responses = client.describeDefaultClusterParametersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDefaultClusterParameters(software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDefaultClusterParametersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDefaultClusterParametersRequest#builder()}
     * </p>
     *
     * @param describeDefaultClusterParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDefaultClusterParametersMessage.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeDefaultClusterParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDefaultClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDefaultClusterParametersIterable describeDefaultClusterParametersPaginator(
            Consumer<DescribeDefaultClusterParametersRequest.Builder> describeDefaultClusterParametersRequest)
            throws AwsServiceException, SdkClientException, RedshiftException {
        return describeDefaultClusterParametersPaginator(DescribeDefaultClusterParametersRequest.builder()
                .applyMutation(describeDefaultClusterParametersRequest).build());
    }

    /**
     * <p>
     * Displays a list of event categories for all event source types, or for a specified source type. For a list of the
     * event categories and source types, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html">Amazon Redshift
     * Event Notifications</a>.
     * </p>
     *
     * @return Result of the DescribeEventCategories operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeEventCategories
     * @see #describeEventCategories(DescribeEventCategoriesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventCategoriesResponse describeEventCategories() throws AwsServiceException, SdkClientException,
            RedshiftException {
        return describeEventCategories(DescribeEventCategoriesRequest.builder().build());
    }

    /**
     * <p>
     * Displays a list of event categories for all event source types, or for a specified source type. For a list of the
     * event categories and source types, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html">Amazon Redshift
     * Event Notifications</a>.
     * </p>
     *
     * @param describeEventCategoriesRequest
     * @return Result of the DescribeEventCategories operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeEventCategories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventCategoriesResponse describeEventCategories(DescribeEventCategoriesRequest describeEventCategoriesRequest)
            throws AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays a list of event categories for all event source types, or for a specified source type. For a list of the
     * event categories and source types, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html">Amazon Redshift
     * Event Notifications</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventCategoriesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventCategoriesRequest#builder()}
     * </p>
     *
     * @param describeEventCategoriesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventCategoriesMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeEventCategories operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeEventCategories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventCategoriesResponse describeEventCategories(
            Consumer<DescribeEventCategoriesRequest.Builder> describeEventCategoriesRequest) throws AwsServiceException,
            SdkClientException, RedshiftException {
        return describeEventCategories(DescribeEventCategoriesRequest.builder().applyMutation(describeEventCategoriesRequest)
                .build());
    }

    /**
     * <p>
     * Lists descriptions of all the Amazon Redshift event notification subscriptions for a customer account. If you
     * specify a subscription name, lists the description for that subscription.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all event notification
     * subscriptions that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all subscriptions that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subscriptions are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     *
     * @return Result of the DescribeEventSubscriptions operation returned by the service.
     * @throws SubscriptionNotFoundException
     *         An Amazon Redshift event notification subscription with the specified name does not exist.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeEventSubscriptions
     * @see #describeEventSubscriptions(DescribeEventSubscriptionsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsResponse describeEventSubscriptions() throws SubscriptionNotFoundException,
            InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return describeEventSubscriptions(DescribeEventSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists descriptions of all the Amazon Redshift event notification subscriptions for a customer account. If you
     * specify a subscription name, lists the description for that subscription.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all event notification
     * subscriptions that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all subscriptions that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subscriptions are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     * @return Result of the DescribeEventSubscriptions operation returned by the service.
     * @throws SubscriptionNotFoundException
     *         An Amazon Redshift event notification subscription with the specified name does not exist.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeEventSubscriptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsResponse describeEventSubscriptions(
            DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) throws SubscriptionNotFoundException,
            InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists descriptions of all the Amazon Redshift event notification subscriptions for a customer account. If you
     * specify a subscription name, lists the description for that subscription.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all event notification
     * subscriptions that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all subscriptions that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subscriptions are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventSubscriptionsRequest#builder()}
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventSubscriptionsMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeEventSubscriptions operation returned by the service.
     * @throws SubscriptionNotFoundException
     *         An Amazon Redshift event notification subscription with the specified name does not exist.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeEventSubscriptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsResponse describeEventSubscriptions(
            Consumer<DescribeEventSubscriptionsRequest.Builder> describeEventSubscriptionsRequest)
            throws SubscriptionNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return describeEventSubscriptions(DescribeEventSubscriptionsRequest.builder()
                .applyMutation(describeEventSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Lists descriptions of all the Amazon Redshift event notification subscriptions for a customer account. If you
     * specify a subscription name, lists the description for that subscription.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all event notification
     * subscriptions that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all subscriptions that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subscriptions are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeEventSubscriptionsIterable responses = client
     *             .describeEventSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SubscriptionNotFoundException
     *         An Amazon Redshift event notification subscription with the specified name does not exist.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeEventSubscriptions
     * @see #describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsIterable describeEventSubscriptionsPaginator() throws SubscriptionNotFoundException,
            InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists descriptions of all the Amazon Redshift event notification subscriptions for a customer account. If you
     * specify a subscription name, lists the description for that subscription.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all event notification
     * subscriptions that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all subscriptions that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subscriptions are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeEventSubscriptionsIterable responses = client
     *             .describeEventSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SubscriptionNotFoundException
     *         An Amazon Redshift event notification subscription with the specified name does not exist.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeEventSubscriptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsIterable describeEventSubscriptionsPaginator(
            DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) throws SubscriptionNotFoundException,
            InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists descriptions of all the Amazon Redshift event notification subscriptions for a customer account. If you
     * specify a subscription name, lists the description for that subscription.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all event notification
     * subscriptions that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all subscriptions that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subscriptions are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeEventSubscriptionsIterable responses = client
     *             .describeEventSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventSubscriptionsRequest#builder()}
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventSubscriptionsMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SubscriptionNotFoundException
     *         An Amazon Redshift event notification subscription with the specified name does not exist.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeEventSubscriptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsIterable describeEventSubscriptionsPaginator(
            Consumer<DescribeEventSubscriptionsRequest.Builder> describeEventSubscriptionsRequest)
            throws SubscriptionNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest.builder()
                .applyMutation(describeEventSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Returns events related to clusters, security groups, snapshots, and parameter groups for the past 14 days. Events
     * specific to a particular cluster, security group, snapshot or parameter group can be obtained by providing the
     * name as a parameter. By default, the past hour of events are returned.
     * </p>
     *
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeEvents
     * @see #describeEvents(DescribeEventsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsResponse describeEvents() throws AwsServiceException, SdkClientException, RedshiftException {
        return describeEvents(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * Returns events related to clusters, security groups, snapshots, and parameter groups for the past 14 days. Events
     * specific to a particular cluster, security group, snapshot or parameter group can be obtained by providing the
     * name as a parameter. By default, the past hour of events are returned.
     * </p>
     *
     * @param describeEventsRequest
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws AwsServiceException,
            SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns events related to clusters, security groups, snapshots, and parameter groups for the past 14 days. Events
     * specific to a particular cluster, security group, snapshot or parameter group can be obtained by providing the
     * name as a parameter. By default, the past hour of events are returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsMessage.Builder} to create a request.
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsResponse describeEvents(Consumer<DescribeEventsRequest.Builder> describeEventsRequest)
            throws AwsServiceException, SdkClientException, RedshiftException {
        return describeEvents(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns events related to clusters, security groups, snapshots, and parameter groups for the past 14 days. Events
     * specific to a particular cluster, security group, snapshot or parameter group can be obtained by providing the
     * name as a parameter. By default, the past hour of events are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.redshift.model.DescribeEventsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeEventsIterable responses = client
     *             .describeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.redshift.model.DescribeEventsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeEvents
     * @see #describeEventsPaginator(DescribeEventsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsIterable describeEventsPaginator() throws AwsServiceException, SdkClientException, RedshiftException {
        return describeEventsPaginator(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * Returns events related to clusters, security groups, snapshots, and parameter groups for the past 14 days. Events
     * specific to a particular cluster, security group, snapshot or parameter group can be obtained by providing the
     * name as a parameter. By default, the past hour of events are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.redshift.model.DescribeEventsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeEventsIterable responses = client
     *             .describeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.redshift.model.DescribeEventsRequest)} operation.</b>
     * </p>
     *
     * @param describeEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsIterable describeEventsPaginator(DescribeEventsRequest describeEventsRequest)
            throws AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns events related to clusters, security groups, snapshots, and parameter groups for the past 14 days. Events
     * specific to a particular cluster, security group, snapshot or parameter group can be obtained by providing the
     * name as a parameter. By default, the past hour of events are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.redshift.model.DescribeEventsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeEventsIterable responses = client
     *             .describeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.redshift.model.DescribeEventsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsMessage.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsIterable describeEventsPaginator(Consumer<DescribeEventsRequest.Builder> describeEventsRequest)
            throws AwsServiceException, SdkClientException, RedshiftException {
        return describeEventsPaginator(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified HSM client certificate. If no certificate ID is specified, returns
     * information about all the HSM certificates owned by your AWS customer account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM client
     * certificates that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all HSM client certificates that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM client certificates are returned regardless of
     * whether they have tag keys or values associated with them.
     * </p>
     *
     * @return Result of the DescribeHsmClientCertificates operation returned by the service.
     * @throws HsmClientCertificateNotFoundException
     *         There is no Amazon Redshift HSM client certificate with the specified identifier.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeHsmClientCertificates
     * @see #describeHsmClientCertificates(DescribeHsmClientCertificatesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmClientCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHsmClientCertificatesResponse describeHsmClientCertificates() throws HsmClientCertificateNotFoundException,
            InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return describeHsmClientCertificates(DescribeHsmClientCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the specified HSM client certificate. If no certificate ID is specified, returns
     * information about all the HSM certificates owned by your AWS customer account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM client
     * certificates that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all HSM client certificates that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM client certificates are returned regardless of
     * whether they have tag keys or values associated with them.
     * </p>
     *
     * @param describeHsmClientCertificatesRequest
     * @return Result of the DescribeHsmClientCertificates operation returned by the service.
     * @throws HsmClientCertificateNotFoundException
     *         There is no Amazon Redshift HSM client certificate with the specified identifier.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeHsmClientCertificates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmClientCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHsmClientCertificatesResponse describeHsmClientCertificates(
            DescribeHsmClientCertificatesRequest describeHsmClientCertificatesRequest)
            throws HsmClientCertificateNotFoundException, InvalidTagException, AwsServiceException, SdkClientException,
            RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified HSM client certificate. If no certificate ID is specified, returns
     * information about all the HSM certificates owned by your AWS customer account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM client
     * certificates that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all HSM client certificates that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM client certificates are returned regardless of
     * whether they have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHsmClientCertificatesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeHsmClientCertificatesRequest#builder()}
     * </p>
     *
     * @param describeHsmClientCertificatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeHsmClientCertificatesMessage.Builder} to
     *        create a request.
     * @return Result of the DescribeHsmClientCertificates operation returned by the service.
     * @throws HsmClientCertificateNotFoundException
     *         There is no Amazon Redshift HSM client certificate with the specified identifier.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeHsmClientCertificates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmClientCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHsmClientCertificatesResponse describeHsmClientCertificates(
            Consumer<DescribeHsmClientCertificatesRequest.Builder> describeHsmClientCertificatesRequest)
            throws HsmClientCertificateNotFoundException, InvalidTagException, AwsServiceException, SdkClientException,
            RedshiftException {
        return describeHsmClientCertificates(DescribeHsmClientCertificatesRequest.builder()
                .applyMutation(describeHsmClientCertificatesRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified HSM client certificate. If no certificate ID is specified, returns
     * information about all the HSM certificates owned by your AWS customer account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM client
     * certificates that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all HSM client certificates that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM client certificates are returned regardless of
     * whether they have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeHsmClientCertificates(software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeHsmClientCertificatesIterable responses = client.describeHsmClientCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeHsmClientCertificatesIterable responses = client
     *             .describeHsmClientCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeHsmClientCertificatesIterable responses = client.describeHsmClientCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeHsmClientCertificates(software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws HsmClientCertificateNotFoundException
     *         There is no Amazon Redshift HSM client certificate with the specified identifier.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeHsmClientCertificates
     * @see #describeHsmClientCertificatesPaginator(DescribeHsmClientCertificatesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmClientCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHsmClientCertificatesIterable describeHsmClientCertificatesPaginator()
            throws HsmClientCertificateNotFoundException, InvalidTagException, AwsServiceException, SdkClientException,
            RedshiftException {
        return describeHsmClientCertificatesPaginator(DescribeHsmClientCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the specified HSM client certificate. If no certificate ID is specified, returns
     * information about all the HSM certificates owned by your AWS customer account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM client
     * certificates that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all HSM client certificates that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM client certificates are returned regardless of
     * whether they have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeHsmClientCertificates(software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeHsmClientCertificatesIterable responses = client.describeHsmClientCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeHsmClientCertificatesIterable responses = client
     *             .describeHsmClientCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeHsmClientCertificatesIterable responses = client.describeHsmClientCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeHsmClientCertificates(software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeHsmClientCertificatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws HsmClientCertificateNotFoundException
     *         There is no Amazon Redshift HSM client certificate with the specified identifier.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeHsmClientCertificates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmClientCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHsmClientCertificatesIterable describeHsmClientCertificatesPaginator(
            DescribeHsmClientCertificatesRequest describeHsmClientCertificatesRequest)
            throws HsmClientCertificateNotFoundException, InvalidTagException, AwsServiceException, SdkClientException,
            RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified HSM client certificate. If no certificate ID is specified, returns
     * information about all the HSM certificates owned by your AWS customer account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM client
     * certificates that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all HSM client certificates that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM client certificates are returned regardless of
     * whether they have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeHsmClientCertificates(software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeHsmClientCertificatesIterable responses = client.describeHsmClientCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeHsmClientCertificatesIterable responses = client
     *             .describeHsmClientCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeHsmClientCertificatesIterable responses = client.describeHsmClientCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeHsmClientCertificates(software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHsmClientCertificatesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeHsmClientCertificatesRequest#builder()}
     * </p>
     *
     * @param describeHsmClientCertificatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeHsmClientCertificatesMessage.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws HsmClientCertificateNotFoundException
     *         There is no Amazon Redshift HSM client certificate with the specified identifier.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeHsmClientCertificates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmClientCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHsmClientCertificatesIterable describeHsmClientCertificatesPaginator(
            Consumer<DescribeHsmClientCertificatesRequest.Builder> describeHsmClientCertificatesRequest)
            throws HsmClientCertificateNotFoundException, InvalidTagException, AwsServiceException, SdkClientException,
            RedshiftException {
        return describeHsmClientCertificatesPaginator(DescribeHsmClientCertificatesRequest.builder()
                .applyMutation(describeHsmClientCertificatesRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified Amazon Redshift HSM configuration. If no configuration ID is specified,
     * returns information about all the HSM configurations owned by your AWS customer account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM connections that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all HSM
     * connections that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM connections are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     *
     * @return Result of the DescribeHsmConfigurations operation returned by the service.
     * @throws HsmConfigurationNotFoundException
     *         There is no Amazon Redshift HSM configuration with the specified identifier.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeHsmConfigurations
     * @see #describeHsmConfigurations(DescribeHsmConfigurationsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHsmConfigurationsResponse describeHsmConfigurations() throws HsmConfigurationNotFoundException,
            InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return describeHsmConfigurations(DescribeHsmConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the specified Amazon Redshift HSM configuration. If no configuration ID is specified,
     * returns information about all the HSM configurations owned by your AWS customer account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM connections that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all HSM
     * connections that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM connections are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     *
     * @param describeHsmConfigurationsRequest
     * @return Result of the DescribeHsmConfigurations operation returned by the service.
     * @throws HsmConfigurationNotFoundException
     *         There is no Amazon Redshift HSM configuration with the specified identifier.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeHsmConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHsmConfigurationsResponse describeHsmConfigurations(
            DescribeHsmConfigurationsRequest describeHsmConfigurationsRequest) throws HsmConfigurationNotFoundException,
            InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified Amazon Redshift HSM configuration. If no configuration ID is specified,
     * returns information about all the HSM configurations owned by your AWS customer account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM connections that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all HSM
     * connections that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM connections are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHsmConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeHsmConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeHsmConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeHsmConfigurationsMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeHsmConfigurations operation returned by the service.
     * @throws HsmConfigurationNotFoundException
     *         There is no Amazon Redshift HSM configuration with the specified identifier.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeHsmConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHsmConfigurationsResponse describeHsmConfigurations(
            Consumer<DescribeHsmConfigurationsRequest.Builder> describeHsmConfigurationsRequest)
            throws HsmConfigurationNotFoundException, InvalidTagException, AwsServiceException, SdkClientException,
            RedshiftException {
        return describeHsmConfigurations(DescribeHsmConfigurationsRequest.builder()
                .applyMutation(describeHsmConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified Amazon Redshift HSM configuration. If no configuration ID is specified,
     * returns information about all the HSM configurations owned by your AWS customer account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM connections that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all HSM
     * connections that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM connections are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeHsmConfigurations(software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeHsmConfigurationsIterable responses = client.describeHsmConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeHsmConfigurationsIterable responses = client
     *             .describeHsmConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeHsmConfigurationsIterable responses = client.describeHsmConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeHsmConfigurations(software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws HsmConfigurationNotFoundException
     *         There is no Amazon Redshift HSM configuration with the specified identifier.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeHsmConfigurations
     * @see #describeHsmConfigurationsPaginator(DescribeHsmConfigurationsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHsmConfigurationsIterable describeHsmConfigurationsPaginator() throws HsmConfigurationNotFoundException,
            InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return describeHsmConfigurationsPaginator(DescribeHsmConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the specified Amazon Redshift HSM configuration. If no configuration ID is specified,
     * returns information about all the HSM configurations owned by your AWS customer account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM connections that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all HSM
     * connections that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM connections are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeHsmConfigurations(software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeHsmConfigurationsIterable responses = client.describeHsmConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeHsmConfigurationsIterable responses = client
     *             .describeHsmConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeHsmConfigurationsIterable responses = client.describeHsmConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeHsmConfigurations(software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeHsmConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws HsmConfigurationNotFoundException
     *         There is no Amazon Redshift HSM configuration with the specified identifier.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeHsmConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHsmConfigurationsIterable describeHsmConfigurationsPaginator(
            DescribeHsmConfigurationsRequest describeHsmConfigurationsRequest) throws HsmConfigurationNotFoundException,
            InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified Amazon Redshift HSM configuration. If no configuration ID is specified,
     * returns information about all the HSM configurations owned by your AWS customer account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM connections that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all HSM
     * connections that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM connections are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeHsmConfigurations(software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeHsmConfigurationsIterable responses = client.describeHsmConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeHsmConfigurationsIterable responses = client
     *             .describeHsmConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeHsmConfigurationsIterable responses = client.describeHsmConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeHsmConfigurations(software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHsmConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeHsmConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeHsmConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeHsmConfigurationsMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws HsmConfigurationNotFoundException
     *         There is no Amazon Redshift HSM configuration with the specified identifier.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeHsmConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHsmConfigurationsIterable describeHsmConfigurationsPaginator(
            Consumer<DescribeHsmConfigurationsRequest.Builder> describeHsmConfigurationsRequest)
            throws HsmConfigurationNotFoundException, InvalidTagException, AwsServiceException, SdkClientException,
            RedshiftException {
        return describeHsmConfigurationsPaginator(DescribeHsmConfigurationsRequest.builder()
                .applyMutation(describeHsmConfigurationsRequest).build());
    }

    /**
     * <p>
     * Describes whether information, such as queries and connection attempts, is being logged for the specified Amazon
     * Redshift cluster.
     * </p>
     *
     * @param describeLoggingStatusRequest
     * @return Result of the DescribeLoggingStatus operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeLoggingStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeLoggingStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeLoggingStatusResponse describeLoggingStatus(DescribeLoggingStatusRequest describeLoggingStatusRequest)
            throws ClusterNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes whether information, such as queries and connection attempts, is being logged for the specified Amazon
     * Redshift cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoggingStatusRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLoggingStatusRequest#builder()}
     * </p>
     *
     * @param describeLoggingStatusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeLoggingStatusMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeLoggingStatus operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeLoggingStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeLoggingStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeLoggingStatusResponse describeLoggingStatus(
            Consumer<DescribeLoggingStatusRequest.Builder> describeLoggingStatusRequest) throws ClusterNotFoundException,
            AwsServiceException, SdkClientException, RedshiftException {
        return describeLoggingStatus(DescribeLoggingStatusRequest.builder().applyMutation(describeLoggingStatusRequest).build());
    }

    /**
     * <p>
     * Returns a list of orderable cluster options. Before you create a new cluster you can use this operation to find
     * what options are available, such as the EC2 Availability Zones (AZ) in the specific AWS Region that you can
     * specify, and the node types you can request. The node types differ by available storage, memory, CPU and price.
     * With the cost involved you might want to obtain a list of cluster options in the specific region and specify
     * values when creating a cluster. For more information about managing clusters, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in
     * the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @return Result of the DescribeOrderableClusterOptions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeOrderableClusterOptions
     * @see #describeOrderableClusterOptions(DescribeOrderableClusterOptionsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeOrderableClusterOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableClusterOptionsResponse describeOrderableClusterOptions() throws AwsServiceException,
            SdkClientException, RedshiftException {
        return describeOrderableClusterOptions(DescribeOrderableClusterOptionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of orderable cluster options. Before you create a new cluster you can use this operation to find
     * what options are available, such as the EC2 Availability Zones (AZ) in the specific AWS Region that you can
     * specify, and the node types you can request. The node types differ by available storage, memory, CPU and price.
     * With the cost involved you might want to obtain a list of cluster options in the specific region and specify
     * values when creating a cluster. For more information about managing clusters, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in
     * the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param describeOrderableClusterOptionsRequest
     * @return Result of the DescribeOrderableClusterOptions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeOrderableClusterOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeOrderableClusterOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableClusterOptionsResponse describeOrderableClusterOptions(
            DescribeOrderableClusterOptionsRequest describeOrderableClusterOptionsRequest) throws AwsServiceException,
            SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of orderable cluster options. Before you create a new cluster you can use this operation to find
     * what options are available, such as the EC2 Availability Zones (AZ) in the specific AWS Region that you can
     * specify, and the node types you can request. The node types differ by available storage, memory, CPU and price.
     * With the cost involved you might want to obtain a list of cluster options in the specific region and specify
     * values when creating a cluster. For more information about managing clusters, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in
     * the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrderableClusterOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrderableClusterOptionsRequest#builder()}
     * </p>
     *
     * @param describeOrderableClusterOptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOrderableClusterOptionsMessage.Builder} to
     *        create a request.
     * @return Result of the DescribeOrderableClusterOptions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeOrderableClusterOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeOrderableClusterOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableClusterOptionsResponse describeOrderableClusterOptions(
            Consumer<DescribeOrderableClusterOptionsRequest.Builder> describeOrderableClusterOptionsRequest)
            throws AwsServiceException, SdkClientException, RedshiftException {
        return describeOrderableClusterOptions(DescribeOrderableClusterOptionsRequest.builder()
                .applyMutation(describeOrderableClusterOptionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of orderable cluster options. Before you create a new cluster you can use this operation to find
     * what options are available, such as the EC2 Availability Zones (AZ) in the specific AWS Region that you can
     * specify, and the node types you can request. The node types differ by available storage, memory, CPU and price.
     * With the cost involved you might want to obtain a list of cluster options in the specific region and specify
     * values when creating a cluster. For more information about managing clusters, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in
     * the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOrderableClusterOptions(software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeOrderableClusterOptionsIterable responses = client.describeOrderableClusterOptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeOrderableClusterOptionsIterable responses = client
     *             .describeOrderableClusterOptionsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeOrderableClusterOptionsIterable responses = client.describeOrderableClusterOptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableClusterOptions(software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeOrderableClusterOptions
     * @see #describeOrderableClusterOptionsPaginator(DescribeOrderableClusterOptionsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeOrderableClusterOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableClusterOptionsIterable describeOrderableClusterOptionsPaginator() throws AwsServiceException,
            SdkClientException, RedshiftException {
        return describeOrderableClusterOptionsPaginator(DescribeOrderableClusterOptionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of orderable cluster options. Before you create a new cluster you can use this operation to find
     * what options are available, such as the EC2 Availability Zones (AZ) in the specific AWS Region that you can
     * specify, and the node types you can request. The node types differ by available storage, memory, CPU and price.
     * With the cost involved you might want to obtain a list of cluster options in the specific region and specify
     * values when creating a cluster. For more information about managing clusters, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in
     * the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOrderableClusterOptions(software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeOrderableClusterOptionsIterable responses = client.describeOrderableClusterOptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeOrderableClusterOptionsIterable responses = client
     *             .describeOrderableClusterOptionsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeOrderableClusterOptionsIterable responses = client.describeOrderableClusterOptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableClusterOptions(software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrderableClusterOptionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeOrderableClusterOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeOrderableClusterOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableClusterOptionsIterable describeOrderableClusterOptionsPaginator(
            DescribeOrderableClusterOptionsRequest describeOrderableClusterOptionsRequest) throws AwsServiceException,
            SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of orderable cluster options. Before you create a new cluster you can use this operation to find
     * what options are available, such as the EC2 Availability Zones (AZ) in the specific AWS Region that you can
     * specify, and the node types you can request. The node types differ by available storage, memory, CPU and price.
     * With the cost involved you might want to obtain a list of cluster options in the specific region and specify
     * values when creating a cluster. For more information about managing clusters, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in
     * the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOrderableClusterOptions(software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeOrderableClusterOptionsIterable responses = client.describeOrderableClusterOptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeOrderableClusterOptionsIterable responses = client
     *             .describeOrderableClusterOptionsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeOrderableClusterOptionsIterable responses = client.describeOrderableClusterOptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableClusterOptions(software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrderableClusterOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrderableClusterOptionsRequest#builder()}
     * </p>
     *
     * @param describeOrderableClusterOptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOrderableClusterOptionsMessage.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeOrderableClusterOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeOrderableClusterOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableClusterOptionsIterable describeOrderableClusterOptionsPaginator(
            Consumer<DescribeOrderableClusterOptionsRequest.Builder> describeOrderableClusterOptionsRequest)
            throws AwsServiceException, SdkClientException, RedshiftException {
        return describeOrderableClusterOptionsPaginator(DescribeOrderableClusterOptionsRequest.builder()
                .applyMutation(describeOrderableClusterOptionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the available reserved node offerings by Amazon Redshift with their descriptions including the
     * node type, the fixed and recurring costs of reserving the node and duration the node will be reserved for you.
     * These descriptions help you determine which reserve node offering you want to purchase. You then use the unique
     * offering ID in you call to <a>PurchaseReservedNodeOffering</a> to reserve one or more nodes for your Amazon
     * Redshift cluster.
     * </p>
     * <p>
     * For more information about reserved node offerings, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html">Purchasing Reserved
     * Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @return Result of the DescribeReservedNodeOfferings operation returned by the service.
     * @throws ReservedNodeOfferingNotFoundException
     *         Specified offering does not exist.
     * @throws UnsupportedOperationException
     *         The requested operation isn't supported.
     * @throws DependentServiceUnavailableException
     *         Your request cannot be completed because a dependent internal service is temporarily unavailable. Wait 30
     *         to 60 seconds and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeReservedNodeOfferings
     * @see #describeReservedNodeOfferings(DescribeReservedNodeOfferingsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodeOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedNodeOfferingsResponse describeReservedNodeOfferings() throws ReservedNodeOfferingNotFoundException,
            UnsupportedOperationException, DependentServiceUnavailableException, AwsServiceException, SdkClientException,
            RedshiftException {
        return describeReservedNodeOfferings(DescribeReservedNodeOfferingsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the available reserved node offerings by Amazon Redshift with their descriptions including the
     * node type, the fixed and recurring costs of reserving the node and duration the node will be reserved for you.
     * These descriptions help you determine which reserve node offering you want to purchase. You then use the unique
     * offering ID in you call to <a>PurchaseReservedNodeOffering</a> to reserve one or more nodes for your Amazon
     * Redshift cluster.
     * </p>
     * <p>
     * For more information about reserved node offerings, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html">Purchasing Reserved
     * Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param describeReservedNodeOfferingsRequest
     * @return Result of the DescribeReservedNodeOfferings operation returned by the service.
     * @throws ReservedNodeOfferingNotFoundException
     *         Specified offering does not exist.
     * @throws UnsupportedOperationException
     *         The requested operation isn't supported.
     * @throws DependentServiceUnavailableException
     *         Your request cannot be completed because a dependent internal service is temporarily unavailable. Wait 30
     *         to 60 seconds and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeReservedNodeOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodeOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedNodeOfferingsResponse describeReservedNodeOfferings(
            DescribeReservedNodeOfferingsRequest describeReservedNodeOfferingsRequest)
            throws ReservedNodeOfferingNotFoundException, UnsupportedOperationException, DependentServiceUnavailableException,
            AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the available reserved node offerings by Amazon Redshift with their descriptions including the
     * node type, the fixed and recurring costs of reserving the node and duration the node will be reserved for you.
     * These descriptions help you determine which reserve node offering you want to purchase. You then use the unique
     * offering ID in you call to <a>PurchaseReservedNodeOffering</a> to reserve one or more nodes for your Amazon
     * Redshift cluster.
     * </p>
     * <p>
     * For more information about reserved node offerings, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html">Purchasing Reserved
     * Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedNodeOfferingsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReservedNodeOfferingsRequest#builder()}
     * </p>
     *
     * @param describeReservedNodeOfferingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedNodeOfferingsMessage.Builder} to
     *        create a request.
     * @return Result of the DescribeReservedNodeOfferings operation returned by the service.
     * @throws ReservedNodeOfferingNotFoundException
     *         Specified offering does not exist.
     * @throws UnsupportedOperationException
     *         The requested operation isn't supported.
     * @throws DependentServiceUnavailableException
     *         Your request cannot be completed because a dependent internal service is temporarily unavailable. Wait 30
     *         to 60 seconds and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeReservedNodeOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodeOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedNodeOfferingsResponse describeReservedNodeOfferings(
            Consumer<DescribeReservedNodeOfferingsRequest.Builder> describeReservedNodeOfferingsRequest)
            throws ReservedNodeOfferingNotFoundException, UnsupportedOperationException, DependentServiceUnavailableException,
            AwsServiceException, SdkClientException, RedshiftException {
        return describeReservedNodeOfferings(DescribeReservedNodeOfferingsRequest.builder()
                .applyMutation(describeReservedNodeOfferingsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the available reserved node offerings by Amazon Redshift with their descriptions including the
     * node type, the fixed and recurring costs of reserving the node and duration the node will be reserved for you.
     * These descriptions help you determine which reserve node offering you want to purchase. You then use the unique
     * offering ID in you call to <a>PurchaseReservedNodeOffering</a> to reserve one or more nodes for your Amazon
     * Redshift cluster.
     * </p>
     * <p>
     * For more information about reserved node offerings, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html">Purchasing Reserved
     * Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedNodeOfferings(software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodeOfferingsIterable responses = client.describeReservedNodeOfferingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodeOfferingsIterable responses = client
     *             .describeReservedNodeOfferingsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodeOfferingsIterable responses = client.describeReservedNodeOfferingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedNodeOfferings(software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ReservedNodeOfferingNotFoundException
     *         Specified offering does not exist.
     * @throws UnsupportedOperationException
     *         The requested operation isn't supported.
     * @throws DependentServiceUnavailableException
     *         Your request cannot be completed because a dependent internal service is temporarily unavailable. Wait 30
     *         to 60 seconds and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeReservedNodeOfferings
     * @see #describeReservedNodeOfferingsPaginator(DescribeReservedNodeOfferingsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodeOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedNodeOfferingsIterable describeReservedNodeOfferingsPaginator()
            throws ReservedNodeOfferingNotFoundException, UnsupportedOperationException, DependentServiceUnavailableException,
            AwsServiceException, SdkClientException, RedshiftException {
        return describeReservedNodeOfferingsPaginator(DescribeReservedNodeOfferingsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the available reserved node offerings by Amazon Redshift with their descriptions including the
     * node type, the fixed and recurring costs of reserving the node and duration the node will be reserved for you.
     * These descriptions help you determine which reserve node offering you want to purchase. You then use the unique
     * offering ID in you call to <a>PurchaseReservedNodeOffering</a> to reserve one or more nodes for your Amazon
     * Redshift cluster.
     * </p>
     * <p>
     * For more information about reserved node offerings, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html">Purchasing Reserved
     * Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedNodeOfferings(software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodeOfferingsIterable responses = client.describeReservedNodeOfferingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodeOfferingsIterable responses = client
     *             .describeReservedNodeOfferingsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodeOfferingsIterable responses = client.describeReservedNodeOfferingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedNodeOfferings(software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedNodeOfferingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ReservedNodeOfferingNotFoundException
     *         Specified offering does not exist.
     * @throws UnsupportedOperationException
     *         The requested operation isn't supported.
     * @throws DependentServiceUnavailableException
     *         Your request cannot be completed because a dependent internal service is temporarily unavailable. Wait 30
     *         to 60 seconds and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeReservedNodeOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodeOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedNodeOfferingsIterable describeReservedNodeOfferingsPaginator(
            DescribeReservedNodeOfferingsRequest describeReservedNodeOfferingsRequest)
            throws ReservedNodeOfferingNotFoundException, UnsupportedOperationException, DependentServiceUnavailableException,
            AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the available reserved node offerings by Amazon Redshift with their descriptions including the
     * node type, the fixed and recurring costs of reserving the node and duration the node will be reserved for you.
     * These descriptions help you determine which reserve node offering you want to purchase. You then use the unique
     * offering ID in you call to <a>PurchaseReservedNodeOffering</a> to reserve one or more nodes for your Amazon
     * Redshift cluster.
     * </p>
     * <p>
     * For more information about reserved node offerings, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html">Purchasing Reserved
     * Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedNodeOfferings(software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodeOfferingsIterable responses = client.describeReservedNodeOfferingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodeOfferingsIterable responses = client
     *             .describeReservedNodeOfferingsPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodeOfferingsIterable responses = client.describeReservedNodeOfferingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedNodeOfferings(software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedNodeOfferingsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReservedNodeOfferingsRequest#builder()}
     * </p>
     *
     * @param describeReservedNodeOfferingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedNodeOfferingsMessage.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ReservedNodeOfferingNotFoundException
     *         Specified offering does not exist.
     * @throws UnsupportedOperationException
     *         The requested operation isn't supported.
     * @throws DependentServiceUnavailableException
     *         Your request cannot be completed because a dependent internal service is temporarily unavailable. Wait 30
     *         to 60 seconds and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeReservedNodeOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodeOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedNodeOfferingsIterable describeReservedNodeOfferingsPaginator(
            Consumer<DescribeReservedNodeOfferingsRequest.Builder> describeReservedNodeOfferingsRequest)
            throws ReservedNodeOfferingNotFoundException, UnsupportedOperationException, DependentServiceUnavailableException,
            AwsServiceException, SdkClientException, RedshiftException {
        return describeReservedNodeOfferingsPaginator(DescribeReservedNodeOfferingsRequest.builder()
                .applyMutation(describeReservedNodeOfferingsRequest).build());
    }

    /**
     * <p>
     * Returns the descriptions of the reserved nodes.
     * </p>
     *
     * @return Result of the DescribeReservedNodes operation returned by the service.
     * @throws ReservedNodeNotFoundException
     *         The specified reserved compute node not found.
     * @throws DependentServiceUnavailableException
     *         Your request cannot be completed because a dependent internal service is temporarily unavailable. Wait 30
     *         to 60 seconds and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeReservedNodes
     * @see #describeReservedNodes(DescribeReservedNodesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodes" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReservedNodesResponse describeReservedNodes() throws ReservedNodeNotFoundException,
            DependentServiceUnavailableException, AwsServiceException, SdkClientException, RedshiftException {
        return describeReservedNodes(DescribeReservedNodesRequest.builder().build());
    }

    /**
     * <p>
     * Returns the descriptions of the reserved nodes.
     * </p>
     *
     * @param describeReservedNodesRequest
     * @return Result of the DescribeReservedNodes operation returned by the service.
     * @throws ReservedNodeNotFoundException
     *         The specified reserved compute node not found.
     * @throws DependentServiceUnavailableException
     *         Your request cannot be completed because a dependent internal service is temporarily unavailable. Wait 30
     *         to 60 seconds and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeReservedNodes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodes" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReservedNodesResponse describeReservedNodes(DescribeReservedNodesRequest describeReservedNodesRequest)
            throws ReservedNodeNotFoundException, DependentServiceUnavailableException, AwsServiceException, SdkClientException,
            RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the descriptions of the reserved nodes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedNodesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeReservedNodesRequest#builder()}
     * </p>
     *
     * @param describeReservedNodesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedNodesMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeReservedNodes operation returned by the service.
     * @throws ReservedNodeNotFoundException
     *         The specified reserved compute node not found.
     * @throws DependentServiceUnavailableException
     *         Your request cannot be completed because a dependent internal service is temporarily unavailable. Wait 30
     *         to 60 seconds and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeReservedNodes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodes" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReservedNodesResponse describeReservedNodes(
            Consumer<DescribeReservedNodesRequest.Builder> describeReservedNodesRequest) throws ReservedNodeNotFoundException,
            DependentServiceUnavailableException, AwsServiceException, SdkClientException, RedshiftException {
        return describeReservedNodes(DescribeReservedNodesRequest.builder().applyMutation(describeReservedNodesRequest).build());
    }

    /**
     * <p>
     * Returns the descriptions of the reserved nodes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedNodes(software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodesIterable responses = client.describeReservedNodesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodesIterable responses = client
     *             .describeReservedNodesPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeReservedNodesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodesIterable responses = client.describeReservedNodesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedNodes(software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ReservedNodeNotFoundException
     *         The specified reserved compute node not found.
     * @throws DependentServiceUnavailableException
     *         Your request cannot be completed because a dependent internal service is temporarily unavailable. Wait 30
     *         to 60 seconds and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeReservedNodes
     * @see #describeReservedNodesPaginator(DescribeReservedNodesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodes" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReservedNodesIterable describeReservedNodesPaginator() throws ReservedNodeNotFoundException,
            DependentServiceUnavailableException, AwsServiceException, SdkClientException, RedshiftException {
        return describeReservedNodesPaginator(DescribeReservedNodesRequest.builder().build());
    }

    /**
     * <p>
     * Returns the descriptions of the reserved nodes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedNodes(software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodesIterable responses = client.describeReservedNodesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodesIterable responses = client
     *             .describeReservedNodesPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeReservedNodesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodesIterable responses = client.describeReservedNodesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedNodes(software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedNodesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ReservedNodeNotFoundException
     *         The specified reserved compute node not found.
     * @throws DependentServiceUnavailableException
     *         Your request cannot be completed because a dependent internal service is temporarily unavailable. Wait 30
     *         to 60 seconds and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeReservedNodes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodes" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReservedNodesIterable describeReservedNodesPaginator(DescribeReservedNodesRequest describeReservedNodesRequest)
            throws ReservedNodeNotFoundException, DependentServiceUnavailableException, AwsServiceException, SdkClientException,
            RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the descriptions of the reserved nodes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedNodes(software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodesIterable responses = client.describeReservedNodesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodesIterable responses = client
     *             .describeReservedNodesPaginator(request);
     *     for (software.amazon.awssdk.services.redshift.model.DescribeReservedNodesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodesIterable responses = client.describeReservedNodesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedNodes(software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedNodesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeReservedNodesRequest#builder()}
     * </p>
     *
     * @param describeReservedNodesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedNodesMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ReservedNodeNotFoundException
     *         The specified reserved compute node not found.
     * @throws DependentServiceUnavailableException
     *         Your request cannot be completed because a dependent internal service is temporarily unavailable. Wait 30
     *         to 60 seconds and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeReservedNodes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodes" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReservedNodesIterable describeReservedNodesPaginator(
            Consumer<DescribeReservedNodesRequest.Builder> describeReservedNodesRequest) throws ReservedNodeNotFoundException,
            DependentServiceUnavailableException, AwsServiceException, SdkClientException, RedshiftException {
        return describeReservedNodesPaginator(DescribeReservedNodesRequest.builder().applyMutation(describeReservedNodesRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about the last resize operation for the specified cluster. If no resize operation has ever
     * been initiated for the specified cluster, a <code>HTTP 404</code> error is returned. If a resize operation was
     * initiated and completed, the status of the resize remains as <code>SUCCEEDED</code> until the next resize.
     * </p>
     * <p>
     * A resize operation can be requested using <a>ModifyCluster</a> and specifying a different number or type of nodes
     * for the cluster.
     * </p>
     *
     * @param describeResizeRequest
     * @return Result of the DescribeResize operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws ResizeNotFoundException
     *         A resize operation for the specified cluster is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeResize
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeResize" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeResizeResponse describeResize(DescribeResizeRequest describeResizeRequest) throws ClusterNotFoundException,
            ResizeNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the last resize operation for the specified cluster. If no resize operation has ever
     * been initiated for the specified cluster, a <code>HTTP 404</code> error is returned. If a resize operation was
     * initiated and completed, the status of the resize remains as <code>SUCCEEDED</code> until the next resize.
     * </p>
     * <p>
     * A resize operation can be requested using <a>ModifyCluster</a> and specifying a different number or type of nodes
     * for the cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResizeRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeResizeRequest#builder()}
     * </p>
     *
     * @param describeResizeRequest
     *        A {@link Consumer} that will call methods on {@link DescribeResizeMessage.Builder} to create a request.
     * @return Result of the DescribeResize operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws ResizeNotFoundException
     *         A resize operation for the specified cluster is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeResize
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeResize" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeResizeResponse describeResize(Consumer<DescribeResizeRequest.Builder> describeResizeRequest)
            throws ClusterNotFoundException, ResizeNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        return describeResize(DescribeResizeRequest.builder().applyMutation(describeResizeRequest).build());
    }

    /**
     * <p>
     * Returns a list of snapshot copy grants owned by the AWS account in the destination region.
     * </p>
     * <p>
     * For more information about managing snapshot copy grants, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database
     * Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @return Result of the DescribeSnapshotCopyGrants operation returned by the service.
     * @throws SnapshotCopyGrantNotFoundException
     *         The specified snapshot copy grant can't be found. Make sure that the name is typed correctly and that the
     *         grant exists in the destination region.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeSnapshotCopyGrants
     * @see #describeSnapshotCopyGrants(DescribeSnapshotCopyGrantsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotCopyGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSnapshotCopyGrantsResponse describeSnapshotCopyGrants() throws SnapshotCopyGrantNotFoundException,
            InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return describeSnapshotCopyGrants(DescribeSnapshotCopyGrantsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of snapshot copy grants owned by the AWS account in the destination region.
     * </p>
     * <p>
     * For more information about managing snapshot copy grants, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database
     * Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param describeSnapshotCopyGrantsRequest
     *        The result of the <code>DescribeSnapshotCopyGrants</code> action.
     * @return Result of the DescribeSnapshotCopyGrants operation returned by the service.
     * @throws SnapshotCopyGrantNotFoundException
     *         The specified snapshot copy grant can't be found. Make sure that the name is typed correctly and that the
     *         grant exists in the destination region.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeSnapshotCopyGrants
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotCopyGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSnapshotCopyGrantsResponse describeSnapshotCopyGrants(
            DescribeSnapshotCopyGrantsRequest describeSnapshotCopyGrantsRequest) throws SnapshotCopyGrantNotFoundException,
            InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of snapshot copy grants owned by the AWS account in the destination region.
     * </p>
     * <p>
     * For more information about managing snapshot copy grants, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database
     * Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSnapshotCopyGrantsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSnapshotCopyGrantsRequest#builder()}
     * </p>
     *
     * @param describeSnapshotCopyGrantsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSnapshotCopyGrantsMessage.Builder} to create a
     *        request. The result of the <code>DescribeSnapshotCopyGrants</code> action.
     * @return Result of the DescribeSnapshotCopyGrants operation returned by the service.
     * @throws SnapshotCopyGrantNotFoundException
     *         The specified snapshot copy grant can't be found. Make sure that the name is typed correctly and that the
     *         grant exists in the destination region.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeSnapshotCopyGrants
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotCopyGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSnapshotCopyGrantsResponse describeSnapshotCopyGrants(
            Consumer<DescribeSnapshotCopyGrantsRequest.Builder> describeSnapshotCopyGrantsRequest)
            throws SnapshotCopyGrantNotFoundException, InvalidTagException, AwsServiceException, SdkClientException,
            RedshiftException {
        return describeSnapshotCopyGrants(DescribeSnapshotCopyGrantsRequest.builder()
                .applyMutation(describeSnapshotCopyGrantsRequest).build());
    }

    /**
     * <p>
     * Returns a list of snapshot schedules.
     * </p>
     *
     * @return Result of the DescribeSnapshotSchedules operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeSnapshotSchedules
     * @see #describeSnapshotSchedules(DescribeSnapshotSchedulesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSnapshotSchedulesResponse describeSnapshotSchedules() throws AwsServiceException, SdkClientException,
            RedshiftException {
        return describeSnapshotSchedules(DescribeSnapshotSchedulesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of snapshot schedules.
     * </p>
     *
     * @param describeSnapshotSchedulesRequest
     * @return Result of the DescribeSnapshotSchedules operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeSnapshotSchedules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSnapshotSchedulesResponse describeSnapshotSchedules(
            DescribeSnapshotSchedulesRequest describeSnapshotSchedulesRequest) throws AwsServiceException, SdkClientException,
            RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of snapshot schedules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSnapshotSchedulesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSnapshotSchedulesRequest#builder()}
     * </p>
     *
     * @param describeSnapshotSchedulesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSnapshotSchedulesMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeSnapshotSchedules operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeSnapshotSchedules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSnapshotSchedulesResponse describeSnapshotSchedules(
            Consumer<DescribeSnapshotSchedulesRequest.Builder> describeSnapshotSchedulesRequest) throws AwsServiceException,
            SdkClientException, RedshiftException {
        return describeSnapshotSchedules(DescribeSnapshotSchedulesRequest.builder()
                .applyMutation(describeSnapshotSchedulesRequest).build());
    }

    /**
     * <p>
     * Returns the total amount of snapshot usage and provisioned storage for a user in megabytes.
     * </p>
     *
     * @return Result of the DescribeStorage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeStorage
     * @see #describeStorage(DescribeStorageRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeStorage" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeStorageResponse describeStorage() throws AwsServiceException, SdkClientException, RedshiftException {
        return describeStorage(DescribeStorageRequest.builder().build());
    }

    /**
     * <p>
     * Returns the total amount of snapshot usage and provisioned storage for a user in megabytes.
     * </p>
     *
     * @param describeStorageRequest
     * @return Result of the DescribeStorage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeStorage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeStorage" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeStorageResponse describeStorage(DescribeStorageRequest describeStorageRequest) throws AwsServiceException,
            SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the total amount of snapshot usage and provisioned storage for a user in megabytes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStorageRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeStorageRequest#builder()}
     * </p>
     *
     * @param describeStorageRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStorageRequest.Builder} to create a request.
     * @return Result of the DescribeStorage operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeStorage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeStorage" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeStorageResponse describeStorage(Consumer<DescribeStorageRequest.Builder> describeStorageRequest)
            throws AwsServiceException, SdkClientException, RedshiftException {
        return describeStorage(DescribeStorageRequest.builder().applyMutation(describeStorageRequest).build());
    }

    /**
     * <p>
     * Lists the status of one or more table restore requests made using the <a>RestoreTableFromClusterSnapshot</a> API
     * action. If you don't specify a value for the <code>TableRestoreRequestId</code> parameter, then
     * <code>DescribeTableRestoreStatus</code> returns the status of all table restore requests ordered by the date and
     * time of the request in ascending order. Otherwise <code>DescribeTableRestoreStatus</code> returns the status of
     * the table specified by <code>TableRestoreRequestId</code>.
     * </p>
     *
     * @param describeTableRestoreStatusRequest
     * @return Result of the DescribeTableRestoreStatus operation returned by the service.
     * @throws TableRestoreNotFoundException
     *         The specified <code>TableRestoreRequestId</code> value was not found.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeTableRestoreStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTableRestoreStatusResponse describeTableRestoreStatus(
            DescribeTableRestoreStatusRequest describeTableRestoreStatusRequest) throws TableRestoreNotFoundException,
            ClusterNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the status of one or more table restore requests made using the <a>RestoreTableFromClusterSnapshot</a> API
     * action. If you don't specify a value for the <code>TableRestoreRequestId</code> parameter, then
     * <code>DescribeTableRestoreStatus</code> returns the status of all table restore requests ordered by the date and
     * time of the request in ascending order. Otherwise <code>DescribeTableRestoreStatus</code> returns the status of
     * the table specified by <code>TableRestoreRequestId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTableRestoreStatusRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeTableRestoreStatusRequest#builder()}
     * </p>
     *
     * @param describeTableRestoreStatusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTableRestoreStatusMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeTableRestoreStatus operation returned by the service.
     * @throws TableRestoreNotFoundException
     *         The specified <code>TableRestoreRequestId</code> value was not found.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeTableRestoreStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTableRestoreStatusResponse describeTableRestoreStatus(
            Consumer<DescribeTableRestoreStatusRequest.Builder> describeTableRestoreStatusRequest)
            throws TableRestoreNotFoundException, ClusterNotFoundException, AwsServiceException, SdkClientException,
            RedshiftException {
        return describeTableRestoreStatus(DescribeTableRestoreStatusRequest.builder()
                .applyMutation(describeTableRestoreStatusRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags. You can return tags from a specific resource by specifying an ARN, or you can return all
     * tags for a given type of resource, such as clusters, snapshots, and so on.
     * </p>
     * <p>
     * The following are limitations for <code>DescribeTags</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You cannot specify an ARN and a resource-type value together in the same request.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use the <code>MaxRecords</code> and <code>Marker</code> parameters together with the ARN parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>MaxRecords</code> parameter can be a range from 10 to 50 results to return in a request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all resources that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all resources
     * that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, resources are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     *
     * @return Result of the DescribeTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeTags
     * @see #describeTags(DescribeTagsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTagsResponse describeTags() throws ResourceNotFoundException, InvalidTagException, AwsServiceException,
            SdkClientException, RedshiftException {
        return describeTags(DescribeTagsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of tags. You can return tags from a specific resource by specifying an ARN, or you can return all
     * tags for a given type of resource, such as clusters, snapshots, and so on.
     * </p>
     * <p>
     * The following are limitations for <code>DescribeTags</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You cannot specify an ARN and a resource-type value together in the same request.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use the <code>MaxRecords</code> and <code>Marker</code> parameters together with the ARN parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>MaxRecords</code> parameter can be a range from 10 to 50 results to return in a request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all resources that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all resources
     * that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, resources are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     *
     * @param describeTagsRequest
     * @return Result of the DescribeTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws ResourceNotFoundException,
            InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags. You can return tags from a specific resource by specifying an ARN, or you can return all
     * tags for a given type of resource, such as clusters, snapshots, and so on.
     * </p>
     * <p>
     * The following are limitations for <code>DescribeTags</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You cannot specify an ARN and a resource-type value together in the same request.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use the <code>MaxRecords</code> and <code>Marker</code> parameters together with the ARN parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>MaxRecords</code> parameter can be a range from 10 to 50 results to return in a request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all resources that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all resources
     * that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, resources are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTagsRequest#builder()}
     * </p>
     *
     * @param describeTagsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTagsMessage.Builder} to create a request.
     * @return Result of the DescribeTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidTagException
     *         The tag is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DescribeTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTagsResponse describeTags(Consumer<DescribeTagsRequest.Builder> describeTagsRequest)
            throws ResourceNotFoundException, InvalidTagException, AwsServiceException, SdkClientException, RedshiftException {
        return describeTags(DescribeTagsRequest.builder().applyMutation(describeTagsRequest).build());
    }

    /**
     * <p>
     * Stops logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
     * </p>
     *
     * @param disableLoggingRequest
     * @return Result of the DisableLogging operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DisableLogging
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisableLogging" target="_top">AWS API
     *      Documentation</a>
     */
    default DisableLoggingResponse disableLogging(DisableLoggingRequest disableLoggingRequest) throws ClusterNotFoundException,
            AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableLoggingRequest.Builder} avoiding the need to
     * create one manually via {@link DisableLoggingRequest#builder()}
     * </p>
     *
     * @param disableLoggingRequest
     *        A {@link Consumer} that will call methods on {@link DisableLoggingMessage.Builder} to create a request.
     * @return Result of the DisableLogging operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DisableLogging
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisableLogging" target="_top">AWS API
     *      Documentation</a>
     */
    default DisableLoggingResponse disableLogging(Consumer<DisableLoggingRequest.Builder> disableLoggingRequest)
            throws ClusterNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        return disableLogging(DisableLoggingRequest.builder().applyMutation(disableLoggingRequest).build());
    }

    /**
     * <p>
     * Disables the automatic copying of snapshots from one region to another region for a specified cluster.
     * </p>
     * <p>
     * If your cluster and its snapshots are encrypted using a customer master key (CMK) from AWS KMS, use
     * <a>DeleteSnapshotCopyGrant</a> to delete the grant that grants Amazon Redshift permission to the CMK in the
     * destination region.
     * </p>
     *
     * @param disableSnapshotCopyRequest
     * @return Result of the DisableSnapshotCopy operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws SnapshotCopyAlreadyDisabledException
     *         The cluster already has cross-region snapshot copy disabled.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws UnauthorizedOperationException
     *         Your account is not authorized to perform the requested operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DisableSnapshotCopy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisableSnapshotCopy" target="_top">AWS
     *      API Documentation</a>
     */
    default DisableSnapshotCopyResponse disableSnapshotCopy(DisableSnapshotCopyRequest disableSnapshotCopyRequest)
            throws ClusterNotFoundException, SnapshotCopyAlreadyDisabledException, InvalidClusterStateException,
            UnauthorizedOperationException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the automatic copying of snapshots from one region to another region for a specified cluster.
     * </p>
     * <p>
     * If your cluster and its snapshots are encrypted using a customer master key (CMK) from AWS KMS, use
     * <a>DeleteSnapshotCopyGrant</a> to delete the grant that grants Amazon Redshift permission to the CMK in the
     * destination region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableSnapshotCopyRequest.Builder} avoiding the
     * need to create one manually via {@link DisableSnapshotCopyRequest#builder()}
     * </p>
     *
     * @param disableSnapshotCopyRequest
     *        A {@link Consumer} that will call methods on {@link DisableSnapshotCopyMessage.Builder} to create a
     *        request.
     * @return Result of the DisableSnapshotCopy operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws SnapshotCopyAlreadyDisabledException
     *         The cluster already has cross-region snapshot copy disabled.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws UnauthorizedOperationException
     *         Your account is not authorized to perform the requested operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.DisableSnapshotCopy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisableSnapshotCopy" target="_top">AWS
     *      API Documentation</a>
     */
    default DisableSnapshotCopyResponse disableSnapshotCopy(
            Consumer<DisableSnapshotCopyRequest.Builder> disableSnapshotCopyRequest) throws ClusterNotFoundException,
            SnapshotCopyAlreadyDisabledException, InvalidClusterStateException, UnauthorizedOperationException,
            AwsServiceException, SdkClientException, RedshiftException {
        return disableSnapshotCopy(DisableSnapshotCopyRequest.builder().applyMutation(disableSnapshotCopyRequest).build());
    }

    /**
     * <p>
     * Starts logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
     * </p>
     *
     * @param enableLoggingRequest
     * @return Result of the EnableLogging operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws BucketNotFoundException
     *         Could not find the specified S3 bucket.
     * @throws InsufficientS3BucketPolicyException
     *         The cluster does not have read bucket or put object permissions on the S3 bucket specified when enabling
     *         logging.
     * @throws InvalidS3KeyPrefixException
     *         The string specified for the logging S3 key prefix does not comply with the documented constraints.
     * @throws InvalidS3BucketNameException
     *         The S3 bucket name is invalid. For more information about naming rules, go to <a
     *         href="http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Bucket Restrictions and
     *         Limitations</a> in the Amazon Simple Storage Service (S3) Developer Guide.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.EnableLogging
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EnableLogging" target="_top">AWS API
     *      Documentation</a>
     */
    default EnableLoggingResponse enableLogging(EnableLoggingRequest enableLoggingRequest) throws ClusterNotFoundException,
            BucketNotFoundException, InsufficientS3BucketPolicyException, InvalidS3KeyPrefixException,
            InvalidS3BucketNameException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableLoggingRequest.Builder} avoiding the need to
     * create one manually via {@link EnableLoggingRequest#builder()}
     * </p>
     *
     * @param enableLoggingRequest
     *        A {@link Consumer} that will call methods on {@link EnableLoggingMessage.Builder} to create a request.
     * @return Result of the EnableLogging operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws BucketNotFoundException
     *         Could not find the specified S3 bucket.
     * @throws InsufficientS3BucketPolicyException
     *         The cluster does not have read bucket or put object permissions on the S3 bucket specified when enabling
     *         logging.
     * @throws InvalidS3KeyPrefixException
     *         The string specified for the logging S3 key prefix does not comply with the documented constraints.
     * @throws InvalidS3BucketNameException
     *         The S3 bucket name is invalid. For more information about naming rules, go to <a
     *         href="http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Bucket Restrictions and
     *         Limitations</a> in the Amazon Simple Storage Service (S3) Developer Guide.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.EnableLogging
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EnableLogging" target="_top">AWS API
     *      Documentation</a>
     */
    default EnableLoggingResponse enableLogging(Consumer<EnableLoggingRequest.Builder> enableLoggingRequest)
            throws ClusterNotFoundException, BucketNotFoundException, InsufficientS3BucketPolicyException,
            InvalidS3KeyPrefixException, InvalidS3BucketNameException, AwsServiceException, SdkClientException, RedshiftException {
        return enableLogging(EnableLoggingRequest.builder().applyMutation(enableLoggingRequest).build());
    }

    /**
     * <p>
     * Enables the automatic copy of snapshots from one region to another region for a specified cluster.
     * </p>
     *
     * @param enableSnapshotCopyRequest
     * @return Result of the EnableSnapshotCopy operation returned by the service.
     * @throws IncompatibleOrderableOptionsException
     *         The specified options are incompatible.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws CopyToRegionDisabledException
     *         Cross-region snapshot copy was temporarily disabled. Try your request again.
     * @throws SnapshotCopyAlreadyEnabledException
     *         The cluster already has cross-region snapshot copy enabled.
     * @throws UnknownSnapshotCopyRegionException
     *         The specified region is incorrect or does not exist.
     * @throws UnauthorizedOperationException
     *         Your account is not authorized to perform the requested operation.
     * @throws SnapshotCopyGrantNotFoundException
     *         The specified snapshot copy grant can't be found. Make sure that the name is typed correctly and that the
     *         grant exists in the destination region.
     * @throws LimitExceededException
     *         The encryption key has exceeded its grant limit in AWS KMS.
     * @throws DependentServiceRequestThrottlingException
     *         The request cannot be completed because a dependent service is throttling requests made by Amazon
     *         Redshift on your behalf. Wait and retry the request.
     * @throws InvalidRetentionPeriodException
     *         The retention period specified is either in the past or is not a valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.EnableSnapshotCopy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EnableSnapshotCopy" target="_top">AWS
     *      API Documentation</a>
     */
    default EnableSnapshotCopyResponse enableSnapshotCopy(EnableSnapshotCopyRequest enableSnapshotCopyRequest)
            throws IncompatibleOrderableOptionsException, InvalidClusterStateException, ClusterNotFoundException,
            CopyToRegionDisabledException, SnapshotCopyAlreadyEnabledException, UnknownSnapshotCopyRegionException,
            UnauthorizedOperationException, SnapshotCopyGrantNotFoundException, LimitExceededException,
            DependentServiceRequestThrottlingException, InvalidRetentionPeriodException, AwsServiceException, SdkClientException,
            RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the automatic copy of snapshots from one region to another region for a specified cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableSnapshotCopyRequest.Builder} avoiding the
     * need to create one manually via {@link EnableSnapshotCopyRequest#builder()}
     * </p>
     *
     * @param enableSnapshotCopyRequest
     *        A {@link Consumer} that will call methods on {@link EnableSnapshotCopyMessage.Builder} to create a
     *        request.
     * @return Result of the EnableSnapshotCopy operation returned by the service.
     * @throws IncompatibleOrderableOptionsException
     *         The specified options are incompatible.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws CopyToRegionDisabledException
     *         Cross-region snapshot copy was temporarily disabled. Try your request again.
     * @throws SnapshotCopyAlreadyEnabledException
     *         The cluster already has cross-region snapshot copy enabled.
     * @throws UnknownSnapshotCopyRegionException
     *         The specified region is incorrect or does not exist.
     * @throws UnauthorizedOperationException
     *         Your account is not authorized to perform the requested operation.
     * @throws SnapshotCopyGrantNotFoundException
     *         The specified snapshot copy grant can't be found. Make sure that the name is typed correctly and that the
     *         grant exists in the destination region.
     * @throws LimitExceededException
     *         The encryption key has exceeded its grant limit in AWS KMS.
     * @throws DependentServiceRequestThrottlingException
     *         The request cannot be completed because a dependent service is throttling requests made by Amazon
     *         Redshift on your behalf. Wait and retry the request.
     * @throws InvalidRetentionPeriodException
     *         The retention period specified is either in the past or is not a valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.EnableSnapshotCopy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EnableSnapshotCopy" target="_top">AWS
     *      API Documentation</a>
     */
    default EnableSnapshotCopyResponse enableSnapshotCopy(Consumer<EnableSnapshotCopyRequest.Builder> enableSnapshotCopyRequest)
            throws IncompatibleOrderableOptionsException, InvalidClusterStateException, ClusterNotFoundException,
            CopyToRegionDisabledException, SnapshotCopyAlreadyEnabledException, UnknownSnapshotCopyRegionException,
            UnauthorizedOperationException, SnapshotCopyGrantNotFoundException, LimitExceededException,
            DependentServiceRequestThrottlingException, InvalidRetentionPeriodException, AwsServiceException, SdkClientException,
            RedshiftException {
        return enableSnapshotCopy(EnableSnapshotCopyRequest.builder().applyMutation(enableSnapshotCopyRequest).build());
    }

    /**
     * <p>
     * Returns a database user name and temporary password with temporary authorization to log on to an Amazon Redshift
     * database. The action returns the database user name prefixed with <code>IAM:</code> if <code>AutoCreate</code> is
     * <code>False</code> or <code>IAMA:</code> if <code>AutoCreate</code> is <code>True</code>. You can optionally
     * specify one or more database user groups that the user will join at log on. By default, the temporary credentials
     * expire in 900 seconds. You can optionally specify a duration between 900 seconds (15 minutes) and 3600 seconds
     * (60 minutes). For more information, see <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/generating-user-credentials.html">Using IAM Authentication
     * to Generate Database User Credentials</a> in the Amazon Redshift Cluster Management Guide.
     * </p>
     * <p>
     * The AWS Identity and Access Management (IAM)user or role that executes GetClusterCredentials must have an IAM
     * policy attached that allows access to all necessary actions and resources. For more information about
     * permissions, see <a href=
     * "http://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html#redshift-policy-resources.getclustercredentials-resources"
     * >Resource Policies for GetClusterCredentials</a> in the Amazon Redshift Cluster Management Guide.
     * </p>
     * <p>
     * If the <code>DbGroups</code> parameter is specified, the IAM policy must allow the
     * <code>redshift:JoinGroup</code> action with access to the listed <code>dbgroups</code>.
     * </p>
     * <p>
     * In addition, if the <code>AutoCreate</code> parameter is set to <code>True</code>, then the policy must include
     * the <code>redshift:CreateClusterUser</code> privilege.
     * </p>
     * <p>
     * If the <code>DbName</code> parameter is specified, the IAM policy must allow access to the resource
     * <code>dbname</code> for the specified database name.
     * </p>
     *
     * @param getClusterCredentialsRequest
     *        The request parameters to get cluster credentials.
     * @return Result of the GetClusterCredentials operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws UnsupportedOperationException
     *         The requested operation isn't supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.GetClusterCredentials
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetClusterCredentials" target="_top">AWS
     *      API Documentation</a>
     */
    default GetClusterCredentialsResponse getClusterCredentials(GetClusterCredentialsRequest getClusterCredentialsRequest)
            throws ClusterNotFoundException, UnsupportedOperationException, AwsServiceException, SdkClientException,
            RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a database user name and temporary password with temporary authorization to log on to an Amazon Redshift
     * database. The action returns the database user name prefixed with <code>IAM:</code> if <code>AutoCreate</code> is
     * <code>False</code> or <code>IAMA:</code> if <code>AutoCreate</code> is <code>True</code>. You can optionally
     * specify one or more database user groups that the user will join at log on. By default, the temporary credentials
     * expire in 900 seconds. You can optionally specify a duration between 900 seconds (15 minutes) and 3600 seconds
     * (60 minutes). For more information, see <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/generating-user-credentials.html">Using IAM Authentication
     * to Generate Database User Credentials</a> in the Amazon Redshift Cluster Management Guide.
     * </p>
     * <p>
     * The AWS Identity and Access Management (IAM)user or role that executes GetClusterCredentials must have an IAM
     * policy attached that allows access to all necessary actions and resources. For more information about
     * permissions, see <a href=
     * "http://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html#redshift-policy-resources.getclustercredentials-resources"
     * >Resource Policies for GetClusterCredentials</a> in the Amazon Redshift Cluster Management Guide.
     * </p>
     * <p>
     * If the <code>DbGroups</code> parameter is specified, the IAM policy must allow the
     * <code>redshift:JoinGroup</code> action with access to the listed <code>dbgroups</code>.
     * </p>
     * <p>
     * In addition, if the <code>AutoCreate</code> parameter is set to <code>True</code>, then the policy must include
     * the <code>redshift:CreateClusterUser</code> privilege.
     * </p>
     * <p>
     * If the <code>DbName</code> parameter is specified, the IAM policy must allow access to the resource
     * <code>dbname</code> for the specified database name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetClusterCredentialsRequest.Builder} avoiding the
     * need to create one manually via {@link GetClusterCredentialsRequest#builder()}
     * </p>
     *
     * @param getClusterCredentialsRequest
     *        A {@link Consumer} that will call methods on {@link GetClusterCredentialsMessage.Builder} to create a
     *        request. The request parameters to get cluster credentials.
     * @return Result of the GetClusterCredentials operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws UnsupportedOperationException
     *         The requested operation isn't supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.GetClusterCredentials
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetClusterCredentials" target="_top">AWS
     *      API Documentation</a>
     */
    default GetClusterCredentialsResponse getClusterCredentials(
            Consumer<GetClusterCredentialsRequest.Builder> getClusterCredentialsRequest) throws ClusterNotFoundException,
            UnsupportedOperationException, AwsServiceException, SdkClientException, RedshiftException {
        return getClusterCredentials(GetClusterCredentialsRequest.builder().applyMutation(getClusterCredentialsRequest).build());
    }

    /**
     * <p>
     * Returns an array of DC2 ReservedNodeOfferings that matches the payment type, term, and usage price of the given
     * DC1 reserved node.
     * </p>
     *
     * @param getReservedNodeExchangeOfferingsRequest
     * @return Result of the GetReservedNodeExchangeOfferings operation returned by the service.
     * @throws ReservedNodeNotFoundException
     *         The specified reserved compute node not found.
     * @throws InvalidReservedNodeStateException
     *         Indicates that the Reserved Node being exchanged is not in an active state.
     * @throws ReservedNodeAlreadyMigratedException
     *         Indicates that the reserved node has already been exchanged.
     * @throws ReservedNodeOfferingNotFoundException
     *         Specified offering does not exist.
     * @throws UnsupportedOperationException
     *         The requested operation isn't supported.
     * @throws DependentServiceUnavailableException
     *         Your request cannot be completed because a dependent internal service is temporarily unavailable. Wait 30
     *         to 60 seconds and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.GetReservedNodeExchangeOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetReservedNodeExchangeOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetReservedNodeExchangeOfferingsResponse getReservedNodeExchangeOfferings(
            GetReservedNodeExchangeOfferingsRequest getReservedNodeExchangeOfferingsRequest)
            throws ReservedNodeNotFoundException, InvalidReservedNodeStateException, ReservedNodeAlreadyMigratedException,
            ReservedNodeOfferingNotFoundException, UnsupportedOperationException, DependentServiceUnavailableException,
            AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of DC2 ReservedNodeOfferings that matches the payment type, term, and usage price of the given
     * DC1 reserved node.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReservedNodeExchangeOfferingsRequest.Builder}
     * avoiding the need to create one manually via {@link GetReservedNodeExchangeOfferingsRequest#builder()}
     * </p>
     *
     * @param getReservedNodeExchangeOfferingsRequest
     *        A {@link Consumer} that will call methods on {@link GetReservedNodeExchangeOfferingsInputMessage.Builder}
     *        to create a request.
     * @return Result of the GetReservedNodeExchangeOfferings operation returned by the service.
     * @throws ReservedNodeNotFoundException
     *         The specified reserved compute node not found.
     * @throws InvalidReservedNodeStateException
     *         Indicates that the Reserved Node being exchanged is not in an active state.
     * @throws ReservedNodeAlreadyMigratedException
     *         Indicates that the reserved node has already been exchanged.
     * @throws ReservedNodeOfferingNotFoundException
     *         Specified offering does not exist.
     * @throws UnsupportedOperationException
     *         The requested operation isn't supported.
     * @throws DependentServiceUnavailableException
     *         Your request cannot be completed because a dependent internal service is temporarily unavailable. Wait 30
     *         to 60 seconds and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.GetReservedNodeExchangeOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetReservedNodeExchangeOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetReservedNodeExchangeOfferingsResponse getReservedNodeExchangeOfferings(
            Consumer<GetReservedNodeExchangeOfferingsRequest.Builder> getReservedNodeExchangeOfferingsRequest)
            throws ReservedNodeNotFoundException, InvalidReservedNodeStateException, ReservedNodeAlreadyMigratedException,
            ReservedNodeOfferingNotFoundException, UnsupportedOperationException, DependentServiceUnavailableException,
            AwsServiceException, SdkClientException, RedshiftException {
        return getReservedNodeExchangeOfferings(GetReservedNodeExchangeOfferingsRequest.builder()
                .applyMutation(getReservedNodeExchangeOfferingsRequest).build());
    }

    /**
     * <p>
     * Modifies the settings for a cluster. For example, you can add another security or parameter group, update the
     * preferred maintenance window, or change the master user password. Resetting a cluster password or modifying the
     * security groups associated with a cluster do not need a reboot. However, modifying a parameter group requires a
     * reboot for parameters to take effect. For more information about managing clusters, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in
     * the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * You can also change node type and the number of nodes to scale up or down the cluster. When resizing a cluster,
     * you must specify both the number of nodes and the node type even if one of the parameters does not change.
     * </p>
     *
     * @param modifyClusterRequest
     * @return Result of the ModifyCluster operation returned by the service.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws InvalidClusterSecurityGroupStateException
     *         The state of the cluster security group is not <code>available</code>.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws NumberOfNodesQuotaExceededException
     *         The operation would exceed the number of nodes allotted to the account. For information about increasing
     *         your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws NumberOfNodesPerClusterLimitExceededException
     *         The operation would exceed the number of nodes allowed for a cluster.
     * @throws ClusterSecurityGroupNotFoundException
     *         The cluster security group name does not refer to an existing cluster security group.
     * @throws ClusterParameterGroupNotFoundException
     *         The parameter group name does not refer to an existing parameter group.
     * @throws InsufficientClusterCapacityException
     *         The number of nodes specified exceeds the allotted capacity of the cluster.
     * @throws UnsupportedOptionException
     *         A request option was specified that is not supported.
     * @throws UnauthorizedOperationException
     *         Your account is not authorized to perform the requested operation.
     * @throws HsmClientCertificateNotFoundException
     *         There is no Amazon Redshift HSM client certificate with the specified identifier.
     * @throws HsmConfigurationNotFoundException
     *         There is no Amazon Redshift HSM configuration with the specified identifier.
     * @throws ClusterAlreadyExistsException
     *         The account already has a cluster with the given identifier.
     * @throws LimitExceededException
     *         The encryption key has exceeded its grant limit in AWS KMS.
     * @throws DependentServiceRequestThrottlingException
     *         The request cannot be completed because a dependent service is throttling requests made by Amazon
     *         Redshift on your behalf. Wait and retry the request.
     * @throws InvalidElasticIpException
     *         The Elastic IP (EIP) is invalid or cannot be found.
     * @throws TableLimitExceededException
     *         The number of tables in the cluster exceeds the limit for the requested new cluster node type.
     * @throws InvalidClusterTrackException
     *         The provided cluster track name is not valid.
     * @throws InvalidRetentionPeriodException
     *         The retention period specified is either in the past or is not a valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ModifyCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyClusterResponse modifyCluster(ModifyClusterRequest modifyClusterRequest) throws InvalidClusterStateException,
            InvalidClusterSecurityGroupStateException, ClusterNotFoundException, NumberOfNodesQuotaExceededException,
            NumberOfNodesPerClusterLimitExceededException, ClusterSecurityGroupNotFoundException,
            ClusterParameterGroupNotFoundException, InsufficientClusterCapacityException, UnsupportedOptionException,
            UnauthorizedOperationException, HsmClientCertificateNotFoundException, HsmConfigurationNotFoundException,
            ClusterAlreadyExistsException, LimitExceededException, DependentServiceRequestThrottlingException,
            InvalidElasticIpException, TableLimitExceededException, InvalidClusterTrackException,
            InvalidRetentionPeriodException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the settings for a cluster. For example, you can add another security or parameter group, update the
     * preferred maintenance window, or change the master user password. Resetting a cluster password or modifying the
     * security groups associated with a cluster do not need a reboot. However, modifying a parameter group requires a
     * reboot for parameters to take effect. For more information about managing clusters, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in
     * the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * You can also change node type and the number of nodes to scale up or down the cluster. When resizing a cluster,
     * you must specify both the number of nodes and the node type even if one of the parameters does not change.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyClusterRequest.Builder} avoiding the need to
     * create one manually via {@link ModifyClusterRequest#builder()}
     * </p>
     *
     * @param modifyClusterRequest
     *        A {@link Consumer} that will call methods on {@link ModifyClusterMessage.Builder} to create a request.
     * @return Result of the ModifyCluster operation returned by the service.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws InvalidClusterSecurityGroupStateException
     *         The state of the cluster security group is not <code>available</code>.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws NumberOfNodesQuotaExceededException
     *         The operation would exceed the number of nodes allotted to the account. For information about increasing
     *         your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws NumberOfNodesPerClusterLimitExceededException
     *         The operation would exceed the number of nodes allowed for a cluster.
     * @throws ClusterSecurityGroupNotFoundException
     *         The cluster security group name does not refer to an existing cluster security group.
     * @throws ClusterParameterGroupNotFoundException
     *         The parameter group name does not refer to an existing parameter group.
     * @throws InsufficientClusterCapacityException
     *         The number of nodes specified exceeds the allotted capacity of the cluster.
     * @throws UnsupportedOptionException
     *         A request option was specified that is not supported.
     * @throws UnauthorizedOperationException
     *         Your account is not authorized to perform the requested operation.
     * @throws HsmClientCertificateNotFoundException
     *         There is no Amazon Redshift HSM client certificate with the specified identifier.
     * @throws HsmConfigurationNotFoundException
     *         There is no Amazon Redshift HSM configuration with the specified identifier.
     * @throws ClusterAlreadyExistsException
     *         The account already has a cluster with the given identifier.
     * @throws LimitExceededException
     *         The encryption key has exceeded its grant limit in AWS KMS.
     * @throws DependentServiceRequestThrottlingException
     *         The request cannot be completed because a dependent service is throttling requests made by Amazon
     *         Redshift on your behalf. Wait and retry the request.
     * @throws InvalidElasticIpException
     *         The Elastic IP (EIP) is invalid or cannot be found.
     * @throws TableLimitExceededException
     *         The number of tables in the cluster exceeds the limit for the requested new cluster node type.
     * @throws InvalidClusterTrackException
     *         The provided cluster track name is not valid.
     * @throws InvalidRetentionPeriodException
     *         The retention period specified is either in the past or is not a valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ModifyCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyClusterResponse modifyCluster(Consumer<ModifyClusterRequest.Builder> modifyClusterRequest)
            throws InvalidClusterStateException, InvalidClusterSecurityGroupStateException, ClusterNotFoundException,
            NumberOfNodesQuotaExceededException, NumberOfNodesPerClusterLimitExceededException,
            ClusterSecurityGroupNotFoundException, ClusterParameterGroupNotFoundException, InsufficientClusterCapacityException,
            UnsupportedOptionException, UnauthorizedOperationException, HsmClientCertificateNotFoundException,
            HsmConfigurationNotFoundException, ClusterAlreadyExistsException, LimitExceededException,
            DependentServiceRequestThrottlingException, InvalidElasticIpException, TableLimitExceededException,
            InvalidClusterTrackException, InvalidRetentionPeriodException, AwsServiceException, SdkClientException,
            RedshiftException {
        return modifyCluster(ModifyClusterRequest.builder().applyMutation(modifyClusterRequest).build());
    }

    /**
     * <p>
     * Modifies the database revision of a cluster. The database revision is a unique revision of the database running
     * in a cluster.
     * </p>
     *
     * @param modifyClusterDbRevisionRequest
     * @return Result of the ModifyClusterDbRevision operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws ClusterOnLatestRevisionException
     *         Cluster is already on the latest database revision.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ModifyClusterDbRevision
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterDbRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyClusterDbRevisionResponse modifyClusterDbRevision(ModifyClusterDbRevisionRequest modifyClusterDbRevisionRequest)
            throws ClusterNotFoundException, ClusterOnLatestRevisionException, InvalidClusterStateException, AwsServiceException,
            SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the database revision of a cluster. The database revision is a unique revision of the database running
     * in a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyClusterDbRevisionRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyClusterDbRevisionRequest#builder()}
     * </p>
     *
     * @param modifyClusterDbRevisionRequest
     *        A {@link Consumer} that will call methods on {@link ModifyClusterDbRevisionMessage.Builder} to create a
     *        request.
     * @return Result of the ModifyClusterDbRevision operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws ClusterOnLatestRevisionException
     *         Cluster is already on the latest database revision.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ModifyClusterDbRevision
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterDbRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyClusterDbRevisionResponse modifyClusterDbRevision(
            Consumer<ModifyClusterDbRevisionRequest.Builder> modifyClusterDbRevisionRequest) throws ClusterNotFoundException,
            ClusterOnLatestRevisionException, InvalidClusterStateException, AwsServiceException, SdkClientException,
            RedshiftException {
        return modifyClusterDbRevision(ModifyClusterDbRevisionRequest.builder().applyMutation(modifyClusterDbRevisionRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access
     * other AWS services.
     * </p>
     * <p>
     * A cluster can have up to 10 IAM roles associated at any time.
     * </p>
     *
     * @param modifyClusterIamRolesRequest
     * @return Result of the ModifyClusterIamRoles operation returned by the service.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ModifyClusterIamRoles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterIamRoles" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyClusterIamRolesResponse modifyClusterIamRoles(ModifyClusterIamRolesRequest modifyClusterIamRolesRequest)
            throws InvalidClusterStateException, ClusterNotFoundException, AwsServiceException, SdkClientException,
            RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the list of AWS Identity and Access Management (IAM) roles that can be used by the cluster to access
     * other AWS services.
     * </p>
     * <p>
     * A cluster can have up to 10 IAM roles associated at any time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyClusterIamRolesRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyClusterIamRolesRequest#builder()}
     * </p>
     *
     * @param modifyClusterIamRolesRequest
     *        A {@link Consumer} that will call methods on {@link ModifyClusterIamRolesMessage.Builder} to create a
     *        request.
     * @return Result of the ModifyClusterIamRoles operation returned by the service.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ModifyClusterIamRoles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterIamRoles" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyClusterIamRolesResponse modifyClusterIamRoles(
            Consumer<ModifyClusterIamRolesRequest.Builder> modifyClusterIamRolesRequest) throws InvalidClusterStateException,
            ClusterNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        return modifyClusterIamRoles(ModifyClusterIamRolesRequest.builder().applyMutation(modifyClusterIamRolesRequest).build());
    }

    /**
     * <p>
     * Modifies the maintenance settings of a cluster. For example, you can defer a maintenance window. You can also
     * update or cancel a deferment.
     * </p>
     *
     * @param modifyClusterMaintenanceRequest
     * @return Result of the ModifyClusterMaintenance operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ModifyClusterMaintenance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterMaintenance"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyClusterMaintenanceResponse modifyClusterMaintenance(
            ModifyClusterMaintenanceRequest modifyClusterMaintenanceRequest) throws ClusterNotFoundException,
            AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the maintenance settings of a cluster. For example, you can defer a maintenance window. You can also
     * update or cancel a deferment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyClusterMaintenanceRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyClusterMaintenanceRequest#builder()}
     * </p>
     *
     * @param modifyClusterMaintenanceRequest
     *        A {@link Consumer} that will call methods on {@link ModifyClusterMaintenanceMessage.Builder} to create a
     *        request.
     * @return Result of the ModifyClusterMaintenance operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ModifyClusterMaintenance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterMaintenance"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyClusterMaintenanceResponse modifyClusterMaintenance(
            Consumer<ModifyClusterMaintenanceRequest.Builder> modifyClusterMaintenanceRequest) throws ClusterNotFoundException,
            AwsServiceException, SdkClientException, RedshiftException {
        return modifyClusterMaintenance(ModifyClusterMaintenanceRequest.builder().applyMutation(modifyClusterMaintenanceRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the parameters of a parameter group.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param modifyClusterParameterGroupRequest
     * @return Result of the ModifyClusterParameterGroup operation returned by the service.
     * @throws ClusterParameterGroupNotFoundException
     *         The parameter group name does not refer to an existing parameter group.
     * @throws InvalidClusterParameterGroupStateException
     *         The cluster parameter group action can not be completed because another task is in progress that involves
     *         the parameter group. Wait a few moments and try the operation again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ModifyClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyClusterParameterGroupResponse modifyClusterParameterGroup(
            ModifyClusterParameterGroupRequest modifyClusterParameterGroupRequest) throws ClusterParameterGroupNotFoundException,
            InvalidClusterParameterGroupStateException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the parameters of a parameter group.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param modifyClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link ModifyClusterParameterGroupMessage.Builder} to create
     *        a request.
     * @return Result of the ModifyClusterParameterGroup operation returned by the service.
     * @throws ClusterParameterGroupNotFoundException
     *         The parameter group name does not refer to an existing parameter group.
     * @throws InvalidClusterParameterGroupStateException
     *         The cluster parameter group action can not be completed because another task is in progress that involves
     *         the parameter group. Wait a few moments and try the operation again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ModifyClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyClusterParameterGroupResponse modifyClusterParameterGroup(
            Consumer<ModifyClusterParameterGroupRequest.Builder> modifyClusterParameterGroupRequest)
            throws ClusterParameterGroupNotFoundException, InvalidClusterParameterGroupStateException, AwsServiceException,
            SdkClientException, RedshiftException {
        return modifyClusterParameterGroup(ModifyClusterParameterGroupRequest.builder()
                .applyMutation(modifyClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Modifies the settings for a snapshot.
     * </p>
     *
     * @param modifyClusterSnapshotRequest
     * @return Result of the ModifyClusterSnapshot operation returned by the service.
     * @throws InvalidClusterSnapshotStateException
     *         The specified cluster snapshot is not in the <code>available</code> state, or other accounts are
     *         authorized to access the snapshot.
     * @throws ClusterSnapshotNotFoundException
     *         The snapshot identifier does not refer to an existing cluster snapshot.
     * @throws InvalidRetentionPeriodException
     *         The retention period specified is either in the past or is not a valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ModifyClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyClusterSnapshotResponse modifyClusterSnapshot(ModifyClusterSnapshotRequest modifyClusterSnapshotRequest)
            throws InvalidClusterSnapshotStateException, ClusterSnapshotNotFoundException, InvalidRetentionPeriodException,
            AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the settings for a snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyClusterSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param modifyClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link ModifyClusterSnapshotMessage.Builder} to create a
     *        request.
     * @return Result of the ModifyClusterSnapshot operation returned by the service.
     * @throws InvalidClusterSnapshotStateException
     *         The specified cluster snapshot is not in the <code>available</code> state, or other accounts are
     *         authorized to access the snapshot.
     * @throws ClusterSnapshotNotFoundException
     *         The snapshot identifier does not refer to an existing cluster snapshot.
     * @throws InvalidRetentionPeriodException
     *         The retention period specified is either in the past or is not a valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ModifyClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyClusterSnapshotResponse modifyClusterSnapshot(
            Consumer<ModifyClusterSnapshotRequest.Builder> modifyClusterSnapshotRequest)
            throws InvalidClusterSnapshotStateException, ClusterSnapshotNotFoundException, InvalidRetentionPeriodException,
            AwsServiceException, SdkClientException, RedshiftException {
        return modifyClusterSnapshot(ModifyClusterSnapshotRequest.builder().applyMutation(modifyClusterSnapshotRequest).build());
    }

    /**
     * <p>
     * Modifies a snapshot schedule for a cluster.
     * </p>
     *
     * @param modifyClusterSnapshotScheduleRequest
     * @return Result of the ModifyClusterSnapshotSchedule operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws SnapshotScheduleNotFoundException
     *         We could not find the specified snapshot schedule.
     * @throws InvalidClusterSnapshotScheduleStateException
     *         The cluster snapshot schedule state is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ModifyClusterSnapshotSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyClusterSnapshotScheduleResponse modifyClusterSnapshotSchedule(
            ModifyClusterSnapshotScheduleRequest modifyClusterSnapshotScheduleRequest) throws ClusterNotFoundException,
            SnapshotScheduleNotFoundException, InvalidClusterSnapshotScheduleStateException, AwsServiceException,
            SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies a snapshot schedule for a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyClusterSnapshotScheduleRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyClusterSnapshotScheduleRequest#builder()}
     * </p>
     *
     * @param modifyClusterSnapshotScheduleRequest
     *        A {@link Consumer} that will call methods on {@link ModifyClusterSnapshotScheduleMessage.Builder} to
     *        create a request.
     * @return Result of the ModifyClusterSnapshotSchedule operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws SnapshotScheduleNotFoundException
     *         We could not find the specified snapshot schedule.
     * @throws InvalidClusterSnapshotScheduleStateException
     *         The cluster snapshot schedule state is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ModifyClusterSnapshotSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyClusterSnapshotScheduleResponse modifyClusterSnapshotSchedule(
            Consumer<ModifyClusterSnapshotScheduleRequest.Builder> modifyClusterSnapshotScheduleRequest)
            throws ClusterNotFoundException, SnapshotScheduleNotFoundException, InvalidClusterSnapshotScheduleStateException,
            AwsServiceException, SdkClientException, RedshiftException {
        return modifyClusterSnapshotSchedule(ModifyClusterSnapshotScheduleRequest.builder()
                .applyMutation(modifyClusterSnapshotScheduleRequest).build());
    }

    /**
     * <p>
     * Modifies a cluster subnet group to include the specified list of VPC subnets. The operation replaces the existing
     * list of subnets with the new list of subnets.
     * </p>
     *
     * @param modifyClusterSubnetGroupRequest
     * @return Result of the ModifyClusterSubnetGroup operation returned by the service.
     * @throws ClusterSubnetGroupNotFoundException
     *         The cluster subnet group name does not refer to an existing cluster subnet group.
     * @throws ClusterSubnetQuotaExceededException
     *         The request would result in user exceeding the allowed number of subnets in a cluster subnet groups. For
     *         information about increasing your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws SubnetAlreadyInUseException
     *         A specified subnet is already in use by another cluster.
     * @throws InvalidSubnetException
     *         The requested subnet is not valid, or not all of the subnets are in the same VPC.
     * @throws UnauthorizedOperationException
     *         Your account is not authorized to perform the requested operation.
     * @throws DependentServiceRequestThrottlingException
     *         The request cannot be completed because a dependent service is throttling requests made by Amazon
     *         Redshift on your behalf. Wait and retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ModifyClusterSubnetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyClusterSubnetGroupResponse modifyClusterSubnetGroup(
            ModifyClusterSubnetGroupRequest modifyClusterSubnetGroupRequest) throws ClusterSubnetGroupNotFoundException,
            ClusterSubnetQuotaExceededException, SubnetAlreadyInUseException, InvalidSubnetException,
            UnauthorizedOperationException, DependentServiceRequestThrottlingException, AwsServiceException, SdkClientException,
            RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies a cluster subnet group to include the specified list of VPC subnets. The operation replaces the existing
     * list of subnets with the new list of subnets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyClusterSubnetGroupRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyClusterSubnetGroupRequest#builder()}
     * </p>
     *
     * @param modifyClusterSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link ModifyClusterSubnetGroupMessage.Builder} to create a
     *        request.
     * @return Result of the ModifyClusterSubnetGroup operation returned by the service.
     * @throws ClusterSubnetGroupNotFoundException
     *         The cluster subnet group name does not refer to an existing cluster subnet group.
     * @throws ClusterSubnetQuotaExceededException
     *         The request would result in user exceeding the allowed number of subnets in a cluster subnet groups. For
     *         information about increasing your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws SubnetAlreadyInUseException
     *         A specified subnet is already in use by another cluster.
     * @throws InvalidSubnetException
     *         The requested subnet is not valid, or not all of the subnets are in the same VPC.
     * @throws UnauthorizedOperationException
     *         Your account is not authorized to perform the requested operation.
     * @throws DependentServiceRequestThrottlingException
     *         The request cannot be completed because a dependent service is throttling requests made by Amazon
     *         Redshift on your behalf. Wait and retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ModifyClusterSubnetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyClusterSubnetGroupResponse modifyClusterSubnetGroup(
            Consumer<ModifyClusterSubnetGroupRequest.Builder> modifyClusterSubnetGroupRequest)
            throws ClusterSubnetGroupNotFoundException, ClusterSubnetQuotaExceededException, SubnetAlreadyInUseException,
            InvalidSubnetException, UnauthorizedOperationException, DependentServiceRequestThrottlingException,
            AwsServiceException, SdkClientException, RedshiftException {
        return modifyClusterSubnetGroup(ModifyClusterSubnetGroupRequest.builder().applyMutation(modifyClusterSubnetGroupRequest)
                .build());
    }

    /**
     * <p>
     * Modifies an existing Amazon Redshift event notification subscription.
     * </p>
     *
     * @param modifyEventSubscriptionRequest
     * @return Result of the ModifyEventSubscription operation returned by the service.
     * @throws SubscriptionNotFoundException
     *         An Amazon Redshift event notification subscription with the specified name does not exist.
     * @throws SnsInvalidTopicException
     *         Amazon SNS has responded that there is a problem with the specified Amazon SNS topic.
     * @throws SnsNoAuthorizationException
     *         You do not have permission to publish to the specified Amazon SNS topic.
     * @throws SnsTopicArnNotFoundException
     *         An Amazon SNS topic with the specified Amazon Resource Name (ARN) does not exist.
     * @throws SubscriptionEventIdNotFoundException
     *         An Amazon Redshift event with the specified event ID does not exist.
     * @throws SubscriptionCategoryNotFoundException
     *         The value specified for the event category was not one of the allowed values, or it specified a category
     *         that does not apply to the specified source type. The allowed values are Configuration, Management,
     *         Monitoring, and Security.
     * @throws SubscriptionSeverityNotFoundException
     *         The value specified for the event severity was not one of the allowed values, or it specified a severity
     *         that does not apply to the specified source type. The allowed values are ERROR and INFO.
     * @throws SourceNotFoundException
     *         The specified Amazon Redshift event source could not be found.
     * @throws InvalidSubscriptionStateException
     *         The subscription request is invalid because it is a duplicate request. This subscription request is
     *         already in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ModifyEventSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyEventSubscriptionResponse modifyEventSubscription(ModifyEventSubscriptionRequest modifyEventSubscriptionRequest)
            throws SubscriptionNotFoundException, SnsInvalidTopicException, SnsNoAuthorizationException,
            SnsTopicArnNotFoundException, SubscriptionEventIdNotFoundException, SubscriptionCategoryNotFoundException,
            SubscriptionSeverityNotFoundException, SourceNotFoundException, InvalidSubscriptionStateException,
            AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an existing Amazon Redshift event notification subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyEventSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyEventSubscriptionRequest#builder()}
     * </p>
     *
     * @param modifyEventSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link ModifyEventSubscriptionMessage.Builder} to create a
     *        request.
     * @return Result of the ModifyEventSubscription operation returned by the service.
     * @throws SubscriptionNotFoundException
     *         An Amazon Redshift event notification subscription with the specified name does not exist.
     * @throws SnsInvalidTopicException
     *         Amazon SNS has responded that there is a problem with the specified Amazon SNS topic.
     * @throws SnsNoAuthorizationException
     *         You do not have permission to publish to the specified Amazon SNS topic.
     * @throws SnsTopicArnNotFoundException
     *         An Amazon SNS topic with the specified Amazon Resource Name (ARN) does not exist.
     * @throws SubscriptionEventIdNotFoundException
     *         An Amazon Redshift event with the specified event ID does not exist.
     * @throws SubscriptionCategoryNotFoundException
     *         The value specified for the event category was not one of the allowed values, or it specified a category
     *         that does not apply to the specified source type. The allowed values are Configuration, Management,
     *         Monitoring, and Security.
     * @throws SubscriptionSeverityNotFoundException
     *         The value specified for the event severity was not one of the allowed values, or it specified a severity
     *         that does not apply to the specified source type. The allowed values are ERROR and INFO.
     * @throws SourceNotFoundException
     *         The specified Amazon Redshift event source could not be found.
     * @throws InvalidSubscriptionStateException
     *         The subscription request is invalid because it is a duplicate request. This subscription request is
     *         already in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ModifyEventSubscription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyEventSubscriptionResponse modifyEventSubscription(
            Consumer<ModifyEventSubscriptionRequest.Builder> modifyEventSubscriptionRequest)
            throws SubscriptionNotFoundException, SnsInvalidTopicException, SnsNoAuthorizationException,
            SnsTopicArnNotFoundException, SubscriptionEventIdNotFoundException, SubscriptionCategoryNotFoundException,
            SubscriptionSeverityNotFoundException, SourceNotFoundException, InvalidSubscriptionStateException,
            AwsServiceException, SdkClientException, RedshiftException {
        return modifyEventSubscription(ModifyEventSubscriptionRequest.builder().applyMutation(modifyEventSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the number of days to retain snapshots in the destination AWS Region after they are copied from the
     * source AWS Region. By default, this operation only changes the retention period of copied automated snapshots.
     * The retention periods for both new and existing copied automated snapshots are updated with the new retention
     * period. You can set the manual option to change only the retention periods of copied manual snapshots. If you set
     * this option, only newly copied manual snapshots have the new retention period.
     * </p>
     *
     * @param modifySnapshotCopyRetentionPeriodRequest
     * @return Result of the ModifySnapshotCopyRetentionPeriod operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws SnapshotCopyDisabledException
     *         Cross-region snapshot copy was temporarily disabled. Try your request again.
     * @throws UnauthorizedOperationException
     *         Your account is not authorized to perform the requested operation.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws InvalidRetentionPeriodException
     *         The retention period specified is either in the past or is not a valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ModifySnapshotCopyRetentionPeriod
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifySnapshotCopyRetentionPeriod"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifySnapshotCopyRetentionPeriodResponse modifySnapshotCopyRetentionPeriod(
            ModifySnapshotCopyRetentionPeriodRequest modifySnapshotCopyRetentionPeriodRequest) throws ClusterNotFoundException,
            SnapshotCopyDisabledException, UnauthorizedOperationException, InvalidClusterStateException,
            InvalidRetentionPeriodException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the number of days to retain snapshots in the destination AWS Region after they are copied from the
     * source AWS Region. By default, this operation only changes the retention period of copied automated snapshots.
     * The retention periods for both new and existing copied automated snapshots are updated with the new retention
     * period. You can set the manual option to change only the retention periods of copied manual snapshots. If you set
     * this option, only newly copied manual snapshots have the new retention period.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifySnapshotCopyRetentionPeriodRequest.Builder}
     * avoiding the need to create one manually via {@link ModifySnapshotCopyRetentionPeriodRequest#builder()}
     * </p>
     *
     * @param modifySnapshotCopyRetentionPeriodRequest
     *        A {@link Consumer} that will call methods on {@link ModifySnapshotCopyRetentionPeriodMessage.Builder} to
     *        create a request.
     * @return Result of the ModifySnapshotCopyRetentionPeriod operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws SnapshotCopyDisabledException
     *         Cross-region snapshot copy was temporarily disabled. Try your request again.
     * @throws UnauthorizedOperationException
     *         Your account is not authorized to perform the requested operation.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws InvalidRetentionPeriodException
     *         The retention period specified is either in the past or is not a valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ModifySnapshotCopyRetentionPeriod
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifySnapshotCopyRetentionPeriod"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifySnapshotCopyRetentionPeriodResponse modifySnapshotCopyRetentionPeriod(
            Consumer<ModifySnapshotCopyRetentionPeriodRequest.Builder> modifySnapshotCopyRetentionPeriodRequest)
            throws ClusterNotFoundException, SnapshotCopyDisabledException, UnauthorizedOperationException,
            InvalidClusterStateException, InvalidRetentionPeriodException, AwsServiceException, SdkClientException,
            RedshiftException {
        return modifySnapshotCopyRetentionPeriod(ModifySnapshotCopyRetentionPeriodRequest.builder()
                .applyMutation(modifySnapshotCopyRetentionPeriodRequest).build());
    }

    /**
     * <p>
     * Modifies a snapshot schedule. Any schedule associated with a cluster is modified asynchronously.
     * </p>
     *
     * @param modifySnapshotScheduleRequest
     * @return Result of the ModifySnapshotSchedule operation returned by the service.
     * @throws InvalidScheduleException
     *         The schedule you submitted isn't valid.
     * @throws SnapshotScheduleNotFoundException
     *         We could not find the specified snapshot schedule.
     * @throws SnapshotScheduleUpdateInProgressException
     *         The specified snapshot schedule is already being updated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ModifySnapshotSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifySnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifySnapshotScheduleResponse modifySnapshotSchedule(ModifySnapshotScheduleRequest modifySnapshotScheduleRequest)
            throws InvalidScheduleException, SnapshotScheduleNotFoundException, SnapshotScheduleUpdateInProgressException,
            AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies a snapshot schedule. Any schedule associated with a cluster is modified asynchronously.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifySnapshotScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link ModifySnapshotScheduleRequest#builder()}
     * </p>
     *
     * @param modifySnapshotScheduleRequest
     *        A {@link Consumer} that will call methods on {@link ModifySnapshotScheduleMessage.Builder} to create a
     *        request.
     * @return Result of the ModifySnapshotSchedule operation returned by the service.
     * @throws InvalidScheduleException
     *         The schedule you submitted isn't valid.
     * @throws SnapshotScheduleNotFoundException
     *         We could not find the specified snapshot schedule.
     * @throws SnapshotScheduleUpdateInProgressException
     *         The specified snapshot schedule is already being updated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ModifySnapshotSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifySnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifySnapshotScheduleResponse modifySnapshotSchedule(
            Consumer<ModifySnapshotScheduleRequest.Builder> modifySnapshotScheduleRequest) throws InvalidScheduleException,
            SnapshotScheduleNotFoundException, SnapshotScheduleUpdateInProgressException, AwsServiceException,
            SdkClientException, RedshiftException {
        return modifySnapshotSchedule(ModifySnapshotScheduleRequest.builder().applyMutation(modifySnapshotScheduleRequest)
                .build());
    }

    /**
     * <p>
     * Allows you to purchase reserved nodes. Amazon Redshift offers a predefined set of reserved node offerings. You
     * can purchase one or more of the offerings. You can call the <a>DescribeReservedNodeOfferings</a> API to obtain
     * the available reserved node offerings. You can call this API by providing a specific reserved node offering and
     * the number of nodes you want to reserve.
     * </p>
     * <p>
     * For more information about reserved node offerings, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html">Purchasing Reserved
     * Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param purchaseReservedNodeOfferingRequest
     * @return Result of the PurchaseReservedNodeOffering operation returned by the service.
     * @throws ReservedNodeOfferingNotFoundException
     *         Specified offering does not exist.
     * @throws ReservedNodeAlreadyExistsException
     *         User already has a reservation with the given identifier.
     * @throws ReservedNodeQuotaExceededException
     *         Request would exceed the user's compute node quota. For information about increasing your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws UnsupportedOperationException
     *         The requested operation isn't supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.PurchaseReservedNodeOffering
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/PurchaseReservedNodeOffering"
     *      target="_top">AWS API Documentation</a>
     */
    default PurchaseReservedNodeOfferingResponse purchaseReservedNodeOffering(
            PurchaseReservedNodeOfferingRequest purchaseReservedNodeOfferingRequest)
            throws ReservedNodeOfferingNotFoundException, ReservedNodeAlreadyExistsException, ReservedNodeQuotaExceededException,
            UnsupportedOperationException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to purchase reserved nodes. Amazon Redshift offers a predefined set of reserved node offerings. You
     * can purchase one or more of the offerings. You can call the <a>DescribeReservedNodeOfferings</a> API to obtain
     * the available reserved node offerings. You can call this API by providing a specific reserved node offering and
     * the number of nodes you want to reserve.
     * </p>
     * <p>
     * For more information about reserved node offerings, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html">Purchasing Reserved
     * Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PurchaseReservedNodeOfferingRequest.Builder}
     * avoiding the need to create one manually via {@link PurchaseReservedNodeOfferingRequest#builder()}
     * </p>
     *
     * @param purchaseReservedNodeOfferingRequest
     *        A {@link Consumer} that will call methods on {@link PurchaseReservedNodeOfferingMessage.Builder} to create
     *        a request.
     * @return Result of the PurchaseReservedNodeOffering operation returned by the service.
     * @throws ReservedNodeOfferingNotFoundException
     *         Specified offering does not exist.
     * @throws ReservedNodeAlreadyExistsException
     *         User already has a reservation with the given identifier.
     * @throws ReservedNodeQuotaExceededException
     *         Request would exceed the user's compute node quota. For information about increasing your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws UnsupportedOperationException
     *         The requested operation isn't supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.PurchaseReservedNodeOffering
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/PurchaseReservedNodeOffering"
     *      target="_top">AWS API Documentation</a>
     */
    default PurchaseReservedNodeOfferingResponse purchaseReservedNodeOffering(
            Consumer<PurchaseReservedNodeOfferingRequest.Builder> purchaseReservedNodeOfferingRequest)
            throws ReservedNodeOfferingNotFoundException, ReservedNodeAlreadyExistsException, ReservedNodeQuotaExceededException,
            UnsupportedOperationException, AwsServiceException, SdkClientException, RedshiftException {
        return purchaseReservedNodeOffering(PurchaseReservedNodeOfferingRequest.builder()
                .applyMutation(purchaseReservedNodeOfferingRequest).build());
    }

    /**
     * <p>
     * Reboots a cluster. This action is taken as soon as possible. It results in a momentary outage to the cluster,
     * during which the cluster status is set to <code>rebooting</code>. A cluster event is created when the reboot is
     * completed. Any pending cluster modifications (see <a>ModifyCluster</a>) are applied at this reboot. For more
     * information about managing clusters, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in
     * the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param rebootClusterRequest
     * @return Result of the RebootCluster operation returned by the service.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.RebootCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RebootCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default RebootClusterResponse rebootCluster(RebootClusterRequest rebootClusterRequest) throws InvalidClusterStateException,
            ClusterNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Reboots a cluster. This action is taken as soon as possible. It results in a momentary outage to the cluster,
     * during which the cluster status is set to <code>rebooting</code>. A cluster event is created when the reboot is
     * completed. Any pending cluster modifications (see <a>ModifyCluster</a>) are applied at this reboot. For more
     * information about managing clusters, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in
     * the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebootClusterRequest.Builder} avoiding the need to
     * create one manually via {@link RebootClusterRequest#builder()}
     * </p>
     *
     * @param rebootClusterRequest
     *        A {@link Consumer} that will call methods on {@link RebootClusterMessage.Builder} to create a request.
     * @return Result of the RebootCluster operation returned by the service.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.RebootCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RebootCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default RebootClusterResponse rebootCluster(Consumer<RebootClusterRequest.Builder> rebootClusterRequest)
            throws InvalidClusterStateException, ClusterNotFoundException, AwsServiceException, SdkClientException,
            RedshiftException {
        return rebootCluster(RebootClusterRequest.builder().applyMutation(rebootClusterRequest).build());
    }

    /**
     * <p>
     * Sets one or more parameters of the specified parameter group to their default values and sets the source values
     * of the parameters to "engine-default". To reset the entire parameter group specify the <i>ResetAllParameters</i>
     * parameter. For parameter changes to take effect you must reboot any associated clusters.
     * </p>
     *
     * @param resetClusterParameterGroupRequest
     * @return Result of the ResetClusterParameterGroup operation returned by the service.
     * @throws InvalidClusterParameterGroupStateException
     *         The cluster parameter group action can not be completed because another task is in progress that involves
     *         the parameter group. Wait a few moments and try the operation again.
     * @throws ClusterParameterGroupNotFoundException
     *         The parameter group name does not refer to an existing parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ResetClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ResetClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ResetClusterParameterGroupResponse resetClusterParameterGroup(
            ResetClusterParameterGroupRequest resetClusterParameterGroupRequest)
            throws InvalidClusterParameterGroupStateException, ClusterParameterGroupNotFoundException, AwsServiceException,
            SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets one or more parameters of the specified parameter group to their default values and sets the source values
     * of the parameters to "engine-default". To reset the entire parameter group specify the <i>ResetAllParameters</i>
     * parameter. For parameter changes to take effect you must reboot any associated clusters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetClusterParameterGroupRequest.Builder} avoiding
     * the need to create one manually via {@link ResetClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param resetClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link ResetClusterParameterGroupMessage.Builder} to create a
     *        request.
     * @return Result of the ResetClusterParameterGroup operation returned by the service.
     * @throws InvalidClusterParameterGroupStateException
     *         The cluster parameter group action can not be completed because another task is in progress that involves
     *         the parameter group. Wait a few moments and try the operation again.
     * @throws ClusterParameterGroupNotFoundException
     *         The parameter group name does not refer to an existing parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ResetClusterParameterGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ResetClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ResetClusterParameterGroupResponse resetClusterParameterGroup(
            Consumer<ResetClusterParameterGroupRequest.Builder> resetClusterParameterGroupRequest)
            throws InvalidClusterParameterGroupStateException, ClusterParameterGroupNotFoundException, AwsServiceException,
            SdkClientException, RedshiftException {
        return resetClusterParameterGroup(ResetClusterParameterGroupRequest.builder()
                .applyMutation(resetClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Changes the size of the cluster. You can change the cluster's type, or change the number or type of nodes. The
     * default behavior is to use the elastic resize method. With an elastic resize, your cluster is available for read
     * and write operations more quickly than with the classic resize method.
     * </p>
     * <p>
     * Elastic resize operations have the following restrictions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can only resize clusters of the following types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * dc2.large
     * </p>
     * </li>
     * <li>
     * <p>
     * dc2.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * ds2.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * ds2.8xlarge
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * The type of nodes that you add must match the node type for the cluster.
     * </p>
     * </li>
     * </ul>
     *
     * @param resizeClusterRequest
     * @return Result of the ResizeCluster operation returned by the service.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws NumberOfNodesQuotaExceededException
     *         The operation would exceed the number of nodes allotted to the account. For information about increasing
     *         your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws NumberOfNodesPerClusterLimitExceededException
     *         The operation would exceed the number of nodes allowed for a cluster.
     * @throws InsufficientClusterCapacityException
     *         The number of nodes specified exceeds the allotted capacity of the cluster.
     * @throws UnsupportedOptionException
     *         A request option was specified that is not supported.
     * @throws UnsupportedOperationException
     *         The requested operation isn't supported.
     * @throws UnauthorizedOperationException
     *         Your account is not authorized to perform the requested operation.
     * @throws LimitExceededException
     *         The encryption key has exceeded its grant limit in AWS KMS.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ResizeCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ResizeCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default ResizeClusterResponse resizeCluster(ResizeClusterRequest resizeClusterRequest) throws InvalidClusterStateException,
            ClusterNotFoundException, NumberOfNodesQuotaExceededException, NumberOfNodesPerClusterLimitExceededException,
            InsufficientClusterCapacityException, UnsupportedOptionException, UnsupportedOperationException,
            UnauthorizedOperationException, LimitExceededException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the size of the cluster. You can change the cluster's type, or change the number or type of nodes. The
     * default behavior is to use the elastic resize method. With an elastic resize, your cluster is available for read
     * and write operations more quickly than with the classic resize method.
     * </p>
     * <p>
     * Elastic resize operations have the following restrictions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can only resize clusters of the following types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * dc2.large
     * </p>
     * </li>
     * <li>
     * <p>
     * dc2.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * ds2.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * ds2.8xlarge
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * The type of nodes that you add must match the node type for the cluster.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResizeClusterRequest.Builder} avoiding the need to
     * create one manually via {@link ResizeClusterRequest#builder()}
     * </p>
     *
     * @param resizeClusterRequest
     *        A {@link Consumer} that will call methods on {@link ResizeClusterMessage.Builder} to create a request.
     * @return Result of the ResizeCluster operation returned by the service.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws NumberOfNodesQuotaExceededException
     *         The operation would exceed the number of nodes allotted to the account. For information about increasing
     *         your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws NumberOfNodesPerClusterLimitExceededException
     *         The operation would exceed the number of nodes allowed for a cluster.
     * @throws InsufficientClusterCapacityException
     *         The number of nodes specified exceeds the allotted capacity of the cluster.
     * @throws UnsupportedOptionException
     *         A request option was specified that is not supported.
     * @throws UnsupportedOperationException
     *         The requested operation isn't supported.
     * @throws UnauthorizedOperationException
     *         Your account is not authorized to perform the requested operation.
     * @throws LimitExceededException
     *         The encryption key has exceeded its grant limit in AWS KMS.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.ResizeCluster
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ResizeCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default ResizeClusterResponse resizeCluster(Consumer<ResizeClusterRequest.Builder> resizeClusterRequest)
            throws InvalidClusterStateException, ClusterNotFoundException, NumberOfNodesQuotaExceededException,
            NumberOfNodesPerClusterLimitExceededException, InsufficientClusterCapacityException, UnsupportedOptionException,
            UnsupportedOperationException, UnauthorizedOperationException, LimitExceededException, AwsServiceException,
            SdkClientException, RedshiftException {
        return resizeCluster(ResizeClusterRequest.builder().applyMutation(resizeClusterRequest).build());
    }

    /**
     * <p>
     * Creates a new cluster from a snapshot. By default, Amazon Redshift creates the resulting cluster with the same
     * configuration as the original cluster from which the snapshot was created, except that the new cluster is created
     * with the default cluster security and parameter groups. After Amazon Redshift creates the cluster, you can use
     * the <a>ModifyCluster</a> API to associate a different security group and different parameter group with the
     * restored cluster. If you are using a DS node type, you can also choose to change to another DS node type of the
     * same size during restore.
     * </p>
     * <p>
     * If you restore a cluster into a VPC, you must provide a cluster subnet group where you want the cluster restored.
     * </p>
     * <p>
     * For more information about working with snapshots, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param restoreFromClusterSnapshotRequest
     * @return Result of the RestoreFromClusterSnapshot operation returned by the service.
     * @throws AccessToSnapshotDeniedException
     *         The owner of the specified snapshot has not authorized your account to access the snapshot.
     * @throws ClusterAlreadyExistsException
     *         The account already has a cluster with the given identifier.
     * @throws ClusterSnapshotNotFoundException
     *         The snapshot identifier does not refer to an existing cluster snapshot.
     * @throws ClusterQuotaExceededException
     *         The request would exceed the allowed number of cluster instances for this account. For information about
     *         increasing your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws InsufficientClusterCapacityException
     *         The number of nodes specified exceeds the allotted capacity of the cluster.
     * @throws InvalidClusterSnapshotStateException
     *         The specified cluster snapshot is not in the <code>available</code> state, or other accounts are
     *         authorized to access the snapshot.
     * @throws InvalidRestoreException
     *         The restore is invalid.
     * @throws NumberOfNodesQuotaExceededException
     *         The operation would exceed the number of nodes allotted to the account. For information about increasing
     *         your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws NumberOfNodesPerClusterLimitExceededException
     *         The operation would exceed the number of nodes allowed for a cluster.
     * @throws InvalidVpcNetworkStateException
     *         The cluster subnet group does not cover all Availability Zones.
     * @throws InvalidClusterSubnetGroupStateException
     *         The cluster subnet group cannot be deleted because it is in use.
     * @throws InvalidSubnetException
     *         The requested subnet is not valid, or not all of the subnets are in the same VPC.
     * @throws ClusterSubnetGroupNotFoundException
     *         The cluster subnet group name does not refer to an existing cluster subnet group.
     * @throws UnauthorizedOperationException
     *         Your account is not authorized to perform the requested operation.
     * @throws HsmClientCertificateNotFoundException
     *         There is no Amazon Redshift HSM client certificate with the specified identifier.
     * @throws HsmConfigurationNotFoundException
     *         There is no Amazon Redshift HSM configuration with the specified identifier.
     * @throws InvalidElasticIpException
     *         The Elastic IP (EIP) is invalid or cannot be found.
     * @throws ClusterParameterGroupNotFoundException
     *         The parameter group name does not refer to an existing parameter group.
     * @throws ClusterSecurityGroupNotFoundException
     *         The cluster security group name does not refer to an existing cluster security group.
     * @throws LimitExceededException
     *         The encryption key has exceeded its grant limit in AWS KMS.
     * @throws DependentServiceRequestThrottlingException
     *         The request cannot be completed because a dependent service is throttling requests made by Amazon
     *         Redshift on your behalf. Wait and retry the request.
     * @throws InvalidClusterTrackException
     *         The provided cluster track name is not valid.
     * @throws SnapshotScheduleNotFoundException
     *         We could not find the specified snapshot schedule.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.RestoreFromClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RestoreFromClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default RestoreFromClusterSnapshotResponse restoreFromClusterSnapshot(
            RestoreFromClusterSnapshotRequest restoreFromClusterSnapshotRequest) throws AccessToSnapshotDeniedException,
            ClusterAlreadyExistsException, ClusterSnapshotNotFoundException, ClusterQuotaExceededException,
            InsufficientClusterCapacityException, InvalidClusterSnapshotStateException, InvalidRestoreException,
            NumberOfNodesQuotaExceededException, NumberOfNodesPerClusterLimitExceededException, InvalidVpcNetworkStateException,
            InvalidClusterSubnetGroupStateException, InvalidSubnetException, ClusterSubnetGroupNotFoundException,
            UnauthorizedOperationException, HsmClientCertificateNotFoundException, HsmConfigurationNotFoundException,
            InvalidElasticIpException, ClusterParameterGroupNotFoundException, ClusterSecurityGroupNotFoundException,
            LimitExceededException, DependentServiceRequestThrottlingException, InvalidClusterTrackException,
            SnapshotScheduleNotFoundException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new cluster from a snapshot. By default, Amazon Redshift creates the resulting cluster with the same
     * configuration as the original cluster from which the snapshot was created, except that the new cluster is created
     * with the default cluster security and parameter groups. After Amazon Redshift creates the cluster, you can use
     * the <a>ModifyCluster</a> API to associate a different security group and different parameter group with the
     * restored cluster. If you are using a DS node type, you can also choose to change to another DS node type of the
     * same size during restore.
     * </p>
     * <p>
     * If you restore a cluster into a VPC, you must provide a cluster subnet group where you want the cluster restored.
     * </p>
     * <p>
     * For more information about working with snapshots, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreFromClusterSnapshotRequest.Builder} avoiding
     * the need to create one manually via {@link RestoreFromClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param restoreFromClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link RestoreFromClusterSnapshotMessage.Builder} to create a
     *        request.
     * @return Result of the RestoreFromClusterSnapshot operation returned by the service.
     * @throws AccessToSnapshotDeniedException
     *         The owner of the specified snapshot has not authorized your account to access the snapshot.
     * @throws ClusterAlreadyExistsException
     *         The account already has a cluster with the given identifier.
     * @throws ClusterSnapshotNotFoundException
     *         The snapshot identifier does not refer to an existing cluster snapshot.
     * @throws ClusterQuotaExceededException
     *         The request would exceed the allowed number of cluster instances for this account. For information about
     *         increasing your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws InsufficientClusterCapacityException
     *         The number of nodes specified exceeds the allotted capacity of the cluster.
     * @throws InvalidClusterSnapshotStateException
     *         The specified cluster snapshot is not in the <code>available</code> state, or other accounts are
     *         authorized to access the snapshot.
     * @throws InvalidRestoreException
     *         The restore is invalid.
     * @throws NumberOfNodesQuotaExceededException
     *         The operation would exceed the number of nodes allotted to the account. For information about increasing
     *         your quota, go to <a
     *         href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * @throws NumberOfNodesPerClusterLimitExceededException
     *         The operation would exceed the number of nodes allowed for a cluster.
     * @throws InvalidVpcNetworkStateException
     *         The cluster subnet group does not cover all Availability Zones.
     * @throws InvalidClusterSubnetGroupStateException
     *         The cluster subnet group cannot be deleted because it is in use.
     * @throws InvalidSubnetException
     *         The requested subnet is not valid, or not all of the subnets are in the same VPC.
     * @throws ClusterSubnetGroupNotFoundException
     *         The cluster subnet group name does not refer to an existing cluster subnet group.
     * @throws UnauthorizedOperationException
     *         Your account is not authorized to perform the requested operation.
     * @throws HsmClientCertificateNotFoundException
     *         There is no Amazon Redshift HSM client certificate with the specified identifier.
     * @throws HsmConfigurationNotFoundException
     *         There is no Amazon Redshift HSM configuration with the specified identifier.
     * @throws InvalidElasticIpException
     *         The Elastic IP (EIP) is invalid or cannot be found.
     * @throws ClusterParameterGroupNotFoundException
     *         The parameter group name does not refer to an existing parameter group.
     * @throws ClusterSecurityGroupNotFoundException
     *         The cluster security group name does not refer to an existing cluster security group.
     * @throws LimitExceededException
     *         The encryption key has exceeded its grant limit in AWS KMS.
     * @throws DependentServiceRequestThrottlingException
     *         The request cannot be completed because a dependent service is throttling requests made by Amazon
     *         Redshift on your behalf. Wait and retry the request.
     * @throws InvalidClusterTrackException
     *         The provided cluster track name is not valid.
     * @throws SnapshotScheduleNotFoundException
     *         We could not find the specified snapshot schedule.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.RestoreFromClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RestoreFromClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default RestoreFromClusterSnapshotResponse restoreFromClusterSnapshot(
            Consumer<RestoreFromClusterSnapshotRequest.Builder> restoreFromClusterSnapshotRequest)
            throws AccessToSnapshotDeniedException, ClusterAlreadyExistsException, ClusterSnapshotNotFoundException,
            ClusterQuotaExceededException, InsufficientClusterCapacityException, InvalidClusterSnapshotStateException,
            InvalidRestoreException, NumberOfNodesQuotaExceededException, NumberOfNodesPerClusterLimitExceededException,
            InvalidVpcNetworkStateException, InvalidClusterSubnetGroupStateException, InvalidSubnetException,
            ClusterSubnetGroupNotFoundException, UnauthorizedOperationException, HsmClientCertificateNotFoundException,
            HsmConfigurationNotFoundException, InvalidElasticIpException, ClusterParameterGroupNotFoundException,
            ClusterSecurityGroupNotFoundException, LimitExceededException, DependentServiceRequestThrottlingException,
            InvalidClusterTrackException, SnapshotScheduleNotFoundException, AwsServiceException, SdkClientException,
            RedshiftException {
        return restoreFromClusterSnapshot(RestoreFromClusterSnapshotRequest.builder()
                .applyMutation(restoreFromClusterSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates a new table from a table in an Amazon Redshift cluster snapshot. You must create the new table within the
     * Amazon Redshift cluster that the snapshot was taken from.
     * </p>
     * <p>
     * You cannot use <code>RestoreTableFromClusterSnapshot</code> to restore a table with the same name as an existing
     * table in an Amazon Redshift cluster. That is, you cannot overwrite an existing table in a cluster with a restored
     * table. If you want to replace your original table with a new, restored table, then rename or drop your original
     * table before you call <code>RestoreTableFromClusterSnapshot</code>. When you have renamed your original table,
     * then you can pass the original name of the table as the <code>NewTableName</code> parameter value in the call to
     * <code>RestoreTableFromClusterSnapshot</code>. This way, you can replace the original table with the table created
     * from the snapshot.
     * </p>
     *
     * @param restoreTableFromClusterSnapshotRequest
     * @return Result of the RestoreTableFromClusterSnapshot operation returned by the service.
     * @throws ClusterSnapshotNotFoundException
     *         The snapshot identifier does not refer to an existing cluster snapshot.
     * @throws InProgressTableRestoreQuotaExceededException
     *         You have exceeded the allowed number of table restore requests. Wait for your current table restore
     *         requests to complete before making a new request.
     * @throws InvalidClusterSnapshotStateException
     *         The specified cluster snapshot is not in the <code>available</code> state, or other accounts are
     *         authorized to access the snapshot.
     * @throws InvalidTableRestoreArgumentException
     *         The value specified for the <code>sourceDatabaseName</code>, <code>sourceSchemaName</code>, or
     *         <code>sourceTableName</code> parameter, or a combination of these, doesn't exist in the snapshot.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws UnsupportedOperationException
     *         The requested operation isn't supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.RestoreTableFromClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RestoreTableFromClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default RestoreTableFromClusterSnapshotResponse restoreTableFromClusterSnapshot(
            RestoreTableFromClusterSnapshotRequest restoreTableFromClusterSnapshotRequest)
            throws ClusterSnapshotNotFoundException, InProgressTableRestoreQuotaExceededException,
            InvalidClusterSnapshotStateException, InvalidTableRestoreArgumentException, ClusterNotFoundException,
            InvalidClusterStateException, UnsupportedOperationException, AwsServiceException, SdkClientException,
            RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new table from a table in an Amazon Redshift cluster snapshot. You must create the new table within the
     * Amazon Redshift cluster that the snapshot was taken from.
     * </p>
     * <p>
     * You cannot use <code>RestoreTableFromClusterSnapshot</code> to restore a table with the same name as an existing
     * table in an Amazon Redshift cluster. That is, you cannot overwrite an existing table in a cluster with a restored
     * table. If you want to replace your original table with a new, restored table, then rename or drop your original
     * table before you call <code>RestoreTableFromClusterSnapshot</code>. When you have renamed your original table,
     * then you can pass the original name of the table as the <code>NewTableName</code> parameter value in the call to
     * <code>RestoreTableFromClusterSnapshot</code>. This way, you can replace the original table with the table created
     * from the snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreTableFromClusterSnapshotRequest.Builder}
     * avoiding the need to create one manually via {@link RestoreTableFromClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param restoreTableFromClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link RestoreTableFromClusterSnapshotMessage.Builder} to
     *        create a request.
     * @return Result of the RestoreTableFromClusterSnapshot operation returned by the service.
     * @throws ClusterSnapshotNotFoundException
     *         The snapshot identifier does not refer to an existing cluster snapshot.
     * @throws InProgressTableRestoreQuotaExceededException
     *         You have exceeded the allowed number of table restore requests. Wait for your current table restore
     *         requests to complete before making a new request.
     * @throws InvalidClusterSnapshotStateException
     *         The specified cluster snapshot is not in the <code>available</code> state, or other accounts are
     *         authorized to access the snapshot.
     * @throws InvalidTableRestoreArgumentException
     *         The value specified for the <code>sourceDatabaseName</code>, <code>sourceSchemaName</code>, or
     *         <code>sourceTableName</code> parameter, or a combination of these, doesn't exist in the snapshot.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws UnsupportedOperationException
     *         The requested operation isn't supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.RestoreTableFromClusterSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RestoreTableFromClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default RestoreTableFromClusterSnapshotResponse restoreTableFromClusterSnapshot(
            Consumer<RestoreTableFromClusterSnapshotRequest.Builder> restoreTableFromClusterSnapshotRequest)
            throws ClusterSnapshotNotFoundException, InProgressTableRestoreQuotaExceededException,
            InvalidClusterSnapshotStateException, InvalidTableRestoreArgumentException, ClusterNotFoundException,
            InvalidClusterStateException, UnsupportedOperationException, AwsServiceException, SdkClientException,
            RedshiftException {
        return restoreTableFromClusterSnapshot(RestoreTableFromClusterSnapshotRequest.builder()
                .applyMutation(restoreTableFromClusterSnapshotRequest).build());
    }

    /**
     * <p>
     * Revokes an ingress rule in an Amazon Redshift security group for a previously authorized IP range or Amazon EC2
     * security group. To add an ingress rule, see <a>AuthorizeClusterSecurityGroupIngress</a>. For information about
     * managing security groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster
     * Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param revokeClusterSecurityGroupIngressRequest
     * @return Result of the RevokeClusterSecurityGroupIngress operation returned by the service.
     * @throws ClusterSecurityGroupNotFoundException
     *         The cluster security group name does not refer to an existing cluster security group.
     * @throws AuthorizationNotFoundException
     *         The specified CIDR IP range or EC2 security group is not authorized for the specified cluster security
     *         group.
     * @throws InvalidClusterSecurityGroupStateException
     *         The state of the cluster security group is not <code>available</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.RevokeClusterSecurityGroupIngress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RevokeClusterSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    default RevokeClusterSecurityGroupIngressResponse revokeClusterSecurityGroupIngress(
            RevokeClusterSecurityGroupIngressRequest revokeClusterSecurityGroupIngressRequest)
            throws ClusterSecurityGroupNotFoundException, AuthorizationNotFoundException,
            InvalidClusterSecurityGroupStateException, AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Revokes an ingress rule in an Amazon Redshift security group for a previously authorized IP range or Amazon EC2
     * security group. To add an ingress rule, see <a>AuthorizeClusterSecurityGroupIngress</a>. For information about
     * managing security groups, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster
     * Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RevokeClusterSecurityGroupIngressRequest.Builder}
     * avoiding the need to create one manually via {@link RevokeClusterSecurityGroupIngressRequest#builder()}
     * </p>
     *
     * @param revokeClusterSecurityGroupIngressRequest
     *        A {@link Consumer} that will call methods on {@link RevokeClusterSecurityGroupIngressMessage.Builder} to
     *        create a request.
     * @return Result of the RevokeClusterSecurityGroupIngress operation returned by the service.
     * @throws ClusterSecurityGroupNotFoundException
     *         The cluster security group name does not refer to an existing cluster security group.
     * @throws AuthorizationNotFoundException
     *         The specified CIDR IP range or EC2 security group is not authorized for the specified cluster security
     *         group.
     * @throws InvalidClusterSecurityGroupStateException
     *         The state of the cluster security group is not <code>available</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.RevokeClusterSecurityGroupIngress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RevokeClusterSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    default RevokeClusterSecurityGroupIngressResponse revokeClusterSecurityGroupIngress(
            Consumer<RevokeClusterSecurityGroupIngressRequest.Builder> revokeClusterSecurityGroupIngressRequest)
            throws ClusterSecurityGroupNotFoundException, AuthorizationNotFoundException,
            InvalidClusterSecurityGroupStateException, AwsServiceException, SdkClientException, RedshiftException {
        return revokeClusterSecurityGroupIngress(RevokeClusterSecurityGroupIngressRequest.builder()
                .applyMutation(revokeClusterSecurityGroupIngressRequest).build());
    }

    /**
     * <p>
     * Removes the ability of the specified AWS customer account to restore the specified snapshot. If the account is
     * currently restoring the snapshot, the restore will run to completion.
     * </p>
     * <p>
     * For more information about working with snapshots, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param revokeSnapshotAccessRequest
     * @return Result of the RevokeSnapshotAccess operation returned by the service.
     * @throws AccessToSnapshotDeniedException
     *         The owner of the specified snapshot has not authorized your account to access the snapshot.
     * @throws AuthorizationNotFoundException
     *         The specified CIDR IP range or EC2 security group is not authorized for the specified cluster security
     *         group.
     * @throws ClusterSnapshotNotFoundException
     *         The snapshot identifier does not refer to an existing cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.RevokeSnapshotAccess
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RevokeSnapshotAccess" target="_top">AWS
     *      API Documentation</a>
     */
    default RevokeSnapshotAccessResponse revokeSnapshotAccess(RevokeSnapshotAccessRequest revokeSnapshotAccessRequest)
            throws AccessToSnapshotDeniedException, AuthorizationNotFoundException, ClusterSnapshotNotFoundException,
            AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the ability of the specified AWS customer account to restore the specified snapshot. If the account is
     * currently restoring the snapshot, the restore will run to completion.
     * </p>
     * <p>
     * For more information about working with snapshots, go to <a
     * href="http://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RevokeSnapshotAccessRequest.Builder} avoiding the
     * need to create one manually via {@link RevokeSnapshotAccessRequest#builder()}
     * </p>
     *
     * @param revokeSnapshotAccessRequest
     *        A {@link Consumer} that will call methods on {@link RevokeSnapshotAccessMessage.Builder} to create a
     *        request.
     * @return Result of the RevokeSnapshotAccess operation returned by the service.
     * @throws AccessToSnapshotDeniedException
     *         The owner of the specified snapshot has not authorized your account to access the snapshot.
     * @throws AuthorizationNotFoundException
     *         The specified CIDR IP range or EC2 security group is not authorized for the specified cluster security
     *         group.
     * @throws ClusterSnapshotNotFoundException
     *         The snapshot identifier does not refer to an existing cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.RevokeSnapshotAccess
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RevokeSnapshotAccess" target="_top">AWS
     *      API Documentation</a>
     */
    default RevokeSnapshotAccessResponse revokeSnapshotAccess(
            Consumer<RevokeSnapshotAccessRequest.Builder> revokeSnapshotAccessRequest) throws AccessToSnapshotDeniedException,
            AuthorizationNotFoundException, ClusterSnapshotNotFoundException, AwsServiceException, SdkClientException,
            RedshiftException {
        return revokeSnapshotAccess(RevokeSnapshotAccessRequest.builder().applyMutation(revokeSnapshotAccessRequest).build());
    }

    /**
     * <p>
     * Rotates the encryption keys for a cluster.
     * </p>
     *
     * @param rotateEncryptionKeyRequest
     * @return Result of the RotateEncryptionKey operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws DependentServiceRequestThrottlingException
     *         The request cannot be completed because a dependent service is throttling requests made by Amazon
     *         Redshift on your behalf. Wait and retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.RotateEncryptionKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RotateEncryptionKey" target="_top">AWS
     *      API Documentation</a>
     */
    default RotateEncryptionKeyResponse rotateEncryptionKey(RotateEncryptionKeyRequest rotateEncryptionKeyRequest)
            throws ClusterNotFoundException, InvalidClusterStateException, DependentServiceRequestThrottlingException,
            AwsServiceException, SdkClientException, RedshiftException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Rotates the encryption keys for a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RotateEncryptionKeyRequest.Builder} avoiding the
     * need to create one manually via {@link RotateEncryptionKeyRequest#builder()}
     * </p>
     *
     * @param rotateEncryptionKeyRequest
     *        A {@link Consumer} that will call methods on {@link RotateEncryptionKeyMessage.Builder} to create a
     *        request.
     * @return Result of the RotateEncryptionKey operation returned by the service.
     * @throws ClusterNotFoundException
     *         The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
     * @throws InvalidClusterStateException
     *         The specified cluster is not in the <code>available</code> state.
     * @throws DependentServiceRequestThrottlingException
     *         The request cannot be completed because a dependent service is throttling requests made by Amazon
     *         Redshift on your behalf. Wait and retry the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftClient.RotateEncryptionKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RotateEncryptionKey" target="_top">AWS
     *      API Documentation</a>
     */
    default RotateEncryptionKeyResponse rotateEncryptionKey(
            Consumer<RotateEncryptionKeyRequest.Builder> rotateEncryptionKeyRequest) throws ClusterNotFoundException,
            InvalidClusterStateException, DependentServiceRequestThrottlingException, AwsServiceException, SdkClientException,
            RedshiftException {
        return rotateEncryptionKey(RotateEncryptionKeyRequest.builder().applyMutation(rotateEncryptionKeyRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("redshift");
    }
}
