/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.ActivityStreamModeListCopier;
import software.amazon.awssdk.services.rds.model.AvailabilityZone;
import software.amazon.awssdk.services.rds.model.AvailabilityZoneListCopier;
import software.amazon.awssdk.services.rds.model.AvailableProcessorFeature;
import software.amazon.awssdk.services.rds.model.AvailableProcessorFeatureListCopier;
import software.amazon.awssdk.services.rds.model.EngineModeListCopier;
import software.amazon.awssdk.services.rds.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrderableDBInstanceOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrderableDBInstanceOption> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::engine)).setter(OrderableDBInstanceOption.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::engineVersion)).setter(OrderableDBInstanceOption.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBInstanceClass").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::dbInstanceClass)).setter(OrderableDBInstanceOption.setter(Builder::dbInstanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()}).build();
    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseModel").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::licenseModel)).setter(OrderableDBInstanceOption.setter(Builder::licenseModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneGroup").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::availabilityZoneGroup)).setter(OrderableDBInstanceOption.setter(Builder::availabilityZoneGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneGroup").build()}).build();
    private static final SdkField<List<AvailabilityZone>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::availabilityZones)).setter(OrderableDBInstanceOption.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName("AvailabilityZone").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AvailabilityZone::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build()).build()}).build();
    private static final SdkField<Boolean> MULTI_AZ_CAPABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MultiAZCapable").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::multiAZCapable)).setter(OrderableDBInstanceOption.setter(Builder::multiAZCapable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZCapable").build()}).build();
    private static final SdkField<Boolean> READ_REPLICA_CAPABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ReadReplicaCapable").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::readReplicaCapable)).setter(OrderableDBInstanceOption.setter(Builder::readReplicaCapable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadReplicaCapable").build()}).build();
    private static final SdkField<Boolean> VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Vpc").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::vpc)).setter(OrderableDBInstanceOption.setter(Builder::vpc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpc").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_STORAGE_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsStorageEncryption").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::supportsStorageEncryption)).setter(OrderableDBInstanceOption.setter(Builder::supportsStorageEncryption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsStorageEncryption").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::storageType)).setter(OrderableDBInstanceOption.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsIops").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::supportsIops)).setter(OrderableDBInstanceOption.setter(Builder::supportsIops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsIops").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_ENHANCED_MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsEnhancedMonitoring").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::supportsEnhancedMonitoring)).setter(OrderableDBInstanceOption.setter(Builder::supportsEnhancedMonitoring)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsEnhancedMonitoring").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsIAMDatabaseAuthentication").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::supportsIAMDatabaseAuthentication)).setter(OrderableDBInstanceOption.setter(Builder::supportsIAMDatabaseAuthentication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsIAMDatabaseAuthentication").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_PERFORMANCE_INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsPerformanceInsights").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::supportsPerformanceInsights)).setter(OrderableDBInstanceOption.setter(Builder::supportsPerformanceInsights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsPerformanceInsights").build()}).build();
    private static final SdkField<Integer> MIN_STORAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinStorageSize").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::minStorageSize)).setter(OrderableDBInstanceOption.setter(Builder::minStorageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinStorageSize").build()}).build();
    private static final SdkField<Integer> MAX_STORAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxStorageSize").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::maxStorageSize)).setter(OrderableDBInstanceOption.setter(Builder::maxStorageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxStorageSize").build()}).build();
    private static final SdkField<Integer> MIN_IOPS_PER_DB_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinIopsPerDbInstance").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::minIopsPerDbInstance)).setter(OrderableDBInstanceOption.setter(Builder::minIopsPerDbInstance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinIopsPerDbInstance").build()}).build();
    private static final SdkField<Integer> MAX_IOPS_PER_DB_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxIopsPerDbInstance").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::maxIopsPerDbInstance)).setter(OrderableDBInstanceOption.setter(Builder::maxIopsPerDbInstance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxIopsPerDbInstance").build()}).build();
    private static final SdkField<Double> MIN_IOPS_PER_GIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MinIopsPerGib").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::minIopsPerGib)).setter(OrderableDBInstanceOption.setter(Builder::minIopsPerGib)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinIopsPerGib").build()}).build();
    private static final SdkField<Double> MAX_IOPS_PER_GIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MaxIopsPerGib").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::maxIopsPerGib)).setter(OrderableDBInstanceOption.setter(Builder::maxIopsPerGib)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxIopsPerGib").build()}).build();
    private static final SdkField<List<AvailableProcessorFeature>> AVAILABLE_PROCESSOR_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailableProcessorFeatures").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::availableProcessorFeatures)).setter(OrderableDBInstanceOption.setter(Builder::availableProcessorFeatures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableProcessorFeatures").build(), ListTrait.builder().memberLocationName("AvailableProcessorFeature").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AvailableProcessorFeature::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableProcessorFeature").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_ENGINE_MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedEngineModes").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::supportedEngineModes)).setter(OrderableDBInstanceOption.setter(Builder::supportedEngineModes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedEngineModes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SUPPORTS_STORAGE_AUTOSCALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsStorageAutoscaling").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::supportsStorageAutoscaling)).setter(OrderableDBInstanceOption.setter(Builder::supportsStorageAutoscaling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsStorageAutoscaling").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_KERBEROS_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsKerberosAuthentication").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::supportsKerberosAuthentication)).setter(OrderableDBInstanceOption.setter(Builder::supportsKerberosAuthentication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsKerberosAuthentication").build()}).build();
    private static final SdkField<Boolean> OUTPOST_CAPABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("OutpostCapable").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::outpostCapable)).setter(OrderableDBInstanceOption.setter(Builder::outpostCapable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostCapable").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_ACTIVITY_STREAM_MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedActivityStreamModes").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::supportedActivityStreamModes)).setter(OrderableDBInstanceOption.setter(Builder::supportedActivityStreamModes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedActivityStreamModes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SUPPORTS_GLOBAL_DATABASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsGlobalDatabases").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::supportsGlobalDatabases)).setter(OrderableDBInstanceOption.setter(Builder::supportsGlobalDatabases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsGlobalDatabases").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsClusters").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::supportsClusters)).setter(OrderableDBInstanceOption.setter(Builder::supportsClusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsClusters").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_NETWORK_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedNetworkTypes").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::supportedNetworkTypes)).setter(OrderableDBInstanceOption.setter(Builder::supportedNetworkTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedNetworkTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SUPPORTS_STORAGE_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsStorageThroughput").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::supportsStorageThroughput)).setter(OrderableDBInstanceOption.setter(Builder::supportsStorageThroughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsStorageThroughput").build()}).build();
    private static final SdkField<Integer> MIN_STORAGE_THROUGHPUT_PER_DB_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinStorageThroughputPerDbInstance").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::minStorageThroughputPerDbInstance)).setter(OrderableDBInstanceOption.setter(Builder::minStorageThroughputPerDbInstance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinStorageThroughputPerDbInstance").build()}).build();
    private static final SdkField<Integer> MAX_STORAGE_THROUGHPUT_PER_DB_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxStorageThroughputPerDbInstance").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::maxStorageThroughputPerDbInstance)).setter(OrderableDBInstanceOption.setter(Builder::maxStorageThroughputPerDbInstance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxStorageThroughputPerDbInstance").build()}).build();
    private static final SdkField<Double> MIN_STORAGE_THROUGHPUT_PER_IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MinStorageThroughputPerIops").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::minStorageThroughputPerIops)).setter(OrderableDBInstanceOption.setter(Builder::minStorageThroughputPerIops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinStorageThroughputPerIops").build()}).build();
    private static final SdkField<Double> MAX_STORAGE_THROUGHPUT_PER_IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MaxStorageThroughputPerIops").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::maxStorageThroughputPerIops)).setter(OrderableDBInstanceOption.setter(Builder::maxStorageThroughputPerIops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxStorageThroughputPerIops").build()}).build();
    private static final SdkField<Boolean> SUPPORTS_DEDICATED_LOG_VOLUME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsDedicatedLogVolume").getter(OrderableDBInstanceOption.getter(OrderableDBInstanceOption::supportsDedicatedLogVolume)).setter(OrderableDBInstanceOption.setter(Builder::supportsDedicatedLogVolume)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsDedicatedLogVolume").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD, ENGINE_VERSION_FIELD, DB_INSTANCE_CLASS_FIELD, LICENSE_MODEL_FIELD, AVAILABILITY_ZONE_GROUP_FIELD, AVAILABILITY_ZONES_FIELD, MULTI_AZ_CAPABLE_FIELD, READ_REPLICA_CAPABLE_FIELD, VPC_FIELD, SUPPORTS_STORAGE_ENCRYPTION_FIELD, STORAGE_TYPE_FIELD, SUPPORTS_IOPS_FIELD, SUPPORTS_ENHANCED_MONITORING_FIELD, SUPPORTS_IAM_DATABASE_AUTHENTICATION_FIELD, SUPPORTS_PERFORMANCE_INSIGHTS_FIELD, MIN_STORAGE_SIZE_FIELD, MAX_STORAGE_SIZE_FIELD, MIN_IOPS_PER_DB_INSTANCE_FIELD, MAX_IOPS_PER_DB_INSTANCE_FIELD, MIN_IOPS_PER_GIB_FIELD, MAX_IOPS_PER_GIB_FIELD, AVAILABLE_PROCESSOR_FEATURES_FIELD, SUPPORTED_ENGINE_MODES_FIELD, SUPPORTS_STORAGE_AUTOSCALING_FIELD, SUPPORTS_KERBEROS_AUTHENTICATION_FIELD, OUTPOST_CAPABLE_FIELD, SUPPORTED_ACTIVITY_STREAM_MODES_FIELD, SUPPORTS_GLOBAL_DATABASES_FIELD, SUPPORTS_CLUSTERS_FIELD, SUPPORTED_NETWORK_TYPES_FIELD, SUPPORTS_STORAGE_THROUGHPUT_FIELD, MIN_STORAGE_THROUGHPUT_PER_DB_INSTANCE_FIELD, MAX_STORAGE_THROUGHPUT_PER_DB_INSTANCE_FIELD, MIN_STORAGE_THROUGHPUT_PER_IOPS_FIELD, MAX_STORAGE_THROUGHPUT_PER_IOPS_FIELD, SUPPORTS_DEDICATED_LOG_VOLUME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OrderableDBInstanceOption.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String engine;
    private final String engineVersion;
    private final String dbInstanceClass;
    private final String licenseModel;
    private final String availabilityZoneGroup;
    private final List<AvailabilityZone> availabilityZones;
    private final Boolean multiAZCapable;
    private final Boolean readReplicaCapable;
    private final Boolean vpc;
    private final Boolean supportsStorageEncryption;
    private final String storageType;
    private final Boolean supportsIops;
    private final Boolean supportsEnhancedMonitoring;
    private final Boolean supportsIAMDatabaseAuthentication;
    private final Boolean supportsPerformanceInsights;
    private final Integer minStorageSize;
    private final Integer maxStorageSize;
    private final Integer minIopsPerDbInstance;
    private final Integer maxIopsPerDbInstance;
    private final Double minIopsPerGib;
    private final Double maxIopsPerGib;
    private final List<AvailableProcessorFeature> availableProcessorFeatures;
    private final List<String> supportedEngineModes;
    private final Boolean supportsStorageAutoscaling;
    private final Boolean supportsKerberosAuthentication;
    private final Boolean outpostCapable;
    private final List<String> supportedActivityStreamModes;
    private final Boolean supportsGlobalDatabases;
    private final Boolean supportsClusters;
    private final List<String> supportedNetworkTypes;
    private final Boolean supportsStorageThroughput;
    private final Integer minStorageThroughputPerDbInstance;
    private final Integer maxStorageThroughputPerDbInstance;
    private final Double minStorageThroughputPerIops;
    private final Double maxStorageThroughputPerIops;
    private final Boolean supportsDedicatedLogVolume;

    private OrderableDBInstanceOption(BuilderImpl builder) {
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.licenseModel = builder.licenseModel;
        this.availabilityZoneGroup = builder.availabilityZoneGroup;
        this.availabilityZones = builder.availabilityZones;
        this.multiAZCapable = builder.multiAZCapable;
        this.readReplicaCapable = builder.readReplicaCapable;
        this.vpc = builder.vpc;
        this.supportsStorageEncryption = builder.supportsStorageEncryption;
        this.storageType = builder.storageType;
        this.supportsIops = builder.supportsIops;
        this.supportsEnhancedMonitoring = builder.supportsEnhancedMonitoring;
        this.supportsIAMDatabaseAuthentication = builder.supportsIAMDatabaseAuthentication;
        this.supportsPerformanceInsights = builder.supportsPerformanceInsights;
        this.minStorageSize = builder.minStorageSize;
        this.maxStorageSize = builder.maxStorageSize;
        this.minIopsPerDbInstance = builder.minIopsPerDbInstance;
        this.maxIopsPerDbInstance = builder.maxIopsPerDbInstance;
        this.minIopsPerGib = builder.minIopsPerGib;
        this.maxIopsPerGib = builder.maxIopsPerGib;
        this.availableProcessorFeatures = builder.availableProcessorFeatures;
        this.supportedEngineModes = builder.supportedEngineModes;
        this.supportsStorageAutoscaling = builder.supportsStorageAutoscaling;
        this.supportsKerberosAuthentication = builder.supportsKerberosAuthentication;
        this.outpostCapable = builder.outpostCapable;
        this.supportedActivityStreamModes = builder.supportedActivityStreamModes;
        this.supportsGlobalDatabases = builder.supportsGlobalDatabases;
        this.supportsClusters = builder.supportsClusters;
        this.supportedNetworkTypes = builder.supportedNetworkTypes;
        this.supportsStorageThroughput = builder.supportsStorageThroughput;
        this.minStorageThroughputPerDbInstance = builder.minStorageThroughputPerDbInstance;
        this.maxStorageThroughputPerDbInstance = builder.maxStorageThroughputPerDbInstance;
        this.minStorageThroughputPerIops = builder.minStorageThroughputPerIops;
        this.maxStorageThroughputPerIops = builder.maxStorageThroughputPerIops;
        this.supportsDedicatedLogVolume = builder.supportsDedicatedLogVolume;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String dbInstanceClass() {
        return this.dbInstanceClass;
    }

    public final String licenseModel() {
        return this.licenseModel;
    }

    public final String availabilityZoneGroup() {
        return this.availabilityZoneGroup;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<AvailabilityZone> availabilityZones() {
        return this.availabilityZones;
    }

    public final Boolean multiAZCapable() {
        return this.multiAZCapable;
    }

    public final Boolean readReplicaCapable() {
        return this.readReplicaCapable;
    }

    public final Boolean vpc() {
        return this.vpc;
    }

    public final Boolean supportsStorageEncryption() {
        return this.supportsStorageEncryption;
    }

    public final String storageType() {
        return this.storageType;
    }

    public final Boolean supportsIops() {
        return this.supportsIops;
    }

    public final Boolean supportsEnhancedMonitoring() {
        return this.supportsEnhancedMonitoring;
    }

    public final Boolean supportsIAMDatabaseAuthentication() {
        return this.supportsIAMDatabaseAuthentication;
    }

    public final Boolean supportsPerformanceInsights() {
        return this.supportsPerformanceInsights;
    }

    public final Integer minStorageSize() {
        return this.minStorageSize;
    }

    public final Integer maxStorageSize() {
        return this.maxStorageSize;
    }

    public final Integer minIopsPerDbInstance() {
        return this.minIopsPerDbInstance;
    }

    public final Integer maxIopsPerDbInstance() {
        return this.maxIopsPerDbInstance;
    }

    public final Double minIopsPerGib() {
        return this.minIopsPerGib;
    }

    public final Double maxIopsPerGib() {
        return this.maxIopsPerGib;
    }

    public final boolean hasAvailableProcessorFeatures() {
        return this.availableProcessorFeatures != null && !(this.availableProcessorFeatures instanceof SdkAutoConstructList);
    }

    public final List<AvailableProcessorFeature> availableProcessorFeatures() {
        return this.availableProcessorFeatures;
    }

    public final boolean hasSupportedEngineModes() {
        return this.supportedEngineModes != null && !(this.supportedEngineModes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedEngineModes() {
        return this.supportedEngineModes;
    }

    public final Boolean supportsStorageAutoscaling() {
        return this.supportsStorageAutoscaling;
    }

    public final Boolean supportsKerberosAuthentication() {
        return this.supportsKerberosAuthentication;
    }

    public final Boolean outpostCapable() {
        return this.outpostCapable;
    }

    public final boolean hasSupportedActivityStreamModes() {
        return this.supportedActivityStreamModes != null && !(this.supportedActivityStreamModes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedActivityStreamModes() {
        return this.supportedActivityStreamModes;
    }

    public final Boolean supportsGlobalDatabases() {
        return this.supportsGlobalDatabases;
    }

    public final Boolean supportsClusters() {
        return this.supportsClusters;
    }

    public final boolean hasSupportedNetworkTypes() {
        return this.supportedNetworkTypes != null && !(this.supportedNetworkTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedNetworkTypes() {
        return this.supportedNetworkTypes;
    }

    public final Boolean supportsStorageThroughput() {
        return this.supportsStorageThroughput;
    }

    public final Integer minStorageThroughputPerDbInstance() {
        return this.minStorageThroughputPerDbInstance;
    }

    public final Integer maxStorageThroughputPerDbInstance() {
        return this.maxStorageThroughputPerDbInstance;
    }

    public final Double minStorageThroughputPerIops() {
        return this.minStorageThroughputPerIops;
    }

    public final Double maxStorageThroughputPerIops() {
        return this.maxStorageThroughputPerIops;
    }

    public final Boolean supportsDedicatedLogVolume() {
        return this.supportsDedicatedLogVolume;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZCapable());
        hashCode = 31 * hashCode + Objects.hashCode(this.readReplicaCapable());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsStorageEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsIops());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsEnhancedMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsPerformanceInsights());
        hashCode = 31 * hashCode + Objects.hashCode(this.minStorageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxStorageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.minIopsPerDbInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxIopsPerDbInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.minIopsPerGib());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxIopsPerGib());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailableProcessorFeatures() ? this.availableProcessorFeatures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedEngineModes() ? this.supportedEngineModes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsStorageAutoscaling());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsKerberosAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostCapable());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedActivityStreamModes() ? this.supportedActivityStreamModes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsGlobalDatabases());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsClusters());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedNetworkTypes() ? this.supportedNetworkTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsStorageThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.minStorageThroughputPerDbInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxStorageThroughputPerDbInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.minStorageThroughputPerIops());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxStorageThroughputPerIops());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsDedicatedLogVolume());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderableDBInstanceOption)) {
            return false;
        }
        OrderableDBInstanceOption other = (OrderableDBInstanceOption)obj;
        return Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(this.licenseModel(), other.licenseModel()) && Objects.equals(this.availabilityZoneGroup(), other.availabilityZoneGroup()) && this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.multiAZCapable(), other.multiAZCapable()) && Objects.equals(this.readReplicaCapable(), other.readReplicaCapable()) && Objects.equals(this.vpc(), other.vpc()) && Objects.equals(this.supportsStorageEncryption(), other.supportsStorageEncryption()) && Objects.equals(this.storageType(), other.storageType()) && Objects.equals(this.supportsIops(), other.supportsIops()) && Objects.equals(this.supportsEnhancedMonitoring(), other.supportsEnhancedMonitoring()) && Objects.equals(this.supportsIAMDatabaseAuthentication(), other.supportsIAMDatabaseAuthentication()) && Objects.equals(this.supportsPerformanceInsights(), other.supportsPerformanceInsights()) && Objects.equals(this.minStorageSize(), other.minStorageSize()) && Objects.equals(this.maxStorageSize(), other.maxStorageSize()) && Objects.equals(this.minIopsPerDbInstance(), other.minIopsPerDbInstance()) && Objects.equals(this.maxIopsPerDbInstance(), other.maxIopsPerDbInstance()) && Objects.equals(this.minIopsPerGib(), other.minIopsPerGib()) && Objects.equals(this.maxIopsPerGib(), other.maxIopsPerGib()) && this.hasAvailableProcessorFeatures() == other.hasAvailableProcessorFeatures() && Objects.equals(this.availableProcessorFeatures(), other.availableProcessorFeatures()) && this.hasSupportedEngineModes() == other.hasSupportedEngineModes() && Objects.equals(this.supportedEngineModes(), other.supportedEngineModes()) && Objects.equals(this.supportsStorageAutoscaling(), other.supportsStorageAutoscaling()) && Objects.equals(this.supportsKerberosAuthentication(), other.supportsKerberosAuthentication()) && Objects.equals(this.outpostCapable(), other.outpostCapable()) && this.hasSupportedActivityStreamModes() == other.hasSupportedActivityStreamModes() && Objects.equals(this.supportedActivityStreamModes(), other.supportedActivityStreamModes()) && Objects.equals(this.supportsGlobalDatabases(), other.supportsGlobalDatabases()) && Objects.equals(this.supportsClusters(), other.supportsClusters()) && this.hasSupportedNetworkTypes() == other.hasSupportedNetworkTypes() && Objects.equals(this.supportedNetworkTypes(), other.supportedNetworkTypes()) && Objects.equals(this.supportsStorageThroughput(), other.supportsStorageThroughput()) && Objects.equals(this.minStorageThroughputPerDbInstance(), other.minStorageThroughputPerDbInstance()) && Objects.equals(this.maxStorageThroughputPerDbInstance(), other.maxStorageThroughputPerDbInstance()) && Objects.equals(this.minStorageThroughputPerIops(), other.minStorageThroughputPerIops()) && Objects.equals(this.maxStorageThroughputPerIops(), other.maxStorageThroughputPerIops()) && Objects.equals(this.supportsDedicatedLogVolume(), other.supportsDedicatedLogVolume());
    }

    public final String toString() {
        return ToString.builder((String)"OrderableDBInstanceOption").add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("DBInstanceClass", (Object)this.dbInstanceClass()).add("LicenseModel", (Object)this.licenseModel()).add("AvailabilityZoneGroup", (Object)this.availabilityZoneGroup()).add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("MultiAZCapable", (Object)this.multiAZCapable()).add("ReadReplicaCapable", (Object)this.readReplicaCapable()).add("Vpc", (Object)this.vpc()).add("SupportsStorageEncryption", (Object)this.supportsStorageEncryption()).add("StorageType", (Object)this.storageType()).add("SupportsIops", (Object)this.supportsIops()).add("SupportsEnhancedMonitoring", (Object)this.supportsEnhancedMonitoring()).add("SupportsIAMDatabaseAuthentication", (Object)this.supportsIAMDatabaseAuthentication()).add("SupportsPerformanceInsights", (Object)this.supportsPerformanceInsights()).add("MinStorageSize", (Object)this.minStorageSize()).add("MaxStorageSize", (Object)this.maxStorageSize()).add("MinIopsPerDbInstance", (Object)this.minIopsPerDbInstance()).add("MaxIopsPerDbInstance", (Object)this.maxIopsPerDbInstance()).add("MinIopsPerGib", (Object)this.minIopsPerGib()).add("MaxIopsPerGib", (Object)this.maxIopsPerGib()).add("AvailableProcessorFeatures", this.hasAvailableProcessorFeatures() ? this.availableProcessorFeatures() : null).add("SupportedEngineModes", this.hasSupportedEngineModes() ? this.supportedEngineModes() : null).add("SupportsStorageAutoscaling", (Object)this.supportsStorageAutoscaling()).add("SupportsKerberosAuthentication", (Object)this.supportsKerberosAuthentication()).add("OutpostCapable", (Object)this.outpostCapable()).add("SupportedActivityStreamModes", this.hasSupportedActivityStreamModes() ? this.supportedActivityStreamModes() : null).add("SupportsGlobalDatabases", (Object)this.supportsGlobalDatabases()).add("SupportsClusters", (Object)this.supportsClusters()).add("SupportedNetworkTypes", this.hasSupportedNetworkTypes() ? this.supportedNetworkTypes() : null).add("SupportsStorageThroughput", (Object)this.supportsStorageThroughput()).add("MinStorageThroughputPerDbInstance", (Object)this.minStorageThroughputPerDbInstance()).add("MaxStorageThroughputPerDbInstance", (Object)this.maxStorageThroughputPerDbInstance()).add("MinStorageThroughputPerIops", (Object)this.minStorageThroughputPerIops()).add("MaxStorageThroughputPerIops", (Object)this.maxStorageThroughputPerIops()).add("SupportsDedicatedLogVolume", (Object)this.supportsDedicatedLogVolume()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "DBInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceClass()));
            }
            case "LicenseModel": {
                return Optional.ofNullable(clazz.cast(this.licenseModel()));
            }
            case "AvailabilityZoneGroup": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneGroup()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "MultiAZCapable": {
                return Optional.ofNullable(clazz.cast(this.multiAZCapable()));
            }
            case "ReadReplicaCapable": {
                return Optional.ofNullable(clazz.cast(this.readReplicaCapable()));
            }
            case "Vpc": {
                return Optional.ofNullable(clazz.cast(this.vpc()));
            }
            case "SupportsStorageEncryption": {
                return Optional.ofNullable(clazz.cast(this.supportsStorageEncryption()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "SupportsIops": {
                return Optional.ofNullable(clazz.cast(this.supportsIops()));
            }
            case "SupportsEnhancedMonitoring": {
                return Optional.ofNullable(clazz.cast(this.supportsEnhancedMonitoring()));
            }
            case "SupportsIAMDatabaseAuthentication": {
                return Optional.ofNullable(clazz.cast(this.supportsIAMDatabaseAuthentication()));
            }
            case "SupportsPerformanceInsights": {
                return Optional.ofNullable(clazz.cast(this.supportsPerformanceInsights()));
            }
            case "MinStorageSize": {
                return Optional.ofNullable(clazz.cast(this.minStorageSize()));
            }
            case "MaxStorageSize": {
                return Optional.ofNullable(clazz.cast(this.maxStorageSize()));
            }
            case "MinIopsPerDbInstance": {
                return Optional.ofNullable(clazz.cast(this.minIopsPerDbInstance()));
            }
            case "MaxIopsPerDbInstance": {
                return Optional.ofNullable(clazz.cast(this.maxIopsPerDbInstance()));
            }
            case "MinIopsPerGib": {
                return Optional.ofNullable(clazz.cast(this.minIopsPerGib()));
            }
            case "MaxIopsPerGib": {
                return Optional.ofNullable(clazz.cast(this.maxIopsPerGib()));
            }
            case "AvailableProcessorFeatures": {
                return Optional.ofNullable(clazz.cast(this.availableProcessorFeatures()));
            }
            case "SupportedEngineModes": {
                return Optional.ofNullable(clazz.cast(this.supportedEngineModes()));
            }
            case "SupportsStorageAutoscaling": {
                return Optional.ofNullable(clazz.cast(this.supportsStorageAutoscaling()));
            }
            case "SupportsKerberosAuthentication": {
                return Optional.ofNullable(clazz.cast(this.supportsKerberosAuthentication()));
            }
            case "OutpostCapable": {
                return Optional.ofNullable(clazz.cast(this.outpostCapable()));
            }
            case "SupportedActivityStreamModes": {
                return Optional.ofNullable(clazz.cast(this.supportedActivityStreamModes()));
            }
            case "SupportsGlobalDatabases": {
                return Optional.ofNullable(clazz.cast(this.supportsGlobalDatabases()));
            }
            case "SupportsClusters": {
                return Optional.ofNullable(clazz.cast(this.supportsClusters()));
            }
            case "SupportedNetworkTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedNetworkTypes()));
            }
            case "SupportsStorageThroughput": {
                return Optional.ofNullable(clazz.cast(this.supportsStorageThroughput()));
            }
            case "MinStorageThroughputPerDbInstance": {
                return Optional.ofNullable(clazz.cast(this.minStorageThroughputPerDbInstance()));
            }
            case "MaxStorageThroughputPerDbInstance": {
                return Optional.ofNullable(clazz.cast(this.maxStorageThroughputPerDbInstance()));
            }
            case "MinStorageThroughputPerIops": {
                return Optional.ofNullable(clazz.cast(this.minStorageThroughputPerIops()));
            }
            case "MaxStorageThroughputPerIops": {
                return Optional.ofNullable(clazz.cast(this.maxStorageThroughputPerIops()));
            }
            case "SupportsDedicatedLogVolume": {
                return Optional.ofNullable(clazz.cast(this.supportsDedicatedLogVolume()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Engine", ENGINE_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("DBInstanceClass", DB_INSTANCE_CLASS_FIELD);
        map.put("LicenseModel", LICENSE_MODEL_FIELD);
        map.put("AvailabilityZoneGroup", AVAILABILITY_ZONE_GROUP_FIELD);
        map.put("AvailabilityZones", AVAILABILITY_ZONES_FIELD);
        map.put("MultiAZCapable", MULTI_AZ_CAPABLE_FIELD);
        map.put("ReadReplicaCapable", READ_REPLICA_CAPABLE_FIELD);
        map.put("Vpc", VPC_FIELD);
        map.put("SupportsStorageEncryption", SUPPORTS_STORAGE_ENCRYPTION_FIELD);
        map.put("StorageType", STORAGE_TYPE_FIELD);
        map.put("SupportsIops", SUPPORTS_IOPS_FIELD);
        map.put("SupportsEnhancedMonitoring", SUPPORTS_ENHANCED_MONITORING_FIELD);
        map.put("SupportsIAMDatabaseAuthentication", SUPPORTS_IAM_DATABASE_AUTHENTICATION_FIELD);
        map.put("SupportsPerformanceInsights", SUPPORTS_PERFORMANCE_INSIGHTS_FIELD);
        map.put("MinStorageSize", MIN_STORAGE_SIZE_FIELD);
        map.put("MaxStorageSize", MAX_STORAGE_SIZE_FIELD);
        map.put("MinIopsPerDbInstance", MIN_IOPS_PER_DB_INSTANCE_FIELD);
        map.put("MaxIopsPerDbInstance", MAX_IOPS_PER_DB_INSTANCE_FIELD);
        map.put("MinIopsPerGib", MIN_IOPS_PER_GIB_FIELD);
        map.put("MaxIopsPerGib", MAX_IOPS_PER_GIB_FIELD);
        map.put("AvailableProcessorFeatures", AVAILABLE_PROCESSOR_FEATURES_FIELD);
        map.put("SupportedEngineModes", SUPPORTED_ENGINE_MODES_FIELD);
        map.put("SupportsStorageAutoscaling", SUPPORTS_STORAGE_AUTOSCALING_FIELD);
        map.put("SupportsKerberosAuthentication", SUPPORTS_KERBEROS_AUTHENTICATION_FIELD);
        map.put("OutpostCapable", OUTPOST_CAPABLE_FIELD);
        map.put("SupportedActivityStreamModes", SUPPORTED_ACTIVITY_STREAM_MODES_FIELD);
        map.put("SupportsGlobalDatabases", SUPPORTS_GLOBAL_DATABASES_FIELD);
        map.put("SupportsClusters", SUPPORTS_CLUSTERS_FIELD);
        map.put("SupportedNetworkTypes", SUPPORTED_NETWORK_TYPES_FIELD);
        map.put("SupportsStorageThroughput", SUPPORTS_STORAGE_THROUGHPUT_FIELD);
        map.put("MinStorageThroughputPerDbInstance", MIN_STORAGE_THROUGHPUT_PER_DB_INSTANCE_FIELD);
        map.put("MaxStorageThroughputPerDbInstance", MAX_STORAGE_THROUGHPUT_PER_DB_INSTANCE_FIELD);
        map.put("MinStorageThroughputPerIops", MIN_STORAGE_THROUGHPUT_PER_IOPS_FIELD);
        map.put("MaxStorageThroughputPerIops", MAX_STORAGE_THROUGHPUT_PER_IOPS_FIELD);
        map.put("SupportsDedicatedLogVolume", SUPPORTS_DEDICATED_LOG_VOLUME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrderableDBInstanceOption, T> g) {
        return obj -> g.apply((OrderableDBInstanceOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String engine;
        private String engineVersion;
        private String dbInstanceClass;
        private String licenseModel;
        private String availabilityZoneGroup;
        private List<AvailabilityZone> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private Boolean multiAZCapable;
        private Boolean readReplicaCapable;
        private Boolean vpc;
        private Boolean supportsStorageEncryption;
        private String storageType;
        private Boolean supportsIops;
        private Boolean supportsEnhancedMonitoring;
        private Boolean supportsIAMDatabaseAuthentication;
        private Boolean supportsPerformanceInsights;
        private Integer minStorageSize;
        private Integer maxStorageSize;
        private Integer minIopsPerDbInstance;
        private Integer maxIopsPerDbInstance;
        private Double minIopsPerGib;
        private Double maxIopsPerGib;
        private List<AvailableProcessorFeature> availableProcessorFeatures = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedEngineModes = DefaultSdkAutoConstructList.getInstance();
        private Boolean supportsStorageAutoscaling;
        private Boolean supportsKerberosAuthentication;
        private Boolean outpostCapable;
        private List<String> supportedActivityStreamModes = DefaultSdkAutoConstructList.getInstance();
        private Boolean supportsGlobalDatabases;
        private Boolean supportsClusters;
        private List<String> supportedNetworkTypes = DefaultSdkAutoConstructList.getInstance();
        private Boolean supportsStorageThroughput;
        private Integer minStorageThroughputPerDbInstance;
        private Integer maxStorageThroughputPerDbInstance;
        private Double minStorageThroughputPerIops;
        private Double maxStorageThroughputPerIops;
        private Boolean supportsDedicatedLogVolume;

        private BuilderImpl() {
        }

        private BuilderImpl(OrderableDBInstanceOption model) {
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.dbInstanceClass(model.dbInstanceClass);
            this.licenseModel(model.licenseModel);
            this.availabilityZoneGroup(model.availabilityZoneGroup);
            this.availabilityZones(model.availabilityZones);
            this.multiAZCapable(model.multiAZCapable);
            this.readReplicaCapable(model.readReplicaCapable);
            this.vpc(model.vpc);
            this.supportsStorageEncryption(model.supportsStorageEncryption);
            this.storageType(model.storageType);
            this.supportsIops(model.supportsIops);
            this.supportsEnhancedMonitoring(model.supportsEnhancedMonitoring);
            this.supportsIAMDatabaseAuthentication(model.supportsIAMDatabaseAuthentication);
            this.supportsPerformanceInsights(model.supportsPerformanceInsights);
            this.minStorageSize(model.minStorageSize);
            this.maxStorageSize(model.maxStorageSize);
            this.minIopsPerDbInstance(model.minIopsPerDbInstance);
            this.maxIopsPerDbInstance(model.maxIopsPerDbInstance);
            this.minIopsPerGib(model.minIopsPerGib);
            this.maxIopsPerGib(model.maxIopsPerGib);
            this.availableProcessorFeatures(model.availableProcessorFeatures);
            this.supportedEngineModes(model.supportedEngineModes);
            this.supportsStorageAutoscaling(model.supportsStorageAutoscaling);
            this.supportsKerberosAuthentication(model.supportsKerberosAuthentication);
            this.outpostCapable(model.outpostCapable);
            this.supportedActivityStreamModes(model.supportedActivityStreamModes);
            this.supportsGlobalDatabases(model.supportsGlobalDatabases);
            this.supportsClusters(model.supportsClusters);
            this.supportedNetworkTypes(model.supportedNetworkTypes);
            this.supportsStorageThroughput(model.supportsStorageThroughput);
            this.minStorageThroughputPerDbInstance(model.minStorageThroughputPerDbInstance);
            this.maxStorageThroughputPerDbInstance(model.maxStorageThroughputPerDbInstance);
            this.minStorageThroughputPerIops(model.minStorageThroughputPerIops);
            this.maxStorageThroughputPerIops(model.maxStorageThroughputPerIops);
            this.supportsDedicatedLogVolume(model.supportsDedicatedLogVolume);
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getDbInstanceClass() {
            return this.dbInstanceClass;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final String getAvailabilityZoneGroup() {
            return this.availabilityZoneGroup;
        }

        public final void setAvailabilityZoneGroup(String availabilityZoneGroup) {
            this.availabilityZoneGroup = availabilityZoneGroup;
        }

        @Override
        public final Builder availabilityZoneGroup(String availabilityZoneGroup) {
            this.availabilityZoneGroup = availabilityZoneGroup;
            return this;
        }

        public final List<AvailabilityZone.Builder> getAvailabilityZones() {
            List<AvailabilityZone.Builder> result = AvailabilityZoneListCopier.copyToBuilder(this.availabilityZones);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAvailabilityZones(Collection<AvailabilityZone.BuilderImpl> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copyFromBuilder(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<AvailabilityZone> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(AvailabilityZone ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(Consumer<AvailabilityZone.Builder> ... availabilityZones) {
            this.availabilityZones(Stream.of(availabilityZones).map(c -> (AvailabilityZone)((AvailabilityZone.Builder)AvailabilityZone.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getMultiAZCapable() {
            return this.multiAZCapable;
        }

        public final void setMultiAZCapable(Boolean multiAZCapable) {
            this.multiAZCapable = multiAZCapable;
        }

        @Override
        public final Builder multiAZCapable(Boolean multiAZCapable) {
            this.multiAZCapable = multiAZCapable;
            return this;
        }

        public final Boolean getReadReplicaCapable() {
            return this.readReplicaCapable;
        }

        public final void setReadReplicaCapable(Boolean readReplicaCapable) {
            this.readReplicaCapable = readReplicaCapable;
        }

        @Override
        public final Builder readReplicaCapable(Boolean readReplicaCapable) {
            this.readReplicaCapable = readReplicaCapable;
            return this;
        }

        public final Boolean getVpc() {
            return this.vpc;
        }

        public final void setVpc(Boolean vpc) {
            this.vpc = vpc;
        }

        @Override
        public final Builder vpc(Boolean vpc) {
            this.vpc = vpc;
            return this;
        }

        public final Boolean getSupportsStorageEncryption() {
            return this.supportsStorageEncryption;
        }

        public final void setSupportsStorageEncryption(Boolean supportsStorageEncryption) {
            this.supportsStorageEncryption = supportsStorageEncryption;
        }

        @Override
        public final Builder supportsStorageEncryption(Boolean supportsStorageEncryption) {
            this.supportsStorageEncryption = supportsStorageEncryption;
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final Boolean getSupportsIops() {
            return this.supportsIops;
        }

        public final void setSupportsIops(Boolean supportsIops) {
            this.supportsIops = supportsIops;
        }

        @Override
        public final Builder supportsIops(Boolean supportsIops) {
            this.supportsIops = supportsIops;
            return this;
        }

        public final Boolean getSupportsEnhancedMonitoring() {
            return this.supportsEnhancedMonitoring;
        }

        public final void setSupportsEnhancedMonitoring(Boolean supportsEnhancedMonitoring) {
            this.supportsEnhancedMonitoring = supportsEnhancedMonitoring;
        }

        @Override
        public final Builder supportsEnhancedMonitoring(Boolean supportsEnhancedMonitoring) {
            this.supportsEnhancedMonitoring = supportsEnhancedMonitoring;
            return this;
        }

        public final Boolean getSupportsIAMDatabaseAuthentication() {
            return this.supportsIAMDatabaseAuthentication;
        }

        public final void setSupportsIAMDatabaseAuthentication(Boolean supportsIAMDatabaseAuthentication) {
            this.supportsIAMDatabaseAuthentication = supportsIAMDatabaseAuthentication;
        }

        @Override
        public final Builder supportsIAMDatabaseAuthentication(Boolean supportsIAMDatabaseAuthentication) {
            this.supportsIAMDatabaseAuthentication = supportsIAMDatabaseAuthentication;
            return this;
        }

        public final Boolean getSupportsPerformanceInsights() {
            return this.supportsPerformanceInsights;
        }

        public final void setSupportsPerformanceInsights(Boolean supportsPerformanceInsights) {
            this.supportsPerformanceInsights = supportsPerformanceInsights;
        }

        @Override
        public final Builder supportsPerformanceInsights(Boolean supportsPerformanceInsights) {
            this.supportsPerformanceInsights = supportsPerformanceInsights;
            return this;
        }

        public final Integer getMinStorageSize() {
            return this.minStorageSize;
        }

        public final void setMinStorageSize(Integer minStorageSize) {
            this.minStorageSize = minStorageSize;
        }

        @Override
        public final Builder minStorageSize(Integer minStorageSize) {
            this.minStorageSize = minStorageSize;
            return this;
        }

        public final Integer getMaxStorageSize() {
            return this.maxStorageSize;
        }

        public final void setMaxStorageSize(Integer maxStorageSize) {
            this.maxStorageSize = maxStorageSize;
        }

        @Override
        public final Builder maxStorageSize(Integer maxStorageSize) {
            this.maxStorageSize = maxStorageSize;
            return this;
        }

        public final Integer getMinIopsPerDbInstance() {
            return this.minIopsPerDbInstance;
        }

        public final void setMinIopsPerDbInstance(Integer minIopsPerDbInstance) {
            this.minIopsPerDbInstance = minIopsPerDbInstance;
        }

        @Override
        public final Builder minIopsPerDbInstance(Integer minIopsPerDbInstance) {
            this.minIopsPerDbInstance = minIopsPerDbInstance;
            return this;
        }

        public final Integer getMaxIopsPerDbInstance() {
            return this.maxIopsPerDbInstance;
        }

        public final void setMaxIopsPerDbInstance(Integer maxIopsPerDbInstance) {
            this.maxIopsPerDbInstance = maxIopsPerDbInstance;
        }

        @Override
        public final Builder maxIopsPerDbInstance(Integer maxIopsPerDbInstance) {
            this.maxIopsPerDbInstance = maxIopsPerDbInstance;
            return this;
        }

        public final Double getMinIopsPerGib() {
            return this.minIopsPerGib;
        }

        public final void setMinIopsPerGib(Double minIopsPerGib) {
            this.minIopsPerGib = minIopsPerGib;
        }

        @Override
        public final Builder minIopsPerGib(Double minIopsPerGib) {
            this.minIopsPerGib = minIopsPerGib;
            return this;
        }

        public final Double getMaxIopsPerGib() {
            return this.maxIopsPerGib;
        }

        public final void setMaxIopsPerGib(Double maxIopsPerGib) {
            this.maxIopsPerGib = maxIopsPerGib;
        }

        @Override
        public final Builder maxIopsPerGib(Double maxIopsPerGib) {
            this.maxIopsPerGib = maxIopsPerGib;
            return this;
        }

        public final List<AvailableProcessorFeature.Builder> getAvailableProcessorFeatures() {
            List<AvailableProcessorFeature.Builder> result = AvailableProcessorFeatureListCopier.copyToBuilder(this.availableProcessorFeatures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAvailableProcessorFeatures(Collection<AvailableProcessorFeature.BuilderImpl> availableProcessorFeatures) {
            this.availableProcessorFeatures = AvailableProcessorFeatureListCopier.copyFromBuilder(availableProcessorFeatures);
        }

        @Override
        public final Builder availableProcessorFeatures(Collection<AvailableProcessorFeature> availableProcessorFeatures) {
            this.availableProcessorFeatures = AvailableProcessorFeatureListCopier.copy(availableProcessorFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableProcessorFeatures(AvailableProcessorFeature ... availableProcessorFeatures) {
            this.availableProcessorFeatures(Arrays.asList(availableProcessorFeatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableProcessorFeatures(Consumer<AvailableProcessorFeature.Builder> ... availableProcessorFeatures) {
            this.availableProcessorFeatures(Stream.of(availableProcessorFeatures).map(c -> (AvailableProcessorFeature)((AvailableProcessorFeature.Builder)AvailableProcessorFeature.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSupportedEngineModes() {
            if (this.supportedEngineModes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedEngineModes;
        }

        public final void setSupportedEngineModes(Collection<String> supportedEngineModes) {
            this.supportedEngineModes = EngineModeListCopier.copy(supportedEngineModes);
        }

        @Override
        public final Builder supportedEngineModes(Collection<String> supportedEngineModes) {
            this.supportedEngineModes = EngineModeListCopier.copy(supportedEngineModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedEngineModes(String ... supportedEngineModes) {
            this.supportedEngineModes(Arrays.asList(supportedEngineModes));
            return this;
        }

        public final Boolean getSupportsStorageAutoscaling() {
            return this.supportsStorageAutoscaling;
        }

        public final void setSupportsStorageAutoscaling(Boolean supportsStorageAutoscaling) {
            this.supportsStorageAutoscaling = supportsStorageAutoscaling;
        }

        @Override
        public final Builder supportsStorageAutoscaling(Boolean supportsStorageAutoscaling) {
            this.supportsStorageAutoscaling = supportsStorageAutoscaling;
            return this;
        }

        public final Boolean getSupportsKerberosAuthentication() {
            return this.supportsKerberosAuthentication;
        }

        public final void setSupportsKerberosAuthentication(Boolean supportsKerberosAuthentication) {
            this.supportsKerberosAuthentication = supportsKerberosAuthentication;
        }

        @Override
        public final Builder supportsKerberosAuthentication(Boolean supportsKerberosAuthentication) {
            this.supportsKerberosAuthentication = supportsKerberosAuthentication;
            return this;
        }

        public final Boolean getOutpostCapable() {
            return this.outpostCapable;
        }

        public final void setOutpostCapable(Boolean outpostCapable) {
            this.outpostCapable = outpostCapable;
        }

        @Override
        public final Builder outpostCapable(Boolean outpostCapable) {
            this.outpostCapable = outpostCapable;
            return this;
        }

        public final Collection<String> getSupportedActivityStreamModes() {
            if (this.supportedActivityStreamModes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedActivityStreamModes;
        }

        public final void setSupportedActivityStreamModes(Collection<String> supportedActivityStreamModes) {
            this.supportedActivityStreamModes = ActivityStreamModeListCopier.copy(supportedActivityStreamModes);
        }

        @Override
        public final Builder supportedActivityStreamModes(Collection<String> supportedActivityStreamModes) {
            this.supportedActivityStreamModes = ActivityStreamModeListCopier.copy(supportedActivityStreamModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedActivityStreamModes(String ... supportedActivityStreamModes) {
            this.supportedActivityStreamModes(Arrays.asList(supportedActivityStreamModes));
            return this;
        }

        public final Boolean getSupportsGlobalDatabases() {
            return this.supportsGlobalDatabases;
        }

        public final void setSupportsGlobalDatabases(Boolean supportsGlobalDatabases) {
            this.supportsGlobalDatabases = supportsGlobalDatabases;
        }

        @Override
        public final Builder supportsGlobalDatabases(Boolean supportsGlobalDatabases) {
            this.supportsGlobalDatabases = supportsGlobalDatabases;
            return this;
        }

        public final Boolean getSupportsClusters() {
            return this.supportsClusters;
        }

        public final void setSupportsClusters(Boolean supportsClusters) {
            this.supportsClusters = supportsClusters;
        }

        @Override
        public final Builder supportsClusters(Boolean supportsClusters) {
            this.supportsClusters = supportsClusters;
            return this;
        }

        public final Collection<String> getSupportedNetworkTypes() {
            if (this.supportedNetworkTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedNetworkTypes;
        }

        public final void setSupportedNetworkTypes(Collection<String> supportedNetworkTypes) {
            this.supportedNetworkTypes = StringListCopier.copy(supportedNetworkTypes);
        }

        @Override
        public final Builder supportedNetworkTypes(Collection<String> supportedNetworkTypes) {
            this.supportedNetworkTypes = StringListCopier.copy(supportedNetworkTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedNetworkTypes(String ... supportedNetworkTypes) {
            this.supportedNetworkTypes(Arrays.asList(supportedNetworkTypes));
            return this;
        }

        public final Boolean getSupportsStorageThroughput() {
            return this.supportsStorageThroughput;
        }

        public final void setSupportsStorageThroughput(Boolean supportsStorageThroughput) {
            this.supportsStorageThroughput = supportsStorageThroughput;
        }

        @Override
        public final Builder supportsStorageThroughput(Boolean supportsStorageThroughput) {
            this.supportsStorageThroughput = supportsStorageThroughput;
            return this;
        }

        public final Integer getMinStorageThroughputPerDbInstance() {
            return this.minStorageThroughputPerDbInstance;
        }

        public final void setMinStorageThroughputPerDbInstance(Integer minStorageThroughputPerDbInstance) {
            this.minStorageThroughputPerDbInstance = minStorageThroughputPerDbInstance;
        }

        @Override
        public final Builder minStorageThroughputPerDbInstance(Integer minStorageThroughputPerDbInstance) {
            this.minStorageThroughputPerDbInstance = minStorageThroughputPerDbInstance;
            return this;
        }

        public final Integer getMaxStorageThroughputPerDbInstance() {
            return this.maxStorageThroughputPerDbInstance;
        }

        public final void setMaxStorageThroughputPerDbInstance(Integer maxStorageThroughputPerDbInstance) {
            this.maxStorageThroughputPerDbInstance = maxStorageThroughputPerDbInstance;
        }

        @Override
        public final Builder maxStorageThroughputPerDbInstance(Integer maxStorageThroughputPerDbInstance) {
            this.maxStorageThroughputPerDbInstance = maxStorageThroughputPerDbInstance;
            return this;
        }

        public final Double getMinStorageThroughputPerIops() {
            return this.minStorageThroughputPerIops;
        }

        public final void setMinStorageThroughputPerIops(Double minStorageThroughputPerIops) {
            this.minStorageThroughputPerIops = minStorageThroughputPerIops;
        }

        @Override
        public final Builder minStorageThroughputPerIops(Double minStorageThroughputPerIops) {
            this.minStorageThroughputPerIops = minStorageThroughputPerIops;
            return this;
        }

        public final Double getMaxStorageThroughputPerIops() {
            return this.maxStorageThroughputPerIops;
        }

        public final void setMaxStorageThroughputPerIops(Double maxStorageThroughputPerIops) {
            this.maxStorageThroughputPerIops = maxStorageThroughputPerIops;
        }

        @Override
        public final Builder maxStorageThroughputPerIops(Double maxStorageThroughputPerIops) {
            this.maxStorageThroughputPerIops = maxStorageThroughputPerIops;
            return this;
        }

        public final Boolean getSupportsDedicatedLogVolume() {
            return this.supportsDedicatedLogVolume;
        }

        public final void setSupportsDedicatedLogVolume(Boolean supportsDedicatedLogVolume) {
            this.supportsDedicatedLogVolume = supportsDedicatedLogVolume;
        }

        @Override
        public final Builder supportsDedicatedLogVolume(Boolean supportsDedicatedLogVolume) {
            this.supportsDedicatedLogVolume = supportsDedicatedLogVolume;
            return this;
        }

        public OrderableDBInstanceOption build() {
            return new OrderableDBInstanceOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrderableDBInstanceOption> {
        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder dbInstanceClass(String var1);

        public Builder licenseModel(String var1);

        public Builder availabilityZoneGroup(String var1);

        public Builder availabilityZones(Collection<AvailabilityZone> var1);

        public Builder availabilityZones(AvailabilityZone ... var1);

        public Builder availabilityZones(Consumer<AvailabilityZone.Builder> ... var1);

        public Builder multiAZCapable(Boolean var1);

        public Builder readReplicaCapable(Boolean var1);

        public Builder vpc(Boolean var1);

        public Builder supportsStorageEncryption(Boolean var1);

        public Builder storageType(String var1);

        public Builder supportsIops(Boolean var1);

        public Builder supportsEnhancedMonitoring(Boolean var1);

        public Builder supportsIAMDatabaseAuthentication(Boolean var1);

        public Builder supportsPerformanceInsights(Boolean var1);

        public Builder minStorageSize(Integer var1);

        public Builder maxStorageSize(Integer var1);

        public Builder minIopsPerDbInstance(Integer var1);

        public Builder maxIopsPerDbInstance(Integer var1);

        public Builder minIopsPerGib(Double var1);

        public Builder maxIopsPerGib(Double var1);

        public Builder availableProcessorFeatures(Collection<AvailableProcessorFeature> var1);

        public Builder availableProcessorFeatures(AvailableProcessorFeature ... var1);

        public Builder availableProcessorFeatures(Consumer<AvailableProcessorFeature.Builder> ... var1);

        public Builder supportedEngineModes(Collection<String> var1);

        public Builder supportedEngineModes(String ... var1);

        public Builder supportsStorageAutoscaling(Boolean var1);

        public Builder supportsKerberosAuthentication(Boolean var1);

        public Builder outpostCapable(Boolean var1);

        public Builder supportedActivityStreamModes(Collection<String> var1);

        public Builder supportedActivityStreamModes(String ... var1);

        public Builder supportsGlobalDatabases(Boolean var1);

        public Builder supportsClusters(Boolean var1);

        public Builder supportedNetworkTypes(Collection<String> var1);

        public Builder supportedNetworkTypes(String ... var1);

        public Builder supportsStorageThroughput(Boolean var1);

        public Builder minStorageThroughputPerDbInstance(Integer var1);

        public Builder maxStorageThroughputPerDbInstance(Integer var1);

        public Builder minStorageThroughputPerIops(Double var1);

        public Builder maxStorageThroughputPerIops(Double var1);

        public Builder supportsDedicatedLogVolume(Boolean var1);
    }
}

