/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.internal.UserAgentUtils;
import software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.rds.model.DescribeExportTasksResponse;
import software.amazon.awssdk.services.rds.model.ExportTask;

public class DescribeExportTasksIterable
implements SdkIterable<DescribeExportTasksResponse> {
    private final RdsClient client;
    private final DescribeExportTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeExportTasksIterable(RdsClient client, DescribeExportTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeExportTasksResponseFetcher();
    }

    public Iterator<DescribeExportTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ExportTask> exportTasks() {
        Function<DescribeExportTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.exportTasks() != null) {
                return response.exportTasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeExportTasksResponseFetcher
    implements SyncPageFetcher<DescribeExportTasksResponse> {
        private DescribeExportTasksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeExportTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeExportTasksResponse nextPage(DescribeExportTasksResponse previousPage) {
            if (previousPage == null) {
                return DescribeExportTasksIterable.this.client.describeExportTasks(DescribeExportTasksIterable.this.firstRequest);
            }
            return DescribeExportTasksIterable.this.client.describeExportTasks((DescribeExportTasksRequest)((Object)DescribeExportTasksIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

