/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DBProxyEndpointStatus {
    AVAILABLE("available"),
    MODIFYING("modifying"),
    INCOMPATIBLE_NETWORK("incompatible-network"),
    INSUFFICIENT_RESOURCE_LIMITS("insufficient-resource-limits"),
    CREATING("creating"),
    DELETING("deleting"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DBProxyEndpointStatus> VALUE_MAP;
    private final String value;

    private DBProxyEndpointStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DBProxyEndpointStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DBProxyEndpointStatus> knownValues() {
        EnumSet<DBProxyEndpointStatus> knownValues = EnumSet.allOf(DBProxyEndpointStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DBProxyEndpointStatus.class, DBProxyEndpointStatus::toString);
    }
}

