/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data returned from the <b>DescribePendingMaintenanceActions</b> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePendingMaintenanceActionsResponse extends RdsResponse implements
        ToCopyableBuilder<DescribePendingMaintenanceActionsResponse.Builder, DescribePendingMaintenanceActionsResponse> {
    private static final SdkField<List<ResourcePendingMaintenanceActions>> PENDING_MAINTENANCE_ACTIONS_FIELD = SdkField
            .<List<ResourcePendingMaintenanceActions>> builder(MarshallingType.LIST)
            .memberName("PendingMaintenanceActions")
            .getter(getter(DescribePendingMaintenanceActionsResponse::pendingMaintenanceActions))
            .setter(setter(Builder::pendingMaintenanceActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingMaintenanceActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ResourcePendingMaintenanceActions")
                            .memberFieldInfo(
                                    SdkField.<ResourcePendingMaintenanceActions> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcePendingMaintenanceActions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ResourcePendingMaintenanceActions").build()).build()).build())
            .build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribePendingMaintenanceActionsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PENDING_MAINTENANCE_ACTIONS_FIELD, MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ResourcePendingMaintenanceActions> pendingMaintenanceActions;

    private final String marker;

    private DescribePendingMaintenanceActionsResponse(BuilderImpl builder) {
        super(builder);
        this.pendingMaintenanceActions = builder.pendingMaintenanceActions;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the PendingMaintenanceActions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPendingMaintenanceActions() {
        return pendingMaintenanceActions != null && !(pendingMaintenanceActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the pending maintenance actions for the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPendingMaintenanceActions} method.
     * </p>
     * 
     * @return A list of the pending maintenance actions for the resource.
     */
    public final List<ResourcePendingMaintenanceActions> pendingMaintenanceActions() {
        return pendingMaintenanceActions;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code> request. If
     * this parameter is specified, the response includes only records beyond the marker, up to a number of records
     * specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code>
     *         request. If this parameter is specified, the response includes only records beyond the marker, up to a
     *         number of records specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPendingMaintenanceActions() ? pendingMaintenanceActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePendingMaintenanceActionsResponse)) {
            return false;
        }
        DescribePendingMaintenanceActionsResponse other = (DescribePendingMaintenanceActionsResponse) obj;
        return hasPendingMaintenanceActions() == other.hasPendingMaintenanceActions()
                && Objects.equals(pendingMaintenanceActions(), other.pendingMaintenanceActions())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePendingMaintenanceActionsResponse")
                .add("PendingMaintenanceActions", hasPendingMaintenanceActions() ? pendingMaintenanceActions() : null)
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PendingMaintenanceActions":
            return Optional.ofNullable(clazz.cast(pendingMaintenanceActions()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PendingMaintenanceActions", PENDING_MAINTENANCE_ACTIONS_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribePendingMaintenanceActionsResponse, T> g) {
        return obj -> g.apply((DescribePendingMaintenanceActionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribePendingMaintenanceActionsResponse> {
        /**
         * <p>
         * A list of the pending maintenance actions for the resource.
         * </p>
         * 
         * @param pendingMaintenanceActions
         *        A list of the pending maintenance actions for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingMaintenanceActions(Collection<ResourcePendingMaintenanceActions> pendingMaintenanceActions);

        /**
         * <p>
         * A list of the pending maintenance actions for the resource.
         * </p>
         * 
         * @param pendingMaintenanceActions
         *        A list of the pending maintenance actions for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingMaintenanceActions(ResourcePendingMaintenanceActions... pendingMaintenanceActions);

        /**
         * <p>
         * A list of the pending maintenance actions for the resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.ResourcePendingMaintenanceActions.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.ResourcePendingMaintenanceActions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.ResourcePendingMaintenanceActions.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #pendingMaintenanceActions(List<ResourcePendingMaintenanceActions>)}.
         * 
         * @param pendingMaintenanceActions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.ResourcePendingMaintenanceActions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingMaintenanceActions(java.util.Collection<ResourcePendingMaintenanceActions>)
         */
        Builder pendingMaintenanceActions(Consumer<ResourcePendingMaintenanceActions.Builder>... pendingMaintenanceActions);

        /**
         * <p>
         * An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code> request.
         * If this parameter is specified, the response includes only records beyond the marker, up to a number of
         * records specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code>
         *        request. If this parameter is specified, the response includes only records beyond the marker, up to a
         *        number of records specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private List<ResourcePendingMaintenanceActions> pendingMaintenanceActions = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePendingMaintenanceActionsResponse model) {
            super(model);
            pendingMaintenanceActions(model.pendingMaintenanceActions);
            marker(model.marker);
        }

        public final List<ResourcePendingMaintenanceActions.Builder> getPendingMaintenanceActions() {
            List<ResourcePendingMaintenanceActions.Builder> result = PendingMaintenanceActionsCopier
                    .copyToBuilder(this.pendingMaintenanceActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPendingMaintenanceActions(
                Collection<ResourcePendingMaintenanceActions.BuilderImpl> pendingMaintenanceActions) {
            this.pendingMaintenanceActions = PendingMaintenanceActionsCopier.copyFromBuilder(pendingMaintenanceActions);
        }

        @Override
        public final Builder pendingMaintenanceActions(Collection<ResourcePendingMaintenanceActions> pendingMaintenanceActions) {
            this.pendingMaintenanceActions = PendingMaintenanceActionsCopier.copy(pendingMaintenanceActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingMaintenanceActions(ResourcePendingMaintenanceActions... pendingMaintenanceActions) {
            pendingMaintenanceActions(Arrays.asList(pendingMaintenanceActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingMaintenanceActions(
                Consumer<ResourcePendingMaintenanceActions.Builder>... pendingMaintenanceActions) {
            pendingMaintenanceActions(Stream.of(pendingMaintenanceActions)
                    .map(c -> ResourcePendingMaintenanceActions.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribePendingMaintenanceActionsResponse build() {
            return new DescribePendingMaintenanceActionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
