/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Reserved for future use.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBClusterStatusInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<DBClusterStatusInfo.Builder, DBClusterStatusInfo> {
    private static final SdkField<String> STATUS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusType").getter(getter(DBClusterStatusInfo::statusType)).setter(setter(Builder::statusType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusType").build()).build();

    private static final SdkField<Boolean> NORMAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Normal").getter(getter(DBClusterStatusInfo::normal)).setter(setter(Builder::normal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Normal").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DBClusterStatusInfo::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(DBClusterStatusInfo::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_TYPE_FIELD,
            NORMAL_FIELD, STATUS_FIELD, MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String statusType;

    private final Boolean normal;

    private final String status;

    private final String message;

    private DBClusterStatusInfo(BuilderImpl builder) {
        this.statusType = builder.statusType;
        this.normal = builder.normal;
        this.status = builder.status;
        this.message = builder.message;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public final String statusType() {
        return statusType;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public final Boolean normal() {
        return normal;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusType());
        hashCode = 31 * hashCode + Objects.hashCode(normal());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBClusterStatusInfo)) {
            return false;
        }
        DBClusterStatusInfo other = (DBClusterStatusInfo) obj;
        return Objects.equals(statusType(), other.statusType()) && Objects.equals(normal(), other.normal())
                && Objects.equals(status(), other.status()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DBClusterStatusInfo").add("StatusType", statusType()).add("Normal", normal())
                .add("Status", status()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatusType":
            return Optional.ofNullable(clazz.cast(statusType()));
        case "Normal":
            return Optional.ofNullable(clazz.cast(normal()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StatusType", STATUS_TYPE_FIELD);
        map.put("Normal", NORMAL_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DBClusterStatusInfo, T> g) {
        return obj -> g.apply((DBClusterStatusInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBClusterStatusInfo> {
        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param statusType
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusType(String statusType);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param normal
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder normal(Boolean normal);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param status
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param message
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String statusType;

        private Boolean normal;

        private String status;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(DBClusterStatusInfo model) {
            statusType(model.statusType);
            normal(model.normal);
            status(model.status);
            message(model.message);
        }

        public final String getStatusType() {
            return statusType;
        }

        public final void setStatusType(String statusType) {
            this.statusType = statusType;
        }

        @Override
        public final Builder statusType(String statusType) {
            this.statusType = statusType;
            return this;
        }

        public final Boolean getNormal() {
            return normal;
        }

        public final void setNormal(Boolean normal) {
            this.normal = normal;
        }

        @Override
        public final Builder normal(Boolean normal) {
            this.normal = normal;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public DBClusterStatusInfo build() {
            return new DBClusterStatusInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
