/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the performance issue.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PerformanceIssueDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<PerformanceIssueDetails.Builder, PerformanceIssueDetails> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(PerformanceIssueDetails::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(PerformanceIssueDetails::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<List<Metric>> METRICS_FIELD = SdkField
            .<List<Metric>> builder(MarshallingType.LIST)
            .memberName("Metrics")
            .getter(getter(PerformanceIssueDetails::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Metric> builder(MarshallingType.SDK_POJO)
                                            .constructor(Metric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ANALYSIS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Analysis").getter(getter(PerformanceIssueDetails::analysis)).setter(setter(Builder::analysis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Analysis").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD, METRICS_FIELD, ANALYSIS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant startTime;

    private final Instant endTime;

    private final List<Metric> metrics;

    private final String analysis;

    private PerformanceIssueDetails(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.metrics = builder.metrics;
        this.analysis = builder.analysis;
    }

    /**
     * <p>
     * The time when the performance issue started.
     * </p>
     * 
     * @return The time when the performance issue started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time when the performance issue stopped.
     * </p>
     * 
     * @return The time when the performance issue stopped.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metrics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetrics() {
        return metrics != null && !(metrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metrics that are relevant to the performance issue.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetrics} method.
     * </p>
     * 
     * @return The metrics that are relevant to the performance issue.
     */
    public final List<Metric> metrics() {
        return metrics;
    }

    /**
     * <p>
     * The analysis of the performance issue. The information might contain markdown.
     * </p>
     * 
     * @return The analysis of the performance issue. The information might contain markdown.
     */
    public final String analysis() {
        return analysis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetrics() ? metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(analysis());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PerformanceIssueDetails)) {
            return false;
        }
        PerformanceIssueDetails other = (PerformanceIssueDetails) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && hasMetrics() == other.hasMetrics() && Objects.equals(metrics(), other.metrics())
                && Objects.equals(analysis(), other.analysis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PerformanceIssueDetails").add("StartTime", startTime()).add("EndTime", endTime())
                .add("Metrics", hasMetrics() ? metrics() : null).add("Analysis", analysis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "Analysis":
            return Optional.ofNullable(clazz.cast(analysis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Metrics", METRICS_FIELD);
        map.put("Analysis", ANALYSIS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PerformanceIssueDetails, T> g) {
        return obj -> g.apply((PerformanceIssueDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PerformanceIssueDetails> {
        /**
         * <p>
         * The time when the performance issue started.
         * </p>
         * 
         * @param startTime
         *        The time when the performance issue started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time when the performance issue stopped.
         * </p>
         * 
         * @param endTime
         *        The time when the performance issue stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The metrics that are relevant to the performance issue.
         * </p>
         * 
         * @param metrics
         *        The metrics that are relevant to the performance issue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Collection<Metric> metrics);

        /**
         * <p>
         * The metrics that are relevant to the performance issue.
         * </p>
         * 
         * @param metrics
         *        The metrics that are relevant to the performance issue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Metric... metrics);

        /**
         * <p>
         * The metrics that are relevant to the performance issue.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Metric.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Metric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Metric.Builder#build()}
         * is called immediately and its result is passed to {@link #metrics(List<Metric>)}.
         * 
         * @param metrics
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Metric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metrics(java.util.Collection<Metric>)
         */
        Builder metrics(Consumer<Metric.Builder>... metrics);

        /**
         * <p>
         * The analysis of the performance issue. The information might contain markdown.
         * </p>
         * 
         * @param analysis
         *        The analysis of the performance issue. The information might contain markdown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysis(String analysis);
    }

    static final class BuilderImpl implements Builder {
        private Instant startTime;

        private Instant endTime;

        private List<Metric> metrics = DefaultSdkAutoConstructList.getInstance();

        private String analysis;

        private BuilderImpl() {
        }

        private BuilderImpl(PerformanceIssueDetails model) {
            startTime(model.startTime);
            endTime(model.endTime);
            metrics(model.metrics);
            analysis(model.analysis);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<Metric.Builder> getMetrics() {
            List<Metric.Builder> result = MetricListCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Collection<Metric.BuilderImpl> metrics) {
            this.metrics = MetricListCopier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Collection<Metric> metrics) {
            this.metrics = MetricListCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Metric... metrics) {
            metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<Metric.Builder>... metrics) {
            metrics(Stream.of(metrics).map(c -> Metric.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAnalysis() {
            return analysis;
        }

        public final void setAnalysis(String analysis) {
            this.analysis = analysis;
        }

        @Override
        public final Builder analysis(String analysis) {
            this.analysis = analysis;
            return this;
        }

        @Override
        public PerformanceIssueDetails build() {
            return new PerformanceIssueDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
