/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDbSnapshotRequest extends RdsRequest implements
        ToCopyableBuilder<ModifyDbSnapshotRequest.Builder, ModifyDbSnapshotRequest> {
    private static final SdkField<String> DB_SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSnapshotIdentifier").getter(getter(ModifyDbSnapshotRequest::dbSnapshotIdentifier))
            .setter(setter(Builder::dbSnapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSnapshotIdentifier").build())
            .build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(ModifyDbSnapshotRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionGroupName").getter(getter(ModifyDbSnapshotRequest::optionGroupName))
            .setter(setter(Builder::optionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SNAPSHOT_IDENTIFIER_FIELD,
            ENGINE_VERSION_FIELD, OPTION_GROUP_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dbSnapshotIdentifier;

    private final String engineVersion;

    private final String optionGroupName;

    private ModifyDbSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.dbSnapshotIdentifier = builder.dbSnapshotIdentifier;
        this.engineVersion = builder.engineVersion;
        this.optionGroupName = builder.optionGroupName;
    }

    /**
     * <p>
     * The identifier of the DB snapshot to modify.
     * </p>
     * 
     * @return The identifier of the DB snapshot to modify.
     */
    public final String dbSnapshotIdentifier() {
        return dbSnapshotIdentifier;
    }

    /**
     * <p>
     * The engine version to upgrade the DB snapshot to.
     * </p>
     * <p>
     * The following are the database engines and engine versions that are available when you upgrade a DB snapshot.
     * </p>
     * <p>
     * <b>MySQL</b>
     * </p>
     * <p>
     * For the list of engine versions that are available for upgrading a DB snapshot, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/mysql-upgrade-snapshot.html"> Upgrading a MySQL DB
     * snapshot engine version</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <p>
     * <b>Oracle</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>19.0.0.0.ru-2022-01.rur-2022-01.r1</code> (supported for 12.2.0.1 DB snapshots)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>19.0.0.0.ru-2022-07.rur-2022-07.r1</code> (supported for 12.1.0.2 DB snapshots)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>12.1.0.2.v8</code> (supported for 12.1.0.1 DB snapshots)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>11.2.0.4.v12</code> (supported for 11.2.0.2 DB snapshots)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>11.2.0.4.v11</code> (supported for 11.2.0.3 DB snapshots)
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>PostgreSQL</b>
     * </p>
     * <p>
     * For the list of engine versions that are available for upgrading a DB snapshot, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBSnapshot.PostgreSQL.html"> Upgrading a
     * PostgreSQL DB snapshot engine version</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * 
     * @return The engine version to upgrade the DB snapshot to.</p>
     *         <p>
     *         The following are the database engines and engine versions that are available when you upgrade a DB
     *         snapshot.
     *         </p>
     *         <p>
     *         <b>MySQL</b>
     *         </p>
     *         <p>
     *         For the list of engine versions that are available for upgrading a DB snapshot, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/mysql-upgrade-snapshot.html"> Upgrading a
     *         MySQL DB snapshot engine version</a> in the <i>Amazon RDS User Guide.</i>
     *         </p>
     *         <p>
     *         <b>Oracle</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>19.0.0.0.ru-2022-01.rur-2022-01.r1</code> (supported for 12.2.0.1 DB snapshots)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>19.0.0.0.ru-2022-07.rur-2022-07.r1</code> (supported for 12.1.0.2 DB snapshots)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>12.1.0.2.v8</code> (supported for 12.1.0.1 DB snapshots)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>11.2.0.4.v12</code> (supported for 11.2.0.2 DB snapshots)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>11.2.0.4.v11</code> (supported for 11.2.0.3 DB snapshots)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>PostgreSQL</b>
     *         </p>
     *         <p>
     *         For the list of engine versions that are available for upgrading a DB snapshot, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBSnapshot.PostgreSQL.html">
     *         Upgrading a PostgreSQL DB snapshot engine version</a> in the <i>Amazon RDS User Guide.</i>
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The option group to identify with the upgraded DB snapshot.
     * </p>
     * <p>
     * You can specify this parameter when you upgrade an Oracle DB snapshot. The same option group considerations apply
     * when upgrading a DB snapshot as when upgrading a DB instance. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Oracle.html#USER_UpgradeDBInstance.Oracle.OGPG.OG"
     * >Option group considerations</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * 
     * @return The option group to identify with the upgraded DB snapshot.</p>
     *         <p>
     *         You can specify this parameter when you upgrade an Oracle DB snapshot. The same option group
     *         considerations apply when upgrading a DB snapshot as when upgrading a DB instance. For more information,
     *         see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Oracle.html#USER_UpgradeDBInstance.Oracle.OGPG.OG"
     *         >Option group considerations</a> in the <i>Amazon RDS User Guide.</i>
     */
    public final String optionGroupName() {
        return optionGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(optionGroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbSnapshotRequest)) {
            return false;
        }
        ModifyDbSnapshotRequest other = (ModifyDbSnapshotRequest) obj;
        return Objects.equals(dbSnapshotIdentifier(), other.dbSnapshotIdentifier())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(optionGroupName(), other.optionGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyDbSnapshotRequest").add("DBSnapshotIdentifier", dbSnapshotIdentifier())
                .add("EngineVersion", engineVersion()).add("OptionGroupName", optionGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBSnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(dbSnapshotIdentifier()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "OptionGroupName":
            return Optional.ofNullable(clazz.cast(optionGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DBSnapshotIdentifier", DB_SNAPSHOT_IDENTIFIER_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("OptionGroupName", OPTION_GROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbSnapshotRequest, T> g) {
        return obj -> g.apply((ModifyDbSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyDbSnapshotRequest> {
        /**
         * <p>
         * The identifier of the DB snapshot to modify.
         * </p>
         * 
         * @param dbSnapshotIdentifier
         *        The identifier of the DB snapshot to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSnapshotIdentifier(String dbSnapshotIdentifier);

        /**
         * <p>
         * The engine version to upgrade the DB snapshot to.
         * </p>
         * <p>
         * The following are the database engines and engine versions that are available when you upgrade a DB snapshot.
         * </p>
         * <p>
         * <b>MySQL</b>
         * </p>
         * <p>
         * For the list of engine versions that are available for upgrading a DB snapshot, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/mysql-upgrade-snapshot.html"> Upgrading a MySQL
         * DB snapshot engine version</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * <p>
         * <b>Oracle</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>19.0.0.0.ru-2022-01.rur-2022-01.r1</code> (supported for 12.2.0.1 DB snapshots)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>19.0.0.0.ru-2022-07.rur-2022-07.r1</code> (supported for 12.1.0.2 DB snapshots)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>12.1.0.2.v8</code> (supported for 12.1.0.1 DB snapshots)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>11.2.0.4.v12</code> (supported for 11.2.0.2 DB snapshots)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>11.2.0.4.v11</code> (supported for 11.2.0.3 DB snapshots)
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>PostgreSQL</b>
         * </p>
         * <p>
         * For the list of engine versions that are available for upgrading a DB snapshot, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBSnapshot.PostgreSQL.html">
         * Upgrading a PostgreSQL DB snapshot engine version</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * 
         * @param engineVersion
         *        The engine version to upgrade the DB snapshot to.</p>
         *        <p>
         *        The following are the database engines and engine versions that are available when you upgrade a DB
         *        snapshot.
         *        </p>
         *        <p>
         *        <b>MySQL</b>
         *        </p>
         *        <p>
         *        For the list of engine versions that are available for upgrading a DB snapshot, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/mysql-upgrade-snapshot.html"> Upgrading a
         *        MySQL DB snapshot engine version</a> in the <i>Amazon RDS User Guide.</i>
         *        </p>
         *        <p>
         *        <b>Oracle</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>19.0.0.0.ru-2022-01.rur-2022-01.r1</code> (supported for 12.2.0.1 DB snapshots)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>19.0.0.0.ru-2022-07.rur-2022-07.r1</code> (supported for 12.1.0.2 DB snapshots)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>12.1.0.2.v8</code> (supported for 12.1.0.1 DB snapshots)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>11.2.0.4.v12</code> (supported for 11.2.0.2 DB snapshots)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>11.2.0.4.v11</code> (supported for 11.2.0.3 DB snapshots)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>PostgreSQL</b>
         *        </p>
         *        <p>
         *        For the list of engine versions that are available for upgrading a DB snapshot, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBSnapshot.PostgreSQL.html">
         *        Upgrading a PostgreSQL DB snapshot engine version</a> in the <i>Amazon RDS User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The option group to identify with the upgraded DB snapshot.
         * </p>
         * <p>
         * You can specify this parameter when you upgrade an Oracle DB snapshot. The same option group considerations
         * apply when upgrading a DB snapshot as when upgrading a DB instance. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Oracle.html#USER_UpgradeDBInstance.Oracle.OGPG.OG"
         * >Option group considerations</a> in the <i>Amazon RDS User Guide.</i>
         * </p>
         * 
         * @param optionGroupName
         *        The option group to identify with the upgraded DB snapshot.</p>
         *        <p>
         *        You can specify this parameter when you upgrade an Oracle DB snapshot. The same option group
         *        considerations apply when upgrading a DB snapshot as when upgrading a DB instance. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Oracle.html#USER_UpgradeDBInstance.Oracle.OGPG.OG"
         *        >Option group considerations</a> in the <i>Amazon RDS User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupName(String optionGroupName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbSnapshotIdentifier;

        private String engineVersion;

        private String optionGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbSnapshotRequest model) {
            super(model);
            dbSnapshotIdentifier(model.dbSnapshotIdentifier);
            engineVersion(model.engineVersion);
            optionGroupName(model.optionGroupName);
        }

        public final String getDbSnapshotIdentifier() {
            return dbSnapshotIdentifier;
        }

        public final void setDbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
        }

        @Override
        public final Builder dbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getOptionGroupName() {
            return optionGroupName;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbSnapshotRequest build() {
            return new ModifyDbSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
