/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the secret managed by RDS in Amazon Web Services Secrets Manager for the master user password.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with
 * Amazon Web Services Secrets Manager</a> in the <i>Amazon RDS User Guide</i> and <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password management with
 * Amazon Web Services Secrets Manager</a> in the <i>Amazon Aurora User Guide.</i>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MasterUserSecret implements SdkPojo, Serializable,
        ToCopyableBuilder<MasterUserSecret.Builder, MasterUserSecret> {
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(MasterUserSecret::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<String> SECRET_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretStatus").getter(getter(MasterUserSecret::secretStatus)).setter(setter(Builder::secretStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretStatus").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(MasterUserSecret::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ARN_FIELD,
            SECRET_STATUS_FIELD, KMS_KEY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String secretArn;

    private final String secretStatus;

    private final String kmsKeyId;

    private MasterUserSecret(BuilderImpl builder) {
        this.secretArn = builder.secretArn;
        this.secretStatus = builder.secretStatus;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the secret.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the secret.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * The status of the secret.
     * </p>
     * <p>
     * The possible status values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>creating</code> - The secret is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>active</code> - The secret is available for normal use and rotation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rotating</code> - The secret is being rotated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>impaired</code> - The secret can be used to access database credentials, but it can't be rotated. A secret
     * might have this status if, for example, permissions are changed so that RDS can no longer access either the
     * secret or the KMS key for the secret.
     * </p>
     * <p>
     * When a secret has this status, you can correct the condition that caused the status. Alternatively, modify the DB
     * instance to turn off automatic management of database credentials, and then modify the DB instance again to turn
     * on automatic management of database credentials.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the secret.</p>
     *         <p>
     *         The possible status values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>creating</code> - The secret is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>active</code> - The secret is available for normal use and rotation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rotating</code> - The secret is being rotated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>impaired</code> - The secret can be used to access database credentials, but it can't be rotated. A
     *         secret might have this status if, for example, permissions are changed so that RDS can no longer access
     *         either the secret or the KMS key for the secret.
     *         </p>
     *         <p>
     *         When a secret has this status, you can correct the condition that caused the status. Alternatively,
     *         modify the DB instance to turn off automatic management of database credentials, and then modify the DB
     *         instance again to turn on automatic management of database credentials.
     *         </p>
     *         </li>
     */
    public final String secretStatus() {
        return secretStatus;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key identifier that is used to encrypt the secret.
     * </p>
     * 
     * @return The Amazon Web Services KMS key identifier that is used to encrypt the secret.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(secretStatus());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MasterUserSecret)) {
            return false;
        }
        MasterUserSecret other = (MasterUserSecret) obj;
        return Objects.equals(secretArn(), other.secretArn()) && Objects.equals(secretStatus(), other.secretStatus())
                && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MasterUserSecret").add("SecretArn", secretArn()).add("SecretStatus", secretStatus())
                .add("KmsKeyId", kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "SecretStatus":
            return Optional.ofNullable(clazz.cast(secretStatus()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("SecretStatus", SECRET_STATUS_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MasterUserSecret, T> g) {
        return obj -> g.apply((MasterUserSecret) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MasterUserSecret> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the secret.
         * </p>
         * 
         * @param secretArn
         *        The Amazon Resource Name (ARN) of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * The status of the secret.
         * </p>
         * <p>
         * The possible status values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>creating</code> - The secret is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>active</code> - The secret is available for normal use and rotation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rotating</code> - The secret is being rotated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>impaired</code> - The secret can be used to access database credentials, but it can't be rotated. A
         * secret might have this status if, for example, permissions are changed so that RDS can no longer access
         * either the secret or the KMS key for the secret.
         * </p>
         * <p>
         * When a secret has this status, you can correct the condition that caused the status. Alternatively, modify
         * the DB instance to turn off automatic management of database credentials, and then modify the DB instance
         * again to turn on automatic management of database credentials.
         * </p>
         * </li>
         * </ul>
         * 
         * @param secretStatus
         *        The status of the secret.</p>
         *        <p>
         *        The possible status values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>creating</code> - The secret is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>active</code> - The secret is available for normal use and rotation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rotating</code> - The secret is being rotated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>impaired</code> - The secret can be used to access database credentials, but it can't be
         *        rotated. A secret might have this status if, for example, permissions are changed so that RDS can no
         *        longer access either the secret or the KMS key for the secret.
         *        </p>
         *        <p>
         *        When a secret has this status, you can correct the condition that caused the status. Alternatively,
         *        modify the DB instance to turn off automatic management of database credentials, and then modify the
         *        DB instance again to turn on automatic management of database credentials.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretStatus(String secretStatus);

        /**
         * <p>
         * The Amazon Web Services KMS key identifier that is used to encrypt the secret.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Web Services KMS key identifier that is used to encrypt the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String secretArn;

        private String secretStatus;

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(MasterUserSecret model) {
            secretArn(model.secretArn);
            secretStatus(model.secretStatus);
            kmsKeyId(model.kmsKeyId);
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getSecretStatus() {
            return secretStatus;
        }

        public final void setSecretStatus(String secretStatus) {
            this.secretStatus = secretStatus;
        }

        @Override
        public final Builder secretStatus(String secretStatus) {
            this.secretStatus = secretStatus;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public MasterUserSecret build() {
            return new MasterUserSecret(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
