/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDbSubnetGroupResponse extends RdsResponse implements
        ToCopyableBuilder<CreateDbSubnetGroupResponse.Builder, CreateDbSubnetGroupResponse> {
    private static final SdkField<DBSubnetGroup> DB_SUBNET_GROUP_FIELD = SdkField
            .<DBSubnetGroup> builder(MarshallingType.SDK_POJO).memberName("DBSubnetGroup")
            .getter(getter(CreateDbSubnetGroupResponse::dbSubnetGroup)).setter(setter(Builder::dbSubnetGroup))
            .constructor(DBSubnetGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SUBNET_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DBSubnetGroup dbSubnetGroup;

    private CreateDbSubnetGroupResponse(BuilderImpl builder) {
        super(builder);
        this.dbSubnetGroup = builder.dbSubnetGroup;
    }

    /**
     * Returns the value of the DBSubnetGroup property for this object.
     * 
     * @return The value of the DBSubnetGroup property for this object.
     */
    public final DBSubnetGroup dbSubnetGroup() {
        return dbSubnetGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbSubnetGroupResponse)) {
            return false;
        }
        CreateDbSubnetGroupResponse other = (CreateDbSubnetGroupResponse) obj;
        return Objects.equals(dbSubnetGroup(), other.dbSubnetGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDbSubnetGroupResponse").add("DBSubnetGroup", dbSubnetGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBSubnetGroup":
            return Optional.ofNullable(clazz.cast(dbSubnetGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DBSubnetGroup", DB_SUBNET_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDbSubnetGroupResponse, T> g) {
        return obj -> g.apply((CreateDbSubnetGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDbSubnetGroupResponse> {
        /**
         * Sets the value of the DBSubnetGroup property for this object.
         *
         * @param dbSubnetGroup
         *        The new value for the DBSubnetGroup property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroup(DBSubnetGroup dbSubnetGroup);

        /**
         * Sets the value of the DBSubnetGroup property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DBSubnetGroup.Builder} avoiding the need
         * to create one manually via {@link DBSubnetGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DBSubnetGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #dbSubnetGroup(DBSubnetGroup)}.
         * 
         * @param dbSubnetGroup
         *        a consumer that will call methods on {@link DBSubnetGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbSubnetGroup(DBSubnetGroup)
         */
        default Builder dbSubnetGroup(Consumer<DBSubnetGroup.Builder> dbSubnetGroup) {
            return dbSubnetGroup(DBSubnetGroup.builder().applyMutation(dbSubnetGroup).build());
        }
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private DBSubnetGroup dbSubnetGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDbSubnetGroupResponse model) {
            super(model);
            dbSubnetGroup(model.dbSubnetGroup);
        }

        public final DBSubnetGroup.Builder getDbSubnetGroup() {
            return dbSubnetGroup != null ? dbSubnetGroup.toBuilder() : null;
        }

        public final void setDbSubnetGroup(DBSubnetGroup.BuilderImpl dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup != null ? dbSubnetGroup.build() : null;
        }

        @Override
        public final Builder dbSubnetGroup(DBSubnetGroup dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup;
            return this;
        }

        @Override
        public CreateDbSubnetGroupResponse build() {
            return new CreateDbSubnetGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
