/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details about a blue/green deployment.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS Blue/Green
 * Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html">Using Amazon RDS
 * Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SwitchoverDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<SwitchoverDetail.Builder, SwitchoverDetail> {
    private static final SdkField<String> SOURCE_MEMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceMember").getter(getter(SwitchoverDetail::sourceMember)).setter(setter(Builder::sourceMember))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceMember").build()).build();

    private static final SdkField<String> TARGET_MEMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetMember").getter(getter(SwitchoverDetail::targetMember)).setter(setter(Builder::targetMember))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMember").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(SwitchoverDetail::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_MEMBER_FIELD,
            TARGET_MEMBER_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceMember;

    private final String targetMember;

    private final String status;

    private SwitchoverDetail(BuilderImpl builder) {
        this.sourceMember = builder.sourceMember;
        this.targetMember = builder.targetMember;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a resource in the blue environment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a resource in the blue environment.
     */
    public final String sourceMember() {
        return sourceMember;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a resource in the green environment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a resource in the green environment.
     */
    public final String targetMember() {
        return targetMember;
    }

    /**
     * <p>
     * The switchover status of a resource in a blue/green deployment.
     * </p>
     * <p>
     * Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PROVISIONING</code> - The resource is being prepared to switch over.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AVAILABLE</code> - The resource is ready to switch over.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SWITCHOVER_IN_PROGRESS</code> - The resource is being switched over.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SWITCHOVER_COMPLETED</code> - The resource has been switched over.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SWITCHOVER_FAILED</code> - The resource attempted to switch over but failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MISSING_SOURCE</code> - The source resource has been deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MISSING_TARGET</code> - The target resource has been deleted.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The switchover status of a resource in a blue/green deployment.</p>
     *         <p>
     *         Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PROVISIONING</code> - The resource is being prepared to switch over.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AVAILABLE</code> - The resource is ready to switch over.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SWITCHOVER_IN_PROGRESS</code> - The resource is being switched over.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SWITCHOVER_COMPLETED</code> - The resource has been switched over.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SWITCHOVER_FAILED</code> - The resource attempted to switch over but failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MISSING_SOURCE</code> - The source resource has been deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MISSING_TARGET</code> - The target resource has been deleted.
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceMember());
        hashCode = 31 * hashCode + Objects.hashCode(targetMember());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SwitchoverDetail)) {
            return false;
        }
        SwitchoverDetail other = (SwitchoverDetail) obj;
        return Objects.equals(sourceMember(), other.sourceMember()) && Objects.equals(targetMember(), other.targetMember())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SwitchoverDetail").add("SourceMember", sourceMember()).add("TargetMember", targetMember())
                .add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceMember":
            return Optional.ofNullable(clazz.cast(sourceMember()));
        case "TargetMember":
            return Optional.ofNullable(clazz.cast(targetMember()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceMember", SOURCE_MEMBER_FIELD);
        map.put("TargetMember", TARGET_MEMBER_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SwitchoverDetail, T> g) {
        return obj -> g.apply((SwitchoverDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SwitchoverDetail> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a resource in the blue environment.
         * </p>
         * 
         * @param sourceMember
         *        The Amazon Resource Name (ARN) of a resource in the blue environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceMember(String sourceMember);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a resource in the green environment.
         * </p>
         * 
         * @param targetMember
         *        The Amazon Resource Name (ARN) of a resource in the green environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetMember(String targetMember);

        /**
         * <p>
         * The switchover status of a resource in a blue/green deployment.
         * </p>
         * <p>
         * Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PROVISIONING</code> - The resource is being prepared to switch over.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AVAILABLE</code> - The resource is ready to switch over.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SWITCHOVER_IN_PROGRESS</code> - The resource is being switched over.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SWITCHOVER_COMPLETED</code> - The resource has been switched over.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SWITCHOVER_FAILED</code> - The resource attempted to switch over but failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MISSING_SOURCE</code> - The source resource has been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MISSING_TARGET</code> - The target resource has been deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The switchover status of a resource in a blue/green deployment.</p>
         *        <p>
         *        Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PROVISIONING</code> - The resource is being prepared to switch over.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AVAILABLE</code> - The resource is ready to switch over.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SWITCHOVER_IN_PROGRESS</code> - The resource is being switched over.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SWITCHOVER_COMPLETED</code> - The resource has been switched over.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SWITCHOVER_FAILED</code> - The resource attempted to switch over but failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MISSING_SOURCE</code> - The source resource has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MISSING_TARGET</code> - The target resource has been deleted.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String sourceMember;

        private String targetMember;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SwitchoverDetail model) {
            sourceMember(model.sourceMember);
            targetMember(model.targetMember);
            status(model.status);
        }

        public final String getSourceMember() {
            return sourceMember;
        }

        public final void setSourceMember(String sourceMember) {
            this.sourceMember = sourceMember;
        }

        @Override
        public final Builder sourceMember(String sourceMember) {
            this.sourceMember = sourceMember;
            return this;
        }

        public final String getTargetMember() {
            return targetMember;
        }

        public final void setTargetMember(String targetMember) {
            this.targetMember = targetMember;
        }

        @Override
        public final Builder targetMember(String targetMember) {
            this.targetMember = targetMember;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public SwitchoverDetail build() {
            return new SwitchoverDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
