/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyTenantDatabaseRequest extends RdsRequest implements
        ToCopyableBuilder<ModifyTenantDatabaseRequest.Builder, ModifyTenantDatabaseRequest> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceIdentifier").getter(getter(ModifyTenantDatabaseRequest::dbInstanceIdentifier))
            .setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<String> TENANT_DB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TenantDBName").getter(getter(ModifyTenantDatabaseRequest::tenantDBName))
            .setter(setter(Builder::tenantDBName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantDBName").build()).build();

    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUserPassword").getter(getter(ModifyTenantDatabaseRequest::masterUserPassword))
            .setter(setter(Builder::masterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserPassword").build())
            .build();

    private static final SdkField<String> NEW_TENANT_DB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewTenantDBName").getter(getter(ModifyTenantDatabaseRequest::newTenantDBName))
            .setter(setter(Builder::newTenantDBName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewTenantDBName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD,
            TENANT_DB_NAME_FIELD, MASTER_USER_PASSWORD_FIELD, NEW_TENANT_DB_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dbInstanceIdentifier;

    private final String tenantDBName;

    private final String masterUserPassword;

    private final String newTenantDBName;

    private ModifyTenantDatabaseRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.tenantDBName = builder.tenantDBName;
        this.masterUserPassword = builder.masterUserPassword;
        this.newTenantDBName = builder.newTenantDBName;
    }

    /**
     * <p>
     * The identifier of the DB instance that contains the tenant database that you are modifying. This parameter isn't
     * case-sensitive.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the identifier of an existing DB instance.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier of the DB instance that contains the tenant database that you are modifying. This
     *         parameter isn't case-sensitive.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the identifier of an existing DB instance.
     *         </p>
     *         </li>
     */
    public final String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * The user-supplied name of the tenant database that you want to modify. This parameter isn’t case-sensitive.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the identifier of an existing tenant database.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The user-supplied name of the tenant database that you want to modify. This parameter isn’t
     *         case-sensitive.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the identifier of an existing tenant database.
     *         </p>
     *         </li>
     */
    public final String tenantDBName() {
        return tenantDBName;
    }

    /**
     * <p>
     * The new password for the master user of the specified tenant database in your DB instance.
     * </p>
     * <note>
     * <p>
     * Amazon RDS operations never return the password, so this action provides a way to regain access to a tenant
     * database user if the password is lost. This includes restoring privileges that might have been accidentally
     * revoked.
     * </p>
     * </note>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Can include any printable ASCII character except <code>/</code>, <code>"</code> (double quote), <code>@</code>,
     * <code>&amp;</code> (ampersand), and <code>'</code> (single quote).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Length constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain between 8 and 30 characters.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The new password for the master user of the specified tenant database in your DB instance.</p> <note>
     *         <p>
     *         Amazon RDS operations never return the password, so this action provides a way to regain access to a
     *         tenant database user if the password is lost. This includes restoring privileges that might have been
     *         accidentally revoked.
     *         </p>
     *         </note>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Can include any printable ASCII character except <code>/</code>, <code>"</code> (double quote),
     *         <code>@</code>, <code>&amp;</code> (ampersand), and <code>'</code> (single quote).
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Length constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain between 8 and 30 characters.
     *         </p>
     *         </li>
     */
    public final String masterUserPassword() {
        return masterUserPassword;
    }

    /**
     * <p>
     * The new name of the tenant database when renaming a tenant database. This parameter isn’t case-sensitive.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Can't be the string null or any other reserved word.
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't be longer than 8 characters.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The new name of the tenant database when renaming a tenant database. This parameter isn’t
     *         case-sensitive.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Can't be the string null or any other reserved word.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't be longer than 8 characters.
     *         </p>
     *         </li>
     */
    public final String newTenantDBName() {
        return newTenantDBName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(tenantDBName());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(newTenantDBName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTenantDatabaseRequest)) {
            return false;
        }
        ModifyTenantDatabaseRequest other = (ModifyTenantDatabaseRequest) obj;
        return Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(tenantDBName(), other.tenantDBName())
                && Objects.equals(masterUserPassword(), other.masterUserPassword())
                && Objects.equals(newTenantDBName(), other.newTenantDBName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyTenantDatabaseRequest").add("DBInstanceIdentifier", dbInstanceIdentifier())
                .add("TenantDBName", tenantDBName())
                .add("MasterUserPassword", masterUserPassword() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NewTenantDBName", newTenantDBName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "TenantDBName":
            return Optional.ofNullable(clazz.cast(tenantDBName()));
        case "MasterUserPassword":
            return Optional.ofNullable(clazz.cast(masterUserPassword()));
        case "NewTenantDBName":
            return Optional.ofNullable(clazz.cast(newTenantDBName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DBInstanceIdentifier", DB_INSTANCE_IDENTIFIER_FIELD);
        map.put("TenantDBName", TENANT_DB_NAME_FIELD);
        map.put("MasterUserPassword", MASTER_USER_PASSWORD_FIELD);
        map.put("NewTenantDBName", NEW_TENANT_DB_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyTenantDatabaseRequest, T> g) {
        return obj -> g.apply((ModifyTenantDatabaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyTenantDatabaseRequest> {
        /**
         * <p>
         * The identifier of the DB instance that contains the tenant database that you are modifying. This parameter
         * isn't case-sensitive.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match the identifier of an existing DB instance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbInstanceIdentifier
         *        The identifier of the DB instance that contains the tenant database that you are modifying. This
         *        parameter isn't case-sensitive.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match the identifier of an existing DB instance.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * The user-supplied name of the tenant database that you want to modify. This parameter isn’t case-sensitive.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match the identifier of an existing tenant database.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tenantDBName
         *        The user-supplied name of the tenant database that you want to modify. This parameter isn’t
         *        case-sensitive.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match the identifier of an existing tenant database.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantDBName(String tenantDBName);

        /**
         * <p>
         * The new password for the master user of the specified tenant database in your DB instance.
         * </p>
         * <note>
         * <p>
         * Amazon RDS operations never return the password, so this action provides a way to regain access to a tenant
         * database user if the password is lost. This includes restoring privileges that might have been accidentally
         * revoked.
         * </p>
         * </note>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Can include any printable ASCII character except <code>/</code>, <code>"</code> (double quote),
         * <code>@</code>, <code>&amp;</code> (ampersand), and <code>'</code> (single quote).
         * </p>
         * </li>
         * </ul>
         * <p>
         * Length constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain between 8 and 30 characters.
         * </p>
         * </li>
         * </ul>
         * 
         * @param masterUserPassword
         *        The new password for the master user of the specified tenant database in your DB instance.</p> <note>
         *        <p>
         *        Amazon RDS operations never return the password, so this action provides a way to regain access to a
         *        tenant database user if the password is lost. This includes restoring privileges that might have been
         *        accidentally revoked.
         *        </p>
         *        </note>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Can include any printable ASCII character except <code>/</code>, <code>"</code> (double quote),
         *        <code>@</code>, <code>&amp;</code> (ampersand), and <code>'</code> (single quote).
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Length constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain between 8 and 30 characters.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserPassword(String masterUserPassword);

        /**
         * <p>
         * The new name of the tenant database when renaming a tenant database. This parameter isn’t case-sensitive.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Can't be the string null or any other reserved word.
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't be longer than 8 characters.
         * </p>
         * </li>
         * </ul>
         * 
         * @param newTenantDBName
         *        The new name of the tenant database when renaming a tenant database. This parameter isn’t
         *        case-sensitive.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Can't be the string null or any other reserved word.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't be longer than 8 characters.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newTenantDBName(String newTenantDBName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbInstanceIdentifier;

        private String tenantDBName;

        private String masterUserPassword;

        private String newTenantDBName;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTenantDatabaseRequest model) {
            super(model);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            tenantDBName(model.tenantDBName);
            masterUserPassword(model.masterUserPassword);
            newTenantDBName(model.newTenantDBName);
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final String getTenantDBName() {
            return tenantDBName;
        }

        public final void setTenantDBName(String tenantDBName) {
            this.tenantDBName = tenantDBName;
        }

        @Override
        public final Builder tenantDBName(String tenantDBName) {
            this.tenantDBName = tenantDBName;
            return this;
        }

        public final String getMasterUserPassword() {
            return masterUserPassword;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final String getNewTenantDBName() {
            return newTenantDBName;
        }

        public final void setNewTenantDBName(String newTenantDBName) {
            this.newTenantDBName = newTenantDBName;
        }

        @Override
        public final Builder newTenantDBName(String newTenantDBName) {
            this.newTenantDBName = newTenantDBName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyTenantDatabaseRequest build() {
            return new ModifyTenantDatabaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
