/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDbShardGroupRequest extends RdsRequest implements
        ToCopyableBuilder<ModifyDbShardGroupRequest.Builder, ModifyDbShardGroupRequest> {
    private static final SdkField<String> DB_SHARD_GROUP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBShardGroupIdentifier").getter(getter(ModifyDbShardGroupRequest::dbShardGroupIdentifier))
            .setter(setter(Builder::dbShardGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBShardGroupIdentifier").build())
            .build();

    private static final SdkField<Double> MAX_ACU_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("MaxACU")
            .getter(getter(ModifyDbShardGroupRequest::maxACU)).setter(setter(Builder::maxACU))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxACU").build()).build();

    private static final SdkField<Double> MIN_ACU_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("MinACU")
            .getter(getter(ModifyDbShardGroupRequest::minACU)).setter(setter(Builder::minACU))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinACU").build()).build();

    private static final SdkField<Integer> COMPUTE_REDUNDANCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ComputeRedundancy").getter(getter(ModifyDbShardGroupRequest::computeRedundancy))
            .setter(setter(Builder::computeRedundancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeRedundancy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DB_SHARD_GROUP_IDENTIFIER_FIELD, MAX_ACU_FIELD, MIN_ACU_FIELD, COMPUTE_REDUNDANCY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dbShardGroupIdentifier;

    private final Double maxACU;

    private final Double minACU;

    private final Integer computeRedundancy;

    private ModifyDbShardGroupRequest(BuilderImpl builder) {
        super(builder);
        this.dbShardGroupIdentifier = builder.dbShardGroupIdentifier;
        this.maxACU = builder.maxACU;
        this.minACU = builder.minACU;
        this.computeRedundancy = builder.computeRedundancy;
    }

    /**
     * <p>
     * The name of the DB shard group to modify.
     * </p>
     * 
     * @return The name of the DB shard group to modify.
     */
    public final String dbShardGroupIdentifier() {
        return dbShardGroupIdentifier;
    }

    /**
     * <p>
     * The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
     * </p>
     * 
     * @return The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
     */
    public final Double maxACU() {
        return maxACU;
    }

    /**
     * <p>
     * The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
     * </p>
     * 
     * @return The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
     */
    public final Double minACU() {
        return minACU;
    }

    /**
     * <p>
     * Specifies whether to create standby DB shard groups for the DB shard group. Valid values are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * 0 - Creates a DB shard group without a standby DB shard group. This is the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * 1 - Creates a DB shard group with a standby DB shard group in a different Availability Zone (AZ).
     * </p>
     * </li>
     * <li>
     * <p>
     * 2 - Creates a DB shard group with two standby DB shard groups in two different AZs.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies whether to create standby DB shard groups for the DB shard group. Valid values are the
     *         following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         0 - Creates a DB shard group without a standby DB shard group. This is the default value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1 - Creates a DB shard group with a standby DB shard group in a different Availability Zone (AZ).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2 - Creates a DB shard group with two standby DB shard groups in two different AZs.
     *         </p>
     *         </li>
     */
    public final Integer computeRedundancy() {
        return computeRedundancy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbShardGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxACU());
        hashCode = 31 * hashCode + Objects.hashCode(minACU());
        hashCode = 31 * hashCode + Objects.hashCode(computeRedundancy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbShardGroupRequest)) {
            return false;
        }
        ModifyDbShardGroupRequest other = (ModifyDbShardGroupRequest) obj;
        return Objects.equals(dbShardGroupIdentifier(), other.dbShardGroupIdentifier())
                && Objects.equals(maxACU(), other.maxACU()) && Objects.equals(minACU(), other.minACU())
                && Objects.equals(computeRedundancy(), other.computeRedundancy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyDbShardGroupRequest").add("DBShardGroupIdentifier", dbShardGroupIdentifier())
                .add("MaxACU", maxACU()).add("MinACU", minACU()).add("ComputeRedundancy", computeRedundancy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBShardGroupIdentifier":
            return Optional.ofNullable(clazz.cast(dbShardGroupIdentifier()));
        case "MaxACU":
            return Optional.ofNullable(clazz.cast(maxACU()));
        case "MinACU":
            return Optional.ofNullable(clazz.cast(minACU()));
        case "ComputeRedundancy":
            return Optional.ofNullable(clazz.cast(computeRedundancy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DBShardGroupIdentifier", DB_SHARD_GROUP_IDENTIFIER_FIELD);
        map.put("MaxACU", MAX_ACU_FIELD);
        map.put("MinACU", MIN_ACU_FIELD);
        map.put("ComputeRedundancy", COMPUTE_REDUNDANCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbShardGroupRequest, T> g) {
        return obj -> g.apply((ModifyDbShardGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyDbShardGroupRequest> {
        /**
         * <p>
         * The name of the DB shard group to modify.
         * </p>
         * 
         * @param dbShardGroupIdentifier
         *        The name of the DB shard group to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbShardGroupIdentifier(String dbShardGroupIdentifier);

        /**
         * <p>
         * The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
         * </p>
         * 
         * @param maxACU
         *        The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxACU(Double maxACU);

        /**
         * <p>
         * The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
         * </p>
         * 
         * @param minACU
         *        The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minACU(Double minACU);

        /**
         * <p>
         * Specifies whether to create standby DB shard groups for the DB shard group. Valid values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * 0 - Creates a DB shard group without a standby DB shard group. This is the default value.
         * </p>
         * </li>
         * <li>
         * <p>
         * 1 - Creates a DB shard group with a standby DB shard group in a different Availability Zone (AZ).
         * </p>
         * </li>
         * <li>
         * <p>
         * 2 - Creates a DB shard group with two standby DB shard groups in two different AZs.
         * </p>
         * </li>
         * </ul>
         * 
         * @param computeRedundancy
         *        Specifies whether to create standby DB shard groups for the DB shard group. Valid values are the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        0 - Creates a DB shard group without a standby DB shard group. This is the default value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1 - Creates a DB shard group with a standby DB shard group in a different Availability Zone (AZ).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        2 - Creates a DB shard group with two standby DB shard groups in two different AZs.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeRedundancy(Integer computeRedundancy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbShardGroupIdentifier;

        private Double maxACU;

        private Double minACU;

        private Integer computeRedundancy;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbShardGroupRequest model) {
            super(model);
            dbShardGroupIdentifier(model.dbShardGroupIdentifier);
            maxACU(model.maxACU);
            minACU(model.minACU);
            computeRedundancy(model.computeRedundancy);
        }

        public final String getDbShardGroupIdentifier() {
            return dbShardGroupIdentifier;
        }

        public final void setDbShardGroupIdentifier(String dbShardGroupIdentifier) {
            this.dbShardGroupIdentifier = dbShardGroupIdentifier;
        }

        @Override
        public final Builder dbShardGroupIdentifier(String dbShardGroupIdentifier) {
            this.dbShardGroupIdentifier = dbShardGroupIdentifier;
            return this;
        }

        public final Double getMaxACU() {
            return maxACU;
        }

        public final void setMaxACU(Double maxACU) {
            this.maxACU = maxACU;
        }

        @Override
        public final Builder maxACU(Double maxACU) {
            this.maxACU = maxACU;
            return this;
        }

        public final Double getMinACU() {
            return minACU;
        }

        public final void setMinACU(Double minACU) {
            this.minACU = minACU;
        }

        @Override
        public final Builder minACU(Double minACU) {
            this.minACU = minACU;
            return this;
        }

        public final Integer getComputeRedundancy() {
            return computeRedundancy;
        }

        public final void setComputeRedundancy(Integer computeRedundancy) {
            this.computeRedundancy = computeRedundancy;
        }

        @Override
        public final Builder computeRedundancy(Integer computeRedundancy) {
            this.computeRedundancy = computeRedundancy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbShardGroupRequest build() {
            return new ModifyDbShardGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
