/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTenantDatabasesResponse extends RdsResponse implements
        ToCopyableBuilder<DescribeTenantDatabasesResponse.Builder, DescribeTenantDatabasesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeTenantDatabasesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<TenantDatabase>> TENANT_DATABASES_FIELD = SdkField
            .<List<TenantDatabase>> builder(MarshallingType.LIST)
            .memberName("TenantDatabases")
            .getter(getter(DescribeTenantDatabasesResponse::tenantDatabases))
            .setter(setter(Builder::tenantDatabases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantDatabases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("TenantDatabase")
                            .memberFieldInfo(
                                    SdkField.<TenantDatabase> builder(MarshallingType.SDK_POJO)
                                            .constructor(TenantDatabase::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("TenantDatabase").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            TENANT_DATABASES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String marker;

    private final List<TenantDatabase> tenantDatabases;

    private DescribeTenantDatabasesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.tenantDatabases = builder.tenantDatabases;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous <code>DescribeTenantDatabases</code> request. If this
     * parameter is specified, the response includes only records beyond the marker, up to the value specified by
     * <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous <code>DescribeTenantDatabases</code> request. If this
     *         parameter is specified, the response includes only records beyond the marker, up to the value specified
     *         by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the TenantDatabases property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTenantDatabases() {
        return tenantDatabases != null && !(tenantDatabases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of the tenant databases requested by the <code>DescribeTenantDatabases</code> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTenantDatabases} method.
     * </p>
     * 
     * @return An array of the tenant databases requested by the <code>DescribeTenantDatabases</code> operation.
     */
    public final List<TenantDatabase> tenantDatabases() {
        return tenantDatabases;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasTenantDatabases() ? tenantDatabases() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTenantDatabasesResponse)) {
            return false;
        }
        DescribeTenantDatabasesResponse other = (DescribeTenantDatabasesResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasTenantDatabases() == other.hasTenantDatabases()
                && Objects.equals(tenantDatabases(), other.tenantDatabases());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTenantDatabasesResponse").add("Marker", marker())
                .add("TenantDatabases", hasTenantDatabases() ? tenantDatabases() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "TenantDatabases":
            return Optional.ofNullable(clazz.cast(tenantDatabases()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Marker", MARKER_FIELD);
        map.put("TenantDatabases", TENANT_DATABASES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTenantDatabasesResponse, T> g) {
        return obj -> g.apply((DescribeTenantDatabasesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTenantDatabasesResponse> {
        /**
         * <p>
         * An optional pagination token provided by a previous <code>DescribeTenantDatabases</code> request. If this
         * parameter is specified, the response includes only records beyond the marker, up to the value specified by
         * <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous <code>DescribeTenantDatabases</code> request. If
         *        this parameter is specified, the response includes only records beyond the marker, up to the value
         *        specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * An array of the tenant databases requested by the <code>DescribeTenantDatabases</code> operation.
         * </p>
         * 
         * @param tenantDatabases
         *        An array of the tenant databases requested by the <code>DescribeTenantDatabases</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantDatabases(Collection<TenantDatabase> tenantDatabases);

        /**
         * <p>
         * An array of the tenant databases requested by the <code>DescribeTenantDatabases</code> operation.
         * </p>
         * 
         * @param tenantDatabases
         *        An array of the tenant databases requested by the <code>DescribeTenantDatabases</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantDatabases(TenantDatabase... tenantDatabases);

        /**
         * <p>
         * An array of the tenant databases requested by the <code>DescribeTenantDatabases</code> operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.TenantDatabase.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rds.model.TenantDatabase#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.TenantDatabase.Builder#build()} is called immediately and
         * its result is passed to {@link #tenantDatabases(List<TenantDatabase>)}.
         * 
         * @param tenantDatabases
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.TenantDatabase.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tenantDatabases(java.util.Collection<TenantDatabase>)
         */
        Builder tenantDatabases(Consumer<TenantDatabase.Builder>... tenantDatabases);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private String marker;

        private List<TenantDatabase> tenantDatabases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTenantDatabasesResponse model) {
            super(model);
            marker(model.marker);
            tenantDatabases(model.tenantDatabases);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<TenantDatabase.Builder> getTenantDatabases() {
            List<TenantDatabase.Builder> result = TenantDatabasesListCopier.copyToBuilder(this.tenantDatabases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTenantDatabases(Collection<TenantDatabase.BuilderImpl> tenantDatabases) {
            this.tenantDatabases = TenantDatabasesListCopier.copyFromBuilder(tenantDatabases);
        }

        @Override
        public final Builder tenantDatabases(Collection<TenantDatabase> tenantDatabases) {
            this.tenantDatabases = TenantDatabasesListCopier.copy(tenantDatabases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tenantDatabases(TenantDatabase... tenantDatabases) {
            tenantDatabases(Arrays.asList(tenantDatabases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tenantDatabases(Consumer<TenantDatabase.Builder>... tenantDatabases) {
            tenantDatabases(Stream.of(tenantDatabases).map(c -> TenantDatabase.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeTenantDatabasesResponse build() {
            return new DescribeTenantDatabasesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
