/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionRequest;
import software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionResponse;

public class DownloadDBLogFilePortionIterable
implements SdkIterable<DownloadDbLogFilePortionResponse> {
    private final RdsClient client;
    private final DownloadDbLogFilePortionRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DownloadDBLogFilePortionIterable(RdsClient client, DownloadDbLogFilePortionRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DownloadDbLogFilePortionResponseFetcher();
    }

    public Iterator<DownloadDbLogFilePortionResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final DownloadDBLogFilePortionIterable resume(DownloadDbLogFilePortionResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DownloadDBLogFilePortionIterable(this.client, (DownloadDbLogFilePortionRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DownloadDBLogFilePortionIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DownloadDbLogFilePortionResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DownloadDbLogFilePortionResponseFetcher
    implements SyncPageFetcher<DownloadDbLogFilePortionResponse> {
        private DownloadDbLogFilePortionResponseFetcher() {
        }

        public boolean hasNextPage(DownloadDbLogFilePortionResponse previousPage) {
            return previousPage.additionalDataPending();
        }

        public DownloadDbLogFilePortionResponse nextPage(DownloadDbLogFilePortionResponse previousPage) {
            if (previousPage == null) {
                return DownloadDBLogFilePortionIterable.this.client.downloadDBLogFilePortion(DownloadDBLogFilePortionIterable.this.firstRequest);
            }
            return DownloadDBLogFilePortionIterable.this.client.downloadDBLogFilePortion((DownloadDbLogFilePortionRequest)((Object)DownloadDBLogFilePortionIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

