/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse;
import software.amazon.awssdk.services.rds.model.OptionGroupOption;

public class DescribeOptionGroupOptionsIterable
implements SdkIterable<DescribeOptionGroupOptionsResponse> {
    private final RdsClient client;
    private final DescribeOptionGroupOptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeOptionGroupOptionsIterable(RdsClient client, DescribeOptionGroupOptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeOptionGroupOptionsResponseFetcher();
    }

    public Iterator<DescribeOptionGroupOptionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OptionGroupOption> optionGroupOptions() {
        Function<DescribeOptionGroupOptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.optionGroupOptions() != null) {
                return response.optionGroupOptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeOptionGroupOptionsIterable resume(DescribeOptionGroupOptionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeOptionGroupOptionsIterable(this.client, (DescribeOptionGroupOptionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeOptionGroupOptionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeOptionGroupOptionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeOptionGroupOptionsResponseFetcher
    implements SyncPageFetcher<DescribeOptionGroupOptionsResponse> {
        private DescribeOptionGroupOptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOptionGroupOptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeOptionGroupOptionsResponse nextPage(DescribeOptionGroupOptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOptionGroupOptionsIterable.this.client.describeOptionGroupOptions(DescribeOptionGroupOptionsIterable.this.firstRequest);
            }
            return DescribeOptionGroupOptionsIterable.this.client.describeOptionGroupOptions((DescribeOptionGroupOptionsRequest)((Object)DescribeOptionGroupOptionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

