/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevokeDbSecurityGroupIngressRequest extends RdsRequest implements
        ToCopyableBuilder<RevokeDbSecurityGroupIngressRequest.Builder, RevokeDbSecurityGroupIngressRequest> {
    private static final SdkField<String> DB_SECURITY_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSecurityGroupName").getter(getter(RevokeDbSecurityGroupIngressRequest::dbSecurityGroupName))
            .setter(setter(Builder::dbSecurityGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroupName").build())
            .build();

    private static final SdkField<String> CIDRIP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("CIDRIP")
            .getter(getter(RevokeDbSecurityGroupIngressRequest::cidrip)).setter(setter(Builder::cidrip))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CIDRIP").build()).build();

    private static final SdkField<String> EC2_SECURITY_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EC2SecurityGroupName").getter(getter(RevokeDbSecurityGroupIngressRequest::ec2SecurityGroupName))
            .setter(setter(Builder::ec2SecurityGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2SecurityGroupName").build())
            .build();

    private static final SdkField<String> EC2_SECURITY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EC2SecurityGroupId").getter(getter(RevokeDbSecurityGroupIngressRequest::ec2SecurityGroupId))
            .setter(setter(Builder::ec2SecurityGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2SecurityGroupId").build())
            .build();

    private static final SdkField<String> EC2_SECURITY_GROUP_OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EC2SecurityGroupOwnerId").getter(getter(RevokeDbSecurityGroupIngressRequest::ec2SecurityGroupOwnerId))
            .setter(setter(Builder::ec2SecurityGroupOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2SecurityGroupOwnerId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SECURITY_GROUP_NAME_FIELD,
            CIDRIP_FIELD, EC2_SECURITY_GROUP_NAME_FIELD, EC2_SECURITY_GROUP_ID_FIELD, EC2_SECURITY_GROUP_OWNER_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dbSecurityGroupName;

    private final String cidrip;

    private final String ec2SecurityGroupName;

    private final String ec2SecurityGroupId;

    private final String ec2SecurityGroupOwnerId;

    private RevokeDbSecurityGroupIngressRequest(BuilderImpl builder) {
        super(builder);
        this.dbSecurityGroupName = builder.dbSecurityGroupName;
        this.cidrip = builder.cidrip;
        this.ec2SecurityGroupName = builder.ec2SecurityGroupName;
        this.ec2SecurityGroupId = builder.ec2SecurityGroupId;
        this.ec2SecurityGroupOwnerId = builder.ec2SecurityGroupOwnerId;
    }

    /**
     * <p>
     * The name of the DB security group to revoke ingress from.
     * </p>
     * 
     * @return The name of the DB security group to revoke ingress from.
     */
    public final String dbSecurityGroupName() {
        return dbSecurityGroupName;
    }

    /**
     * <p>
     * The IP range to revoke access from. Must be a valid CIDR range. If <code>CIDRIP</code> is specified,
     * <code>EC2SecurityGroupName</code>, <code>EC2SecurityGroupId</code> and <code>EC2SecurityGroupOwnerId</code> can't
     * be provided.
     * </p>
     * 
     * @return The IP range to revoke access from. Must be a valid CIDR range. If <code>CIDRIP</code> is specified,
     *         <code>EC2SecurityGroupName</code>, <code>EC2SecurityGroupId</code> and
     *         <code>EC2SecurityGroupOwnerId</code> can't be provided.
     */
    public final String cidrip() {
        return cidrip;
    }

    /**
     * <p>
     * The name of the EC2 security group to revoke access from. For VPC DB security groups,
     * <code>EC2SecurityGroupId</code> must be provided. Otherwise, EC2SecurityGroupOwnerId and either
     * <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.
     * </p>
     * 
     * @return The name of the EC2 security group to revoke access from. For VPC DB security groups,
     *         <code>EC2SecurityGroupId</code> must be provided. Otherwise, EC2SecurityGroupOwnerId and either
     *         <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.
     */
    public final String ec2SecurityGroupName() {
        return ec2SecurityGroupName;
    }

    /**
     * <p>
     * The id of the EC2 security group to revoke access from. For VPC DB security groups,
     * <code>EC2SecurityGroupId</code> must be provided. Otherwise, EC2SecurityGroupOwnerId and either
     * <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.
     * </p>
     * 
     * @return The id of the EC2 security group to revoke access from. For VPC DB security groups,
     *         <code>EC2SecurityGroupId</code> must be provided. Otherwise, EC2SecurityGroupOwnerId and either
     *         <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.
     */
    public final String ec2SecurityGroupId() {
        return ec2SecurityGroupId;
    }

    /**
     * <p>
     * The Amazon Web Services account number of the owner of the EC2 security group specified in the
     * <code>EC2SecurityGroupName</code> parameter. The Amazon Web Services access key ID isn't an acceptable value. For
     * VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, EC2SecurityGroupOwnerId and
     * either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.
     * </p>
     * 
     * @return The Amazon Web Services account number of the owner of the EC2 security group specified in the
     *         <code>EC2SecurityGroupName</code> parameter. The Amazon Web Services access key ID isn't an acceptable
     *         value. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise,
     *         EC2SecurityGroupOwnerId and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code>
     *         must be provided.
     */
    public final String ec2SecurityGroupOwnerId() {
        return ec2SecurityGroupOwnerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(cidrip());
        hashCode = 31 * hashCode + Objects.hashCode(ec2SecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(ec2SecurityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(ec2SecurityGroupOwnerId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeDbSecurityGroupIngressRequest)) {
            return false;
        }
        RevokeDbSecurityGroupIngressRequest other = (RevokeDbSecurityGroupIngressRequest) obj;
        return Objects.equals(dbSecurityGroupName(), other.dbSecurityGroupName()) && Objects.equals(cidrip(), other.cidrip())
                && Objects.equals(ec2SecurityGroupName(), other.ec2SecurityGroupName())
                && Objects.equals(ec2SecurityGroupId(), other.ec2SecurityGroupId())
                && Objects.equals(ec2SecurityGroupOwnerId(), other.ec2SecurityGroupOwnerId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RevokeDbSecurityGroupIngressRequest").add("DBSecurityGroupName", dbSecurityGroupName())
                .add("CIDRIP", cidrip()).add("EC2SecurityGroupName", ec2SecurityGroupName())
                .add("EC2SecurityGroupId", ec2SecurityGroupId()).add("EC2SecurityGroupOwnerId", ec2SecurityGroupOwnerId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBSecurityGroupName":
            return Optional.ofNullable(clazz.cast(dbSecurityGroupName()));
        case "CIDRIP":
            return Optional.ofNullable(clazz.cast(cidrip()));
        case "EC2SecurityGroupName":
            return Optional.ofNullable(clazz.cast(ec2SecurityGroupName()));
        case "EC2SecurityGroupId":
            return Optional.ofNullable(clazz.cast(ec2SecurityGroupId()));
        case "EC2SecurityGroupOwnerId":
            return Optional.ofNullable(clazz.cast(ec2SecurityGroupOwnerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DBSecurityGroupName", DB_SECURITY_GROUP_NAME_FIELD);
        map.put("CIDRIP", CIDRIP_FIELD);
        map.put("EC2SecurityGroupName", EC2_SECURITY_GROUP_NAME_FIELD);
        map.put("EC2SecurityGroupId", EC2_SECURITY_GROUP_ID_FIELD);
        map.put("EC2SecurityGroupOwnerId", EC2_SECURITY_GROUP_OWNER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RevokeDbSecurityGroupIngressRequest, T> g) {
        return obj -> g.apply((RevokeDbSecurityGroupIngressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, RevokeDbSecurityGroupIngressRequest> {
        /**
         * <p>
         * The name of the DB security group to revoke ingress from.
         * </p>
         * 
         * @param dbSecurityGroupName
         *        The name of the DB security group to revoke ingress from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroupName(String dbSecurityGroupName);

        /**
         * <p>
         * The IP range to revoke access from. Must be a valid CIDR range. If <code>CIDRIP</code> is specified,
         * <code>EC2SecurityGroupName</code>, <code>EC2SecurityGroupId</code> and <code>EC2SecurityGroupOwnerId</code>
         * can't be provided.
         * </p>
         * 
         * @param cidrip
         *        The IP range to revoke access from. Must be a valid CIDR range. If <code>CIDRIP</code> is specified,
         *        <code>EC2SecurityGroupName</code>, <code>EC2SecurityGroupId</code> and
         *        <code>EC2SecurityGroupOwnerId</code> can't be provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrip(String cidrip);

        /**
         * <p>
         * The name of the EC2 security group to revoke access from. For VPC DB security groups,
         * <code>EC2SecurityGroupId</code> must be provided. Otherwise, EC2SecurityGroupOwnerId and either
         * <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.
         * </p>
         * 
         * @param ec2SecurityGroupName
         *        The name of the EC2 security group to revoke access from. For VPC DB security groups,
         *        <code>EC2SecurityGroupId</code> must be provided. Otherwise, EC2SecurityGroupOwnerId and either
         *        <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroupName(String ec2SecurityGroupName);

        /**
         * <p>
         * The id of the EC2 security group to revoke access from. For VPC DB security groups,
         * <code>EC2SecurityGroupId</code> must be provided. Otherwise, EC2SecurityGroupOwnerId and either
         * <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.
         * </p>
         * 
         * @param ec2SecurityGroupId
         *        The id of the EC2 security group to revoke access from. For VPC DB security groups,
         *        <code>EC2SecurityGroupId</code> must be provided. Otherwise, EC2SecurityGroupOwnerId and either
         *        <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroupId(String ec2SecurityGroupId);

        /**
         * <p>
         * The Amazon Web Services account number of the owner of the EC2 security group specified in the
         * <code>EC2SecurityGroupName</code> parameter. The Amazon Web Services access key ID isn't an acceptable value.
         * For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise,
         * EC2SecurityGroupOwnerId and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must
         * be provided.
         * </p>
         * 
         * @param ec2SecurityGroupOwnerId
         *        The Amazon Web Services account number of the owner of the EC2 security group specified in the
         *        <code>EC2SecurityGroupName</code> parameter. The Amazon Web Services access key ID isn't an acceptable
         *        value. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise,
         *        EC2SecurityGroupOwnerId and either <code>EC2SecurityGroupName</code> or
         *        <code>EC2SecurityGroupId</code> must be provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbSecurityGroupName;

        private String cidrip;

        private String ec2SecurityGroupName;

        private String ec2SecurityGroupId;

        private String ec2SecurityGroupOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeDbSecurityGroupIngressRequest model) {
            super(model);
            dbSecurityGroupName(model.dbSecurityGroupName);
            cidrip(model.cidrip);
            ec2SecurityGroupName(model.ec2SecurityGroupName);
            ec2SecurityGroupId(model.ec2SecurityGroupId);
            ec2SecurityGroupOwnerId(model.ec2SecurityGroupOwnerId);
        }

        public final String getDbSecurityGroupName() {
            return dbSecurityGroupName;
        }

        public final void setDbSecurityGroupName(String dbSecurityGroupName) {
            this.dbSecurityGroupName = dbSecurityGroupName;
        }

        @Override
        public final Builder dbSecurityGroupName(String dbSecurityGroupName) {
            this.dbSecurityGroupName = dbSecurityGroupName;
            return this;
        }

        public final String getCidrip() {
            return cidrip;
        }

        public final void setCidrip(String cidrip) {
            this.cidrip = cidrip;
        }

        @Override
        public final Builder cidrip(String cidrip) {
            this.cidrip = cidrip;
            return this;
        }

        public final String getEc2SecurityGroupName() {
            return ec2SecurityGroupName;
        }

        public final void setEc2SecurityGroupName(String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
        }

        @Override
        public final Builder ec2SecurityGroupName(String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
            return this;
        }

        public final String getEc2SecurityGroupId() {
            return ec2SecurityGroupId;
        }

        public final void setEc2SecurityGroupId(String ec2SecurityGroupId) {
            this.ec2SecurityGroupId = ec2SecurityGroupId;
        }

        @Override
        public final Builder ec2SecurityGroupId(String ec2SecurityGroupId) {
            this.ec2SecurityGroupId = ec2SecurityGroupId;
            return this;
        }

        public final String getEc2SecurityGroupOwnerId() {
            return ec2SecurityGroupOwnerId;
        }

        public final void setEc2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
        }

        @Override
        public final Builder ec2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RevokeDbSecurityGroupIngressRequest build() {
            return new RevokeDbSecurityGroupIngressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
