/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Active Directory Domain membership record associated with the DB instance or cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainMembership implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainMembership.Builder, DomainMembership> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(DomainMembership::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DomainMembership::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> FQDN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("FQDN")
            .getter(getter(DomainMembership::fqdn)).setter(setter(Builder::fqdn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FQDN").build()).build();

    private static final SdkField<String> IAM_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IAMRoleName").getter(getter(DomainMembership::iamRoleName)).setter(setter(Builder::iamRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMRoleName").build()).build();

    private static final SdkField<String> OU_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("OU")
            .getter(getter(DomainMembership::ou)).setter(setter(Builder::ou))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OU").build()).build();

    private static final SdkField<String> AUTH_SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthSecretArn").getter(getter(DomainMembership::authSecretArn)).setter(setter(Builder::authSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthSecretArn").build()).build();

    private static final SdkField<List<String>> DNS_IPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DnsIps")
            .getter(getter(DomainMembership::dnsIps))
            .setter(setter(Builder::dnsIps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsIps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, STATUS_FIELD,
            FQDN_FIELD, IAM_ROLE_NAME_FIELD, OU_FIELD, AUTH_SECRET_ARN_FIELD, DNS_IPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domain;

    private final String status;

    private final String fqdn;

    private final String iamRoleName;

    private final String ou;

    private final String authSecretArn;

    private final List<String> dnsIps;

    private DomainMembership(BuilderImpl builder) {
        this.domain = builder.domain;
        this.status = builder.status;
        this.fqdn = builder.fqdn;
        this.iamRoleName = builder.iamRoleName;
        this.ou = builder.ou;
        this.authSecretArn = builder.authSecretArn;
        this.dnsIps = builder.dnsIps;
    }

    /**
     * <p>
     * The identifier of the Active Directory Domain.
     * </p>
     * 
     * @return The identifier of the Active Directory Domain.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The status of the Active Directory Domain membership for the DB instance or cluster. Values include
     * <code>joined</code>, <code>pending-join</code>, <code>failed</code>, and so on.
     * </p>
     * 
     * @return The status of the Active Directory Domain membership for the DB instance or cluster. Values include
     *         <code>joined</code>, <code>pending-join</code>, <code>failed</code>, and so on.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The fully qualified domain name (FQDN) of the Active Directory Domain.
     * </p>
     * 
     * @return The fully qualified domain name (FQDN) of the Active Directory Domain.
     */
    public final String fqdn() {
        return fqdn;
    }

    /**
     * <p>
     * The name of the IAM role used when making API calls to the Directory Service.
     * </p>
     * 
     * @return The name of the IAM role used when making API calls to the Directory Service.
     */
    public final String iamRoleName() {
        return iamRoleName;
    }

    /**
     * <p>
     * The Active Directory organizational unit for the DB instance or cluster.
     * </p>
     * 
     * @return The Active Directory organizational unit for the DB instance or cluster.
     */
    public final String ou() {
        return ou;
    }

    /**
     * <p>
     * The ARN for the Secrets Manager secret with the credentials for the user that's a member of the domain.
     * </p>
     * 
     * @return The ARN for the Secrets Manager secret with the credentials for the user that's a member of the domain.
     */
    public final String authSecretArn() {
        return authSecretArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the DnsIps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDnsIps() {
        return dnsIps != null && !(dnsIps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv4 DNS IP addresses of the primary and secondary Active Directory domain controllers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDnsIps} method.
     * </p>
     * 
     * @return The IPv4 DNS IP addresses of the primary and secondary Active Directory domain controllers.
     */
    public final List<String> dnsIps() {
        return dnsIps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(fqdn());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(ou());
        hashCode = 31 * hashCode + Objects.hashCode(authSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasDnsIps() ? dnsIps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainMembership)) {
            return false;
        }
        DomainMembership other = (DomainMembership) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(status(), other.status())
                && Objects.equals(fqdn(), other.fqdn()) && Objects.equals(iamRoleName(), other.iamRoleName())
                && Objects.equals(ou(), other.ou()) && Objects.equals(authSecretArn(), other.authSecretArn())
                && hasDnsIps() == other.hasDnsIps() && Objects.equals(dnsIps(), other.dnsIps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainMembership").add("Domain", domain()).add("Status", status()).add("FQDN", fqdn())
                .add("IAMRoleName", iamRoleName()).add("OU", ou()).add("AuthSecretArn", authSecretArn())
                .add("DnsIps", hasDnsIps() ? dnsIps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "FQDN":
            return Optional.ofNullable(clazz.cast(fqdn()));
        case "IAMRoleName":
            return Optional.ofNullable(clazz.cast(iamRoleName()));
        case "OU":
            return Optional.ofNullable(clazz.cast(ou()));
        case "AuthSecretArn":
            return Optional.ofNullable(clazz.cast(authSecretArn()));
        case "DnsIps":
            return Optional.ofNullable(clazz.cast(dnsIps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Domain", DOMAIN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("FQDN", FQDN_FIELD);
        map.put("IAMRoleName", IAM_ROLE_NAME_FIELD);
        map.put("OU", OU_FIELD);
        map.put("AuthSecretArn", AUTH_SECRET_ARN_FIELD);
        map.put("DnsIps", DNS_IPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DomainMembership, T> g) {
        return obj -> g.apply((DomainMembership) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainMembership> {
        /**
         * <p>
         * The identifier of the Active Directory Domain.
         * </p>
         * 
         * @param domain
         *        The identifier of the Active Directory Domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The status of the Active Directory Domain membership for the DB instance or cluster. Values include
         * <code>joined</code>, <code>pending-join</code>, <code>failed</code>, and so on.
         * </p>
         * 
         * @param status
         *        The status of the Active Directory Domain membership for the DB instance or cluster. Values include
         *        <code>joined</code>, <code>pending-join</code>, <code>failed</code>, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The fully qualified domain name (FQDN) of the Active Directory Domain.
         * </p>
         * 
         * @param fqdn
         *        The fully qualified domain name (FQDN) of the Active Directory Domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fqdn(String fqdn);

        /**
         * <p>
         * The name of the IAM role used when making API calls to the Directory Service.
         * </p>
         * 
         * @param iamRoleName
         *        The name of the IAM role used when making API calls to the Directory Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleName(String iamRoleName);

        /**
         * <p>
         * The Active Directory organizational unit for the DB instance or cluster.
         * </p>
         * 
         * @param ou
         *        The Active Directory organizational unit for the DB instance or cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ou(String ou);

        /**
         * <p>
         * The ARN for the Secrets Manager secret with the credentials for the user that's a member of the domain.
         * </p>
         * 
         * @param authSecretArn
         *        The ARN for the Secrets Manager secret with the credentials for the user that's a member of the
         *        domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authSecretArn(String authSecretArn);

        /**
         * <p>
         * The IPv4 DNS IP addresses of the primary and secondary Active Directory domain controllers.
         * </p>
         * 
         * @param dnsIps
         *        The IPv4 DNS IP addresses of the primary and secondary Active Directory domain controllers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsIps(Collection<String> dnsIps);

        /**
         * <p>
         * The IPv4 DNS IP addresses of the primary and secondary Active Directory domain controllers.
         * </p>
         * 
         * @param dnsIps
         *        The IPv4 DNS IP addresses of the primary and secondary Active Directory domain controllers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsIps(String... dnsIps);
    }

    static final class BuilderImpl implements Builder {
        private String domain;

        private String status;

        private String fqdn;

        private String iamRoleName;

        private String ou;

        private String authSecretArn;

        private List<String> dnsIps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DomainMembership model) {
            domain(model.domain);
            status(model.status);
            fqdn(model.fqdn);
            iamRoleName(model.iamRoleName);
            ou(model.ou);
            authSecretArn(model.authSecretArn);
            dnsIps(model.dnsIps);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getFqdn() {
            return fqdn;
        }

        public final void setFqdn(String fqdn) {
            this.fqdn = fqdn;
        }

        @Override
        public final Builder fqdn(String fqdn) {
            this.fqdn = fqdn;
            return this;
        }

        public final String getIamRoleName() {
            return iamRoleName;
        }

        public final void setIamRoleName(String iamRoleName) {
            this.iamRoleName = iamRoleName;
        }

        @Override
        public final Builder iamRoleName(String iamRoleName) {
            this.iamRoleName = iamRoleName;
            return this;
        }

        public final String getOu() {
            return ou;
        }

        public final void setOu(String ou) {
            this.ou = ou;
        }

        @Override
        public final Builder ou(String ou) {
            this.ou = ou;
            return this;
        }

        public final String getAuthSecretArn() {
            return authSecretArn;
        }

        public final void setAuthSecretArn(String authSecretArn) {
            this.authSecretArn = authSecretArn;
        }

        @Override
        public final Builder authSecretArn(String authSecretArn) {
            this.authSecretArn = authSecretArn;
            return this;
        }

        public final Collection<String> getDnsIps() {
            if (dnsIps instanceof SdkAutoConstructList) {
                return null;
            }
            return dnsIps;
        }

        public final void setDnsIps(Collection<String> dnsIps) {
            this.dnsIps = StringListCopier.copy(dnsIps);
        }

        @Override
        public final Builder dnsIps(Collection<String> dnsIps) {
            this.dnsIps = StringListCopier.copy(dnsIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsIps(String... dnsIps) {
            dnsIps(Arrays.asList(dnsIps));
            return this;
        }

        @Override
        public DomainMembership build() {
            return new DomainMembership(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
