/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartExportTaskRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, StartExportTaskRequest> {
    private static final SdkField<String> EXPORT_TASK_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportTaskIdentifier").getter(StartExportTaskRequest.getter(StartExportTaskRequest::exportTaskIdentifier)).setter(StartExportTaskRequest.setter(Builder::exportTaskIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportTaskIdentifier").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceArn").getter(StartExportTaskRequest.getter(StartExportTaskRequest::sourceArn)).setter(StartExportTaskRequest.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()}).build();
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketName").getter(StartExportTaskRequest.getter(StartExportTaskRequest::s3BucketName)).setter(StartExportTaskRequest.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(StartExportTaskRequest.getter(StartExportTaskRequest::iamRoleArn)).setter(StartExportTaskRequest.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(StartExportTaskRequest.getter(StartExportTaskRequest::kmsKeyId)).setter(StartExportTaskRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> S3_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Prefix").getter(StartExportTaskRequest.getter(StartExportTaskRequest::s3Prefix)).setter(StartExportTaskRequest.setter(Builder::s3Prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Prefix").build()}).build();
    private static final SdkField<List<String>> EXPORT_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExportOnly").getter(StartExportTaskRequest.getter(StartExportTaskRequest::exportOnly)).setter(StartExportTaskRequest.setter(Builder::exportOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportOnly").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_TASK_IDENTIFIER_FIELD, SOURCE_ARN_FIELD, S3_BUCKET_NAME_FIELD, IAM_ROLE_ARN_FIELD, KMS_KEY_ID_FIELD, S3_PREFIX_FIELD, EXPORT_ONLY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ExportTaskIdentifier", EXPORT_TASK_IDENTIFIER_FIELD);
            this.put("SourceArn", SOURCE_ARN_FIELD);
            this.put("S3BucketName", S3_BUCKET_NAME_FIELD);
            this.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
            this.put("KmsKeyId", KMS_KEY_ID_FIELD);
            this.put("S3Prefix", S3_PREFIX_FIELD);
            this.put("ExportOnly", EXPORT_ONLY_FIELD);
        }
    });
    private final String exportTaskIdentifier;
    private final String sourceArn;
    private final String s3BucketName;
    private final String iamRoleArn;
    private final String kmsKeyId;
    private final String s3Prefix;
    private final List<String> exportOnly;

    private StartExportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.exportTaskIdentifier = builder.exportTaskIdentifier;
        this.sourceArn = builder.sourceArn;
        this.s3BucketName = builder.s3BucketName;
        this.iamRoleArn = builder.iamRoleArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.s3Prefix = builder.s3Prefix;
        this.exportOnly = builder.exportOnly;
    }

    public final String exportTaskIdentifier() {
        return this.exportTaskIdentifier;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String s3Prefix() {
        return this.s3Prefix;
    }

    public final boolean hasExportOnly() {
        return this.exportOnly != null && !(this.exportOnly instanceof SdkAutoConstructList);
    }

    public final List<String> exportOnly() {
        return this.exportOnly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.exportTaskIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExportOnly() ? this.exportOnly() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExportTaskRequest)) {
            return false;
        }
        StartExportTaskRequest other = (StartExportTaskRequest)((Object)obj);
        return Objects.equals(this.exportTaskIdentifier(), other.exportTaskIdentifier()) && Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.s3Prefix(), other.s3Prefix()) && this.hasExportOnly() == other.hasExportOnly() && Objects.equals(this.exportOnly(), other.exportOnly());
    }

    public final String toString() {
        return ToString.builder((String)"StartExportTaskRequest").add("ExportTaskIdentifier", (Object)this.exportTaskIdentifier()).add("SourceArn", (Object)this.sourceArn()).add("S3BucketName", (Object)this.s3BucketName()).add("IamRoleArn", (Object)this.iamRoleArn()).add("KmsKeyId", (Object)this.kmsKeyId()).add("S3Prefix", (Object)this.s3Prefix()).add("ExportOnly", this.hasExportOnly() ? this.exportOnly() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportTaskIdentifier": {
                return Optional.ofNullable(clazz.cast(this.exportTaskIdentifier()));
            }
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "S3Prefix": {
                return Optional.ofNullable(clazz.cast(this.s3Prefix()));
            }
            case "ExportOnly": {
                return Optional.ofNullable(clazz.cast(this.exportOnly()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartExportTaskRequest, T> g) {
        return obj -> g.apply((StartExportTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String exportTaskIdentifier;
        private String sourceArn;
        private String s3BucketName;
        private String iamRoleArn;
        private String kmsKeyId;
        private String s3Prefix;
        private List<String> exportOnly = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartExportTaskRequest model) {
            super(model);
            this.exportTaskIdentifier(model.exportTaskIdentifier);
            this.sourceArn(model.sourceArn);
            this.s3BucketName(model.s3BucketName);
            this.iamRoleArn(model.iamRoleArn);
            this.kmsKeyId(model.kmsKeyId);
            this.s3Prefix(model.s3Prefix);
            this.exportOnly(model.exportOnly);
        }

        public final String getExportTaskIdentifier() {
            return this.exportTaskIdentifier;
        }

        public final void setExportTaskIdentifier(String exportTaskIdentifier) {
            this.exportTaskIdentifier = exportTaskIdentifier;
        }

        @Override
        public final Builder exportTaskIdentifier(String exportTaskIdentifier) {
            this.exportTaskIdentifier = exportTaskIdentifier;
            return this;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getS3Prefix() {
            return this.s3Prefix;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final Collection<String> getExportOnly() {
            if (this.exportOnly instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exportOnly;
        }

        public final void setExportOnly(Collection<String> exportOnly) {
            this.exportOnly = StringListCopier.copy(exportOnly);
        }

        @Override
        public final Builder exportOnly(Collection<String> exportOnly) {
            this.exportOnly = StringListCopier.copy(exportOnly);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportOnly(String ... exportOnly) {
            this.exportOnly(Arrays.asList(exportOnly));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartExportTaskRequest build() {
            return new StartExportTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartExportTaskRequest> {
        public Builder exportTaskIdentifier(String var1);

        public Builder sourceArn(String var1);

        public Builder s3BucketName(String var1);

        public Builder iamRoleArn(String var1);

        public Builder kmsKeyId(String var1);

        public Builder s3Prefix(String var1);

        public Builder exportOnly(Collection<String> var1);

        public Builder exportOnly(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

