/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.ContextAttribute;
import software.amazon.awssdk.services.rds.model.ContextAttributeListCopier;
import software.amazon.awssdk.services.rds.model.IssueDetails;
import software.amazon.awssdk.services.rds.model.RecommendedActionParameter;
import software.amazon.awssdk.services.rds.model.RecommendedActionParameterListCopier;
import software.amazon.awssdk.services.rds.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendedAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendedAction> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionId").getter(RecommendedAction.getter(RecommendedAction::actionId)).setter(RecommendedAction.setter(Builder::actionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(RecommendedAction.getter(RecommendedAction::title)).setter(RecommendedAction.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(RecommendedAction.getter(RecommendedAction::description)).setter(RecommendedAction.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operation").getter(RecommendedAction.getter(RecommendedAction::operation)).setter(RecommendedAction.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()}).build();
    private static final SdkField<List<RecommendedActionParameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parameters").getter(RecommendedAction.getter(RecommendedAction::parameters)).setter(RecommendedAction.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendedActionParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> APPLY_MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApplyModes").getter(RecommendedAction.getter(RecommendedAction::applyModes)).setter(RecommendedAction.setter(Builder::applyModes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyModes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(RecommendedAction.getter(RecommendedAction::status)).setter(RecommendedAction.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<IssueDetails> ISSUE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IssueDetails").getter(RecommendedAction.getter(RecommendedAction::issueDetails)).setter(RecommendedAction.setter(Builder::issueDetails)).constructor(IssueDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssueDetails").build()}).build();
    private static final SdkField<List<ContextAttribute>> CONTEXT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContextAttributes").getter(RecommendedAction.getter(RecommendedAction::contextAttributes)).setter(RecommendedAction.setter(Builder::contextAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContextAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, OPERATION_FIELD, PARAMETERS_FIELD, APPLY_MODES_FIELD, STATUS_FIELD, ISSUE_DETAILS_FIELD, CONTEXT_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ActionId", ACTION_ID_FIELD);
            this.put("Title", TITLE_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Operation", OPERATION_FIELD);
            this.put("Parameters", PARAMETERS_FIELD);
            this.put("ApplyModes", APPLY_MODES_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("IssueDetails", ISSUE_DETAILS_FIELD);
            this.put("ContextAttributes", CONTEXT_ATTRIBUTES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String actionId;
    private final String title;
    private final String description;
    private final String operation;
    private final List<RecommendedActionParameter> parameters;
    private final List<String> applyModes;
    private final String status;
    private final IssueDetails issueDetails;
    private final List<ContextAttribute> contextAttributes;

    private RecommendedAction(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.title = builder.title;
        this.description = builder.description;
        this.operation = builder.operation;
        this.parameters = builder.parameters;
        this.applyModes = builder.applyModes;
        this.status = builder.status;
        this.issueDetails = builder.issueDetails;
        this.contextAttributes = builder.contextAttributes;
    }

    public final String actionId() {
        return this.actionId;
    }

    public final String title() {
        return this.title;
    }

    public final String description() {
        return this.description;
    }

    public final String operation() {
        return this.operation;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<RecommendedActionParameter> parameters() {
        return this.parameters;
    }

    public final boolean hasApplyModes() {
        return this.applyModes != null && !(this.applyModes instanceof SdkAutoConstructList);
    }

    public final List<String> applyModes() {
        return this.applyModes;
    }

    public final String status() {
        return this.status;
    }

    public final IssueDetails issueDetails() {
        return this.issueDetails;
    }

    public final boolean hasContextAttributes() {
        return this.contextAttributes != null && !(this.contextAttributes instanceof SdkAutoConstructList);
    }

    public final List<ContextAttribute> contextAttributes() {
        return this.contextAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.operation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplyModes() ? this.applyModes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.issueDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContextAttributes() ? this.contextAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendedAction)) {
            return false;
        }
        RecommendedAction other = (RecommendedAction)obj;
        return Objects.equals(this.actionId(), other.actionId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.operation(), other.operation()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && this.hasApplyModes() == other.hasApplyModes() && Objects.equals(this.applyModes(), other.applyModes()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.issueDetails(), other.issueDetails()) && this.hasContextAttributes() == other.hasContextAttributes() && Objects.equals(this.contextAttributes(), other.contextAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendedAction").add("ActionId", (Object)this.actionId()).add("Title", (Object)this.title()).add("Description", (Object)this.description()).add("Operation", (Object)this.operation()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("ApplyModes", this.hasApplyModes() ? this.applyModes() : null).add("Status", (Object)this.status()).add("IssueDetails", (Object)this.issueDetails()).add("ContextAttributes", this.hasContextAttributes() ? this.contextAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionId": {
                return Optional.ofNullable(clazz.cast(this.actionId()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Operation": {
                return Optional.ofNullable(clazz.cast(this.operation()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "ApplyModes": {
                return Optional.ofNullable(clazz.cast(this.applyModes()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "IssueDetails": {
                return Optional.ofNullable(clazz.cast(this.issueDetails()));
            }
            case "ContextAttributes": {
                return Optional.ofNullable(clazz.cast(this.contextAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RecommendedAction, T> g) {
        return obj -> g.apply((RecommendedAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionId;
        private String title;
        private String description;
        private String operation;
        private List<RecommendedActionParameter> parameters = DefaultSdkAutoConstructList.getInstance();
        private List<String> applyModes = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private IssueDetails issueDetails;
        private List<ContextAttribute> contextAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendedAction model) {
            this.actionId(model.actionId);
            this.title(model.title);
            this.description(model.description);
            this.operation(model.operation);
            this.parameters(model.parameters);
            this.applyModes(model.applyModes);
            this.status(model.status);
            this.issueDetails(model.issueDetails);
            this.contextAttributes(model.contextAttributes);
        }

        public final String getActionId() {
            return this.actionId;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final List<RecommendedActionParameter.Builder> getParameters() {
            List<RecommendedActionParameter.Builder> result = RecommendedActionParameterListCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<RecommendedActionParameter.BuilderImpl> parameters) {
            this.parameters = RecommendedActionParameterListCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<RecommendedActionParameter> parameters) {
            this.parameters = RecommendedActionParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(RecommendedActionParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<RecommendedActionParameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (RecommendedActionParameter)((RecommendedActionParameter.Builder)RecommendedActionParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getApplyModes() {
            if (this.applyModes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.applyModes;
        }

        public final void setApplyModes(Collection<String> applyModes) {
            this.applyModes = StringListCopier.copy(applyModes);
        }

        @Override
        public final Builder applyModes(Collection<String> applyModes) {
            this.applyModes = StringListCopier.copy(applyModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applyModes(String ... applyModes) {
            this.applyModes(Arrays.asList(applyModes));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final IssueDetails.Builder getIssueDetails() {
            return this.issueDetails != null ? this.issueDetails.toBuilder() : null;
        }

        public final void setIssueDetails(IssueDetails.BuilderImpl issueDetails) {
            this.issueDetails = issueDetails != null ? issueDetails.build() : null;
        }

        @Override
        public final Builder issueDetails(IssueDetails issueDetails) {
            this.issueDetails = issueDetails;
            return this;
        }

        public final List<ContextAttribute.Builder> getContextAttributes() {
            List<ContextAttribute.Builder> result = ContextAttributeListCopier.copyToBuilder(this.contextAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContextAttributes(Collection<ContextAttribute.BuilderImpl> contextAttributes) {
            this.contextAttributes = ContextAttributeListCopier.copyFromBuilder(contextAttributes);
        }

        @Override
        public final Builder contextAttributes(Collection<ContextAttribute> contextAttributes) {
            this.contextAttributes = ContextAttributeListCopier.copy(contextAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextAttributes(ContextAttribute ... contextAttributes) {
            this.contextAttributes(Arrays.asList(contextAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextAttributes(Consumer<ContextAttribute.Builder> ... contextAttributes) {
            this.contextAttributes(Stream.of(contextAttributes).map(c -> (ContextAttribute)((ContextAttribute.Builder)ContextAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RecommendedAction build() {
            return new RecommendedAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendedAction> {
        public Builder actionId(String var1);

        public Builder title(String var1);

        public Builder description(String var1);

        public Builder operation(String var1);

        public Builder parameters(Collection<RecommendedActionParameter> var1);

        public Builder parameters(RecommendedActionParameter ... var1);

        public Builder parameters(Consumer<RecommendedActionParameter.Builder> ... var1);

        public Builder applyModes(Collection<String> var1);

        public Builder applyModes(String ... var1);

        public Builder status(String var1);

        public Builder issueDetails(IssueDetails var1);

        default public Builder issueDetails(Consumer<IssueDetails.Builder> issueDetails) {
            return this.issueDetails((IssueDetails)((IssueDetails.Builder)IssueDetails.builder().applyMutation(issueDetails)).build());
        }

        public Builder contextAttributes(Collection<ContextAttribute> var1);

        public Builder contextAttributes(ContextAttribute ... var1);

        public Builder contextAttributes(Consumer<ContextAttribute.Builder> ... var1);
    }
}

