/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBlueGreenDeploymentRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, CreateBlueGreenDeploymentRequest> {
    private static final SdkField<String> BLUE_GREEN_DEPLOYMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BlueGreenDeploymentName").getter(CreateBlueGreenDeploymentRequest.getter(CreateBlueGreenDeploymentRequest::blueGreenDeploymentName)).setter(CreateBlueGreenDeploymentRequest.setter(Builder::blueGreenDeploymentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueGreenDeploymentName").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(CreateBlueGreenDeploymentRequest.getter(CreateBlueGreenDeploymentRequest::source)).setter(CreateBlueGreenDeploymentRequest.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<String> TARGET_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetEngineVersion").getter(CreateBlueGreenDeploymentRequest.getter(CreateBlueGreenDeploymentRequest::targetEngineVersion)).setter(CreateBlueGreenDeploymentRequest.setter(Builder::targetEngineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetEngineVersion").build()}).build();
    private static final SdkField<String> TARGET_DB_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetDBParameterGroupName").getter(CreateBlueGreenDeploymentRequest.getter(CreateBlueGreenDeploymentRequest::targetDBParameterGroupName)).setter(CreateBlueGreenDeploymentRequest.setter(Builder::targetDBParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDBParameterGroupName").build()}).build();
    private static final SdkField<String> TARGET_DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetDBClusterParameterGroupName").getter(CreateBlueGreenDeploymentRequest.getter(CreateBlueGreenDeploymentRequest::targetDBClusterParameterGroupName)).setter(CreateBlueGreenDeploymentRequest.setter(Builder::targetDBClusterParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDBClusterParameterGroupName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateBlueGreenDeploymentRequest.getter(CreateBlueGreenDeploymentRequest::tags)).setter(CreateBlueGreenDeploymentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<String> TARGET_DB_INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetDBInstanceClass").getter(CreateBlueGreenDeploymentRequest.getter(CreateBlueGreenDeploymentRequest::targetDBInstanceClass)).setter(CreateBlueGreenDeploymentRequest.setter(Builder::targetDBInstanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDBInstanceClass").build()}).build();
    private static final SdkField<Boolean> UPGRADE_TARGET_STORAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UpgradeTargetStorageConfig").getter(CreateBlueGreenDeploymentRequest.getter(CreateBlueGreenDeploymentRequest::upgradeTargetStorageConfig)).setter(CreateBlueGreenDeploymentRequest.setter(Builder::upgradeTargetStorageConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeTargetStorageConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUE_GREEN_DEPLOYMENT_NAME_FIELD, SOURCE_FIELD, TARGET_ENGINE_VERSION_FIELD, TARGET_DB_PARAMETER_GROUP_NAME_FIELD, TARGET_DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD, TAGS_FIELD, TARGET_DB_INSTANCE_CLASS_FIELD, UPGRADE_TARGET_STORAGE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BlueGreenDeploymentName", BLUE_GREEN_DEPLOYMENT_NAME_FIELD);
            this.put("Source", SOURCE_FIELD);
            this.put("TargetEngineVersion", TARGET_ENGINE_VERSION_FIELD);
            this.put("TargetDBParameterGroupName", TARGET_DB_PARAMETER_GROUP_NAME_FIELD);
            this.put("TargetDBClusterParameterGroupName", TARGET_DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("TargetDBInstanceClass", TARGET_DB_INSTANCE_CLASS_FIELD);
            this.put("UpgradeTargetStorageConfig", UPGRADE_TARGET_STORAGE_CONFIG_FIELD);
        }
    });
    private final String blueGreenDeploymentName;
    private final String source;
    private final String targetEngineVersion;
    private final String targetDBParameterGroupName;
    private final String targetDBClusterParameterGroupName;
    private final List<Tag> tags;
    private final String targetDBInstanceClass;
    private final Boolean upgradeTargetStorageConfig;

    private CreateBlueGreenDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.blueGreenDeploymentName = builder.blueGreenDeploymentName;
        this.source = builder.source;
        this.targetEngineVersion = builder.targetEngineVersion;
        this.targetDBParameterGroupName = builder.targetDBParameterGroupName;
        this.targetDBClusterParameterGroupName = builder.targetDBClusterParameterGroupName;
        this.tags = builder.tags;
        this.targetDBInstanceClass = builder.targetDBInstanceClass;
        this.upgradeTargetStorageConfig = builder.upgradeTargetStorageConfig;
    }

    public final String blueGreenDeploymentName() {
        return this.blueGreenDeploymentName;
    }

    public final String source() {
        return this.source;
    }

    public final String targetEngineVersion() {
        return this.targetEngineVersion;
    }

    public final String targetDBParameterGroupName() {
        return this.targetDBParameterGroupName;
    }

    public final String targetDBClusterParameterGroupName() {
        return this.targetDBClusterParameterGroupName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String targetDBInstanceClass() {
        return this.targetDBInstanceClass;
    }

    public final Boolean upgradeTargetStorageConfig() {
        return this.upgradeTargetStorageConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.blueGreenDeploymentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDBParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDBClusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDBInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.upgradeTargetStorageConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBlueGreenDeploymentRequest)) {
            return false;
        }
        CreateBlueGreenDeploymentRequest other = (CreateBlueGreenDeploymentRequest)((Object)obj);
        return Objects.equals(this.blueGreenDeploymentName(), other.blueGreenDeploymentName()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.targetEngineVersion(), other.targetEngineVersion()) && Objects.equals(this.targetDBParameterGroupName(), other.targetDBParameterGroupName()) && Objects.equals(this.targetDBClusterParameterGroupName(), other.targetDBClusterParameterGroupName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.targetDBInstanceClass(), other.targetDBInstanceClass()) && Objects.equals(this.upgradeTargetStorageConfig(), other.upgradeTargetStorageConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBlueGreenDeploymentRequest").add("BlueGreenDeploymentName", (Object)this.blueGreenDeploymentName()).add("Source", (Object)this.source()).add("TargetEngineVersion", (Object)this.targetEngineVersion()).add("TargetDBParameterGroupName", (Object)this.targetDBParameterGroupName()).add("TargetDBClusterParameterGroupName", (Object)this.targetDBClusterParameterGroupName()).add("Tags", this.hasTags() ? this.tags() : null).add("TargetDBInstanceClass", (Object)this.targetDBInstanceClass()).add("UpgradeTargetStorageConfig", (Object)this.upgradeTargetStorageConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlueGreenDeploymentName": {
                return Optional.ofNullable(clazz.cast(this.blueGreenDeploymentName()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "TargetEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.targetEngineVersion()));
            }
            case "TargetDBParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.targetDBParameterGroupName()));
            }
            case "TargetDBClusterParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.targetDBClusterParameterGroupName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TargetDBInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.targetDBInstanceClass()));
            }
            case "UpgradeTargetStorageConfig": {
                return Optional.ofNullable(clazz.cast(this.upgradeTargetStorageConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateBlueGreenDeploymentRequest, T> g) {
        return obj -> g.apply((CreateBlueGreenDeploymentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String blueGreenDeploymentName;
        private String source;
        private String targetEngineVersion;
        private String targetDBParameterGroupName;
        private String targetDBClusterParameterGroupName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String targetDBInstanceClass;
        private Boolean upgradeTargetStorageConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBlueGreenDeploymentRequest model) {
            super(model);
            this.blueGreenDeploymentName(model.blueGreenDeploymentName);
            this.source(model.source);
            this.targetEngineVersion(model.targetEngineVersion);
            this.targetDBParameterGroupName(model.targetDBParameterGroupName);
            this.targetDBClusterParameterGroupName(model.targetDBClusterParameterGroupName);
            this.tags(model.tags);
            this.targetDBInstanceClass(model.targetDBInstanceClass);
            this.upgradeTargetStorageConfig(model.upgradeTargetStorageConfig);
        }

        public final String getBlueGreenDeploymentName() {
            return this.blueGreenDeploymentName;
        }

        public final void setBlueGreenDeploymentName(String blueGreenDeploymentName) {
            this.blueGreenDeploymentName = blueGreenDeploymentName;
        }

        @Override
        public final Builder blueGreenDeploymentName(String blueGreenDeploymentName) {
            this.blueGreenDeploymentName = blueGreenDeploymentName;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getTargetEngineVersion() {
            return this.targetEngineVersion;
        }

        public final void setTargetEngineVersion(String targetEngineVersion) {
            this.targetEngineVersion = targetEngineVersion;
        }

        @Override
        public final Builder targetEngineVersion(String targetEngineVersion) {
            this.targetEngineVersion = targetEngineVersion;
            return this;
        }

        public final String getTargetDBParameterGroupName() {
            return this.targetDBParameterGroupName;
        }

        public final void setTargetDBParameterGroupName(String targetDBParameterGroupName) {
            this.targetDBParameterGroupName = targetDBParameterGroupName;
        }

        @Override
        public final Builder targetDBParameterGroupName(String targetDBParameterGroupName) {
            this.targetDBParameterGroupName = targetDBParameterGroupName;
            return this;
        }

        public final String getTargetDBClusterParameterGroupName() {
            return this.targetDBClusterParameterGroupName;
        }

        public final void setTargetDBClusterParameterGroupName(String targetDBClusterParameterGroupName) {
            this.targetDBClusterParameterGroupName = targetDBClusterParameterGroupName;
        }

        @Override
        public final Builder targetDBClusterParameterGroupName(String targetDBClusterParameterGroupName) {
            this.targetDBClusterParameterGroupName = targetDBClusterParameterGroupName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTargetDBInstanceClass() {
            return this.targetDBInstanceClass;
        }

        public final void setTargetDBInstanceClass(String targetDBInstanceClass) {
            this.targetDBInstanceClass = targetDBInstanceClass;
        }

        @Override
        public final Builder targetDBInstanceClass(String targetDBInstanceClass) {
            this.targetDBInstanceClass = targetDBInstanceClass;
            return this;
        }

        public final Boolean getUpgradeTargetStorageConfig() {
            return this.upgradeTargetStorageConfig;
        }

        public final void setUpgradeTargetStorageConfig(Boolean upgradeTargetStorageConfig) {
            this.upgradeTargetStorageConfig = upgradeTargetStorageConfig;
        }

        @Override
        public final Builder upgradeTargetStorageConfig(Boolean upgradeTargetStorageConfig) {
            this.upgradeTargetStorageConfig = upgradeTargetStorageConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBlueGreenDeploymentRequest build() {
            return new CreateBlueGreenDeploymentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBlueGreenDeploymentRequest> {
        public Builder blueGreenDeploymentName(String var1);

        public Builder source(String var1);

        public Builder targetEngineVersion(String var1);

        public Builder targetDBParameterGroupName(String var1);

        public Builder targetDBClusterParameterGroupName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder targetDBInstanceClass(String var1);

        public Builder upgradeTargetStorageConfig(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

