/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BacktrackDbClusterRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, BacktrackDbClusterRequest> {
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterIdentifier").getter(BacktrackDbClusterRequest.getter(BacktrackDbClusterRequest::dbClusterIdentifier)).setter(BacktrackDbClusterRequest.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build()}).build();
    private static final SdkField<Instant> BACKTRACK_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("BacktrackTo").getter(BacktrackDbClusterRequest.getter(BacktrackDbClusterRequest::backtrackTo)).setter(BacktrackDbClusterRequest.setter(Builder::backtrackTo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackTo").build()}).build();
    private static final SdkField<Boolean> FORCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Force").getter(BacktrackDbClusterRequest.getter(BacktrackDbClusterRequest::force)).setter(BacktrackDbClusterRequest.setter(Builder::force)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Force").build()}).build();
    private static final SdkField<Boolean> USE_EARLIEST_TIME_ON_POINT_IN_TIME_UNAVAILABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseEarliestTimeOnPointInTimeUnavailable").getter(BacktrackDbClusterRequest.getter(BacktrackDbClusterRequest::useEarliestTimeOnPointInTimeUnavailable)).setter(BacktrackDbClusterRequest.setter(Builder::useEarliestTimeOnPointInTimeUnavailable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseEarliestTimeOnPointInTimeUnavailable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_IDENTIFIER_FIELD, BACKTRACK_TO_FIELD, FORCE_FIELD, USE_EARLIEST_TIME_ON_POINT_IN_TIME_UNAVAILABLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DBClusterIdentifier", DB_CLUSTER_IDENTIFIER_FIELD);
            this.put("BacktrackTo", BACKTRACK_TO_FIELD);
            this.put("Force", FORCE_FIELD);
            this.put("UseEarliestTimeOnPointInTimeUnavailable", USE_EARLIEST_TIME_ON_POINT_IN_TIME_UNAVAILABLE_FIELD);
        }
    });
    private final String dbClusterIdentifier;
    private final Instant backtrackTo;
    private final Boolean force;
    private final Boolean useEarliestTimeOnPointInTimeUnavailable;

    private BacktrackDbClusterRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.backtrackTo = builder.backtrackTo;
        this.force = builder.force;
        this.useEarliestTimeOnPointInTimeUnavailable = builder.useEarliestTimeOnPointInTimeUnavailable;
    }

    public final String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public final Instant backtrackTo() {
        return this.backtrackTo;
    }

    public final Boolean force() {
        return this.force;
    }

    public final Boolean useEarliestTimeOnPointInTimeUnavailable() {
        return this.useEarliestTimeOnPointInTimeUnavailable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.backtrackTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.force());
        hashCode = 31 * hashCode + Objects.hashCode(this.useEarliestTimeOnPointInTimeUnavailable());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BacktrackDbClusterRequest)) {
            return false;
        }
        BacktrackDbClusterRequest other = (BacktrackDbClusterRequest)((Object)obj);
        return Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.backtrackTo(), other.backtrackTo()) && Objects.equals(this.force(), other.force()) && Objects.equals(this.useEarliestTimeOnPointInTimeUnavailable(), other.useEarliestTimeOnPointInTimeUnavailable());
    }

    public final String toString() {
        return ToString.builder((String)"BacktrackDbClusterRequest").add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("BacktrackTo", (Object)this.backtrackTo()).add("Force", (Object)this.force()).add("UseEarliestTimeOnPointInTimeUnavailable", (Object)this.useEarliestTimeOnPointInTimeUnavailable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "BacktrackTo": {
                return Optional.ofNullable(clazz.cast(this.backtrackTo()));
            }
            case "Force": {
                return Optional.ofNullable(clazz.cast(this.force()));
            }
            case "UseEarliestTimeOnPointInTimeUnavailable": {
                return Optional.ofNullable(clazz.cast(this.useEarliestTimeOnPointInTimeUnavailable()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BacktrackDbClusterRequest, T> g) {
        return obj -> g.apply((BacktrackDbClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbClusterIdentifier;
        private Instant backtrackTo;
        private Boolean force;
        private Boolean useEarliestTimeOnPointInTimeUnavailable;

        private BuilderImpl() {
        }

        private BuilderImpl(BacktrackDbClusterRequest model) {
            super(model);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.backtrackTo(model.backtrackTo);
            this.force(model.force);
            this.useEarliestTimeOnPointInTimeUnavailable(model.useEarliestTimeOnPointInTimeUnavailable);
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final Instant getBacktrackTo() {
            return this.backtrackTo;
        }

        public final void setBacktrackTo(Instant backtrackTo) {
            this.backtrackTo = backtrackTo;
        }

        @Override
        public final Builder backtrackTo(Instant backtrackTo) {
            this.backtrackTo = backtrackTo;
            return this;
        }

        public final Boolean getForce() {
            return this.force;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final Boolean getUseEarliestTimeOnPointInTimeUnavailable() {
            return this.useEarliestTimeOnPointInTimeUnavailable;
        }

        public final void setUseEarliestTimeOnPointInTimeUnavailable(Boolean useEarliestTimeOnPointInTimeUnavailable) {
            this.useEarliestTimeOnPointInTimeUnavailable = useEarliestTimeOnPointInTimeUnavailable;
        }

        @Override
        public final Builder useEarliestTimeOnPointInTimeUnavailable(Boolean useEarliestTimeOnPointInTimeUnavailable) {
            this.useEarliestTimeOnPointInTimeUnavailable = useEarliestTimeOnPointInTimeUnavailable;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BacktrackDbClusterRequest build() {
            return new BacktrackDbClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BacktrackDbClusterRequest> {
        public Builder dbClusterIdentifier(String var1);

        public Builder backtrackTo(Instant var1);

        public Builder force(Boolean var1);

        public Builder useEarliestTimeOnPointInTimeUnavailable(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

