/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.AvailableProcessorFeature;
import software.amazon.awssdk.services.rds.model.AvailableProcessorFeatureListCopier;
import software.amazon.awssdk.services.rds.model.ValidStorageOptions;
import software.amazon.awssdk.services.rds.model.ValidStorageOptionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidDBInstanceModificationsMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ValidDBInstanceModificationsMessage> {
    private static final SdkField<List<ValidStorageOptions>> STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Storage").getter(ValidDBInstanceModificationsMessage.getter(ValidDBInstanceModificationsMessage::storage)).setter(ValidDBInstanceModificationsMessage.setter(Builder::storage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Storage").build(), ListTrait.builder().memberLocationName("ValidStorageOptions").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValidStorageOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidStorageOptions").build()}).build()).build()}).build();
    private static final SdkField<List<AvailableProcessorFeature>> VALID_PROCESSOR_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValidProcessorFeatures").getter(ValidDBInstanceModificationsMessage.getter(ValidDBInstanceModificationsMessage::validProcessorFeatures)).setter(ValidDBInstanceModificationsMessage.setter(Builder::validProcessorFeatures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidProcessorFeatures").build(), ListTrait.builder().memberLocationName("AvailableProcessorFeature").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AvailableProcessorFeature::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableProcessorFeature").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SUPPORTS_DEDICATED_LOG_VOLUME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SupportsDedicatedLogVolume").getter(ValidDBInstanceModificationsMessage.getter(ValidDBInstanceModificationsMessage::supportsDedicatedLogVolume)).setter(ValidDBInstanceModificationsMessage.setter(Builder::supportsDedicatedLogVolume)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsDedicatedLogVolume").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_FIELD, VALID_PROCESSOR_FEATURES_FIELD, SUPPORTS_DEDICATED_LOG_VOLUME_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ValidStorageOptions> storage;
    private final List<AvailableProcessorFeature> validProcessorFeatures;
    private final Boolean supportsDedicatedLogVolume;

    private ValidDBInstanceModificationsMessage(BuilderImpl builder) {
        this.storage = builder.storage;
        this.validProcessorFeatures = builder.validProcessorFeatures;
        this.supportsDedicatedLogVolume = builder.supportsDedicatedLogVolume;
    }

    public final boolean hasStorage() {
        return this.storage != null && !(this.storage instanceof SdkAutoConstructList);
    }

    public final List<ValidStorageOptions> storage() {
        return this.storage;
    }

    public final boolean hasValidProcessorFeatures() {
        return this.validProcessorFeatures != null && !(this.validProcessorFeatures instanceof SdkAutoConstructList);
    }

    public final List<AvailableProcessorFeature> validProcessorFeatures() {
        return this.validProcessorFeatures;
    }

    public final Boolean supportsDedicatedLogVolume() {
        return this.supportsDedicatedLogVolume;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorage() ? this.storage() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidProcessorFeatures() ? this.validProcessorFeatures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsDedicatedLogVolume());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidDBInstanceModificationsMessage)) {
            return false;
        }
        ValidDBInstanceModificationsMessage other = (ValidDBInstanceModificationsMessage)obj;
        return this.hasStorage() == other.hasStorage() && Objects.equals(this.storage(), other.storage()) && this.hasValidProcessorFeatures() == other.hasValidProcessorFeatures() && Objects.equals(this.validProcessorFeatures(), other.validProcessorFeatures()) && Objects.equals(this.supportsDedicatedLogVolume(), other.supportsDedicatedLogVolume());
    }

    public final String toString() {
        return ToString.builder((String)"ValidDBInstanceModificationsMessage").add("Storage", this.hasStorage() ? this.storage() : null).add("ValidProcessorFeatures", this.hasValidProcessorFeatures() ? this.validProcessorFeatures() : null).add("SupportsDedicatedLogVolume", (Object)this.supportsDedicatedLogVolume()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Storage": {
                return Optional.ofNullable(clazz.cast(this.storage()));
            }
            case "ValidProcessorFeatures": {
                return Optional.ofNullable(clazz.cast(this.validProcessorFeatures()));
            }
            case "SupportsDedicatedLogVolume": {
                return Optional.ofNullable(clazz.cast(this.supportsDedicatedLogVolume()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidDBInstanceModificationsMessage, T> g) {
        return obj -> g.apply((ValidDBInstanceModificationsMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ValidStorageOptions> storage = DefaultSdkAutoConstructList.getInstance();
        private List<AvailableProcessorFeature> validProcessorFeatures = DefaultSdkAutoConstructList.getInstance();
        private Boolean supportsDedicatedLogVolume;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidDBInstanceModificationsMessage model) {
            this.storage(model.storage);
            this.validProcessorFeatures(model.validProcessorFeatures);
            this.supportsDedicatedLogVolume(model.supportsDedicatedLogVolume);
        }

        public final List<ValidStorageOptions.Builder> getStorage() {
            List<ValidStorageOptions.Builder> result = ValidStorageOptionsListCopier.copyToBuilder(this.storage);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorage(Collection<ValidStorageOptions.BuilderImpl> storage) {
            this.storage = ValidStorageOptionsListCopier.copyFromBuilder(storage);
        }

        @Override
        public final Builder storage(Collection<ValidStorageOptions> storage) {
            this.storage = ValidStorageOptionsListCopier.copy(storage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storage(ValidStorageOptions ... storage) {
            this.storage(Arrays.asList(storage));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storage(Consumer<ValidStorageOptions.Builder> ... storage) {
            this.storage(Stream.of(storage).map(c -> (ValidStorageOptions)((ValidStorageOptions.Builder)ValidStorageOptions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AvailableProcessorFeature.Builder> getValidProcessorFeatures() {
            List<AvailableProcessorFeature.Builder> result = AvailableProcessorFeatureListCopier.copyToBuilder(this.validProcessorFeatures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidProcessorFeatures(Collection<AvailableProcessorFeature.BuilderImpl> validProcessorFeatures) {
            this.validProcessorFeatures = AvailableProcessorFeatureListCopier.copyFromBuilder(validProcessorFeatures);
        }

        @Override
        public final Builder validProcessorFeatures(Collection<AvailableProcessorFeature> validProcessorFeatures) {
            this.validProcessorFeatures = AvailableProcessorFeatureListCopier.copy(validProcessorFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validProcessorFeatures(AvailableProcessorFeature ... validProcessorFeatures) {
            this.validProcessorFeatures(Arrays.asList(validProcessorFeatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validProcessorFeatures(Consumer<AvailableProcessorFeature.Builder> ... validProcessorFeatures) {
            this.validProcessorFeatures(Stream.of(validProcessorFeatures).map(c -> (AvailableProcessorFeature)((AvailableProcessorFeature.Builder)AvailableProcessorFeature.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getSupportsDedicatedLogVolume() {
            return this.supportsDedicatedLogVolume;
        }

        public final void setSupportsDedicatedLogVolume(Boolean supportsDedicatedLogVolume) {
            this.supportsDedicatedLogVolume = supportsDedicatedLogVolume;
        }

        @Override
        public final Builder supportsDedicatedLogVolume(Boolean supportsDedicatedLogVolume) {
            this.supportsDedicatedLogVolume = supportsDedicatedLogVolume;
            return this;
        }

        public ValidDBInstanceModificationsMessage build() {
            return new ValidDBInstanceModificationsMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ValidDBInstanceModificationsMessage> {
        public Builder storage(Collection<ValidStorageOptions> var1);

        public Builder storage(ValidStorageOptions ... var1);

        public Builder storage(Consumer<ValidStorageOptions.Builder> ... var1);

        public Builder validProcessorFeatures(Collection<AvailableProcessorFeature> var1);

        public Builder validProcessorFeatures(AvailableProcessorFeature ... var1);

        public Builder validProcessorFeatures(Consumer<AvailableProcessorFeature.Builder> ... var1);

        public Builder supportsDedicatedLogVolume(Boolean var1);
    }
}

