/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeregisterDbProxyTargetsRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, DeregisterDbProxyTargetsRequest> {
    private static final SdkField<String> DB_PROXY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBProxyName").getter(DeregisterDbProxyTargetsRequest.getter(DeregisterDbProxyTargetsRequest::dbProxyName)).setter(DeregisterDbProxyTargetsRequest.setter(Builder::dbProxyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyName").build()}).build();
    private static final SdkField<String> TARGET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetGroupName").getter(DeregisterDbProxyTargetsRequest.getter(DeregisterDbProxyTargetsRequest::targetGroupName)).setter(DeregisterDbProxyTargetsRequest.setter(Builder::targetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupName").build()}).build();
    private static final SdkField<List<String>> DB_INSTANCE_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBInstanceIdentifiers").getter(DeregisterDbProxyTargetsRequest.getter(DeregisterDbProxyTargetsRequest::dbInstanceIdentifiers)).setter(DeregisterDbProxyTargetsRequest.setter(Builder::dbInstanceIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DB_CLUSTER_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBClusterIdentifiers").getter(DeregisterDbProxyTargetsRequest.getter(DeregisterDbProxyTargetsRequest::dbClusterIdentifiers)).setter(DeregisterDbProxyTargetsRequest.setter(Builder::dbClusterIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PROXY_NAME_FIELD, TARGET_GROUP_NAME_FIELD, DB_INSTANCE_IDENTIFIERS_FIELD, DB_CLUSTER_IDENTIFIERS_FIELD));
    private final String dbProxyName;
    private final String targetGroupName;
    private final List<String> dbInstanceIdentifiers;
    private final List<String> dbClusterIdentifiers;

    private DeregisterDbProxyTargetsRequest(BuilderImpl builder) {
        super(builder);
        this.dbProxyName = builder.dbProxyName;
        this.targetGroupName = builder.targetGroupName;
        this.dbInstanceIdentifiers = builder.dbInstanceIdentifiers;
        this.dbClusterIdentifiers = builder.dbClusterIdentifiers;
    }

    public final String dbProxyName() {
        return this.dbProxyName;
    }

    public final String targetGroupName() {
        return this.targetGroupName;
    }

    public final boolean hasDbInstanceIdentifiers() {
        return this.dbInstanceIdentifiers != null && !(this.dbInstanceIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> dbInstanceIdentifiers() {
        return this.dbInstanceIdentifiers;
    }

    public final boolean hasDbClusterIdentifiers() {
        return this.dbClusterIdentifiers != null && !(this.dbClusterIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> dbClusterIdentifiers() {
        return this.dbClusterIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbProxyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbInstanceIdentifiers() ? this.dbInstanceIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbClusterIdentifiers() ? this.dbClusterIdentifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterDbProxyTargetsRequest)) {
            return false;
        }
        DeregisterDbProxyTargetsRequest other = (DeregisterDbProxyTargetsRequest)((Object)obj);
        return Objects.equals(this.dbProxyName(), other.dbProxyName()) && Objects.equals(this.targetGroupName(), other.targetGroupName()) && this.hasDbInstanceIdentifiers() == other.hasDbInstanceIdentifiers() && Objects.equals(this.dbInstanceIdentifiers(), other.dbInstanceIdentifiers()) && this.hasDbClusterIdentifiers() == other.hasDbClusterIdentifiers() && Objects.equals(this.dbClusterIdentifiers(), other.dbClusterIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"DeregisterDbProxyTargetsRequest").add("DBProxyName", (Object)this.dbProxyName()).add("TargetGroupName", (Object)this.targetGroupName()).add("DBInstanceIdentifiers", this.hasDbInstanceIdentifiers() ? this.dbInstanceIdentifiers() : null).add("DBClusterIdentifiers", this.hasDbClusterIdentifiers() ? this.dbClusterIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBProxyName": {
                return Optional.ofNullable(clazz.cast(this.dbProxyName()));
            }
            case "TargetGroupName": {
                return Optional.ofNullable(clazz.cast(this.targetGroupName()));
            }
            case "DBInstanceIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceIdentifiers()));
            }
            case "DBClusterIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeregisterDbProxyTargetsRequest, T> g) {
        return obj -> g.apply((DeregisterDbProxyTargetsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbProxyName;
        private String targetGroupName;
        private List<String> dbInstanceIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private List<String> dbClusterIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterDbProxyTargetsRequest model) {
            super(model);
            this.dbProxyName(model.dbProxyName);
            this.targetGroupName(model.targetGroupName);
            this.dbInstanceIdentifiers(model.dbInstanceIdentifiers);
            this.dbClusterIdentifiers(model.dbClusterIdentifiers);
        }

        public final String getDbProxyName() {
            return this.dbProxyName;
        }

        public final void setDbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
        }

        @Override
        public final Builder dbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
            return this;
        }

        public final String getTargetGroupName() {
            return this.targetGroupName;
        }

        public final void setTargetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
        }

        @Override
        public final Builder targetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
            return this;
        }

        public final Collection<String> getDbInstanceIdentifiers() {
            if (this.dbInstanceIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dbInstanceIdentifiers;
        }

        public final void setDbInstanceIdentifiers(Collection<String> dbInstanceIdentifiers) {
            this.dbInstanceIdentifiers = StringListCopier.copy(dbInstanceIdentifiers);
        }

        @Override
        public final Builder dbInstanceIdentifiers(Collection<String> dbInstanceIdentifiers) {
            this.dbInstanceIdentifiers = StringListCopier.copy(dbInstanceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbInstanceIdentifiers(String ... dbInstanceIdentifiers) {
            this.dbInstanceIdentifiers(Arrays.asList(dbInstanceIdentifiers));
            return this;
        }

        public final Collection<String> getDbClusterIdentifiers() {
            if (this.dbClusterIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dbClusterIdentifiers;
        }

        public final void setDbClusterIdentifiers(Collection<String> dbClusterIdentifiers) {
            this.dbClusterIdentifiers = StringListCopier.copy(dbClusterIdentifiers);
        }

        @Override
        public final Builder dbClusterIdentifiers(Collection<String> dbClusterIdentifiers) {
            this.dbClusterIdentifiers = StringListCopier.copy(dbClusterIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterIdentifiers(String ... dbClusterIdentifiers) {
            this.dbClusterIdentifiers(Arrays.asList(dbClusterIdentifiers));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeregisterDbProxyTargetsRequest build() {
            return new DeregisterDbProxyTargetsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeregisterDbProxyTargetsRequest> {
        public Builder dbProxyName(String var1);

        public Builder targetGroupName(String var1);

        public Builder dbInstanceIdentifiers(Collection<String> var1);

        public Builder dbInstanceIdentifiers(String ... var1);

        public Builder dbClusterIdentifiers(Collection<String> var1);

        public Builder dbClusterIdentifiers(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

