/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyOptionGroupRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, CopyOptionGroupRequest> {
    private static final SdkField<String> SOURCE_OPTION_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceOptionGroupIdentifier").getter(CopyOptionGroupRequest.getter(CopyOptionGroupRequest::sourceOptionGroupIdentifier)).setter(CopyOptionGroupRequest.setter(Builder::sourceOptionGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceOptionGroupIdentifier").build()}).build();
    private static final SdkField<String> TARGET_OPTION_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetOptionGroupIdentifier").getter(CopyOptionGroupRequest.getter(CopyOptionGroupRequest::targetOptionGroupIdentifier)).setter(CopyOptionGroupRequest.setter(Builder::targetOptionGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetOptionGroupIdentifier").build()}).build();
    private static final SdkField<String> TARGET_OPTION_GROUP_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetOptionGroupDescription").getter(CopyOptionGroupRequest.getter(CopyOptionGroupRequest::targetOptionGroupDescription)).setter(CopyOptionGroupRequest.setter(Builder::targetOptionGroupDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetOptionGroupDescription").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CopyOptionGroupRequest.getter(CopyOptionGroupRequest::tags)).setter(CopyOptionGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_OPTION_GROUP_IDENTIFIER_FIELD, TARGET_OPTION_GROUP_IDENTIFIER_FIELD, TARGET_OPTION_GROUP_DESCRIPTION_FIELD, TAGS_FIELD));
    private final String sourceOptionGroupIdentifier;
    private final String targetOptionGroupIdentifier;
    private final String targetOptionGroupDescription;
    private final List<Tag> tags;

    private CopyOptionGroupRequest(BuilderImpl builder) {
        super(builder);
        this.sourceOptionGroupIdentifier = builder.sourceOptionGroupIdentifier;
        this.targetOptionGroupIdentifier = builder.targetOptionGroupIdentifier;
        this.targetOptionGroupDescription = builder.targetOptionGroupDescription;
        this.tags = builder.tags;
    }

    public final String sourceOptionGroupIdentifier() {
        return this.sourceOptionGroupIdentifier;
    }

    public final String targetOptionGroupIdentifier() {
        return this.targetOptionGroupIdentifier;
    }

    public final String targetOptionGroupDescription() {
        return this.targetOptionGroupDescription;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceOptionGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetOptionGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetOptionGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyOptionGroupRequest)) {
            return false;
        }
        CopyOptionGroupRequest other = (CopyOptionGroupRequest)((Object)obj);
        return Objects.equals(this.sourceOptionGroupIdentifier(), other.sourceOptionGroupIdentifier()) && Objects.equals(this.targetOptionGroupIdentifier(), other.targetOptionGroupIdentifier()) && Objects.equals(this.targetOptionGroupDescription(), other.targetOptionGroupDescription()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CopyOptionGroupRequest").add("SourceOptionGroupIdentifier", (Object)this.sourceOptionGroupIdentifier()).add("TargetOptionGroupIdentifier", (Object)this.targetOptionGroupIdentifier()).add("TargetOptionGroupDescription", (Object)this.targetOptionGroupDescription()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceOptionGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sourceOptionGroupIdentifier()));
            }
            case "TargetOptionGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.targetOptionGroupIdentifier()));
            }
            case "TargetOptionGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.targetOptionGroupDescription()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyOptionGroupRequest, T> g) {
        return obj -> g.apply((CopyOptionGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String sourceOptionGroupIdentifier;
        private String targetOptionGroupIdentifier;
        private String targetOptionGroupDescription;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CopyOptionGroupRequest model) {
            super(model);
            this.sourceOptionGroupIdentifier(model.sourceOptionGroupIdentifier);
            this.targetOptionGroupIdentifier(model.targetOptionGroupIdentifier);
            this.targetOptionGroupDescription(model.targetOptionGroupDescription);
            this.tags(model.tags);
        }

        public final String getSourceOptionGroupIdentifier() {
            return this.sourceOptionGroupIdentifier;
        }

        public final void setSourceOptionGroupIdentifier(String sourceOptionGroupIdentifier) {
            this.sourceOptionGroupIdentifier = sourceOptionGroupIdentifier;
        }

        @Override
        public final Builder sourceOptionGroupIdentifier(String sourceOptionGroupIdentifier) {
            this.sourceOptionGroupIdentifier = sourceOptionGroupIdentifier;
            return this;
        }

        public final String getTargetOptionGroupIdentifier() {
            return this.targetOptionGroupIdentifier;
        }

        public final void setTargetOptionGroupIdentifier(String targetOptionGroupIdentifier) {
            this.targetOptionGroupIdentifier = targetOptionGroupIdentifier;
        }

        @Override
        public final Builder targetOptionGroupIdentifier(String targetOptionGroupIdentifier) {
            this.targetOptionGroupIdentifier = targetOptionGroupIdentifier;
            return this;
        }

        public final String getTargetOptionGroupDescription() {
            return this.targetOptionGroupDescription;
        }

        public final void setTargetOptionGroupDescription(String targetOptionGroupDescription) {
            this.targetOptionGroupDescription = targetOptionGroupDescription;
        }

        @Override
        public final Builder targetOptionGroupDescription(String targetOptionGroupDescription) {
            this.targetOptionGroupDescription = targetOptionGroupDescription;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyOptionGroupRequest build() {
            return new CopyOptionGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CopyOptionGroupRequest> {
        public Builder sourceOptionGroupIdentifier(String var1);

        public Builder targetOptionGroupIdentifier(String var1);

        public Builder targetOptionGroupDescription(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

