/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the details of authentication used by a proxy to log in as a specific database user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserAuthConfig implements SdkPojo, Serializable, ToCopyableBuilder<UserAuthConfig.Builder, UserAuthConfig> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UserAuthConfig::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(UserAuthConfig::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> AUTH_SCHEME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthScheme").getter(getter(UserAuthConfig::authSchemeAsString)).setter(setter(Builder::authScheme))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthScheme").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(UserAuthConfig::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<String> IAM_AUTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IAMAuth").getter(getter(UserAuthConfig::iamAuthAsString)).setter(setter(Builder::iamAuth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMAuth").build()).build();

    private static final SdkField<String> CLIENT_PASSWORD_AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientPasswordAuthType").getter(getter(UserAuthConfig::clientPasswordAuthTypeAsString))
            .setter(setter(Builder::clientPasswordAuthType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientPasswordAuthType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            USER_NAME_FIELD, AUTH_SCHEME_FIELD, SECRET_ARN_FIELD, IAM_AUTH_FIELD, CLIENT_PASSWORD_AUTH_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String userName;

    private final String authScheme;

    private final String secretArn;

    private final String iamAuth;

    private final String clientPasswordAuthType;

    private UserAuthConfig(BuilderImpl builder) {
        this.description = builder.description;
        this.userName = builder.userName;
        this.authScheme = builder.authScheme;
        this.secretArn = builder.secretArn;
        this.iamAuth = builder.iamAuth;
        this.clientPasswordAuthType = builder.clientPasswordAuthType;
    }

    /**
     * <p>
     * A user-specified description about the authentication used by a proxy to log in as a specific database user.
     * </p>
     * 
     * @return A user-specified description about the authentication used by a proxy to log in as a specific database
     *         user.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the database user to which the proxy connects.
     * </p>
     * 
     * @return The name of the database user to which the proxy connects.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * The type of authentication that the proxy uses for connections from the proxy to the underlying database.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authScheme} will
     * return {@link AuthScheme#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authSchemeAsString}.
     * </p>
     * 
     * @return The type of authentication that the proxy uses for connections from the proxy to the underlying database.
     * @see AuthScheme
     */
    public final AuthScheme authScheme() {
        return AuthScheme.fromValue(authScheme);
    }

    /**
     * <p>
     * The type of authentication that the proxy uses for connections from the proxy to the underlying database.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authScheme} will
     * return {@link AuthScheme#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authSchemeAsString}.
     * </p>
     * 
     * @return The type of authentication that the proxy uses for connections from the proxy to the underlying database.
     * @see AuthScheme
     */
    public final String authSchemeAsString() {
        return authScheme;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance
     * or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB
     *         instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * Whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication for
     * connections to the proxy. The <code>ENABLED</code> value is valid only for proxies with RDS for Microsoft SQL
     * Server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #iamAuth} will
     * return {@link IAMAuthMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #iamAuthAsString}.
     * </p>
     * 
     * @return Whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication
     *         for connections to the proxy. The <code>ENABLED</code> value is valid only for proxies with RDS for
     *         Microsoft SQL Server.
     * @see IAMAuthMode
     */
    public final IAMAuthMode iamAuth() {
        return IAMAuthMode.fromValue(iamAuth);
    }

    /**
     * <p>
     * Whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication for
     * connections to the proxy. The <code>ENABLED</code> value is valid only for proxies with RDS for Microsoft SQL
     * Server.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #iamAuth} will
     * return {@link IAMAuthMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #iamAuthAsString}.
     * </p>
     * 
     * @return Whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication
     *         for connections to the proxy. The <code>ENABLED</code> value is valid only for proxies with RDS for
     *         Microsoft SQL Server.
     * @see IAMAuthMode
     */
    public final String iamAuthAsString() {
        return iamAuth;
    }

    /**
     * <p>
     * The type of authentication the proxy uses for connections from clients.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #clientPasswordAuthType} will return {@link ClientPasswordAuthType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #clientPasswordAuthTypeAsString}.
     * </p>
     * 
     * @return The type of authentication the proxy uses for connections from clients.
     * @see ClientPasswordAuthType
     */
    public final ClientPasswordAuthType clientPasswordAuthType() {
        return ClientPasswordAuthType.fromValue(clientPasswordAuthType);
    }

    /**
     * <p>
     * The type of authentication the proxy uses for connections from clients.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #clientPasswordAuthType} will return {@link ClientPasswordAuthType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #clientPasswordAuthTypeAsString}.
     * </p>
     * 
     * @return The type of authentication the proxy uses for connections from clients.
     * @see ClientPasswordAuthType
     */
    public final String clientPasswordAuthTypeAsString() {
        return clientPasswordAuthType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(authSchemeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(iamAuthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientPasswordAuthTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserAuthConfig)) {
            return false;
        }
        UserAuthConfig other = (UserAuthConfig) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(userName(), other.userName())
                && Objects.equals(authSchemeAsString(), other.authSchemeAsString())
                && Objects.equals(secretArn(), other.secretArn()) && Objects.equals(iamAuthAsString(), other.iamAuthAsString())
                && Objects.equals(clientPasswordAuthTypeAsString(), other.clientPasswordAuthTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserAuthConfig").add("Description", description()).add("UserName", userName())
                .add("AuthScheme", authSchemeAsString()).add("SecretArn", secretArn()).add("IAMAuth", iamAuthAsString())
                .add("ClientPasswordAuthType", clientPasswordAuthTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "AuthScheme":
            return Optional.ofNullable(clazz.cast(authSchemeAsString()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "IAMAuth":
            return Optional.ofNullable(clazz.cast(iamAuthAsString()));
        case "ClientPasswordAuthType":
            return Optional.ofNullable(clazz.cast(clientPasswordAuthTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserAuthConfig, T> g) {
        return obj -> g.apply((UserAuthConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserAuthConfig> {
        /**
         * <p>
         * A user-specified description about the authentication used by a proxy to log in as a specific database user.
         * </p>
         * 
         * @param description
         *        A user-specified description about the authentication used by a proxy to log in as a specific database
         *        user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the database user to which the proxy connects.
         * </p>
         * 
         * @param userName
         *        The name of the database user to which the proxy connects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The type of authentication that the proxy uses for connections from the proxy to the underlying database.
         * </p>
         * 
         * @param authScheme
         *        The type of authentication that the proxy uses for connections from the proxy to the underlying
         *        database.
         * @see AuthScheme
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthScheme
         */
        Builder authScheme(String authScheme);

        /**
         * <p>
         * The type of authentication that the proxy uses for connections from the proxy to the underlying database.
         * </p>
         * 
         * @param authScheme
         *        The type of authentication that the proxy uses for connections from the proxy to the underlying
         *        database.
         * @see AuthScheme
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthScheme
         */
        Builder authScheme(AuthScheme authScheme);

        /**
         * <p>
         * The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB
         * instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.
         * </p>
         * 
         * @param secretArn
         *        The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS
         *        DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * Whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication for
         * connections to the proxy. The <code>ENABLED</code> value is valid only for proxies with RDS for Microsoft SQL
         * Server.
         * </p>
         * 
         * @param iamAuth
         *        Whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication
         *        for connections to the proxy. The <code>ENABLED</code> value is valid only for proxies with RDS for
         *        Microsoft SQL Server.
         * @see IAMAuthMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IAMAuthMode
         */
        Builder iamAuth(String iamAuth);

        /**
         * <p>
         * Whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication for
         * connections to the proxy. The <code>ENABLED</code> value is valid only for proxies with RDS for Microsoft SQL
         * Server.
         * </p>
         * 
         * @param iamAuth
         *        Whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication
         *        for connections to the proxy. The <code>ENABLED</code> value is valid only for proxies with RDS for
         *        Microsoft SQL Server.
         * @see IAMAuthMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IAMAuthMode
         */
        Builder iamAuth(IAMAuthMode iamAuth);

        /**
         * <p>
         * The type of authentication the proxy uses for connections from clients.
         * </p>
         * 
         * @param clientPasswordAuthType
         *        The type of authentication the proxy uses for connections from clients.
         * @see ClientPasswordAuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientPasswordAuthType
         */
        Builder clientPasswordAuthType(String clientPasswordAuthType);

        /**
         * <p>
         * The type of authentication the proxy uses for connections from clients.
         * </p>
         * 
         * @param clientPasswordAuthType
         *        The type of authentication the proxy uses for connections from clients.
         * @see ClientPasswordAuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientPasswordAuthType
         */
        Builder clientPasswordAuthType(ClientPasswordAuthType clientPasswordAuthType);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String userName;

        private String authScheme;

        private String secretArn;

        private String iamAuth;

        private String clientPasswordAuthType;

        private BuilderImpl() {
        }

        private BuilderImpl(UserAuthConfig model) {
            description(model.description);
            userName(model.userName);
            authScheme(model.authScheme);
            secretArn(model.secretArn);
            iamAuth(model.iamAuth);
            clientPasswordAuthType(model.clientPasswordAuthType);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getAuthScheme() {
            return authScheme;
        }

        public final void setAuthScheme(String authScheme) {
            this.authScheme = authScheme;
        }

        @Override
        public final Builder authScheme(String authScheme) {
            this.authScheme = authScheme;
            return this;
        }

        @Override
        public final Builder authScheme(AuthScheme authScheme) {
            this.authScheme(authScheme == null ? null : authScheme.toString());
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getIamAuth() {
            return iamAuth;
        }

        public final void setIamAuth(String iamAuth) {
            this.iamAuth = iamAuth;
        }

        @Override
        public final Builder iamAuth(String iamAuth) {
            this.iamAuth = iamAuth;
            return this;
        }

        @Override
        public final Builder iamAuth(IAMAuthMode iamAuth) {
            this.iamAuth(iamAuth == null ? null : iamAuth.toString());
            return this;
        }

        public final String getClientPasswordAuthType() {
            return clientPasswordAuthType;
        }

        public final void setClientPasswordAuthType(String clientPasswordAuthType) {
            this.clientPasswordAuthType = clientPasswordAuthType;
        }

        @Override
        public final Builder clientPasswordAuthType(String clientPasswordAuthType) {
            this.clientPasswordAuthType = clientPasswordAuthType;
            return this;
        }

        @Override
        public final Builder clientPasswordAuthType(ClientPasswordAuthType clientPasswordAuthType) {
            this.clientPasswordAuthType(clientPasswordAuthType == null ? null : clientPasswordAuthType.toString());
            return this;
        }

        @Override
        public UserAuthConfig build() {
            return new UserAuthConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
