/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyActivityStreamRequest extends RdsRequest implements
        ToCopyableBuilder<ModifyActivityStreamRequest.Builder, ModifyActivityStreamRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(ModifyActivityStreamRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> AUDIT_POLICY_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuditPolicyState").getter(getter(ModifyActivityStreamRequest::auditPolicyStateAsString))
            .setter(setter(Builder::auditPolicyState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditPolicyState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            AUDIT_POLICY_STATE_FIELD));

    private final String resourceArn;

    private final String auditPolicyState;

    private ModifyActivityStreamRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.auditPolicyState = builder.auditPolicyState;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the RDS for Oracle DB instance, for example,
     * <code>arn:aws:rds:us-east-1:12345667890:instance:my-orcl-db</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the RDS for Oracle DB instance, for example,
     *         <code>arn:aws:rds:us-east-1:12345667890:instance:my-orcl-db</code>.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The audit policy state. When a policy is unlocked, it is read/write. When it is locked, it is read-only. You can
     * edit your audit policy only when the activity stream is unlocked or stopped.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #auditPolicyState}
     * will return {@link AuditPolicyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #auditPolicyStateAsString}.
     * </p>
     * 
     * @return The audit policy state. When a policy is unlocked, it is read/write. When it is locked, it is read-only.
     *         You can edit your audit policy only when the activity stream is unlocked or stopped.
     * @see AuditPolicyState
     */
    public final AuditPolicyState auditPolicyState() {
        return AuditPolicyState.fromValue(auditPolicyState);
    }

    /**
     * <p>
     * The audit policy state. When a policy is unlocked, it is read/write. When it is locked, it is read-only. You can
     * edit your audit policy only when the activity stream is unlocked or stopped.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #auditPolicyState}
     * will return {@link AuditPolicyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #auditPolicyStateAsString}.
     * </p>
     * 
     * @return The audit policy state. When a policy is unlocked, it is read/write. When it is locked, it is read-only.
     *         You can edit your audit policy only when the activity stream is unlocked or stopped.
     * @see AuditPolicyState
     */
    public final String auditPolicyStateAsString() {
        return auditPolicyState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(auditPolicyStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyActivityStreamRequest)) {
            return false;
        }
        ModifyActivityStreamRequest other = (ModifyActivityStreamRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(auditPolicyStateAsString(), other.auditPolicyStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyActivityStreamRequest").add("ResourceArn", resourceArn())
                .add("AuditPolicyState", auditPolicyStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "AuditPolicyState":
            return Optional.ofNullable(clazz.cast(auditPolicyStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyActivityStreamRequest, T> g) {
        return obj -> g.apply((ModifyActivityStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyActivityStreamRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the RDS for Oracle DB instance, for example,
         * <code>arn:aws:rds:us-east-1:12345667890:instance:my-orcl-db</code>.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the RDS for Oracle DB instance, for example,
         *        <code>arn:aws:rds:us-east-1:12345667890:instance:my-orcl-db</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The audit policy state. When a policy is unlocked, it is read/write. When it is locked, it is read-only. You
         * can edit your audit policy only when the activity stream is unlocked or stopped.
         * </p>
         * 
         * @param auditPolicyState
         *        The audit policy state. When a policy is unlocked, it is read/write. When it is locked, it is
         *        read-only. You can edit your audit policy only when the activity stream is unlocked or stopped.
         * @see AuditPolicyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditPolicyState
         */
        Builder auditPolicyState(String auditPolicyState);

        /**
         * <p>
         * The audit policy state. When a policy is unlocked, it is read/write. When it is locked, it is read-only. You
         * can edit your audit policy only when the activity stream is unlocked or stopped.
         * </p>
         * 
         * @param auditPolicyState
         *        The audit policy state. When a policy is unlocked, it is read/write. When it is locked, it is
         *        read-only. You can edit your audit policy only when the activity stream is unlocked or stopped.
         * @see AuditPolicyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditPolicyState
         */
        Builder auditPolicyState(AuditPolicyState auditPolicyState);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String resourceArn;

        private String auditPolicyState;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyActivityStreamRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            auditPolicyState(model.auditPolicyState);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getAuditPolicyState() {
            return auditPolicyState;
        }

        public final void setAuditPolicyState(String auditPolicyState) {
            this.auditPolicyState = auditPolicyState;
        }

        @Override
        public final Builder auditPolicyState(String auditPolicyState) {
            this.auditPolicyState = auditPolicyState;
            return this;
        }

        @Override
        public final Builder auditPolicyState(AuditPolicyState auditPolicyState) {
            this.auditPolicyState(auditPolicyState == null ? null : auditPolicyState.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyActivityStreamRequest build() {
            return new ModifyActivityStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
