/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeExportTasksRequest extends RdsRequest implements
        ToCopyableBuilder<DescribeExportTasksRequest.Builder, DescribeExportTasksRequest> {
    private static final SdkField<String> EXPORT_TASK_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportTaskIdentifier").getter(getter(DescribeExportTasksRequest::exportTaskIdentifier))
            .setter(setter(Builder::exportTaskIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportTaskIdentifier").build())
            .build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceArn").getter(getter(DescribeExportTasksRequest::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeExportTasksRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeExportTasksRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeExportTasksRequest::maxRecords)).setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(DescribeExportTasksRequest::sourceTypeAsString))
            .setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_TASK_IDENTIFIER_FIELD,
            SOURCE_ARN_FIELD, FILTERS_FIELD, MARKER_FIELD, MAX_RECORDS_FIELD, SOURCE_TYPE_FIELD));

    private final String exportTaskIdentifier;

    private final String sourceArn;

    private final List<Filter> filters;

    private final String marker;

    private final Integer maxRecords;

    private final String sourceType;

    private DescribeExportTasksRequest(BuilderImpl builder) {
        super(builder);
        this.exportTaskIdentifier = builder.exportTaskIdentifier;
        this.sourceArn = builder.sourceArn;
        this.filters = builder.filters;
        this.marker = builder.marker;
        this.maxRecords = builder.maxRecords;
        this.sourceType = builder.sourceType;
    }

    /**
     * <p>
     * The identifier of the snapshot export task to be described.
     * </p>
     * 
     * @return The identifier of the snapshot export task to be described.
     */
    public final String exportTaskIdentifier() {
        return exportTaskIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.
     */
    public final String sourceArn() {
        return sourceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters specify one or more snapshot exports to describe. The filters are specified as name-value pairs that
     * define what to include in the output. Filter names and values are case-sensitive.
     * </p>
     * <p>
     * Supported filters include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>export-task-identifier</code> - An identifier for the snapshot export task.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3-bucket</code> - The Amazon S3 bucket the snapshot is exported to.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>source-arn</code> - The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status</code> - The status of the export task. Must be lowercase. Valid statuses are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>canceled</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>canceling</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>complete</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>in_progress</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>starting</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Filters specify one or more snapshot exports to describe. The filters are specified as name-value pairs
     *         that define what to include in the output. Filter names and values are case-sensitive.</p>
     *         <p>
     *         Supported filters include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>export-task-identifier</code> - An identifier for the snapshot export task.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3-bucket</code> - The Amazon S3 bucket the snapshot is exported to.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>source-arn</code> - The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status</code> - The status of the export task. Must be lowercase. Valid statuses are the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>canceled</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>canceling</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>complete</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>failed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>in_progress</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>starting</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous <code>DescribeExportTasks</code> request. If you specify this
     * parameter, the response includes only records beyond the marker, up to the value specified by the
     * <code>MaxRecords</code> parameter.
     * </p>
     * 
     * @return An optional pagination token provided by a previous <code>DescribeExportTasks</code> request. If you
     *         specify this parameter, the response includes only records beyond the marker, up to the value specified
     *         by the <code>MaxRecords</code> parameter.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of records to include in the response. If more records exist than the specified value, a
     * pagination token called a marker is included in the response. You can use the marker in a later
     * <code>DescribeExportTasks</code> request to retrieve the remaining results.
     * </p>
     * <p>
     * Default: 100
     * </p>
     * <p>
     * Constraints: Minimum 20, maximum 100.
     * </p>
     * 
     * @return The maximum number of records to include in the response. If more records exist than the specified value,
     *         a pagination token called a marker is included in the response. You can use the marker in a later
     *         <code>DescribeExportTasks</code> request to retrieve the remaining results.</p>
     *         <p>
     *         Default: 100
     *         </p>
     *         <p>
     *         Constraints: Minimum 20, maximum 100.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * The type of source for the export.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link ExportSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The type of source for the export.
     * @see ExportSourceType
     */
    public final ExportSourceType sourceType() {
        return ExportSourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * The type of source for the export.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link ExportSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The type of source for the export.
     * @see ExportSourceType
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exportTaskIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportTasksRequest)) {
            return false;
        }
        DescribeExportTasksRequest other = (DescribeExportTasksRequest) obj;
        return Objects.equals(exportTaskIdentifier(), other.exportTaskIdentifier())
                && Objects.equals(sourceArn(), other.sourceArn()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(marker(), other.marker())
                && Objects.equals(maxRecords(), other.maxRecords())
                && Objects.equals(sourceTypeAsString(), other.sourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeExportTasksRequest").add("ExportTaskIdentifier", exportTaskIdentifier())
                .add("SourceArn", sourceArn()).add("Filters", hasFilters() ? filters() : null).add("Marker", marker())
                .add("MaxRecords", maxRecords()).add("SourceType", sourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportTaskIdentifier":
            return Optional.ofNullable(clazz.cast(exportTaskIdentifier()));
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeExportTasksRequest, T> g) {
        return obj -> g.apply((DescribeExportTasksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeExportTasksRequest> {
        /**
         * <p>
         * The identifier of the snapshot export task to be described.
         * </p>
         * 
         * @param exportTaskIdentifier
         *        The identifier of the snapshot export task to be described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportTaskIdentifier(String exportTaskIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.
         * </p>
         * 
         * @param sourceArn
         *        The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * Filters specify one or more snapshot exports to describe. The filters are specified as name-value pairs that
         * define what to include in the output. Filter names and values are case-sensitive.
         * </p>
         * <p>
         * Supported filters include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>export-task-identifier</code> - An identifier for the snapshot export task.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3-bucket</code> - The Amazon S3 bucket the snapshot is exported to.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>source-arn</code> - The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the export task. Must be lowercase. Valid statuses are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>canceled</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>canceling</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>complete</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failed</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>in_progress</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>starting</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Filters specify one or more snapshot exports to describe. The filters are specified as name-value
         *        pairs that define what to include in the output. Filter names and values are case-sensitive.</p>
         *        <p>
         *        Supported filters include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>export-task-identifier</code> - An identifier for the snapshot export task.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3-bucket</code> - The Amazon S3 bucket the snapshot is exported to.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>source-arn</code> - The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the export task. Must be lowercase. Valid statuses are the
         *        following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>canceled</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>canceling</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>complete</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>failed</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>in_progress</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>starting</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * Filters specify one or more snapshot exports to describe. The filters are specified as name-value pairs that
         * define what to include in the output. Filter names and values are case-sensitive.
         * </p>
         * <p>
         * Supported filters include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>export-task-identifier</code> - An identifier for the snapshot export task.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3-bucket</code> - The Amazon S3 bucket the snapshot is exported to.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>source-arn</code> - The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the export task. Must be lowercase. Valid statuses are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>canceled</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>canceling</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>complete</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failed</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>in_progress</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>starting</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Filters specify one or more snapshot exports to describe. The filters are specified as name-value
         *        pairs that define what to include in the output. Filter names and values are case-sensitive.</p>
         *        <p>
         *        Supported filters include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>export-task-identifier</code> - An identifier for the snapshot export task.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3-bucket</code> - The Amazon S3 bucket the snapshot is exported to.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>source-arn</code> - The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the export task. Must be lowercase. Valid statuses are the
         *        following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>canceled</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>canceling</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>complete</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>failed</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>in_progress</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>starting</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * Filters specify one or more snapshot exports to describe. The filters are specified as name-value pairs that
         * define what to include in the output. Filter names and values are case-sensitive.
         * </p>
         * <p>
         * Supported filters include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>export-task-identifier</code> - An identifier for the snapshot export task.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3-bucket</code> - The Amazon S3 bucket the snapshot is exported to.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>source-arn</code> - The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the export task. Must be lowercase. Valid statuses are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>canceled</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>canceling</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>complete</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failed</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>in_progress</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>starting</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Filter.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Filter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * An optional pagination token provided by a previous <code>DescribeExportTasks</code> request. If you specify
         * this parameter, the response includes only records beyond the marker, up to the value specified by the
         * <code>MaxRecords</code> parameter.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous <code>DescribeExportTasks</code> request. If you
         *        specify this parameter, the response includes only records beyond the marker, up to the value
         *        specified by the <code>MaxRecords</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of records to include in the response. If more records exist than the specified value, a
         * pagination token called a marker is included in the response. You can use the marker in a later
         * <code>DescribeExportTasks</code> request to retrieve the remaining results.
         * </p>
         * <p>
         * Default: 100
         * </p>
         * <p>
         * Constraints: Minimum 20, maximum 100.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of records to include in the response. If more records exist than the specified
         *        value, a pagination token called a marker is included in the response. You can use the marker in a
         *        later <code>DescribeExportTasks</code> request to retrieve the remaining results.</p>
         *        <p>
         *        Default: 100
         *        </p>
         *        <p>
         *        Constraints: Minimum 20, maximum 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * The type of source for the export.
         * </p>
         * 
         * @param sourceType
         *        The type of source for the export.
         * @see ExportSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportSourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The type of source for the export.
         * </p>
         * 
         * @param sourceType
         *        The type of source for the export.
         * @see ExportSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportSourceType
         */
        Builder sourceType(ExportSourceType sourceType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String exportTaskIdentifier;

        private String sourceArn;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private Integer maxRecords;

        private String sourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportTasksRequest model) {
            super(model);
            exportTaskIdentifier(model.exportTaskIdentifier);
            sourceArn(model.sourceArn);
            filters(model.filters);
            marker(model.marker);
            maxRecords(model.maxRecords);
            sourceType(model.sourceType);
        }

        public final String getExportTaskIdentifier() {
            return exportTaskIdentifier;
        }

        public final void setExportTaskIdentifier(String exportTaskIdentifier) {
            this.exportTaskIdentifier = exportTaskIdentifier;
        }

        @Override
        public final Builder exportTaskIdentifier(String exportTaskIdentifier) {
            this.exportTaskIdentifier = exportTaskIdentifier;
            return this;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(ExportSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeExportTasksRequest build() {
            return new DescribeExportTasksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
