/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteBlueGreenDeploymentRequest extends RdsRequest implements
        ToCopyableBuilder<DeleteBlueGreenDeploymentRequest.Builder, DeleteBlueGreenDeploymentRequest> {
    private static final SdkField<String> BLUE_GREEN_DEPLOYMENT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BlueGreenDeploymentIdentifier")
            .getter(getter(DeleteBlueGreenDeploymentRequest::blueGreenDeploymentIdentifier))
            .setter(setter(Builder::blueGreenDeploymentIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueGreenDeploymentIdentifier")
                    .build()).build();

    private static final SdkField<Boolean> DELETE_TARGET_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteTarget").getter(getter(DeleteBlueGreenDeploymentRequest::deleteTarget))
            .setter(setter(Builder::deleteTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteTarget").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BLUE_GREEN_DEPLOYMENT_IDENTIFIER_FIELD, DELETE_TARGET_FIELD));

    private final String blueGreenDeploymentIdentifier;

    private final Boolean deleteTarget;

    private DeleteBlueGreenDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.blueGreenDeploymentIdentifier = builder.blueGreenDeploymentIdentifier;
        this.deleteTarget = builder.deleteTarget;
    }

    /**
     * <p>
     * The blue/green deployment identifier of the deployment to be deleted. This parameter isn't case-sensitive.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match an existing blue/green deployment identifier.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The blue/green deployment identifier of the deployment to be deleted. This parameter isn't
     *         case-sensitive.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match an existing blue/green deployment identifier.
     *         </p>
     *         </li>
     */
    public final String blueGreenDeploymentIdentifier() {
        return blueGreenDeploymentIdentifier;
    }

    /**
     * <p>
     * A value that indicates whether to delete the resources in the green environment.
     * </p>
     * 
     * @return A value that indicates whether to delete the resources in the green environment.
     */
    public final Boolean deleteTarget() {
        return deleteTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(blueGreenDeploymentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(deleteTarget());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBlueGreenDeploymentRequest)) {
            return false;
        }
        DeleteBlueGreenDeploymentRequest other = (DeleteBlueGreenDeploymentRequest) obj;
        return Objects.equals(blueGreenDeploymentIdentifier(), other.blueGreenDeploymentIdentifier())
                && Objects.equals(deleteTarget(), other.deleteTarget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteBlueGreenDeploymentRequest")
                .add("BlueGreenDeploymentIdentifier", blueGreenDeploymentIdentifier()).add("DeleteTarget", deleteTarget())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlueGreenDeploymentIdentifier":
            return Optional.ofNullable(clazz.cast(blueGreenDeploymentIdentifier()));
        case "DeleteTarget":
            return Optional.ofNullable(clazz.cast(deleteTarget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteBlueGreenDeploymentRequest, T> g) {
        return obj -> g.apply((DeleteBlueGreenDeploymentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteBlueGreenDeploymentRequest> {
        /**
         * <p>
         * The blue/green deployment identifier of the deployment to be deleted. This parameter isn't case-sensitive.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match an existing blue/green deployment identifier.
         * </p>
         * </li>
         * </ul>
         * 
         * @param blueGreenDeploymentIdentifier
         *        The blue/green deployment identifier of the deployment to be deleted. This parameter isn't
         *        case-sensitive.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match an existing blue/green deployment identifier.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueGreenDeploymentIdentifier(String blueGreenDeploymentIdentifier);

        /**
         * <p>
         * A value that indicates whether to delete the resources in the green environment.
         * </p>
         * 
         * @param deleteTarget
         *        A value that indicates whether to delete the resources in the green environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteTarget(Boolean deleteTarget);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String blueGreenDeploymentIdentifier;

        private Boolean deleteTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBlueGreenDeploymentRequest model) {
            super(model);
            blueGreenDeploymentIdentifier(model.blueGreenDeploymentIdentifier);
            deleteTarget(model.deleteTarget);
        }

        public final String getBlueGreenDeploymentIdentifier() {
            return blueGreenDeploymentIdentifier;
        }

        public final void setBlueGreenDeploymentIdentifier(String blueGreenDeploymentIdentifier) {
            this.blueGreenDeploymentIdentifier = blueGreenDeploymentIdentifier;
        }

        @Override
        public final Builder blueGreenDeploymentIdentifier(String blueGreenDeploymentIdentifier) {
            this.blueGreenDeploymentIdentifier = blueGreenDeploymentIdentifier;
            return this;
        }

        public final Boolean getDeleteTarget() {
            return deleteTarget;
        }

        public final void setDeleteTarget(Boolean deleteTarget) {
            this.deleteTarget = deleteTarget;
        }

        @Override
        public final Builder deleteTarget(Boolean deleteTarget) {
            this.deleteTarget = deleteTarget;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteBlueGreenDeploymentRequest build() {
            return new DeleteBlueGreenDeploymentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
