/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.ProcessorFeature;
import software.amazon.awssdk.services.rds.model.ProcessorFeatureListCopier;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBSnapshot
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBSnapshot> {
    private static final SdkField<String> DB_SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSnapshotIdentifier").getter(DBSnapshot.getter(DBSnapshot::dbSnapshotIdentifier)).setter(DBSnapshot.setter(Builder::dbSnapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSnapshotIdentifier").build()}).build();
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBInstanceIdentifier").getter(DBSnapshot.getter(DBSnapshot::dbInstanceIdentifier)).setter(DBSnapshot.setter(Builder::dbInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build()}).build();
    private static final SdkField<Instant> SNAPSHOT_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SnapshotCreateTime").getter(DBSnapshot.getter(DBSnapshot::snapshotCreateTime)).setter(DBSnapshot.setter(Builder::snapshotCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotCreateTime").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(DBSnapshot.getter(DBSnapshot::engine)).setter(DBSnapshot.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocatedStorage").getter(DBSnapshot.getter(DBSnapshot::allocatedStorage)).setter(DBSnapshot.setter(Builder::allocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DBSnapshot.getter(DBSnapshot::status)).setter(DBSnapshot.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(DBSnapshot.getter(DBSnapshot::port)).setter(DBSnapshot.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(DBSnapshot.getter(DBSnapshot::availabilityZone)).setter(DBSnapshot.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(DBSnapshot.getter(DBSnapshot::vpcId)).setter(DBSnapshot.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<Instant> INSTANCE_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InstanceCreateTime").getter(DBSnapshot.getter(DBSnapshot::instanceCreateTime)).setter(DBSnapshot.setter(Builder::instanceCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCreateTime").build()}).build();
    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUsername").getter(DBSnapshot.getter(DBSnapshot::masterUsername)).setter(DBSnapshot.setter(Builder::masterUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(DBSnapshot.getter(DBSnapshot::engineVersion)).setter(DBSnapshot.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseModel").getter(DBSnapshot.getter(DBSnapshot::licenseModel)).setter(DBSnapshot.setter(Builder::licenseModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()}).build();
    private static final SdkField<String> SNAPSHOT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotType").getter(DBSnapshot.getter(DBSnapshot::snapshotType)).setter(DBSnapshot.setter(Builder::snapshotType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotType").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Iops").getter(DBSnapshot.getter(DBSnapshot::iops)).setter(DBSnapshot.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()}).build();
    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionGroupName").getter(DBSnapshot.getter(DBSnapshot::optionGroupName)).setter(DBSnapshot.setter(Builder::optionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()}).build();
    private static final SdkField<Integer> PERCENT_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PercentProgress").getter(DBSnapshot.getter(DBSnapshot::percentProgress)).setter(DBSnapshot.setter(Builder::percentProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentProgress").build()}).build();
    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceRegion").getter(DBSnapshot.getter(DBSnapshot::sourceRegion)).setter(DBSnapshot.setter(Builder::sourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion").build()}).build();
    private static final SdkField<String> SOURCE_DB_SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceDBSnapshotIdentifier").getter(DBSnapshot.getter(DBSnapshot::sourceDBSnapshotIdentifier)).setter(DBSnapshot.setter(Builder::sourceDBSnapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDBSnapshotIdentifier").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(DBSnapshot.getter(DBSnapshot::storageType)).setter(DBSnapshot.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final SdkField<String> TDE_CREDENTIAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TdeCredentialArn").getter(DBSnapshot.getter(DBSnapshot::tdeCredentialArn)).setter(DBSnapshot.setter(Builder::tdeCredentialArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdeCredentialArn").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Encrypted").getter(DBSnapshot.getter(DBSnapshot::encrypted)).setter(DBSnapshot.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(DBSnapshot.getter(DBSnapshot::kmsKeyId)).setter(DBSnapshot.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> DB_SNAPSHOT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSnapshotArn").getter(DBSnapshot.getter(DBSnapshot::dbSnapshotArn)).setter(DBSnapshot.setter(Builder::dbSnapshotArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSnapshotArn").build()}).build();
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Timezone").getter(DBSnapshot.getter(DBSnapshot::timezone)).setter(DBSnapshot.setter(Builder::timezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()}).build();
    private static final SdkField<Boolean> IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IAMDatabaseAuthenticationEnabled").getter(DBSnapshot.getter(DBSnapshot::iamDatabaseAuthenticationEnabled)).setter(DBSnapshot.setter(Builder::iamDatabaseAuthenticationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMDatabaseAuthenticationEnabled").build()}).build();
    private static final SdkField<List<ProcessorFeature>> PROCESSOR_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProcessorFeatures").getter(DBSnapshot.getter(DBSnapshot::processorFeatures)).setter(DBSnapshot.setter(Builder::processorFeatures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorFeatures").build(), ListTrait.builder().memberLocationName("ProcessorFeature").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProcessorFeature::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorFeature").build()}).build()).build()}).build();
    private static final SdkField<String> DBI_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbiResourceId").getter(DBSnapshot.getter(DBSnapshot::dbiResourceId)).setter(DBSnapshot.setter(Builder::dbiResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbiResourceId").build()}).build();
    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagList").getter(DBSnapshot.getter(DBSnapshot::tagList)).setter(DBSnapshot.setter(Builder::tagList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagList").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<Instant> ORIGINAL_SNAPSHOT_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("OriginalSnapshotCreateTime").getter(DBSnapshot.getter(DBSnapshot::originalSnapshotCreateTime)).setter(DBSnapshot.setter(Builder::originalSnapshotCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalSnapshotCreateTime").build()}).build();
    private static final SdkField<String> SNAPSHOT_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotTarget").getter(DBSnapshot.getter(DBSnapshot::snapshotTarget)).setter(DBSnapshot.setter(Builder::snapshotTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotTarget").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SNAPSHOT_IDENTIFIER_FIELD, DB_INSTANCE_IDENTIFIER_FIELD, SNAPSHOT_CREATE_TIME_FIELD, ENGINE_FIELD, ALLOCATED_STORAGE_FIELD, STATUS_FIELD, PORT_FIELD, AVAILABILITY_ZONE_FIELD, VPC_ID_FIELD, INSTANCE_CREATE_TIME_FIELD, MASTER_USERNAME_FIELD, ENGINE_VERSION_FIELD, LICENSE_MODEL_FIELD, SNAPSHOT_TYPE_FIELD, IOPS_FIELD, OPTION_GROUP_NAME_FIELD, PERCENT_PROGRESS_FIELD, SOURCE_REGION_FIELD, SOURCE_DB_SNAPSHOT_IDENTIFIER_FIELD, STORAGE_TYPE_FIELD, TDE_CREDENTIAL_ARN_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, DB_SNAPSHOT_ARN_FIELD, TIMEZONE_FIELD, IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD, PROCESSOR_FEATURES_FIELD, DBI_RESOURCE_ID_FIELD, TAG_LIST_FIELD, ORIGINAL_SNAPSHOT_CREATE_TIME_FIELD, SNAPSHOT_TARGET_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dbSnapshotIdentifier;
    private final String dbInstanceIdentifier;
    private final Instant snapshotCreateTime;
    private final String engine;
    private final Integer allocatedStorage;
    private final String status;
    private final Integer port;
    private final String availabilityZone;
    private final String vpcId;
    private final Instant instanceCreateTime;
    private final String masterUsername;
    private final String engineVersion;
    private final String licenseModel;
    private final String snapshotType;
    private final Integer iops;
    private final String optionGroupName;
    private final Integer percentProgress;
    private final String sourceRegion;
    private final String sourceDBSnapshotIdentifier;
    private final String storageType;
    private final String tdeCredentialArn;
    private final Boolean encrypted;
    private final String kmsKeyId;
    private final String dbSnapshotArn;
    private final String timezone;
    private final Boolean iamDatabaseAuthenticationEnabled;
    private final List<ProcessorFeature> processorFeatures;
    private final String dbiResourceId;
    private final List<Tag> tagList;
    private final Instant originalSnapshotCreateTime;
    private final String snapshotTarget;

    private DBSnapshot(BuilderImpl builder) {
        this.dbSnapshotIdentifier = builder.dbSnapshotIdentifier;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.snapshotCreateTime = builder.snapshotCreateTime;
        this.engine = builder.engine;
        this.allocatedStorage = builder.allocatedStorage;
        this.status = builder.status;
        this.port = builder.port;
        this.availabilityZone = builder.availabilityZone;
        this.vpcId = builder.vpcId;
        this.instanceCreateTime = builder.instanceCreateTime;
        this.masterUsername = builder.masterUsername;
        this.engineVersion = builder.engineVersion;
        this.licenseModel = builder.licenseModel;
        this.snapshotType = builder.snapshotType;
        this.iops = builder.iops;
        this.optionGroupName = builder.optionGroupName;
        this.percentProgress = builder.percentProgress;
        this.sourceRegion = builder.sourceRegion;
        this.sourceDBSnapshotIdentifier = builder.sourceDBSnapshotIdentifier;
        this.storageType = builder.storageType;
        this.tdeCredentialArn = builder.tdeCredentialArn;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.dbSnapshotArn = builder.dbSnapshotArn;
        this.timezone = builder.timezone;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
        this.processorFeatures = builder.processorFeatures;
        this.dbiResourceId = builder.dbiResourceId;
        this.tagList = builder.tagList;
        this.originalSnapshotCreateTime = builder.originalSnapshotCreateTime;
        this.snapshotTarget = builder.snapshotTarget;
    }

    public final String dbSnapshotIdentifier() {
        return this.dbSnapshotIdentifier;
    }

    public final String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public final Instant snapshotCreateTime() {
        return this.snapshotCreateTime;
    }

    public final String engine() {
        return this.engine;
    }

    public final Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public final String status() {
        return this.status;
    }

    public final Integer port() {
        return this.port;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final Instant instanceCreateTime() {
        return this.instanceCreateTime;
    }

    public final String masterUsername() {
        return this.masterUsername;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String licenseModel() {
        return this.licenseModel;
    }

    public final String snapshotType() {
        return this.snapshotType;
    }

    public final Integer iops() {
        return this.iops;
    }

    public final String optionGroupName() {
        return this.optionGroupName;
    }

    public final Integer percentProgress() {
        return this.percentProgress;
    }

    public final String sourceRegion() {
        return this.sourceRegion;
    }

    public final String sourceDBSnapshotIdentifier() {
        return this.sourceDBSnapshotIdentifier;
    }

    public final String storageType() {
        return this.storageType;
    }

    public final String tdeCredentialArn() {
        return this.tdeCredentialArn;
    }

    public final Boolean encrypted() {
        return this.encrypted;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String dbSnapshotArn() {
        return this.dbSnapshotArn;
    }

    public final String timezone() {
        return this.timezone;
    }

    public final Boolean iamDatabaseAuthenticationEnabled() {
        return this.iamDatabaseAuthenticationEnabled;
    }

    public final boolean hasProcessorFeatures() {
        return this.processorFeatures != null && !(this.processorFeatures instanceof SdkAutoConstructList);
    }

    public final List<ProcessorFeature> processorFeatures() {
        return this.processorFeatures;
    }

    public final String dbiResourceId() {
        return this.dbiResourceId;
    }

    public final boolean hasTagList() {
        return this.tagList != null && !(this.tagList instanceof SdkAutoConstructList);
    }

    public final List<Tag> tagList() {
        return this.tagList;
    }

    public final Instant originalSnapshotCreateTime() {
        return this.originalSnapshotCreateTime;
    }

    public final String snapshotTarget() {
        return this.snapshotTarget;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotType());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDBSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.tdeCredentialArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSnapshotArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamDatabaseAuthenticationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProcessorFeatures() ? this.processorFeatures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dbiResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagList() ? this.tagList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.originalSnapshotCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotTarget());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBSnapshot)) {
            return false;
        }
        DBSnapshot other = (DBSnapshot)obj;
        return Objects.equals(this.dbSnapshotIdentifier(), other.dbSnapshotIdentifier()) && Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.snapshotCreateTime(), other.snapshotCreateTime()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.instanceCreateTime(), other.instanceCreateTime()) && Objects.equals(this.masterUsername(), other.masterUsername()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.licenseModel(), other.licenseModel()) && Objects.equals(this.snapshotType(), other.snapshotType()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.optionGroupName(), other.optionGroupName()) && Objects.equals(this.percentProgress(), other.percentProgress()) && Objects.equals(this.sourceRegion(), other.sourceRegion()) && Objects.equals(this.sourceDBSnapshotIdentifier(), other.sourceDBSnapshotIdentifier()) && Objects.equals(this.storageType(), other.storageType()) && Objects.equals(this.tdeCredentialArn(), other.tdeCredentialArn()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.dbSnapshotArn(), other.dbSnapshotArn()) && Objects.equals(this.timezone(), other.timezone()) && Objects.equals(this.iamDatabaseAuthenticationEnabled(), other.iamDatabaseAuthenticationEnabled()) && this.hasProcessorFeatures() == other.hasProcessorFeatures() && Objects.equals(this.processorFeatures(), other.processorFeatures()) && Objects.equals(this.dbiResourceId(), other.dbiResourceId()) && this.hasTagList() == other.hasTagList() && Objects.equals(this.tagList(), other.tagList()) && Objects.equals(this.originalSnapshotCreateTime(), other.originalSnapshotCreateTime()) && Objects.equals(this.snapshotTarget(), other.snapshotTarget());
    }

    public final String toString() {
        return ToString.builder((String)"DBSnapshot").add("DBSnapshotIdentifier", (Object)this.dbSnapshotIdentifier()).add("DBInstanceIdentifier", (Object)this.dbInstanceIdentifier()).add("SnapshotCreateTime", (Object)this.snapshotCreateTime()).add("Engine", (Object)this.engine()).add("AllocatedStorage", (Object)this.allocatedStorage()).add("Status", (Object)this.status()).add("Port", (Object)this.port()).add("AvailabilityZone", (Object)this.availabilityZone()).add("VpcId", (Object)this.vpcId()).add("InstanceCreateTime", (Object)this.instanceCreateTime()).add("MasterUsername", (Object)this.masterUsername()).add("EngineVersion", (Object)this.engineVersion()).add("LicenseModel", (Object)this.licenseModel()).add("SnapshotType", (Object)this.snapshotType()).add("Iops", (Object)this.iops()).add("OptionGroupName", (Object)this.optionGroupName()).add("PercentProgress", (Object)this.percentProgress()).add("SourceRegion", (Object)this.sourceRegion()).add("SourceDBSnapshotIdentifier", (Object)this.sourceDBSnapshotIdentifier()).add("StorageType", (Object)this.storageType()).add("TdeCredentialArn", (Object)this.tdeCredentialArn()).add("Encrypted", (Object)this.encrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("DBSnapshotArn", (Object)this.dbSnapshotArn()).add("Timezone", (Object)this.timezone()).add("IAMDatabaseAuthenticationEnabled", (Object)this.iamDatabaseAuthenticationEnabled()).add("ProcessorFeatures", this.hasProcessorFeatures() ? this.processorFeatures() : null).add("DbiResourceId", (Object)this.dbiResourceId()).add("TagList", this.hasTagList() ? this.tagList() : null).add("OriginalSnapshotCreateTime", (Object)this.originalSnapshotCreateTime()).add("SnapshotTarget", (Object)this.snapshotTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbSnapshotIdentifier()));
            }
            case "DBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "SnapshotCreateTime": {
                return Optional.ofNullable(clazz.cast(this.snapshotCreateTime()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "AllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "InstanceCreateTime": {
                return Optional.ofNullable(clazz.cast(this.instanceCreateTime()));
            }
            case "MasterUsername": {
                return Optional.ofNullable(clazz.cast(this.masterUsername()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "LicenseModel": {
                return Optional.ofNullable(clazz.cast(this.licenseModel()));
            }
            case "SnapshotType": {
                return Optional.ofNullable(clazz.cast(this.snapshotType()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "OptionGroupName": {
                return Optional.ofNullable(clazz.cast(this.optionGroupName()));
            }
            case "PercentProgress": {
                return Optional.ofNullable(clazz.cast(this.percentProgress()));
            }
            case "SourceRegion": {
                return Optional.ofNullable(clazz.cast(this.sourceRegion()));
            }
            case "SourceDBSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sourceDBSnapshotIdentifier()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "TdeCredentialArn": {
                return Optional.ofNullable(clazz.cast(this.tdeCredentialArn()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "DBSnapshotArn": {
                return Optional.ofNullable(clazz.cast(this.dbSnapshotArn()));
            }
            case "Timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
            case "IAMDatabaseAuthenticationEnabled": {
                return Optional.ofNullable(clazz.cast(this.iamDatabaseAuthenticationEnabled()));
            }
            case "ProcessorFeatures": {
                return Optional.ofNullable(clazz.cast(this.processorFeatures()));
            }
            case "DbiResourceId": {
                return Optional.ofNullable(clazz.cast(this.dbiResourceId()));
            }
            case "TagList": {
                return Optional.ofNullable(clazz.cast(this.tagList()));
            }
            case "OriginalSnapshotCreateTime": {
                return Optional.ofNullable(clazz.cast(this.originalSnapshotCreateTime()));
            }
            case "SnapshotTarget": {
                return Optional.ofNullable(clazz.cast(this.snapshotTarget()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBSnapshot, T> g) {
        return obj -> g.apply((DBSnapshot)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbSnapshotIdentifier;
        private String dbInstanceIdentifier;
        private Instant snapshotCreateTime;
        private String engine;
        private Integer allocatedStorage;
        private String status;
        private Integer port;
        private String availabilityZone;
        private String vpcId;
        private Instant instanceCreateTime;
        private String masterUsername;
        private String engineVersion;
        private String licenseModel;
        private String snapshotType;
        private Integer iops;
        private String optionGroupName;
        private Integer percentProgress;
        private String sourceRegion;
        private String sourceDBSnapshotIdentifier;
        private String storageType;
        private String tdeCredentialArn;
        private Boolean encrypted;
        private String kmsKeyId;
        private String dbSnapshotArn;
        private String timezone;
        private Boolean iamDatabaseAuthenticationEnabled;
        private List<ProcessorFeature> processorFeatures = DefaultSdkAutoConstructList.getInstance();
        private String dbiResourceId;
        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();
        private Instant originalSnapshotCreateTime;
        private String snapshotTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(DBSnapshot model) {
            this.dbSnapshotIdentifier(model.dbSnapshotIdentifier);
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.snapshotCreateTime(model.snapshotCreateTime);
            this.engine(model.engine);
            this.allocatedStorage(model.allocatedStorage);
            this.status(model.status);
            this.port(model.port);
            this.availabilityZone(model.availabilityZone);
            this.vpcId(model.vpcId);
            this.instanceCreateTime(model.instanceCreateTime);
            this.masterUsername(model.masterUsername);
            this.engineVersion(model.engineVersion);
            this.licenseModel(model.licenseModel);
            this.snapshotType(model.snapshotType);
            this.iops(model.iops);
            this.optionGroupName(model.optionGroupName);
            this.percentProgress(model.percentProgress);
            this.sourceRegion(model.sourceRegion);
            this.sourceDBSnapshotIdentifier(model.sourceDBSnapshotIdentifier);
            this.storageType(model.storageType);
            this.tdeCredentialArn(model.tdeCredentialArn);
            this.encrypted(model.encrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.dbSnapshotArn(model.dbSnapshotArn);
            this.timezone(model.timezone);
            this.iamDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
            this.processorFeatures(model.processorFeatures);
            this.dbiResourceId(model.dbiResourceId);
            this.tagList(model.tagList);
            this.originalSnapshotCreateTime(model.originalSnapshotCreateTime);
            this.snapshotTarget(model.snapshotTarget);
        }

        public final String getDbSnapshotIdentifier() {
            return this.dbSnapshotIdentifier;
        }

        public final void setDbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
        }

        @Override
        @Transient
        public final Builder dbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
            return this;
        }

        public final String getDbInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        @Transient
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final Instant getSnapshotCreateTime() {
            return this.snapshotCreateTime;
        }

        public final void setSnapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
        }

        @Override
        @Transient
        public final Builder snapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        @Transient
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        @Transient
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        @Transient
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        @Transient
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        @Transient
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Instant getInstanceCreateTime() {
            return this.instanceCreateTime;
        }

        public final void setInstanceCreateTime(Instant instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
        }

        @Override
        @Transient
        public final Builder instanceCreateTime(Instant instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
            return this;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        @Transient
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        @Transient
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        @Transient
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final String getSnapshotType() {
            return this.snapshotType;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        @Override
        @Transient
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public final Integer getIops() {
            return this.iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        @Transient
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        @Override
        @Transient
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final Integer getPercentProgress() {
            return this.percentProgress;
        }

        public final void setPercentProgress(Integer percentProgress) {
            this.percentProgress = percentProgress;
        }

        @Override
        @Transient
        public final Builder percentProgress(Integer percentProgress) {
            this.percentProgress = percentProgress;
            return this;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        @Transient
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final String getSourceDBSnapshotIdentifier() {
            return this.sourceDBSnapshotIdentifier;
        }

        public final void setSourceDBSnapshotIdentifier(String sourceDBSnapshotIdentifier) {
            this.sourceDBSnapshotIdentifier = sourceDBSnapshotIdentifier;
        }

        @Override
        @Transient
        public final Builder sourceDBSnapshotIdentifier(String sourceDBSnapshotIdentifier) {
            this.sourceDBSnapshotIdentifier = sourceDBSnapshotIdentifier;
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        @Transient
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final String getTdeCredentialArn() {
            return this.tdeCredentialArn;
        }

        public final void setTdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
        }

        @Override
        @Transient
        public final Builder tdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
            return this;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        @Transient
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getDbSnapshotArn() {
            return this.dbSnapshotArn;
        }

        public final void setDbSnapshotArn(String dbSnapshotArn) {
            this.dbSnapshotArn = dbSnapshotArn;
        }

        @Override
        @Transient
        public final Builder dbSnapshotArn(String dbSnapshotArn) {
            this.dbSnapshotArn = dbSnapshotArn;
            return this;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        @Transient
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final Boolean getIamDatabaseAuthenticationEnabled() {
            return this.iamDatabaseAuthenticationEnabled;
        }

        public final void setIamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        @Override
        @Transient
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final List<ProcessorFeature.Builder> getProcessorFeatures() {
            List<ProcessorFeature.Builder> result = ProcessorFeatureListCopier.copyToBuilder(this.processorFeatures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessorFeatures(Collection<ProcessorFeature.BuilderImpl> processorFeatures) {
            this.processorFeatures = ProcessorFeatureListCopier.copyFromBuilder(processorFeatures);
        }

        @Override
        @Transient
        public final Builder processorFeatures(Collection<ProcessorFeature> processorFeatures) {
            this.processorFeatures = ProcessorFeatureListCopier.copy(processorFeatures);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder processorFeatures(ProcessorFeature ... processorFeatures) {
            this.processorFeatures(Arrays.asList(processorFeatures));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder processorFeatures(Consumer<ProcessorFeature.Builder> ... processorFeatures) {
            this.processorFeatures(Stream.of(processorFeatures).map(c -> (ProcessorFeature)((ProcessorFeature.Builder)ProcessorFeature.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDbiResourceId() {
            return this.dbiResourceId;
        }

        public final void setDbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
        }

        @Override
        @Transient
        public final Builder dbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
            return this;
        }

        public final List<Tag.Builder> getTagList() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        @Transient
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagList(Tag ... tagList) {
            this.tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder> ... tagList) {
            this.tagList(Stream.of(tagList).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getOriginalSnapshotCreateTime() {
            return this.originalSnapshotCreateTime;
        }

        public final void setOriginalSnapshotCreateTime(Instant originalSnapshotCreateTime) {
            this.originalSnapshotCreateTime = originalSnapshotCreateTime;
        }

        @Override
        @Transient
        public final Builder originalSnapshotCreateTime(Instant originalSnapshotCreateTime) {
            this.originalSnapshotCreateTime = originalSnapshotCreateTime;
            return this;
        }

        public final String getSnapshotTarget() {
            return this.snapshotTarget;
        }

        public final void setSnapshotTarget(String snapshotTarget) {
            this.snapshotTarget = snapshotTarget;
        }

        @Override
        @Transient
        public final Builder snapshotTarget(String snapshotTarget) {
            this.snapshotTarget = snapshotTarget;
            return this;
        }

        public DBSnapshot build() {
            return new DBSnapshot(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBSnapshot> {
        public Builder dbSnapshotIdentifier(String var1);

        public Builder dbInstanceIdentifier(String var1);

        public Builder snapshotCreateTime(Instant var1);

        public Builder engine(String var1);

        public Builder allocatedStorage(Integer var1);

        public Builder status(String var1);

        public Builder port(Integer var1);

        public Builder availabilityZone(String var1);

        public Builder vpcId(String var1);

        public Builder instanceCreateTime(Instant var1);

        public Builder masterUsername(String var1);

        public Builder engineVersion(String var1);

        public Builder licenseModel(String var1);

        public Builder snapshotType(String var1);

        public Builder iops(Integer var1);

        public Builder optionGroupName(String var1);

        public Builder percentProgress(Integer var1);

        public Builder sourceRegion(String var1);

        public Builder sourceDBSnapshotIdentifier(String var1);

        public Builder storageType(String var1);

        public Builder tdeCredentialArn(String var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder dbSnapshotArn(String var1);

        public Builder timezone(String var1);

        public Builder iamDatabaseAuthenticationEnabled(Boolean var1);

        public Builder processorFeatures(Collection<ProcessorFeature> var1);

        public Builder processorFeatures(ProcessorFeature ... var1);

        public Builder processorFeatures(Consumer<ProcessorFeature.Builder> ... var1);

        public Builder dbiResourceId(String var1);

        public Builder tagList(Collection<Tag> var1);

        public Builder tagList(Tag ... var1);

        public Builder tagList(Consumer<Tag.Builder> ... var1);

        public Builder originalSnapshotCreateTime(Instant var1);

        public Builder snapshotTarget(String var1);
    }
}

