/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the virtual private network (VPN) between the VMware vSphere cluster and the Amazon Web Services
 * website.
 * </p>
 * <p>
 * For more information about RDS on VMware, see the <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html"> RDS on VMware User
 * Guide.</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpnDetails implements SdkPojo, Serializable, ToCopyableBuilder<VpnDetails.Builder, VpnDetails> {
    private static final SdkField<String> VPN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpnId")
            .getter(getter(VpnDetails::vpnId)).setter(setter(Builder::vpnId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnId").build()).build();

    private static final SdkField<String> VPN_TUNNEL_ORIGINATOR_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpnTunnelOriginatorIP").getter(getter(VpnDetails::vpnTunnelOriginatorIP))
            .setter(setter(Builder::vpnTunnelOriginatorIP))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnTunnelOriginatorIP").build())
            .build();

    private static final SdkField<String> VPN_GATEWAY_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpnGatewayIp").getter(getter(VpnDetails::vpnGatewayIp)).setter(setter(Builder::vpnGatewayIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnGatewayIp").build()).build();

    private static final SdkField<String> VPN_PSK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpnPSK")
            .getter(getter(VpnDetails::vpnPSK)).setter(setter(Builder::vpnPSK))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnPSK").build()).build();

    private static final SdkField<String> VPN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpnName").getter(getter(VpnDetails::vpnName)).setter(setter(Builder::vpnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnName").build()).build();

    private static final SdkField<String> VPN_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpnState").getter(getter(VpnDetails::vpnState)).setter(setter(Builder::vpnState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPN_ID_FIELD,
            VPN_TUNNEL_ORIGINATOR_IP_FIELD, VPN_GATEWAY_IP_FIELD, VPN_PSK_FIELD, VPN_NAME_FIELD, VPN_STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String vpnId;

    private final String vpnTunnelOriginatorIP;

    private final String vpnGatewayIp;

    private final String vpnPSK;

    private final String vpnName;

    private final String vpnState;

    private VpnDetails(BuilderImpl builder) {
        this.vpnId = builder.vpnId;
        this.vpnTunnelOriginatorIP = builder.vpnTunnelOriginatorIP;
        this.vpnGatewayIp = builder.vpnGatewayIp;
        this.vpnPSK = builder.vpnPSK;
        this.vpnName = builder.vpnName;
        this.vpnState = builder.vpnState;
    }

    /**
     * <p>
     * The ID of the VPN.
     * </p>
     * 
     * @return The ID of the VPN.
     */
    public final String vpnId() {
        return vpnId;
    }

    /**
     * <p>
     * The IP address of network traffic from your on-premises data center. A custom AZ receives the network traffic.
     * </p>
     * 
     * @return The IP address of network traffic from your on-premises data center. A custom AZ receives the network
     *         traffic.
     */
    public final String vpnTunnelOriginatorIP() {
        return vpnTunnelOriginatorIP;
    }

    /**
     * <p>
     * The IP address of network traffic from Amazon Web Services to your on-premises data center.
     * </p>
     * 
     * @return The IP address of network traffic from Amazon Web Services to your on-premises data center.
     */
    public final String vpnGatewayIp() {
        return vpnGatewayIp;
    }

    /**
     * <p>
     * The preshared key (PSK) for the VPN.
     * </p>
     * 
     * @return The preshared key (PSK) for the VPN.
     */
    public final String vpnPSK() {
        return vpnPSK;
    }

    /**
     * <p>
     * The name of the VPN.
     * </p>
     * 
     * @return The name of the VPN.
     */
    public final String vpnName() {
        return vpnName;
    }

    /**
     * <p>
     * The state of the VPN.
     * </p>
     * 
     * @return The state of the VPN.
     */
    public final String vpnState() {
        return vpnState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpnId());
        hashCode = 31 * hashCode + Objects.hashCode(vpnTunnelOriginatorIP());
        hashCode = 31 * hashCode + Objects.hashCode(vpnGatewayIp());
        hashCode = 31 * hashCode + Objects.hashCode(vpnPSK());
        hashCode = 31 * hashCode + Objects.hashCode(vpnName());
        hashCode = 31 * hashCode + Objects.hashCode(vpnState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnDetails)) {
            return false;
        }
        VpnDetails other = (VpnDetails) obj;
        return Objects.equals(vpnId(), other.vpnId()) && Objects.equals(vpnTunnelOriginatorIP(), other.vpnTunnelOriginatorIP())
                && Objects.equals(vpnGatewayIp(), other.vpnGatewayIp()) && Objects.equals(vpnPSK(), other.vpnPSK())
                && Objects.equals(vpnName(), other.vpnName()) && Objects.equals(vpnState(), other.vpnState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpnDetails").add("VpnId", vpnId()).add("VpnTunnelOriginatorIP", vpnTunnelOriginatorIP())
                .add("VpnGatewayIp", vpnGatewayIp()).add("VpnPSK", vpnPSK() == null ? null : "*** Sensitive Data Redacted ***")
                .add("VpnName", vpnName()).add("VpnState", vpnState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpnId":
            return Optional.ofNullable(clazz.cast(vpnId()));
        case "VpnTunnelOriginatorIP":
            return Optional.ofNullable(clazz.cast(vpnTunnelOriginatorIP()));
        case "VpnGatewayIp":
            return Optional.ofNullable(clazz.cast(vpnGatewayIp()));
        case "VpnPSK":
            return Optional.ofNullable(clazz.cast(vpnPSK()));
        case "VpnName":
            return Optional.ofNullable(clazz.cast(vpnName()));
        case "VpnState":
            return Optional.ofNullable(clazz.cast(vpnState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpnDetails, T> g) {
        return obj -> g.apply((VpnDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpnDetails> {
        /**
         * <p>
         * The ID of the VPN.
         * </p>
         * 
         * @param vpnId
         *        The ID of the VPN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnId(String vpnId);

        /**
         * <p>
         * The IP address of network traffic from your on-premises data center. A custom AZ receives the network
         * traffic.
         * </p>
         * 
         * @param vpnTunnelOriginatorIP
         *        The IP address of network traffic from your on-premises data center. A custom AZ receives the network
         *        traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnTunnelOriginatorIP(String vpnTunnelOriginatorIP);

        /**
         * <p>
         * The IP address of network traffic from Amazon Web Services to your on-premises data center.
         * </p>
         * 
         * @param vpnGatewayIp
         *        The IP address of network traffic from Amazon Web Services to your on-premises data center.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnGatewayIp(String vpnGatewayIp);

        /**
         * <p>
         * The preshared key (PSK) for the VPN.
         * </p>
         * 
         * @param vpnPSK
         *        The preshared key (PSK) for the VPN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnPSK(String vpnPSK);

        /**
         * <p>
         * The name of the VPN.
         * </p>
         * 
         * @param vpnName
         *        The name of the VPN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnName(String vpnName);

        /**
         * <p>
         * The state of the VPN.
         * </p>
         * 
         * @param vpnState
         *        The state of the VPN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnState(String vpnState);
    }

    static final class BuilderImpl implements Builder {
        private String vpnId;

        private String vpnTunnelOriginatorIP;

        private String vpnGatewayIp;

        private String vpnPSK;

        private String vpnName;

        private String vpnState;

        private BuilderImpl() {
        }

        private BuilderImpl(VpnDetails model) {
            vpnId(model.vpnId);
            vpnTunnelOriginatorIP(model.vpnTunnelOriginatorIP);
            vpnGatewayIp(model.vpnGatewayIp);
            vpnPSK(model.vpnPSK);
            vpnName(model.vpnName);
            vpnState(model.vpnState);
        }

        public final String getVpnId() {
            return vpnId;
        }

        @Override
        public final Builder vpnId(String vpnId) {
            this.vpnId = vpnId;
            return this;
        }

        public final void setVpnId(String vpnId) {
            this.vpnId = vpnId;
        }

        public final String getVpnTunnelOriginatorIP() {
            return vpnTunnelOriginatorIP;
        }

        @Override
        public final Builder vpnTunnelOriginatorIP(String vpnTunnelOriginatorIP) {
            this.vpnTunnelOriginatorIP = vpnTunnelOriginatorIP;
            return this;
        }

        public final void setVpnTunnelOriginatorIP(String vpnTunnelOriginatorIP) {
            this.vpnTunnelOriginatorIP = vpnTunnelOriginatorIP;
        }

        public final String getVpnGatewayIp() {
            return vpnGatewayIp;
        }

        @Override
        public final Builder vpnGatewayIp(String vpnGatewayIp) {
            this.vpnGatewayIp = vpnGatewayIp;
            return this;
        }

        public final void setVpnGatewayIp(String vpnGatewayIp) {
            this.vpnGatewayIp = vpnGatewayIp;
        }

        public final String getVpnPSK() {
            return vpnPSK;
        }

        @Override
        public final Builder vpnPSK(String vpnPSK) {
            this.vpnPSK = vpnPSK;
            return this;
        }

        public final void setVpnPSK(String vpnPSK) {
            this.vpnPSK = vpnPSK;
        }

        public final String getVpnName() {
            return vpnName;
        }

        @Override
        public final Builder vpnName(String vpnName) {
            this.vpnName = vpnName;
            return this;
        }

        public final void setVpnName(String vpnName) {
            this.vpnName = vpnName;
        }

        public final String getVpnState() {
            return vpnState;
        }

        @Override
        public final Builder vpnState(String vpnState) {
            this.vpnState = vpnState;
            return this;
        }

        public final void setVpnState(String vpnState) {
            this.vpnState = vpnState;
        }

        @Override
        public VpnDetails build() {
            return new VpnDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
