/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartActivityStreamRequest extends RdsRequest implements
        ToCopyableBuilder<StartActivityStreamRequest.Builder, StartActivityStreamRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(StartActivityStreamRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(StartActivityStreamRequest::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(StartActivityStreamRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ApplyImmediately").getter(getter(StartActivityStreamRequest::applyImmediately))
            .setter(setter(Builder::applyImmediately))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()).build();

    private static final SdkField<Boolean> ENGINE_NATIVE_AUDIT_FIELDS_INCLUDED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EngineNativeAuditFieldsIncluded")
            .getter(getter(StartActivityStreamRequest::engineNativeAuditFieldsIncluded))
            .setter(setter(Builder::engineNativeAuditFieldsIncluded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineNativeAuditFieldsIncluded")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            MODE_FIELD, KMS_KEY_ID_FIELD, APPLY_IMMEDIATELY_FIELD, ENGINE_NATIVE_AUDIT_FIELDS_INCLUDED_FIELD));

    private final String resourceArn;

    private final String mode;

    private final String kmsKeyId;

    private final Boolean applyImmediately;

    private final Boolean engineNativeAuditFieldsIncluded;

    private StartActivityStreamRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.mode = builder.mode;
        this.kmsKeyId = builder.kmsKeyId;
        this.applyImmediately = builder.applyImmediately;
        this.engineNativeAuditFieldsIncluded = builder.engineNativeAuditFieldsIncluded;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the DB cluster, for example,
     * <code>arn:aws:rds:us-east-1:12345667890:cluster:das-cluster</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the DB cluster, for example,
     *         <code>arn:aws:rds:us-east-1:12345667890:cluster:das-cluster</code>.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * Specifies the mode of the database activity stream. Database events such as a change or access generate an
     * activity stream event. The database session can handle these events either synchronously or asynchronously.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ActivityStreamMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Specifies the mode of the database activity stream. Database events such as a change or access generate
     *         an activity stream event. The database session can handle these events either synchronously or
     *         asynchronously.
     * @see ActivityStreamMode
     */
    public final ActivityStreamMode mode() {
        return ActivityStreamMode.fromValue(mode);
    }

    /**
     * <p>
     * Specifies the mode of the database activity stream. Database events such as a change or access generate an
     * activity stream event. The database session can handle these events either synchronously or asynchronously.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ActivityStreamMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Specifies the mode of the database activity stream. Database events such as a change or access generate
     *         an activity stream event. The database session can handle these events either synchronously or
     *         asynchronously.
     * @see ActivityStreamMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key identifier for encrypting messages in the database activity stream. The Amazon
     * Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS
     * customer master key (CMK).
     * </p>
     * 
     * @return The Amazon Web Services KMS key identifier for encrypting messages in the database activity stream. The
     *         Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon
     *         Web Services KMS customer master key (CMK).
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Specifies whether or not the database activity stream is to start as soon as possible, regardless of the
     * maintenance window for the database.
     * </p>
     * 
     * @return Specifies whether or not the database activity stream is to start as soon as possible, regardless of the
     *         maintenance window for the database.
     */
    public final Boolean applyImmediately() {
        return applyImmediately;
    }

    /**
     * <p>
     * Specifies whether the database activity stream includes engine-native audit fields. This option only applies to
     * an Oracle DB instance. By default, no engine-native audit fields are included.
     * </p>
     * 
     * @return Specifies whether the database activity stream includes engine-native audit fields. This option only
     *         applies to an Oracle DB instance. By default, no engine-native audit fields are included.
     */
    public final Boolean engineNativeAuditFieldsIncluded() {
        return engineNativeAuditFieldsIncluded;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(engineNativeAuditFieldsIncluded());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartActivityStreamRequest)) {
            return false;
        }
        StartActivityStreamRequest other = (StartActivityStreamRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(applyImmediately(), other.applyImmediately())
                && Objects.equals(engineNativeAuditFieldsIncluded(), other.engineNativeAuditFieldsIncluded());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartActivityStreamRequest").add("ResourceArn", resourceArn()).add("Mode", modeAsString())
                .add("KmsKeyId", kmsKeyId()).add("ApplyImmediately", applyImmediately())
                .add("EngineNativeAuditFieldsIncluded", engineNativeAuditFieldsIncluded()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "ApplyImmediately":
            return Optional.ofNullable(clazz.cast(applyImmediately()));
        case "EngineNativeAuditFieldsIncluded":
            return Optional.ofNullable(clazz.cast(engineNativeAuditFieldsIncluded()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartActivityStreamRequest, T> g) {
        return obj -> g.apply((StartActivityStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartActivityStreamRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the DB cluster, for example,
         * <code>arn:aws:rds:us-east-1:12345667890:cluster:das-cluster</code>.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the DB cluster, for example,
         *        <code>arn:aws:rds:us-east-1:12345667890:cluster:das-cluster</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * Specifies the mode of the database activity stream. Database events such as a change or access generate an
         * activity stream event. The database session can handle these events either synchronously or asynchronously.
         * </p>
         * 
         * @param mode
         *        Specifies the mode of the database activity stream. Database events such as a change or access
         *        generate an activity stream event. The database session can handle these events either synchronously
         *        or asynchronously.
         * @see ActivityStreamMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivityStreamMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * Specifies the mode of the database activity stream. Database events such as a change or access generate an
         * activity stream event. The database session can handle these events either synchronously or asynchronously.
         * </p>
         * 
         * @param mode
         *        Specifies the mode of the database activity stream. Database events such as a change or access
         *        generate an activity stream event. The database session can handle these events either synchronously
         *        or asynchronously.
         * @see ActivityStreamMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivityStreamMode
         */
        Builder mode(ActivityStreamMode mode);

        /**
         * <p>
         * The Amazon Web Services KMS key identifier for encrypting messages in the database activity stream. The
         * Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web
         * Services KMS customer master key (CMK).
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Web Services KMS key identifier for encrypting messages in the database activity stream.
         *        The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the
         *        Amazon Web Services KMS customer master key (CMK).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Specifies whether or not the database activity stream is to start as soon as possible, regardless of the
         * maintenance window for the database.
         * </p>
         * 
         * @param applyImmediately
         *        Specifies whether or not the database activity stream is to start as soon as possible, regardless of
         *        the maintenance window for the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyImmediately(Boolean applyImmediately);

        /**
         * <p>
         * Specifies whether the database activity stream includes engine-native audit fields. This option only applies
         * to an Oracle DB instance. By default, no engine-native audit fields are included.
         * </p>
         * 
         * @param engineNativeAuditFieldsIncluded
         *        Specifies whether the database activity stream includes engine-native audit fields. This option only
         *        applies to an Oracle DB instance. By default, no engine-native audit fields are included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineNativeAuditFieldsIncluded(Boolean engineNativeAuditFieldsIncluded);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String resourceArn;

        private String mode;

        private String kmsKeyId;

        private Boolean applyImmediately;

        private Boolean engineNativeAuditFieldsIncluded;

        private BuilderImpl() {
        }

        private BuilderImpl(StartActivityStreamRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            mode(model.mode);
            kmsKeyId(model.kmsKeyId);
            applyImmediately(model.applyImmediately);
            engineNativeAuditFieldsIncluded(model.engineNativeAuditFieldsIncluded);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getMode() {
            return mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ActivityStreamMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getApplyImmediately() {
            return applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        public final Boolean getEngineNativeAuditFieldsIncluded() {
            return engineNativeAuditFieldsIncluded;
        }

        @Override
        public final Builder engineNativeAuditFieldsIncluded(Boolean engineNativeAuditFieldsIncluded) {
            this.engineNativeAuditFieldsIncluded = engineNativeAuditFieldsIncluded;
            return this;
        }

        public final void setEngineNativeAuditFieldsIncluded(Boolean engineNativeAuditFieldsIncluded) {
            this.engineNativeAuditFieldsIncluded = engineNativeAuditFieldsIncluded;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartActivityStreamRequest build() {
            return new StartActivityStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
