/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDbProxyRequest extends RdsRequest implements
        ToCopyableBuilder<ModifyDbProxyRequest.Builder, ModifyDbProxyRequest> {
    private static final SdkField<String> DB_PROXY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBProxyName").getter(getter(ModifyDbProxyRequest::dbProxyName)).setter(setter(Builder::dbProxyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyName").build()).build();

    private static final SdkField<String> NEW_DB_PROXY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewDBProxyName").getter(getter(ModifyDbProxyRequest::newDBProxyName))
            .setter(setter(Builder::newDBProxyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewDBProxyName").build()).build();

    private static final SdkField<List<UserAuthConfig>> AUTH_FIELD = SdkField
            .<List<UserAuthConfig>> builder(MarshallingType.LIST)
            .memberName("Auth")
            .getter(getter(ModifyDbProxyRequest::auth))
            .setter(setter(Builder::auth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Auth").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserAuthConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserAuthConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> REQUIRE_TLS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequireTLS").getter(getter(ModifyDbProxyRequest::requireTLS)).setter(setter(Builder::requireTLS))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireTLS").build()).build();

    private static final SdkField<Integer> IDLE_CLIENT_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("IdleClientTimeout").getter(getter(ModifyDbProxyRequest::idleClientTimeout))
            .setter(setter(Builder::idleClientTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdleClientTimeout").build()).build();

    private static final SdkField<Boolean> DEBUG_LOGGING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DebugLogging").getter(getter(ModifyDbProxyRequest::debugLogging)).setter(setter(Builder::debugLogging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DebugLogging").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(ModifyDbProxyRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(ModifyDbProxyRequest::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PROXY_NAME_FIELD,
            NEW_DB_PROXY_NAME_FIELD, AUTH_FIELD, REQUIRE_TLS_FIELD, IDLE_CLIENT_TIMEOUT_FIELD, DEBUG_LOGGING_FIELD,
            ROLE_ARN_FIELD, SECURITY_GROUPS_FIELD));

    private final String dbProxyName;

    private final String newDBProxyName;

    private final List<UserAuthConfig> auth;

    private final Boolean requireTLS;

    private final Integer idleClientTimeout;

    private final Boolean debugLogging;

    private final String roleArn;

    private final List<String> securityGroups;

    private ModifyDbProxyRequest(BuilderImpl builder) {
        super(builder);
        this.dbProxyName = builder.dbProxyName;
        this.newDBProxyName = builder.newDBProxyName;
        this.auth = builder.auth;
        this.requireTLS = builder.requireTLS;
        this.idleClientTimeout = builder.idleClientTimeout;
        this.debugLogging = builder.debugLogging;
        this.roleArn = builder.roleArn;
        this.securityGroups = builder.securityGroups;
    }

    /**
     * <p>
     * The identifier for the <code>DBProxy</code> to modify.
     * </p>
     * 
     * @return The identifier for the <code>DBProxy</code> to modify.
     */
    public final String dbProxyName() {
        return dbProxyName;
    }

    /**
     * <p>
     * The new identifier for the <code>DBProxy</code>. An identifier must begin with a letter and must contain only
     * ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * 
     * @return The new identifier for the <code>DBProxy</code>. An identifier must begin with a letter and must contain
     *         only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
     */
    public final String newDBProxyName() {
        return newDBProxyName;
    }

    /**
     * Returns true if the Auth property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAuth() {
        return auth != null && !(auth instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The new authentication settings for the <code>DBProxy</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAuth()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The new authentication settings for the <code>DBProxy</code>.
     */
    public final List<UserAuthConfig> auth() {
        return auth;
    }

    /**
     * <p>
     * Whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By enabling this
     * setting, you can enforce encrypted TLS connections to the proxy, even if the associated database doesn't use TLS.
     * </p>
     * 
     * @return Whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By enabling
     *         this setting, you can enforce encrypted TLS connections to the proxy, even if the associated database
     *         doesn't use TLS.
     */
    public final Boolean requireTLS() {
        return requireTLS;
    }

    /**
     * <p>
     * The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can set
     * this value higher or lower than the connection timeout limit for the associated database.
     * </p>
     * 
     * @return The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You
     *         can set this value higher or lower than the connection timeout limit for the associated database.
     */
    public final Integer idleClientTimeout() {
        return idleClientTimeout;
    }

    /**
     * <p>
     * Whether the proxy includes detailed information about SQL statements in its logs. This information helps you to
     * debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug
     * information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting
     * when needed for debugging, and only when you have security measures in place to safeguard any sensitive
     * information that appears in the logs.
     * </p>
     * 
     * @return Whether the proxy includes detailed information about SQL statements in its logs. This information helps
     *         you to debug issues involving SQL behavior or the performance and scalability of the proxy connections.
     *         The debug information includes the text of SQL statements that you submit through the proxy. Thus, only
     *         enable this setting when needed for debugging, and only when you have security measures in place to
     *         safeguard any sensitive information that appears in the logs.
     */
    public final Boolean debugLogging() {
        return debugLogging;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in Amazon Web Services
     * Secrets Manager.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in Amazon Web
     *         Services Secrets Manager.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * Returns true if the SecurityGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The new list of security groups for the <code>DBProxy</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The new list of security groups for the <code>DBProxy</code>.
     */
    public final List<String> securityGroups() {
        return securityGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbProxyName());
        hashCode = 31 * hashCode + Objects.hashCode(newDBProxyName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuth() ? auth() : null);
        hashCode = 31 * hashCode + Objects.hashCode(requireTLS());
        hashCode = 31 * hashCode + Objects.hashCode(idleClientTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(debugLogging());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbProxyRequest)) {
            return false;
        }
        ModifyDbProxyRequest other = (ModifyDbProxyRequest) obj;
        return Objects.equals(dbProxyName(), other.dbProxyName()) && Objects.equals(newDBProxyName(), other.newDBProxyName())
                && hasAuth() == other.hasAuth() && Objects.equals(auth(), other.auth())
                && Objects.equals(requireTLS(), other.requireTLS())
                && Objects.equals(idleClientTimeout(), other.idleClientTimeout())
                && Objects.equals(debugLogging(), other.debugLogging()) && Objects.equals(roleArn(), other.roleArn())
                && hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(securityGroups(), other.securityGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyDbProxyRequest").add("DBProxyName", dbProxyName()).add("NewDBProxyName", newDBProxyName())
                .add("Auth", hasAuth() ? auth() : null).add("RequireTLS", requireTLS())
                .add("IdleClientTimeout", idleClientTimeout()).add("DebugLogging", debugLogging()).add("RoleArn", roleArn())
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBProxyName":
            return Optional.ofNullable(clazz.cast(dbProxyName()));
        case "NewDBProxyName":
            return Optional.ofNullable(clazz.cast(newDBProxyName()));
        case "Auth":
            return Optional.ofNullable(clazz.cast(auth()));
        case "RequireTLS":
            return Optional.ofNullable(clazz.cast(requireTLS()));
        case "IdleClientTimeout":
            return Optional.ofNullable(clazz.cast(idleClientTimeout()));
        case "DebugLogging":
            return Optional.ofNullable(clazz.cast(debugLogging()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbProxyRequest, T> g) {
        return obj -> g.apply((ModifyDbProxyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyDbProxyRequest> {
        /**
         * <p>
         * The identifier for the <code>DBProxy</code> to modify.
         * </p>
         * 
         * @param dbProxyName
         *        The identifier for the <code>DBProxy</code> to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbProxyName(String dbProxyName);

        /**
         * <p>
         * The new identifier for the <code>DBProxy</code>. An identifier must begin with a letter and must contain only
         * ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
         * </p>
         * 
         * @param newDBProxyName
         *        The new identifier for the <code>DBProxy</code>. An identifier must begin with a letter and must
         *        contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive
         *        hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newDBProxyName(String newDBProxyName);

        /**
         * <p>
         * The new authentication settings for the <code>DBProxy</code>.
         * </p>
         * 
         * @param auth
         *        The new authentication settings for the <code>DBProxy</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auth(Collection<UserAuthConfig> auth);

        /**
         * <p>
         * The new authentication settings for the <code>DBProxy</code>.
         * </p>
         * 
         * @param auth
         *        The new authentication settings for the <code>DBProxy</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auth(UserAuthConfig... auth);

        /**
         * <p>
         * The new authentication settings for the <code>DBProxy</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UserAuthConfig>.Builder} avoiding the need
         * to create one manually via {@link List<UserAuthConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UserAuthConfig>.Builder#build()} is called immediately and
         * its result is passed to {@link #auth(List<UserAuthConfig>)}.
         * 
         * @param auth
         *        a consumer that will call methods on {@link List<UserAuthConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #auth(List<UserAuthConfig>)
         */
        Builder auth(Consumer<UserAuthConfig.Builder>... auth);

        /**
         * <p>
         * Whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By enabling this
         * setting, you can enforce encrypted TLS connections to the proxy, even if the associated database doesn't use
         * TLS.
         * </p>
         * 
         * @param requireTLS
         *        Whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By
         *        enabling this setting, you can enforce encrypted TLS connections to the proxy, even if the associated
         *        database doesn't use TLS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireTLS(Boolean requireTLS);

        /**
         * <p>
         * The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can
         * set this value higher or lower than the connection timeout limit for the associated database.
         * </p>
         * 
         * @param idleClientTimeout
         *        The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it.
         *        You can set this value higher or lower than the connection timeout limit for the associated database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleClientTimeout(Integer idleClientTimeout);

        /**
         * <p>
         * Whether the proxy includes detailed information about SQL statements in its logs. This information helps you
         * to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug
         * information includes the text of SQL statements that you submit through the proxy. Thus, only enable this
         * setting when needed for debugging, and only when you have security measures in place to safeguard any
         * sensitive information that appears in the logs.
         * </p>
         * 
         * @param debugLogging
         *        Whether the proxy includes detailed information about SQL statements in its logs. This information
         *        helps you to debug issues involving SQL behavior or the performance and scalability of the proxy
         *        connections. The debug information includes the text of SQL statements that you submit through the
         *        proxy. Thus, only enable this setting when needed for debugging, and only when you have security
         *        measures in place to safeguard any sensitive information that appears in the logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder debugLogging(Boolean debugLogging);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in Amazon Web Services
         * Secrets Manager.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in Amazon Web
         *        Services Secrets Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The new list of security groups for the <code>DBProxy</code>.
         * </p>
         * 
         * @param securityGroups
         *        The new list of security groups for the <code>DBProxy</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * The new list of security groups for the <code>DBProxy</code>.
         * </p>
         * 
         * @param securityGroups
         *        The new list of security groups for the <code>DBProxy</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbProxyName;

        private String newDBProxyName;

        private List<UserAuthConfig> auth = DefaultSdkAutoConstructList.getInstance();

        private Boolean requireTLS;

        private Integer idleClientTimeout;

        private Boolean debugLogging;

        private String roleArn;

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbProxyRequest model) {
            super(model);
            dbProxyName(model.dbProxyName);
            newDBProxyName(model.newDBProxyName);
            auth(model.auth);
            requireTLS(model.requireTLS);
            idleClientTimeout(model.idleClientTimeout);
            debugLogging(model.debugLogging);
            roleArn(model.roleArn);
            securityGroups(model.securityGroups);
        }

        public final String getDbProxyName() {
            return dbProxyName;
        }

        @Override
        public final Builder dbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
            return this;
        }

        public final void setDbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
        }

        public final String getNewDBProxyName() {
            return newDBProxyName;
        }

        @Override
        public final Builder newDBProxyName(String newDBProxyName) {
            this.newDBProxyName = newDBProxyName;
            return this;
        }

        public final void setNewDBProxyName(String newDBProxyName) {
            this.newDBProxyName = newDBProxyName;
        }

        public final List<UserAuthConfig.Builder> getAuth() {
            List<UserAuthConfig.Builder> result = UserAuthConfigListCopier.copyToBuilder(this.auth);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder auth(Collection<UserAuthConfig> auth) {
            this.auth = UserAuthConfigListCopier.copy(auth);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auth(UserAuthConfig... auth) {
            auth(Arrays.asList(auth));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auth(Consumer<UserAuthConfig.Builder>... auth) {
            auth(Stream.of(auth).map(c -> UserAuthConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAuth(Collection<UserAuthConfig.BuilderImpl> auth) {
            this.auth = UserAuthConfigListCopier.copyFromBuilder(auth);
        }

        public final Boolean getRequireTLS() {
            return requireTLS;
        }

        @Override
        public final Builder requireTLS(Boolean requireTLS) {
            this.requireTLS = requireTLS;
            return this;
        }

        public final void setRequireTLS(Boolean requireTLS) {
            this.requireTLS = requireTLS;
        }

        public final Integer getIdleClientTimeout() {
            return idleClientTimeout;
        }

        @Override
        public final Builder idleClientTimeout(Integer idleClientTimeout) {
            this.idleClientTimeout = idleClientTimeout;
            return this;
        }

        public final void setIdleClientTimeout(Integer idleClientTimeout) {
            this.idleClientTimeout = idleClientTimeout;
        }

        public final Boolean getDebugLogging() {
            return debugLogging;
        }

        @Override
        public final Builder debugLogging(Boolean debugLogging) {
            this.debugLogging = debugLogging;
            return this;
        }

        public final void setDebugLogging(Boolean debugLogging) {
            this.debugLogging = debugLogging;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = StringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = StringListCopier.copy(securityGroups);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbProxyRequest build() {
            return new ModifyDbProxyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
